/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleCombinedPermissions;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.BundleProtectionDomainImpl;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionAdminImpl;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionSet;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissions;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.SecurePermissionStorage;
import org.osgi.framework.AdminPermission;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;

public class PermissionAdminImpl
implements PermissionAdmin {
    private static final String ADMIN_IMPLIED_ACTIONS = "resource,metadata,class";
    protected Framework framework;
    protected PermissionStorage storage;
    protected PermissionInfo[] defaultDefaultPermissionInfos;
    protected PermissionInfo[] baseImpliedPermissionInfos;
    protected BundleCombinedPermissions defaultAssignedPermissions;

    protected PermissionAdminImpl(Framework framework, PermissionStorage storage) {
        this.framework = framework;
        this.storage = storage;
        this.defaultDefaultPermissionInfos = this.getPermissionInfos(this.getClass().getResource("default.permissions"));
        this.baseImpliedPermissionInfos = this.getPermissionInfos(this.getClass().getResource("implied.permissions"));
        if (Debug.DEBUG_SECURITY) {
            int i;
            Debug.println("Default default assigned bundle permissions");
            if (this.defaultDefaultPermissionInfos == null) {
                Debug.println("  <none>");
            } else {
                i = 0;
                while (i < this.defaultDefaultPermissionInfos.length) {
                    Debug.println("  " + this.defaultDefaultPermissionInfos[i]);
                    ++i;
                }
            }
            Debug.println("Base implied bundle permissions");
            if (this.baseImpliedPermissionInfos == null) {
                Debug.println("  <none>");
            } else {
                i = 0;
                while (i < this.baseImpliedPermissionInfos.length) {
                    Debug.println("  " + this.baseImpliedPermissionInfos[i]);
                    ++i;
                }
            }
        }
        this.defaultAssignedPermissions = new BundleCombinedPermissions(null);
        this.defaultAssignedPermissions.setAssignedPermissions(this.createDefaultAssignedPermissions(this.getDefaultPermissions()), true);
    }

    public PermissionInfo[] getPermissions(String location) {
        if (location == null) {
            throw new NullPointerException();
        }
        SecurePermissionStorage storage = new SecurePermissionStorage(this.storage);
        try {
            String[] data = storage.getPermissionData(location);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Getting permissions for location: " + location);
                if (data == null) {
                    Debug.println("  <none>");
                } else {
                    int i = 0;
                    while (i < data.length) {
                        Debug.println("  " + data[i]);
                        ++i;
                    }
                }
            }
            return this.makePermissionInfo(data);
        }
        catch (IOException e) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            return null;
        }
    }

    public void setPermissions(String location, PermissionInfo[] permissions) {
        BundleProtectionDomain domain;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AllPermission());
        }
        if (location == null) {
            throw new NullPointerException();
        }
        SecurePermissionStorage storage = new SecurePermissionStorage(this.storage);
        try {
            String[] data = this.makePermissionData(permissions);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Setting permissions for location: " + location);
                if (data == null) {
                    Debug.println("  <none>");
                } else {
                    int i = 0;
                    while (i < data.length) {
                        Debug.println("  " + data[i]);
                        ++i;
                    }
                }
            }
            storage.setPermissionData(location, data);
        }
        catch (IOException e) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            return;
        }
        AbstractBundle bundle = this.framework.getBundleByLocation(location);
        if (bundle != null && bundle.getBundleId() != 0L && (domain = bundle.getProtectionDomain()) != null) {
            BundleCombinedPermissions combined = (BundleCombinedPermissions)domain.getPermissions();
            if (permissions == null) {
                combined.setAssignedPermissions(this.defaultAssignedPermissions, true);
            } else {
                combined.setAssignedPermissions(this.createPermissions(permissions, bundle, false), false);
            }
        }
    }

    public String[] getLocations() {
        SecurePermissionStorage storage = new SecurePermissionStorage(this.storage);
        try {
            String[] locations = storage.getLocations();
            return locations;
        }
        catch (IOException e) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            return null;
        }
    }

    public PermissionInfo[] getDefaultPermissions() {
        SecurePermissionStorage storage = new SecurePermissionStorage(this.storage);
        try {
            String[] data = storage.getPermissionData(null);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Getting default permissions");
                if (data == null) {
                    Debug.println("  <none>");
                } else {
                    int i = 0;
                    while (i < data.length) {
                        Debug.println("  " + data[i]);
                        ++i;
                    }
                }
            }
            return this.makePermissionInfo(data);
        }
        catch (IOException e) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            return null;
        }
    }

    public void setDefaultPermissions(PermissionInfo[] permissions) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AllPermission());
        }
        SecurePermissionStorage storage = new SecurePermissionStorage(this.storage);
        try {
            String[] data = this.makePermissionData(permissions);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Setting default permissions");
                if (data == null) {
                    Debug.println("  <none>");
                } else {
                    int i = 0;
                    while (i < data.length) {
                        Debug.println("  " + data[i]);
                        ++i;
                    }
                }
            }
            storage.setPermissionData(null, data);
        }
        catch (IOException e) {
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
            return;
        }
        this.defaultAssignedPermissions.setAssignedPermissions(this.createDefaultAssignedPermissions(permissions), true);
    }

    protected PermissionInfo[] makePermissionInfo(String[] data) {
        if (data == null) {
            return null;
        }
        int size = data.length;
        PermissionInfo[] permissions = new PermissionInfo[size];
        int i = 0;
        while (i < size) {
            permissions[i] = new PermissionInfo(data[i]);
            ++i;
        }
        return permissions;
    }

    protected String[] makePermissionData(PermissionInfo[] permissions) {
        if (permissions == null) {
            return null;
        }
        int size = permissions.length;
        String[] data = new String[size];
        int i = 0;
        while (i < size) {
            data[i] = permissions[i].getEncoded();
            ++i;
        }
        return data;
    }

    protected BundleProtectionDomain createProtectionDomain(AbstractBundle bundle) {
        BundlePermissionCollection assigned;
        BundlePermissionCollection implied = this.getImpliedPermissions(bundle);
        BundleCombinedPermissions combined = new BundleCombinedPermissions(implied);
        combined.setAssignedPermissions(assigned, (assigned = this.getAssignedPermissions(bundle)) == this.defaultAssignedPermissions);
        combined.setConditionalPermissions(new ConditionalPermissions(bundle, this.framework.condPermAdmin));
        PermissionInfo[] permInfos = this.getPermissionInfos(bundle.getEntry("OSGI-INF/permissions.perm"));
        if (permInfos != null) {
            ConditionalPermissionInfoImpl[] cpiArray = new ConditionalPermissionInfoImpl[]{new ConditionalPermissionInfoImpl(null, ConditionalPermissionAdminImpl.EMPTY_COND_INFO, permInfos)};
            ConditionalPermissionSet cps = new ConditionalPermissionSet(bundle, cpiArray, ConditionalPermissionAdminImpl.EMPTY_COND);
            combined.setRestrictedPermissions(cps);
        }
        return new BundleProtectionDomainImpl(bundle, (PermissionCollection)combined);
    }

    protected BundlePermissionCollection createDefaultAssignedPermissions(PermissionInfo[] info) {
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Creating default assigned permissions");
        }
        if (info == null) {
            info = this.defaultDefaultPermissionInfos;
        }
        return this.createPermissions(info, null, false);
    }

    protected BundlePermissionCollection getAssignedPermissions(AbstractBundle bundle) {
        String location = bundle.getLocation();
        PermissionInfo[] info = this.getPermissions(location);
        if (info == null) {
            return this.defaultAssignedPermissions;
        }
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Creating assigned permissions for " + bundle);
        }
        return this.createPermissions(info, bundle, false);
    }

    protected BundlePermissionCollection getImpliedPermissions(AbstractBundle bundle) {
        if (Debug.DEBUG_SECURITY) {
            Debug.println("Creating implied permissions for " + bundle);
        }
        return this.createPermissions(this.baseImpliedPermissionInfos, bundle, true);
    }

    protected PermissionInfo[] getPermissionInfos(URL resource) {
        PermissionInfo[] info;
        block22: {
            DataInputStream in;
            block21: {
                if (resource == null) {
                    return null;
                }
                info = ConditionalPermissionAdminImpl.EMPTY_PERM_INFO;
                in = null;
                try {
                    try {
                        String line;
                        BufferedReader reader;
                        in = new DataInputStream(resource.openStream());
                        ArrayList<PermissionInfo> permissions = new ArrayList<PermissionInfo>();
                        try {
                            reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            reader = new BufferedReader(new InputStreamReader(in));
                        }
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("//")) continue;
                            try {
                                permissions.add(new PermissionInfo(line));
                            }
                            catch (IllegalArgumentException iae) {
                                this.framework.publishFrameworkEvent(2, this.framework.systemBundle, iae);
                            }
                        }
                        int size = permissions.size();
                        if (size > 0) {
                            info = permissions.toArray(new PermissionInfo[size]);
                        }
                    }
                    catch (IOException iOException) {
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block22;
                }
                catch (IOException iOException) {}
                break block22;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return info;
    }

    protected BundlePermissionCollection createPermissions(PermissionInfo[] info, AbstractBundle bundle, boolean implied) {
        if (info == null) {
            info = new PermissionInfo[]{};
        }
        if (implied) {
            PermissionInfo impliedInfo = new PermissionInfo(AdminPermission.class.getName(), "(id=" + bundle.getBundleId() + ")", ADMIN_IMPLIED_ACTIONS);
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Created permission: " + impliedInfo);
            }
            PermissionInfo[] impliedInfos = new PermissionInfo[info.length + 1];
            System.arraycopy(info, 0, impliedInfos, 0, info.length);
            impliedInfos[info.length] = impliedInfo;
            info = impliedInfos;
        }
        ConditionalPermissionInfoImpl[] cpiArray = new ConditionalPermissionInfoImpl[]{new ConditionalPermissionInfoImpl(null, ConditionalPermissionAdminImpl.EMPTY_COND_INFO, info)};
        return new ConditionalPermissionSet(bundle, cpiArray, ConditionalPermissionAdminImpl.EMPTY_COND);
    }
}

