/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.search;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.xhtml.XHTMLSupport;
import org.eclipse.help.search.ISearchIndex;
import org.eclipse.help.search.LuceneSearchParticipant;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLSearchParticipant
extends LuceneSearchParticipant {
    private Stack stack = new Stack();
    private SAXParser parser;
    private Set filters;

    protected abstract void handleStartElement(String var1, Attributes var2, IParsedXMLContent var3);

    protected abstract void handleEndElement(String var1, IParsedXMLContent var2);

    protected void handleStartDocument(IParsedXMLContent data) {
    }

    protected void handleEndDocument(IParsedXMLContent data) {
    }

    protected void handleProcessingInstruction(String type, IParsedXMLContent data) {
    }

    protected abstract void handleText(String var1, IParsedXMLContent var2);

    /*
     * Loose catch block
     */
    public IStatus addDocument(ISearchIndex index, String pluginId, String name, URL url, String id, Document doc) {
        IStatus iStatus;
        InputStream stream;
        block15: {
            String summary;
            this.filters = new HashSet();
            stream = null;
            if (this.parser == null) {
                this.parser = SAXParserFactory.newInstance().newSAXParser();
            }
            this.stack.clear();
            ParsedXMLContent parsed = new ParsedXMLContent(index.getLocale());
            XMLHandler handler = new XMLHandler(parsed);
            stream = url.openStream();
            this.parser.parse(stream, (DefaultHandler)handler);
            doc.add(Field.Text((String)"contents", (Reader)parsed.newContentReader()));
            doc.add(Field.Text((String)"exact_contents", (Reader)parsed.newContentReader()));
            String title = parsed.getTitle();
            if (title != null) {
                this.addTitle(title, doc);
            }
            if ((summary = parsed.getSummary()) != null) {
                doc.add(Field.UnIndexed((String)"summary", (String)summary));
            }
            if (doc.getField("filters") == null && this.filters.size() > 0) {
                this.filters = this.generalizeFilters(this.filters);
                doc.add(Field.UnIndexed((String)"filters", (String)this.serializeFilters(this.filters)));
            }
            iStatus = Status.OK_STATUS;
            if (stream == null) break block15;
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            stream = null;
        }
        return iStatus;
        catch (Exception e) {
            Status status;
            block16: {
                try {
                    status = new Status(4, "org.eclipse.help.base", 4, "Exception occurred while adding document " + name + " to index.", (Throwable)e);
                    if (stream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        stream = null;
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                stream = null;
            }
            return status;
        }
    }

    protected String getTopElement() {
        return (String)this.stack.peek();
    }

    protected String getElementStackPath() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.stack.size()) {
            if (i > 0) {
                buf.append("/");
            }
            buf.append((String)this.stack.get(i));
            ++i;
        }
        return buf.toString();
    }

    private Set generalizeFilters(Set filters) {
        HashSet<String> processed = new HashSet<String>();
        for (String filter : filters) {
            int index = filter.indexOf(61);
            if (index <= 0) continue;
            String name = filter.substring(0, index);
            if (XHTMLSupport.getFilterProcessor().isMultiValue(name)) {
                processed.add(filter);
                continue;
            }
            processed.add(name);
        }
        return processed;
    }

    private String serializeFilters(Set set) {
        StringBuffer buf = new StringBuffer();
        Iterator iter = set.iterator();
        boolean firstIter = true;
        while (iter.hasNext()) {
            if (!firstIter) {
                buf.append(',');
            }
            firstIter = false;
            buf.append(iter.next());
        }
        return buf.toString();
    }

    protected static interface IParsedXMLContent {
        public String getLocale();

        public void setTitle(String var1);

        public void addToSummary(String var1);

        public void addText(String var1);
    }

    private static class ParsedXMLContent
    implements IParsedXMLContent {
        private StringBuffer buffer = new StringBuffer();
        private StringBuffer summary = new StringBuffer();
        private String title;
        private String locale;
        private static int SUMMARY_LENGTH = 200;

        public ParsedXMLContent(String locale) {
            this.locale = locale;
        }

        public String getLocale() {
            return this.locale;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void addToSummary(String text) {
            if (this.summary.length() >= SUMMARY_LENGTH) {
                return;
            }
            if (this.summary.length() > 0) {
                this.summary.append(" ");
            }
            this.summary.append(text);
            if (this.summary.length() > SUMMARY_LENGTH) {
                this.summary.delete(SUMMARY_LENGTH, this.summary.length());
            }
        }

        public void addText(String text) {
            if (this.buffer.length() > 0) {
                this.buffer.append(" ");
            }
            this.buffer.append(text);
        }

        public Reader newContentReader() {
            return new StringReader(this.buffer.toString());
        }

        public String getSummary() {
            return this.summary.toString();
        }

        public String getTitle() {
            return this.title;
        }
    }

    private class XMLHandler
    extends DefaultHandler {
        public ParsedXMLContent data;

        public XMLHandler(ParsedXMLContent data) {
            this.data = data;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            XMLSearchParticipant.this.stack.push(qName);
            XMLSearchParticipant.this.handleStartElement(qName, attributes, this.data);
            String filterAttribute = attributes.getValue("filter");
            if (filterAttribute != null) {
                XMLSearchParticipant.this.filters.add(filterAttribute);
            }
            if (qName.equalsIgnoreCase("filter")) {
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                if (name != null && value != null) {
                    XMLSearchParticipant.this.filters.add(String.valueOf(name) + '=' + value);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            XMLSearchParticipant.this.handleEndElement(qName, this.data);
            String top = (String)XMLSearchParticipant.this.stack.peek();
            if (top != null && top.equals(qName)) {
                XMLSearchParticipant.this.stack.pop();
            }
        }

        public void startDocument() throws SAXException {
            XMLSearchParticipant.this.handleStartDocument(this.data);
        }

        public void endDocument() throws SAXException {
            XMLSearchParticipant.this.handleEndDocument(this.data);
        }

        public void processingInstruction(String target, String pidata) throws SAXException {
            XMLSearchParticipant.this.handleProcessingInstruction(target, this.data);
        }

        public void characters(char[] characters, int start, int length) throws SAXException {
            if (length == 0) {
                return;
            }
            StringBuffer buff = new StringBuffer();
            int i = 0;
            while (i < length) {
                buff.append(characters[start + i]);
                ++i;
            }
            String text = buff.toString().trim();
            if (text.length() > 0) {
                XMLSearchParticipant.this.handleText(text, this.data);
            }
        }
    }
}

