/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable.set;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.internal.databinding.provisional.observable.AbstractObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.ObservableTracker;
import org.eclipse.jface.internal.databinding.provisional.observable.set.IObservableSet;
import org.eclipse.jface.internal.databinding.provisional.observable.set.ISetChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.set.SetDiff;

public abstract class ObservableSet
extends AbstractObservable
implements IObservableSet {
    protected Set wrappedSet;
    private boolean stale = false;
    private Object setChangeListeners;
    protected Object elementType;

    protected ObservableSet(Set wrappedSet, Object elementType) {
        this.wrappedSet = wrappedSet;
        this.elementType = elementType;
    }

    public void addSetChangeListener(ISetChangeListener listener) {
        ArrayList<ISetChangeListener> listenerList;
        if (this.setChangeListeners == null) {
            boolean hadListeners = this.hasListeners();
            this.setChangeListeners = listener;
            if (!hadListeners) {
                this.firstListenerAdded();
            }
            return;
        }
        if (this.setChangeListeners instanceof Collection) {
            listenerList = (ArrayList<ISetChangeListener>)this.setChangeListeners;
        } else {
            ISetChangeListener l = (ISetChangeListener)this.setChangeListeners;
            listenerList = new ArrayList<ISetChangeListener>();
            listenerList.add(l);
            this.setChangeListeners = listenerList;
        }
        if (listenerList.size() > 16) {
            HashSet<ISetChangeListener> listenerSet = new HashSet<ISetChangeListener>();
            listenerSet.addAll(listenerList);
            this.setChangeListeners = listenerList;
        }
        listenerList.add(listener);
    }

    public void removeSetChangeListener(ISetChangeListener listener) {
        if (this.setChangeListeners == listener) {
            this.setChangeListeners = null;
            if (!this.hasListeners()) {
                this.lastListenerRemoved();
            }
            return;
        }
        if (this.setChangeListeners instanceof Collection) {
            Collection listenerList = (Collection)this.setChangeListeners;
            listenerList.remove(listener);
            if (listenerList.size() == 0) {
                this.setChangeListeners = null;
                if (!this.hasListeners()) {
                    this.lastListenerRemoved();
                }
            }
        }
    }

    protected boolean hasListeners() {
        return super.hasListeners() || this.setChangeListeners != null;
    }

    protected void fireSetChange(SetDiff diff) {
        super.fireChange();
        if (this.setChangeListeners == null) {
            return;
        }
        if (this.setChangeListeners instanceof ISetChangeListener) {
            ((ISetChangeListener)this.setChangeListeners).handleSetChange(this, diff);
            return;
        }
        Collection changeListenerCollection = (Collection)this.setChangeListeners;
        ISetChangeListener[] listeners = changeListenerCollection.toArray(new ISetChangeListener[changeListenerCollection.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].handleSetChange(this, diff);
            ++i;
        }
    }

    public boolean contains(Object o) {
        this.getterCalled();
        return this.wrappedSet.contains(o);
    }

    public boolean containsAll(Collection c) {
        this.getterCalled();
        return this.wrappedSet.containsAll(c);
    }

    public boolean equals(Object o) {
        this.getterCalled();
        return this.wrappedSet.equals(o);
    }

    public int hashCode() {
        this.getterCalled();
        return this.wrappedSet.hashCode();
    }

    public boolean isEmpty() {
        this.getterCalled();
        return this.wrappedSet.isEmpty();
    }

    public Iterator iterator() {
        final Iterator wrappedIterator = this.wrappedSet.iterator();
        return new Iterator(){

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                ObservableTracker.getterCalled(ObservableSet.this);
                return wrappedIterator.hasNext();
            }

            public Object next() {
                ObservableTracker.getterCalled(ObservableSet.this);
                return wrappedIterator.next();
            }
        };
    }

    public int size() {
        this.getterCalled();
        return this.wrappedSet.size();
    }

    public Object[] toArray() {
        this.getterCalled();
        return this.wrappedSet.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.getterCalled();
        return this.wrappedSet.toArray(a);
    }

    public String toString() {
        this.getterCalled();
        return this.wrappedSet.toString();
    }

    protected void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean isStale() {
        return this.stale;
    }

    public void setStale(boolean stale) {
        boolean wasStale = this.stale;
        this.stale = stale;
        if (!wasStale && stale) {
            this.fireStale();
        }
    }

    protected void setWrappedSet(Set wrappedSet) {
        this.wrappedSet = wrappedSet;
    }

    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireSetChange() instead");
    }

    public void dispose() {
        this.setChangeListeners = null;
        super.dispose();
    }

    public Object getElementType() {
        return this.elementType;
    }
}

