/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.internal.databinding.provisional.BindingEvent;
import org.eclipse.jface.internal.databinding.provisional.DataBindingContext;
import org.eclipse.jface.internal.databinding.provisional.IBindingListener;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IObservableValue;
import org.eclipse.jface.internal.databinding.provisional.validation.ValidationError;

public abstract class Binding {
    private List bindingEventListeners = new ArrayList();
    protected final DataBindingContext context;

    public Binding(DataBindingContext context) {
        this.context = context;
    }

    public void addBindingEventListener(IBindingListener listener) {
        this.bindingEventListeners.add(listener);
    }

    protected ValidationError fireBindingEvent(BindingEvent event) {
        ValidationError result = null;
        IBindingListener[] listeners = this.bindingEventListeners.toArray(new IBindingListener[this.bindingEventListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            IBindingListener listener = listeners[i];
            result = listener.bindingEvent(event);
            if (result != null) break;
            ++i;
        }
        if (result == null) {
            result = this.context.fireBindingEvent(event);
        }
        return result;
    }

    public abstract IObservableValue getPartialValidationError();

    public abstract IObservableValue getValidationError();

    public void removeBindingEventListener(IBindingListener listener) {
        this.bindingEventListeners.remove(listener);
    }

    public abstract void updateModelFromTarget();

    public abstract void updateTargetFromModel();
}

