/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.ui.internal.menus.ILayoutNode;
import org.eclipse.ui.internal.menus.ILocationElementTokenizer;
import org.eclipse.ui.internal.menus.LayoutNode;
import org.eclipse.ui.internal.menus.LeafLocationElement;
import org.eclipse.ui.internal.menus.LocationElementToken;
import org.eclipse.ui.internal.menus.MenuElement;
import org.eclipse.ui.internal.menus.SBar;
import org.eclipse.ui.internal.menus.SLocation;
import org.eclipse.ui.internal.menus.SPopup;

class SPartMenuLayout {
    public static final String PATH_DELIMITERS = "/";
    private final Map barsByType = new HashMap();
    private final Map popupsById = new HashMap();

    protected static final void insertElementIntoNode(MenuElement element, SLocation location, LeafLocationElement locationElement, LayoutNode node) throws NotDefinedException {
        ILocationElementTokenizer tokenizer = locationElement.getTokenizer();
        while (tokenizer.hasMoreTokens()) {
            LocationElementToken token = tokenizer.nextToken();
            node = node.getChildNode(token);
        }
        node.createChildNode(element, location);
    }

    protected SPartMenuLayout() {
    }

    protected final void addBar(MenuElement element, SLocation location, SBar bar) throws NotDefinedException {
        String type = bar.getType();
        LayoutNode node = (LayoutNode)this.barsByType.get(type);
        if (node == null) {
            node = new LayoutNode();
            this.barsByType.put(type, node);
        }
        SPartMenuLayout.insertElementIntoNode(element, location, bar, node);
    }

    protected final void addPopup(MenuElement element, SLocation location, SPopup popup) throws NotDefinedException {
        String popupId = popup.getId();
        LayoutNode node = (LayoutNode)this.popupsById.get(popupId);
        if (node == null) {
            node = new LayoutNode();
            this.popupsById.put(popupId, node);
        }
        SPartMenuLayout.insertElementIntoNode(element, location, popup, node);
    }

    public final ILayoutNode getBar(String type) {
        return (ILayoutNode)this.barsByType.get(type);
    }

    public final ILayoutNode getMenuBar() {
        return (ILayoutNode)this.barsByType.get("menu");
    }

    protected final Map getBarsByType() {
        return this.barsByType;
    }

    protected final Map getPopupsById() {
        return this.popupsById;
    }

    protected final void printNode(LayoutNode node, StringBuffer buffer, int indent) {
        int i = 0;
        while (i < indent) {
            buffer.append(' ');
            ++i;
        }
        buffer.append((Object)node.getMenuElement());
        buffer.append('\n');
        List children = node.getChildrenSorted();
        for (LayoutNode childNode : children) {
            this.printNode(childNode, buffer, indent + 2);
        }
    }

    public String toString() {
        LayoutNode node;
        StringBuffer buffer = new StringBuffer();
        buffer.append("   ___ top-level bars ___ \n");
        for (Map.Entry entry : this.getBarsByType().entrySet()) {
            String type = (String)entry.getKey();
            buffer.append(' ');
            buffer.append(' ');
            buffer.append(type);
            buffer.append('\n');
            node = (LayoutNode)entry.getValue();
            this.printNode(node, buffer, 4);
        }
        buffer.append("   ___ context menus ___ \n");
        for (Map.Entry entry : this.getPopupsById().entrySet()) {
            String id = (String)entry.getKey();
            buffer.append(' ');
            buffer.append(' ');
            buffer.append(id);
            buffer.append('\n');
            node = (LayoutNode)entry.getValue();
            this.printNode(node, buffer, 4);
        }
        return buffer.toString();
    }
}

