/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.util;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.ExtJarFactoryContainer;
import org.eclipse.jdt.apt.core.internal.PluginFactoryContainer;
import org.eclipse.jdt.apt.core.internal.VarJarFactoryContainer;
import org.eclipse.jdt.apt.core.internal.WkspJarFactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;
import org.eclipse.jdt.apt.core.internal.util.FileSystemUtil;
import org.eclipse.jdt.apt.core.internal.util.Messages;
import org.eclipse.jdt.apt.core.util.IFactoryPath;
import org.eclipse.jdt.core.IJavaProject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryPathUtil {
    private static final String FACTORYPATH_TAG = "factorypath";
    private static final String FACTORYPATH_ENTRY_TAG = "factorypathentry";
    private static final String KIND = "kind";
    private static final String ID = "id";
    private static final String ENABLED = "enabled";
    private static final String RUN_IN_BATCH_MODE = "runInBatchMode";
    private static final String FACTORYPATH_FILE = ".factorypath";
    private static final String INDENT = "    ";
    private static final HashMap<String, AnnotationProcessorFactory> PLUGIN_FACTORY_MAP = new HashMap();
    private static final TreeMap<String, PluginFactoryContainer> PLUGIN_CONTAINER_MAP = new TreeMap();
    private static boolean mapsInitialized = false;

    private FactoryPathUtil() {
    }

    public static boolean isFactoryPathFile(IResource res) {
        if (res == null || res.getType() != 1 || res.getProject() == null) {
            return false;
        }
        IPath path = res.getProjectRelativePath();
        if (path.segmentCount() != 1) {
            return false;
        }
        return FACTORYPATH_FILE.equals(path.lastSegment());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<FactoryContainer, FactoryPath.Attributes> readFactoryPathFile(IJavaProject jproj) throws CoreException {
        String data = null;
        try {
            if (jproj == null) {
                File file = FactoryPathUtil.getFileForWorkspace();
                if (!file.exists()) {
                    return null;
                }
                data = FileSystemUtil.getContentsOfFile(file);
                return FactoryPathUtil.decodeFactoryPath(data);
            }
            IFile ifile = FactoryPathUtil.getIFileForProject(jproj);
            if (!ifile.exists()) {
                return null;
            }
            data = FileSystemUtil.getContentsOfIFile(ifile);
            return FactoryPathUtil.decodeFactoryPath(data);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.apt.core", -1, Messages.FactoryPathUtil_status_ioException, (Throwable)e));
        }
    }

    public static void saveFactoryPathFile(IJavaProject jproj, Map<FactoryContainer, FactoryPath.Attributes> containers) throws CoreException {
        File wkspFile;
        IFile projFile;
        if (jproj != null) {
            projFile = FactoryPathUtil.getIFileForProject(jproj);
            wkspFile = null;
        } else {
            wkspFile = FactoryPathUtil.getFileForWorkspace();
            projFile = null;
        }
        try {
            if (containers != null) {
                String data = FactoryPathUtil.encodeFactoryPath(containers);
                if (jproj == null) {
                    FileSystemUtil.writeStringToFile(wkspFile, data);
                } else {
                    FileSystemUtil.writeStringToIFile(projFile, data);
                }
            } else if (jproj != null) {
                projFile.delete(true, null);
            } else {
                wkspFile.delete();
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.apt.core", -1, Messages.FactoryPathUtil_status_ioException, (Throwable)e));
        }
    }

    public static String encodeFactoryPath(Map<FactoryContainer, FactoryPath.Attributes> factories) {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(FACTORYPATH_TAG).append(">\n");
        for (Map.Entry<FactoryContainer, FactoryPath.Attributes> entry : factories.entrySet()) {
            FactoryContainer container = entry.getKey();
            FactoryPath.Attributes attr = entry.getValue();
            sb.append(INDENT);
            sb.append("<");
            sb.append(FACTORYPATH_ENTRY_TAG).append(" ");
            sb.append(KIND).append("=\"").append((Object)container.getType()).append("\" ");
            sb.append(ID).append("=\"").append(container.getId()).append("\" ");
            sb.append(ENABLED).append("=\"").append(attr.isEnabled()).append("\" ");
            sb.append(RUN_IN_BATCH_MODE).append("=\"").append(attr.runInBatchMode()).append("\"/>\n");
        }
        sb.append("</").append(FACTORYPATH_TAG).append(">\n");
        return sb.toString();
    }

    public static FactoryContainer newExtJarFactoryContainer(File jar) {
        return new ExtJarFactoryContainer(jar);
    }

    public static FactoryContainer newWkspJarFactoryContainer(IPath jar) {
        return new WkspJarFactoryContainer(jar);
    }

    public static FactoryContainer newVarJarFactoryContainer(IPath jar) {
        return new VarJarFactoryContainer(jar);
    }

    public static Map<FactoryContainer, FactoryPath.Attributes> decodeFactoryPath(String xmlFactoryPath) throws CoreException {
        LinkedHashMap<FactoryContainer, FactoryPath.Attributes> result = new LinkedHashMap<FactoryContainer, FactoryPath.Attributes>();
        StringReader reader = new StringReader(xmlFactoryPath);
        Element fpElement = null;
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                fpElement = parser.parse(new InputSource(reader)).getDocumentElement();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.apt.core", -1, Messages.FactoryPathUtil_status_ioException, (Throwable)e));
            }
            catch (SAXException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.apt.core", -1, Messages.FactoryPathUtil_status_couldNotParse, (Throwable)e));
            }
            catch (ParserConfigurationException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.apt.core", -1, Messages.FactoryPathUtil_status_parserConfigError, (Throwable)e));
            }
        }
        finally {
            reader.close();
        }
        if (!fpElement.getNodeName().equalsIgnoreCase(FACTORYPATH_TAG)) {
            IOException e = new IOException("Incorrect file format. File must begin with factorypath");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.apt.core", -1, Messages.FactoryPathUtil_status_ioException, (Throwable)e));
        }
        NodeList nodes = fpElement.getElementsByTagName(FACTORYPATH_ENTRY_TAG);
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String kindString = element.getAttribute(KIND);
                if ("JAR".equals(kindString)) {
                    kindString = "EXTJAR";
                }
                String idString = element.getAttribute(ID);
                String enabledString = element.getAttribute(ENABLED);
                String runInAptModeString = element.getAttribute(RUN_IN_BATCH_MODE);
                FactoryContainer.FactoryType kind = FactoryContainer.FactoryType.valueOf(kindString);
                FactoryContainer container = null;
                switch (kind) {
                    case WKSPJAR: {
                        container = FactoryPathUtil.newWkspJarFactoryContainer((IPath)new Path(idString));
                        break;
                    }
                    case EXTJAR: {
                        container = FactoryPathUtil.newExtJarFactoryContainer(new File(idString));
                        break;
                    }
                    case VARJAR: {
                        container = FactoryPathUtil.newVarJarFactoryContainer((IPath)new Path(idString));
                        break;
                    }
                    case PLUGIN: {
                        container = FactoryPathUtil.getPluginFactoryContainer(idString);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unrecognized kind: " + (Object)((Object)kind) + ". Original string: " + kindString);
                    }
                }
                if (container != null) {
                    FactoryPath.Attributes a = new FactoryPath.Attributes(Boolean.parseBoolean(enabledString), Boolean.parseBoolean(runInAptModeString));
                    result.put(container, a);
                }
            }
            ++i;
        }
        return result;
    }

    private static File getFileForWorkspace() {
        return AptPlugin.getPlugin().getStateLocation().append(FACTORYPATH_FILE).toFile();
    }

    private static IFile getIFileForProject(IJavaProject jproj) {
        IProject proj = jproj.getProject();
        return proj.getFile(FACTORYPATH_FILE);
    }

    public static boolean doesFactoryPathFileExist(IJavaProject jproj) {
        if (jproj == null) {
            File wkspFile = FactoryPathUtil.getFileForWorkspace();
            return wkspFile.exists();
        }
        IFile projFile = FactoryPathUtil.getIFileForProject(jproj);
        return projFile.exists();
    }

    public static IFactoryPath getDefaultFactoryPath(IJavaProject jproj) {
        FactoryPath fp = new FactoryPath();
        if (jproj != null) {
            fp.setContainers(FactoryPathUtil.calculatePath(null));
        } else {
            fp.setContainers(FactoryPathUtil.getAllPluginFactoryContainers());
        }
        return fp;
    }

    public static FactoryPath getFactoryPath(IJavaProject jproj) {
        Map<FactoryContainer, FactoryPath.Attributes> map = FactoryPathUtil.calculatePath(jproj);
        FactoryPath fp = new FactoryPath();
        fp.setContainers(map);
        return fp;
    }

    public static void setFactoryPath(IJavaProject jproj, FactoryPath path) throws CoreException {
        Map<FactoryContainer, FactoryPath.Attributes> map = path != null ? path.getAllContainers() : null;
        FactoryPathUtil.saveFactoryPathFile(jproj, map);
    }

    private static synchronized Map<FactoryContainer, FactoryPath.Attributes> calculatePath(IJavaProject jproj) {
        Map<FactoryContainer, FactoryPath.Attributes> map = null;
        boolean foundPerProjFile = false;
        if (jproj != null) {
            try {
                map = FactoryPathUtil.readFactoryPathFile(jproj);
                foundPerProjFile = map != null;
            }
            catch (CoreException ce) {
                AptPlugin.log(ce, "Could not get factory containers for project: " + jproj);
            }
        }
        if (map == null) {
            try {
                map = FactoryPathUtil.readFactoryPathFile(null);
            }
            catch (CoreException ce) {
                AptPlugin.log(ce, "Could not get factory containers for project: " + jproj);
            }
        }
        if (map == null) {
            map = new LinkedHashMap<FactoryContainer, FactoryPath.Attributes>();
        }
        boolean disableNewPlugins = jproj != null && foundPerProjFile;
        FactoryPathUtil.updatePluginContainers(map, disableNewPlugins);
        return map;
    }

    private static void updatePluginContainers(Map<FactoryContainer, FactoryPath.Attributes> path, boolean disableNewPlugins) {
        Map<FactoryContainer, FactoryPath.Attributes> pluginContainers = FactoryPathUtil.getAllPluginFactoryContainers();
        Iterator<FactoryContainer> i = path.keySet().iterator();
        while (i.hasNext()) {
            FactoryContainer fc = i.next();
            if (fc.getType() != FactoryContainer.FactoryType.PLUGIN || pluginContainers.containsKey(fc)) continue;
            i.remove();
        }
        for (Map.Entry<FactoryContainer, FactoryPath.Attributes> entry : pluginContainers.entrySet()) {
            if (path.containsKey(entry.getKey())) continue;
            FactoryPath.Attributes oldAttr = entry.getValue();
            FactoryPath.Attributes newAttr = disableNewPlugins ? new FactoryPath.Attributes(false, oldAttr.runInBatchMode()) : oldAttr;
            path.put(entry.getKey(), newAttr);
        }
    }

    private static synchronized Map<FactoryContainer, FactoryPath.Attributes> getAllPluginFactoryContainers() {
        LinkedHashMap<FactoryContainer, FactoryPath.Attributes> map = new LinkedHashMap<FactoryContainer, FactoryPath.Attributes>(FactoryPathUtil.getPluginContainerMap().size());
        for (PluginFactoryContainer pfc : FactoryPathUtil.getPluginContainerMap().values()) {
            FactoryPath.Attributes a = new FactoryPath.Attributes(pfc.getEnableDefault(), false);
            map.put(pfc, a);
        }
        return map;
    }

    public static synchronized AnnotationProcessorFactory getFactoryFromPlugin(String factoryName) {
        AnnotationProcessorFactory apf = FactoryPathUtil.getPluginFactoryMap().get(factoryName);
        if (apf == null) {
            String s = "could not find AnnotationProcessorFactory " + factoryName + " from available factories defined by plugins";
            AptPlugin.log((IStatus)new Status(2, "org.eclipse.jdt.apt.core", 2, s, null));
        }
        return apf;
    }

    public static synchronized FactoryContainer getPluginFactoryContainer(String pluginId) {
        return FactoryPathUtil.getPluginContainerMap().get(pluginId);
    }

    private static TreeMap<String, PluginFactoryContainer> getPluginContainerMap() {
        FactoryPathUtil.loadPluginFactories();
        return PLUGIN_CONTAINER_MAP;
    }

    private static HashMap<String, AnnotationProcessorFactory> getPluginFactoryMap() {
        FactoryPathUtil.loadPluginFactories();
        return PLUGIN_FACTORY_MAP;
    }

    private static synchronized void loadPluginFactories() {
        if (mapsInitialized) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.apt.core", "annotationProcessorFactory");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = 0;
        int n2 = iExtensionArray.length;
        while (n < n2) {
            IExtension extension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = 0;
            int n4 = iConfigurationElementArray.length;
            while (n3 < n4) {
                IConfigurationElement factories = iConfigurationElementArray[n3];
                if ("factories".equals(factories.getName())) {
                    String enableDefaultStr = factories.getAttribute("enableDefault");
                    boolean enableDefault = true;
                    if ("false".equals(enableDefaultStr)) {
                        enableDefault = false;
                    }
                    String pluginId = extension.getNamespaceIdentifier();
                    PluginFactoryContainer pfc = new PluginFactoryContainer(pluginId, enableDefault);
                    PLUGIN_CONTAINER_MAP.put(pluginId, pfc);
                    IConfigurationElement[] iConfigurationElementArray2 = factories.getChildren();
                    int n5 = 0;
                    int n6 = iConfigurationElementArray2.length;
                    while (n5 < n6) {
                        IConfigurationElement factory = iConfigurationElementArray2[n5];
                        if ("factory".equals(factory.getName())) {
                            try {
                                Object execExt = factory.createExecutableExtension("class");
                                if (execExt instanceof AnnotationProcessorFactory) {
                                    String factoryName = execExt.getClass().getName();
                                    PLUGIN_FACTORY_MAP.put(factoryName, (AnnotationProcessorFactory)execExt);
                                    pfc.addFactoryName(factoryName);
                                }
                            }
                            catch (CoreException e) {
                                AptPlugin.log(e, "Unable to load annotation factory from plug-in");
                            }
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
            ++n;
        }
        mapsInitialized = true;
    }
}

