/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.APTDispatchRunnable;
import org.eclipse.jdt.apt.core.internal.AnnotationProcessorFactoryLoader;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.AptProject;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.compiler.ReconcileContext;

public class AptCompilationParticipant
extends CompilationParticipant {
    private Set<AnnotationProcessorFactory> _previousRoundsBatchFactories = new LinkedHashSet<AnnotationProcessorFactory>();
    private int _buildRound = 0;
    private boolean _isBatch = false;
    private static AptCompilationParticipant INSTANCE;
    private Set<IFile> _processedFiles = null;

    public static AptCompilationParticipant getInstance() {
        return INSTANCE;
    }

    public AptCompilationParticipant() {
        INSTANCE = this;
    }

    public boolean isAnnotationProcessor() {
        return true;
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        if (this._buildRound == 0) {
            this._isBatch = isBatch;
        }
    }

    public void processAnnotations(BuildContext[] allfiles) {
        int total;
        int n = total = allfiles == null ? 0 : allfiles.length;
        if (total == 0) {
            return;
        }
        IProject project = allfiles[0].getFile().getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String javaVersion = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        if ("1.3".equals(javaVersion) || "1.4".equals(javaVersion)) {
            return;
        }
        if (this._isBatch && this._buildRound == 0) {
            AnnotationProcessorFactoryLoader.getLoader().resetBatchProcessors(javaProject);
            this._previousRoundsBatchFactories.clear();
        }
        try {
            int annoFileCount = 0;
            int noAnnoFileCount = 0;
            int i = 0;
            while (i < total) {
                if (this._buildRound <= 0 || !this._processedFiles.contains(allfiles[i].getFile())) {
                    if (allfiles[i].hasAnnotations()) {
                        ++annoFileCount;
                    } else {
                        ++noAnnoFileCount;
                    }
                }
                ++i;
            }
            if (annoFileCount == 0 && noAnnoFileCount == 0) {
                return;
            }
            BuildContext[] withAnnotation = null;
            BuildContext[] withoutAnnotation = null;
            if (annoFileCount != 0) {
                withAnnotation = new BuildContext[annoFileCount];
            }
            if (noAnnoFileCount != 0) {
                withoutAnnotation = new BuildContext[noAnnoFileCount];
            }
            int wIndex = 0;
            int woIndex = 0;
            int i2 = 0;
            while (i2 < total) {
                if (!this._processedFiles.contains(allfiles[i2].getFile())) {
                    if (allfiles[i2].hasAnnotations()) {
                        withAnnotation[wIndex++] = allfiles[i2];
                    } else {
                        withoutAnnotation[woIndex++] = allfiles[i2];
                    }
                }
                ++i2;
            }
            BuildContext[] buildContextArray = allfiles;
            int n2 = 0;
            int n3 = buildContextArray.length;
            while (n2 < n3) {
                BuildContext file = buildContextArray[n2];
                this._processedFiles.add(file.getFile());
                ++n2;
            }
            Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories = AnnotationProcessorFactoryLoader.getLoader().getFactoriesAndAttributesForProject(javaProject);
            AptProject aptProject = AptPlugin.getAptProject(javaProject);
            Set<AnnotationProcessorFactory> dispatchedBatchFactories = APTDispatchRunnable.runAPTDuringBuild(withAnnotation, withoutAnnotation, aptProject, factories, this._previousRoundsBatchFactories, this._isBatch);
            this._previousRoundsBatchFactories.addAll(dispatchedBatchFactories);
        }
        finally {
            ++this._buildRound;
        }
    }

    public void reconcile(ReconcileContext context) {
        try {
            ICompilationUnit workingCopy = context.getWorkingCopy();
            if (workingCopy == null) {
                return;
            }
            IJavaProject javaProject = workingCopy.getJavaProject();
            if (javaProject == null) {
                return;
            }
            AptProject aptProject = AptPlugin.getAptProject(javaProject);
            Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories = AnnotationProcessorFactoryLoader.getLoader().getFactoriesAndAttributesForProject(javaProject);
            APTDispatchRunnable.runAPTDuringReconcile(context, aptProject, factories);
        }
        catch (Throwable t) {
            AptPlugin.log(t, "Failure processing");
        }
    }

    public void cleanStarting(IJavaProject javaProject) {
        IProject p = javaProject.getProject();
        AptPlugin.getAptProject(javaProject).projectClean(true);
        try {
            IMarker[] markers = p.findMarkers("org.eclipse.jdt.apt.core.marker", true, 2);
            if (markers != null) {
                IMarker[] iMarkerArray = markers;
                int n = 0;
                int n2 = iMarkerArray.length;
                while (n < n2) {
                    IMarker marker = iMarkerArray[n];
                    marker.delete();
                    ++n;
                }
            }
        }
        catch (CoreException e) {
            AptPlugin.log(e, "Unable to delete batch annotation processor markers");
        }
    }

    public boolean isActive(IJavaProject project) {
        return AptConfig.isEnabled(project);
    }

    public int aboutToBuild(IJavaProject project) {
        if (AptConfig.isEnabled(project)) {
            AptPlugin.getAptProject(project).compilationStarted();
        }
        this._buildRound = 0;
        this._processedFiles = new HashSet<IFile>();
        return CompilationParticipant.READY_FOR_BUILD;
    }
}

