/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.operations.ReplaceOperation;
import org.eclipse.team.internal.ccvs.ui.operations.SingleProjectScopeManager;
import org.eclipse.team.internal.ccvs.ui.operations.SingleProjectSubscriberContext;
import org.eclipse.ui.IWorkbenchPart;

public class OverrideAndUpdateOperation
extends ReplaceOperation {
    private IResource[] conflictingAdditions;
    private final IProject project;

    public OverrideAndUpdateOperation(IWorkbenchPart part, IProject project, IResource[] allResources, IResource[] conflictingAdditions, CVSTag tag, boolean recurse) {
        super(part, allResources, tag, recurse);
        this.project = project;
        this.conflictingAdditions = conflictingAdditions;
    }

    protected ICVSResource[] getResourcesToUpdate(ICVSResource[] resources) throws CVSException {
        HashSet update = new HashSet();
        ICVSResource[] conflicts = this.getCVSArguments(this.conflictingAdditions);
        update.addAll(Arrays.asList(conflicts));
        update.addAll(Arrays.asList(super.getResourcesToUpdate(resources)));
        return update.toArray(new ICVSResource[update.size()]);
    }

    protected ResourceMappingContext getResourceMappingContext() {
        return new SingleProjectSubscriberContext((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber(), false, this.project);
    }

    protected SynchronizationScopeManager createScopeManager(boolean consultModels) {
        return new SingleProjectScopeManager(this.getJobName(), this.getSelectedMappings(), this.getResourceMappingContext(), consultModels, this.project);
    }
}

