/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor.selectionactions;

import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.SelectionActionMessages;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.SelectionHistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class StructureSelectHistoryAction
extends Action
implements IUpdate {
    private JavaEditor fEditor;
    private SelectionHistory fHistory;

    public StructureSelectHistoryAction(JavaEditor editor, SelectionHistory history) {
        super(SelectionActionMessages.StructureSelectHistory_label);
        this.setToolTipText(SelectionActionMessages.StructureSelectHistory_tooltip);
        this.setDescription(SelectionActionMessages.StructureSelectHistory_description);
        Assert.isNotNull((Object)history);
        Assert.isNotNull((Object)editor);
        this.fHistory = history;
        this.fEditor = editor;
        this.update();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.structured_selection_history_action");
    }

    public void update() {
        this.setEnabled(!this.fHistory.isEmpty());
    }

    public void run() {
        ISourceRange old = this.fHistory.getLast();
        if (old != null) {
            try {
                this.fHistory.ignoreSelectionChanges();
                this.fEditor.selectAndReveal(old.getOffset(), old.getLength());
            }
            finally {
                this.fHistory.listenToSelectionChanges();
            }
        }
    }
}

