/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;

public class LinkedNodeFinder {
    private static final int FIELD = 1;
    private static final int METHOD = 2;
    private static final int TYPE = 4;
    private static final int LABEL = 8;
    private static final int NAME = 5;

    private LinkedNodeFinder() {
    }

    public static SimpleName[] findByBinding(ASTNode root, IBinding binding) {
        ArrayList res = new ArrayList();
        BindingFinder nodeFinder = new BindingFinder(binding, res);
        root.accept((ASTVisitor)nodeFinder);
        return res.toArray(new SimpleName[res.size()]);
    }

    public static SimpleName[] findByNode(ASTNode root, SimpleName name) {
        IBinding binding = name.resolveBinding();
        if (binding != null) {
            return LinkedNodeFinder.findByBinding(root, binding);
        }
        SimpleName[] names = LinkedNodeFinder.findByProblems(root, name);
        if (names != null) {
            return names;
        }
        int parentKind = name.getParent().getNodeType();
        if (parentKind == 30 || parentKind == 10 || parentKind == 18) {
            ArrayList res = new ArrayList();
            LabelFinder nodeFinder = new LabelFinder(name, res);
            root.accept((ASTVisitor)nodeFinder);
            return res.toArray(new SimpleName[res.size()]);
        }
        return new SimpleName[]{name};
    }

    private static int getProblemKind(IProblem problem) {
        switch (problem.getID()) {
            case 33554502: {
                return 1;
            }
            case 0x4000064: {
                return 2;
            }
            case 536871086: {
                return 8;
            }
            case 0x22000032: {
                return 5;
            }
            case 0x1000002: {
                return 4;
            }
        }
        return 0;
    }

    private static int getNameNodeProblemKind(IProblem[] problems, SimpleName nameNode) {
        int nameOffset = nameNode.getStartPosition();
        int nameInclEnd = nameOffset + nameNode.getLength() - 1;
        int i = 0;
        while (i < problems.length) {
            int kind;
            IProblem curr = problems[i];
            if (curr.getSourceStart() == nameOffset && curr.getSourceEnd() == nameInclEnd && (kind = LinkedNodeFinder.getProblemKind(curr)) != 0) {
                return kind;
            }
            ++i;
        }
        return 0;
    }

    public static SimpleName[] findByProblems(ASTNode parent, SimpleName nameNode) {
        ArrayList<ASTNode> res = new ArrayList<ASTNode>();
        ASTNode astRoot = parent.getRoot();
        if (!(astRoot instanceof CompilationUnit)) {
            return null;
        }
        IProblem[] problems = ((CompilationUnit)astRoot).getProblems();
        int nameNodeKind = LinkedNodeFinder.getNameNodeProblemKind(problems, nameNode);
        if (nameNodeKind == 0) {
            return null;
        }
        int bodyStart = parent.getStartPosition();
        int bodyEnd = bodyStart + parent.getLength();
        String name = nameNode.getIdentifier();
        int i = 0;
        while (i < problems.length) {
            ASTNode node;
            int currKind;
            IProblem curr = problems[i];
            int probStart = curr.getSourceStart();
            int probEnd = curr.getSourceEnd() + 1;
            if (probStart > bodyStart && probEnd < bodyEnd && (nameNodeKind & (currKind = LinkedNodeFinder.getProblemKind(curr))) != 0 && (node = NodeFinder.perform(parent, probStart, probEnd - probStart)) instanceof SimpleName && name.equals(((SimpleName)node).getIdentifier())) {
                res.add(node);
            }
            ++i;
        }
        return res.toArray(new SimpleName[res.size()]);
    }

    private static class LabelFinder
    extends ASTVisitor {
        private SimpleName fLabel;
        private ASTNode fDefiningLabel;
        private ArrayList fResult;

        public LabelFinder(SimpleName label, ArrayList result) {
            super(true);
            this.fLabel = label;
            this.fResult = result;
            this.fDefiningLabel = null;
        }

        private boolean isSameLabel(SimpleName label) {
            return label != null && this.fLabel.getIdentifier().equals(label.getIdentifier());
        }

        public boolean visit(BreakStatement node) {
            SimpleName label = node.getLabel();
            if (this.fDefiningLabel != null && this.isSameLabel(label) && ASTNodes.isParent((ASTNode)label, this.fDefiningLabel)) {
                this.fResult.add(label);
            }
            return false;
        }

        public boolean visit(ContinueStatement node) {
            SimpleName label = node.getLabel();
            if (this.fDefiningLabel != null && this.isSameLabel(label) && ASTNodes.isParent((ASTNode)label, this.fDefiningLabel)) {
                this.fResult.add(label);
            }
            return false;
        }

        public boolean visit(LabeledStatement node) {
            SimpleName label;
            if (this.fDefiningLabel == null && (this.fLabel == (label = node.getLabel()) || this.isSameLabel(label) && ASTNodes.isParent((ASTNode)this.fLabel, (ASTNode)node))) {
                this.fDefiningLabel = node;
                this.fResult.add(label);
            }
            node.getBody().accept((ASTVisitor)this);
            return false;
        }
    }

    private static class BindingFinder
    extends ASTVisitor {
        private IBinding fBinding;
        private ArrayList fResult;

        public BindingFinder(IBinding binding, ArrayList result) {
            super(true);
            this.fBinding = BindingFinder.getDeclaration(binding);
            this.fResult = result;
        }

        public boolean visit(MethodDeclaration node) {
            ASTNode typeNode;
            if (node.isConstructor() && this.fBinding.getKind() == 2 && (typeNode = node.getParent()) instanceof AbstractTypeDeclaration && this.fBinding == ((AbstractTypeDeclaration)typeNode).resolveBinding()) {
                this.fResult.add(node.getName());
            }
            return true;
        }

        public boolean visit(TypeDeclaration node) {
            IMethodBinding binding;
            if (this.fBinding.getKind() == 4 && (binding = (IMethodBinding)this.fBinding).isConstructor() && binding.getDeclaringClass() == node.resolveBinding()) {
                this.fResult.add(node.getName());
            }
            return true;
        }

        public boolean visit(EnumDeclaration node) {
            IMethodBinding binding;
            if (this.fBinding.getKind() == 4 && (binding = (IMethodBinding)this.fBinding).isConstructor() && binding.getDeclaringClass() == node.resolveBinding()) {
                this.fResult.add(node.getName());
            }
            return true;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return true;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding == null || binding.getKind() != this.fBinding.getKind()) {
                return false;
            }
            if (this.fBinding == (binding = BindingFinder.getDeclaration(binding))) {
                this.fResult.add(node);
            } else if (binding.getKind() == 4 && this.isConnectedMethod((IMethodBinding)binding, (IMethodBinding)this.fBinding)) {
                this.fResult.add(node);
            }
            return false;
        }

        private static IBinding getDeclaration(IBinding binding) {
            if (binding instanceof ITypeBinding) {
                return ((ITypeBinding)binding).getTypeDeclaration();
            }
            if (binding instanceof IMethodBinding) {
                return ((IMethodBinding)binding).getMethodDeclaration();
            }
            if (binding instanceof IVariableBinding) {
                return ((IVariableBinding)binding).getVariableDeclaration();
            }
            return binding;
        }

        private boolean isConnectedMethod(IMethodBinding meth1, IMethodBinding meth2) {
            if (Bindings.isEqualMethod(meth1, meth2.getName(), meth2.getParameterTypes())) {
                ITypeBinding type1 = meth1.getDeclaringClass();
                ITypeBinding type2 = meth2.getDeclaringClass();
                if (Bindings.isSuperType(type2, type1) || Bindings.isSuperType(type1, type2)) {
                    return true;
                }
            }
            return false;
        }
    }
}

