/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.internet.internal.proxy;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;


/**
 * This Dialog class prompts the user for a userid and password  
 */
public class PasswordDialog extends Dialog
{
  private String prompt_;
  private Text   username_;
  private Text   password_;
  private String usernameValue_;
  private String passwordValue_;
  
  public PasswordDialog( Shell parentShell, String prompt )
  {
    super(parentShell);
    setShellStyle(SWT.DIALOG_TRIM | SWT.RESIZE | SWT.APPLICATION_MODAL );
    
    prompt_ = prompt;
  }
 
  /*
   * (non-Javadoc) Method declared in Window.
   */
  protected void configureShell(Shell shell)
  {
    super.configureShell(shell);
    shell.setText( InternetMessages.TITLE_PASSWORD_DIALOG_TITLE );
    shell.setSize( 350, 150 );
  }

  /*
   * (non-Javadoc) Method declared on Dialog. Creates and returns the contents
   * of the upper part of the dialog (above the button bar).
   */
  protected Control createDialogArea(Composite parent)
  {
    Composite  group    = new Composite( parent, SWT.NONE );
    GridLayout layout   = new GridLayout();
    GridData   griddata = null;
    
    layout.numColumns = 2;
    group.setLayout( layout );
    group.setLayoutData( new GridData( GridData.FILL_BOTH ) );
    
    griddata = new GridData( GridData.FILL_BOTH );
    griddata.horizontalSpan = 2;
    
    Text prompt = new Text( group, SWT.READ_ONLY | SWT.WRAP );
    prompt.setLayoutData( griddata );
    prompt.setText( prompt_ );
    
    Label usernameLabel = new Label( group, SWT.NONE );
    usernameLabel.setText( InternetMessages.LABEL_USERNAME );
    username_ = new Text( group, SWT.BORDER );
    griddata = new GridData( GridData.FILL_HORIZONTAL );
    username_.setLayoutData( griddata );
    username_.setFocus();

    Label passwordLabel = new Label( group, SWT.NONE );
    passwordLabel.setText( InternetMessages.LABEL_PASSWORD );
    password_ = new Text( group, SWT.BORDER );
    griddata = new GridData( GridData.FILL_HORIZONTAL );
    password_.setLayoutData( griddata );
    password_.setEchoChar( '*' );
    
    return group;
  }
  
  protected void okPressed()
  {
    usernameValue_ = username_.getText();
    passwordValue_ = password_.getText();
    
    super.okPressed();
  }

  public String getUsername()
  {
    return usernameValue_;
  }
  
  public String getPassword()
  {
    return passwordValue_;
  }
}
