/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.editor;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.IServerEditorPartInput;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPartInput;
import org.eclipse.wst.server.ui.internal.editor.ServerResourceCommandManager;

public abstract class ServerEditorSection {
    private String errorMessage = null;
    private ServerResourceCommandManager commandManager;
    private Composite parentComp;
    private ServerEditorPart editor;
    protected IServerWorkingCopy server;
    protected boolean readOnly;

    public void init(IEditorSite site, IEditorInput input) {
        if (input instanceof IServerEditorPartInput) {
            IServerEditorPartInput sepi = (IServerEditorPartInput)input;
            this.server = sepi.getServer();
            this.commandManager = ((ServerEditorPartInput)sepi).getServerCommandManager();
            this.readOnly = sepi.isServerReadOnly();
        }
    }

    public void execute(IUndoableOperation operation) {
        this.commandManager.execute(operation);
    }

    public void createSection(Composite parent) {
        this.parentComp = parent;
    }

    public Shell getShell() {
        return this.parentComp.getShell();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public IStatus[] getSaveStatus() {
        return null;
    }

    public void setServerEditorPart(ServerEditorPart editor) {
        this.editor = editor;
    }

    public void setErrorMessage(String error) {
        if (error == null && this.errorMessage == null) {
            return;
        }
        if (error != null && error.equals(this.errorMessage)) {
            return;
        }
        this.errorMessage = error;
        if (this.editor != null) {
            this.editor.updateErrorMessage();
        }
    }

    protected FormToolkit getFormToolkit(Display display) {
        return this.editor.getFormToolkit(display);
    }

    public void dispose() {
    }
}

