/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.internal.earcreation.EarComponentCreationDataModelProvider;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class CreateEARProjectCommand
extends AbstractDataModelOperation {
    private String earProjectName_;
    private String serverFactoryId_;
    private String j2eeVersion_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.earProjectName_);
            if (project != null && !project.exists()) {
                IDataModel info = DataModelFactory.createDataModel((IDataModelProvider)new EarComponentCreationDataModelProvider());
                info.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)project.getName());
                if (this.j2eeVersion_ != null && this.j2eeVersion_.length() > 0) {
                    info.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)new Integer(this.j2eeVersion_));
                } else {
                    info.setProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", (Object)new Integer(13));
                }
                if (this.serverFactoryId_ != null) {
                    this.serverFactoryId_.length();
                }
                IDataModelOperation operation = info.getDefaultOperation();
                operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
        }
        catch (ExecutionException ite) {
            IStatus status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_CANNOT_CREATE_EAR_PROJECT, (Object[])new String[]{this.earProjectName_}), (Throwable)ite);
            env.getStatusHandler().reportError(status);
            return status;
        }
        return Status.OK_STATUS;
    }

    public void setEarProjectName(String earProjectName) {
        this.earProjectName_ = earProjectName;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId_ = serverFactoryId;
    }

    public void setJ2EEVersion(String j2eeVersion) {
        this.j2eeVersion_ = j2eeVersion;
    }
}

