/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.uml2.common.util.UnionEObjectEList;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.internal.operations.NamedElementOperations;

public class NamespaceOperations
extends NamedElementOperations {
    protected NamespaceOperations() {
    }

    public static boolean validateMembersDistinguishable(Namespace namespace, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (!namespace.membersAreDistinguishable()) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 7, UMLPlugin.INSTANCE.getString("_UI_Namespace_MembersDistinguishable_diagnostic", NamespaceOperations.getMessageSubstitutions((Map)context, (Object)namespace)), new Object[]{namespace}));
            }
        }
        return result;
    }

    public static ElementImport createElementImport(Namespace namespace, PackageableElement element, VisibilityKind visibility) {
        if (element == null || namespace.getImportedElements().contains((Object)element)) {
            throw new IllegalArgumentException(String.valueOf(element));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.valueOf((Object)visibility));
        }
        ElementImport elementImport = namespace.createElementImport(element);
        elementImport.setVisibility(visibility);
        return elementImport;
    }

    public static PackageImport createPackageImport(Namespace namespace, Package package_, VisibilityKind visibility) {
        if (package_ == null || namespace.getImportedPackages().contains((Object)package_)) {
            throw new IllegalArgumentException(String.valueOf(package_));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.valueOf((Object)visibility));
        }
        PackageImport packageImport = namespace.createPackageImport(package_);
        packageImport.setVisibility(visibility);
        return packageImport;
    }

    public static EList getImportedElements(Namespace namespace) {
        UniqueEList.FastCompare importedElements = new UniqueEList.FastCompare();
        Iterator elementImports = namespace.getElementImports().iterator();
        while (elementImports.hasNext()) {
            PackageableElement importedElement = ((ElementImport)elementImports.next()).getImportedElement();
            if (importedElement == null) continue;
            importedElements.add((Object)importedElement);
        }
        return ECollections.unmodifiableEList((EList)importedElements);
    }

    public static EList getImportedPackages(Namespace namespace) {
        UniqueEList.FastCompare importedPackages = new UniqueEList.FastCompare();
        Iterator packageImports = namespace.getPackageImports().iterator();
        while (packageImports.hasNext()) {
            Package importedPackage = ((PackageImport)packageImports.next()).getImportedPackage();
            if (importedPackage == null) continue;
            importedPackages.add((Object)importedPackage);
        }
        return ECollections.unmodifiableEList((EList)importedPackages);
    }

    public static EList getImportedMembers(Namespace namespace) {
        UniqueEList.FastCompare importedMembers = new UniqueEList.FastCompare();
        Iterator elementImports = namespace.getElementImports().iterator();
        while (elementImports.hasNext()) {
            PackageableElement importedElement = ((ElementImport)elementImports.next()).getImportedElement();
            if (importedElement == null) continue;
            importedMembers.add((Object)importedElement);
        }
        Iterator packageImports = namespace.getPackageImports().iterator();
        while (packageImports.hasNext()) {
            Package importedPackage = ((PackageImport)packageImports.next()).getImportedPackage();
            if (importedPackage == null) continue;
            importedMembers.addAll((Collection)importedPackage.visibleMembers());
        }
        return new UnionEObjectEList((InternalEObject)namespace, (EStructuralFeature)UMLPackage.Literals.NAMESPACE__IMPORTED_MEMBER, importedMembers.size(), importedMembers.toArray());
    }

    protected static EList getNamesOfMember(Namespace namespace, NamedElement element, EList namespaces, EList namesOfMember) {
        if (!namespaces.contains((Object)namespace)) {
            namespaces.add((Object)namespace);
            if (namespace.getOwnedMembers().contains((Object)element)) {
                String name = element.getName();
                if (!NamespaceOperations.isEmpty((String)name)) {
                    namesOfMember.add((Object)name);
                }
            } else {
                UniqueEList elementImportNames = new UniqueEList();
                Iterator elementImports = namespace.getElementImports().iterator();
                while (elementImports.hasNext()) {
                    String name;
                    ElementImport elementImport = (ElementImport)elementImports.next();
                    if (elementImport.getImportedElement() != element || NamespaceOperations.isEmpty((String)(name = elementImport.getName()))) continue;
                    elementImportNames.add((Object)name);
                }
                if (elementImportNames.isEmpty()) {
                    Iterator packageImports = namespace.getPackageImports().iterator();
                    while (packageImports.hasNext()) {
                        Package importedPackage = ((PackageImport)packageImports.next()).getImportedPackage();
                        if (importedPackage == null || !importedPackage.visibleMembers().contains((Object)element)) continue;
                        NamespaceOperations.getNamesOfMember(importedPackage, element, namespaces, namesOfMember);
                    }
                } else {
                    namesOfMember.addAll((Collection)elementImportNames);
                }
            }
        }
        return namesOfMember;
    }

    public static EList getNamesOfMember(Namespace namespace, NamedElement element) {
        return ECollections.unmodifiableEList((EList)NamespaceOperations.getNamesOfMember(namespace, element, (EList)new UniqueEList.FastCompare(), (EList)new UniqueEList()));
    }

    public static boolean membersAreDistinguishable(Namespace namespace) {
        EList namespaceMembers = namespace.getMembers();
        Iterator members = namespaceMembers.iterator();
        while (members.hasNext()) {
            NamedElement member = (NamedElement)members.next();
            Iterator otherMembers = namespaceMembers.iterator();
            while (otherMembers.hasNext()) {
                NamedElement otherMember = (NamedElement)otherMembers.next();
                if (member == otherMember || member.isDistinguishableFrom(otherMember, namespace)) continue;
                return false;
            }
        }
        return true;
    }

    public static EList importMembers(Namespace namespace, EList imps) {
        UniqueEList.FastCompare importMembers = new UniqueEList.FastCompare();
        EList ownedMembers = namespace.getOwnedMembers();
        Iterator excludeCollisions = namespace.excludeCollisions(imps).iterator();
        block0: while (excludeCollisions.hasNext()) {
            PackageableElement excludeCollision = (PackageableElement)excludeCollisions.next();
            Iterator om = ownedMembers.iterator();
            while (om.hasNext()) {
                if (!excludeCollision.isDistinguishableFrom((PackageableElement)om.next(), namespace)) continue block0;
            }
            importMembers.add((Object)excludeCollision);
        }
        return ECollections.unmodifiableEList((EList)importMembers);
    }

    public static EList excludeCollisions(Namespace namespace, EList imps) {
        UniqueEList.FastCompare excludeCollisions = new UniqueEList.FastCompare();
        Iterator imps1 = imps.iterator();
        block0: while (imps1.hasNext()) {
            PackageableElement imp1 = (PackageableElement)imps1.next();
            Iterator imps2 = imps.iterator();
            while (imps2.hasNext()) {
                PackageableElement imp2 = (PackageableElement)imps2.next();
                if (imp1 != imp2 && !imp1.isDistinguishableFrom(imp2, namespace)) continue block0;
            }
            excludeCollisions.add((Object)imp1);
        }
        return ECollections.unmodifiableEList((EList)excludeCollisions);
    }
}

