/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.ConnectorKind;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.internal.operations.ConnectableElementOperations;
import org.eclipse.uml2.uml.internal.operations.RedefinableElementOperations;

public class ConnectorOperations
extends RedefinableElementOperations {
    protected ConnectorOperations() {
    }

    public static boolean validateTypes(Connector connector, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Association connectorType = connector.getType();
        if (connectorType != null) {
            Iterator ends = connector.getEnds().iterator();
            Iterator memberEnds = connectorType.getMemberEnds().iterator();
            while (ends.hasNext() && memberEnds.hasNext()) {
                ConnectableElement role = ((ConnectorEnd)ends.next()).getRole();
                Type type = role == null ? null : role.getType();
                Type memberEndType = ((Property)memberEnds.next()).getType();
                if (!(type == null ? memberEndType != null : !type.conformsTo(memberEndType))) continue;
                result = false;
                break;
            }
            if (ends.hasNext() || memberEnds.hasNext()) {
                result = false;
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 114, UMLPlugin.INSTANCE.getString("_UI_Connector_Types_diagnostic", ConnectorOperations.getMessageSubstitutions((Map)context, (Object)connector)), new Object[]{connector}));
        }
        return result;
    }

    public static boolean validateCompatible(Connector connector, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateRoles(Connector connector, DiagnosticChain diagnostics, Map context) {
        Iterator ends = connector.getEnds().iterator();
        while (ends.hasNext()) {
            ConnectorEnd end = (ConnectorEnd)ends.next();
            ConnectableElement role = end.getRole();
            Element owner = null;
            if (role instanceof Port) {
                Property partWithPort = end.getPartWithPort();
                owner = partWithPort == null ? role.getOwner() : partWithPort.getOwner();
            } else {
                Element element = owner = role == null ? null : role.getOwner();
            }
            if (connector.getOwner() == owner) continue;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 116, UMLPlugin.INSTANCE.getString("_UI_Connector_Roles_diagnostic", ConnectorOperations.getMessageSubstitutions((Map)context, (Object)connector)), new Object[]{connector}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateBetweenInterfacesPorts(Connector connector, DiagnosticChain diagnostics, Map context) {
        EList ends = connector.getEnds();
        if (connector.getKind() == ConnectorKind.DELEGATION_LITERAL && ends.size() == 2) {
            ConnectableElement role1 = ((ConnectorEnd)ends.get(0)).getRole();
            EList required1 = ConnectableElementOperations.getRequiredInterfaces(role1);
            EList provided1 = ConnectableElementOperations.getProvidedInterfaces(role1);
            ConnectableElement role2 = ((ConnectorEnd)ends.get(1)).getRole();
            EList required2 = ConnectableElementOperations.getRequiredInterfaces(role2);
            EList provided2 = ConnectableElementOperations.getProvidedInterfaces(role2);
            if (ConnectorOperations.intersect((Collection)provided2, (Collection)required1) || ConnectorOperations.intersect((Collection)provided1, (Collection)required2)) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 117, UMLPlugin.INSTANCE.getString("_UI_Connector_BetweenInterfacesPorts_diagnostic", ConnectorOperations.getMessageSubstitutions((Map)context, (Object)connector)), new Object[]{connector}));
                }
                return false;
            }
        }
        return true;
    }

    public static boolean validateBetweenInterfacePortImplements(Connector connector, DiagnosticChain diagnostics, Map context) {
        EList ends = connector.getEnds();
        if (connector.getKind() == ConnectorKind.DELEGATION_LITERAL && ends.size() == 2) {
            Type toType;
            ConnectorEnd end1 = (ConnectorEnd)ends.get(0);
            ConnectableElement role1 = end1.getRole();
            ConnectorEnd end2 = (ConnectorEnd)ends.get(1);
            ConnectableElement role2 = end2.getRole();
            EList provided1 = ConnectableElementOperations.getProvidedInterfaces(role1);
            if (!provided1.isEmpty() && !(role2 instanceof Port) && role2 instanceof Property && (toType = ((Property)role2).getType()) instanceof BehavioredClassifier && !((BehavioredClassifier)toType).getAllImplementedInterfaces().containsAll((Collection)provided1)) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 118, UMLPlugin.INSTANCE.getString("_UI_Connector_BetweenInterfacePortImplements_diagnostic", ConnectorOperations.getMessageSubstitutions((Map)context, (Object)connector)), new Object[]{connector}));
                }
                return false;
            }
        }
        return true;
    }

    public static boolean validateBetweenInterfacePortSignature(Connector connector, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        EList ends = connector.getEnds();
        if (connector.getKind() == ConnectorKind.DELEGATION_LITERAL && ends.size() == 2) {
            ConnectableElement role1 = ((ConnectorEnd)ends.get(0)).getRole();
            EList required1 = ConnectableElementOperations.getRequiredInterfaces(role1);
            EList provided1 = ConnectableElementOperations.getProvidedInterfaces(role1);
            ConnectableElement role2 = ((ConnectorEnd)ends.get(1)).getRole();
            EList required2 = ConnectableElementOperations.getRequiredInterfaces(role2);
            EList provided2 = ConnectableElementOperations.getProvidedInterfaces(role2);
            if (!provided1.isEmpty() && !provided2.isEmpty()) {
                boolean bl = result = result && ConnectorOperations.intersect((Collection)provided1, (Collection)provided2);
            }
            if (!required1.isEmpty() && !required2.isEmpty()) {
                boolean bl = result = result && ConnectorOperations.intersect((Collection)required1, (Collection)required2);
            }
            if (!result && diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 119, UMLPlugin.INSTANCE.getString("_UI_Connector_BetweenInterfacePortSignature_diagnostic", ConnectorOperations.getMessageSubstitutions((Map)context, (Object)connector)), new Object[]{connector}));
            }
        }
        return result;
    }

    public static boolean validateUnionSignatureCompatible(Connector connector, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateAssemblyConnector(Connector connector, DiagnosticChain diagnostics, Map context) {
        EList ends = connector.getEnds();
        if (connector.getKind() == ConnectorKind.ASSEMBLY_LITERAL && ends.size() == 2) {
            ConnectableElement role1 = ((ConnectorEnd)ends.get(0)).getRole();
            EList required1 = ConnectableElementOperations.getRequiredInterfaces(role1);
            EList provided1 = ConnectableElementOperations.getProvidedInterfaces(role1);
            ConnectableElement role2 = ((ConnectorEnd)ends.get(1)).getRole();
            EList required2 = ConnectableElementOperations.getRequiredInterfaces(role2);
            EList provided2 = ConnectableElementOperations.getProvidedInterfaces(role2);
            if (!ConnectorOperations.intersect((Collection)provided1, (Collection)required2) && !ConnectorOperations.intersect((Collection)provided2, (Collection)required1)) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 121, UMLPlugin.INSTANCE.getString("_UI_Connector_AssemblyConnector_diagnostic", ConnectorOperations.getMessageSubstitutions((Map)context, (Object)connector)), new Object[]{connector}));
                }
                return false;
            }
        }
        return true;
    }
}

