/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.comments.CommitCommentArea;
import org.tigris.subversion.subclipse.ui.settings.CommentProperties;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SetCommitPropertiesDialog
extends TrayDialog {
    private CommitCommentArea commitCommentArea;
    private ProjectProperties projectProperties;
    private Text issueText;
    private Text committerText;
    private String issue;
    private String author;
    private IDialogSettings settings;
    private SVNRevision revision;
    private Button okButton;
    private CommentProperties commentProperties;
    protected static final int LABEL_WIDTH_HINT = 400;

    public SetCommitPropertiesDialog(Shell parentShell, SVNRevision revision, IResource theResource, ProjectProperties projectProperties) {
        super(parentShell);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        try {
            if (theResource != null) {
                this.commentProperties = CommentProperties.getCommentProperties(theResource);
            }
        }
        catch (SVNException sVNException) {}
        this.commitCommentArea = new CommitCommentArea((Dialog)this, null, this.commentProperties);
        if (this.commentProperties != null && this.commentProperties.getMinimumLogMessageSize() != 0) {
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SetCommitPropertiesDialog.this.okButton.setEnabled(SetCommitPropertiesDialog.this.commitCommentArea.getComment().trim().length() >= SetCommitPropertiesDialog.this.commentProperties.getMinimumLogMessageSize());
                }
            };
            this.commitCommentArea.setModifyListener(modifyListener);
        }
        this.revision = revision;
        this.projectProperties = projectProperties;
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("SetCommitPropertiesDialog.revisionNumber", this.revision.toString()));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        if (this.projectProperties != null) {
            this.addBugtrackingArea(composite);
        }
        this.commitCommentArea.createArea(composite);
        this.commitCommentArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "OkRequested") {
                    SetCommitPropertiesDialog.this.okPressed();
                }
            }
        });
        this.addCommitterName(composite);
        if (this.author != null) {
            this.committerText.setText(this.author);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.change_revprops_context");
        return composite;
    }

    private void addBugtrackingArea(Composite composite) {
        Composite bugtrackingComposite = new Composite(composite, 0);
        GridLayout bugtrackingLayout = new GridLayout();
        bugtrackingLayout.numColumns = 2;
        bugtrackingComposite.setLayout((Layout)bugtrackingLayout);
        Label label = new Label(bugtrackingComposite, 0);
        label.setText(this.projectProperties.getLabel());
        this.issueText = new Text(bugtrackingComposite, 2048);
        GridData data = new GridData();
        data.widthHint = 150;
        this.issueText.setLayoutData((Object)data);
    }

    private void addCommitterName(Composite composite) {
        Composite committerComposite = new Composite(composite, 0);
        GridLayout committerLayout = new GridLayout();
        committerLayout.numColumns = 2;
        committerComposite.setLayout((Layout)committerLayout);
        Label label = new Label(committerComposite, 0);
        label.setText(Policy.bind("SetCommitPropertiesDialog.user"));
        this.committerText = new Text(committerComposite, 2048);
        GridData data = new GridData();
        data.widthHint = 150;
        this.committerText.setLayoutData((Object)data);
    }

    protected void okPressed() {
        this.saveLocation();
        if (this.projectProperties != null) {
            String issueError;
            this.issue = this.issueText.getText().trim();
            if (this.projectProperties.isWarnIfNoIssue() && this.issueText.getText().trim().length() == 0 && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("SetCommitPropertiesDialog.title"), (String)Policy.bind("SetCommitPropertiesDialog.0", this.projectProperties.getLabel()))) {
                this.issueText.setFocus();
                return;
            }
            if (this.issueText.getText().trim().length() > 0 && (issueError = this.projectProperties.validateIssue(this.issueText.getText().trim())) != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("SetCommitPropertiesDialog.title"), (String)issueError);
                this.issueText.selectAll();
                this.issueText.setFocus();
                return;
            }
        }
        if (this.committerText.getText().trim().length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("SetCommitPropertiesDialog.title"), (String)Policy.bind("SetCommitPropertiesDialog.noAuthor"));
            this.committerText.selectAll();
            this.committerText.setFocus();
            return;
        }
        this.author = this.committerText.getText().trim();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.saveLocation();
        super.cancelPressed();
    }

    private void saveLocation() {
        int x = this.getShell().getLocation().x;
        int y = this.getShell().getLocation().y;
        this.settings.put("CommitDialog.location.x", x);
        this.settings.put("CommitDialog.location.y", y);
        x = this.getShell().getSize().x;
        y = this.getShell().getSize().y;
        this.settings.put("CommitDialog.size.x", x);
        this.settings.put("CommitDialog.size.y", y);
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            int x = this.settings.getInt("CommitDialog.location.x");
            int y = this.settings.getInt("CommitDialog.location.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    protected Point getInitialSize() {
        try {
            int x = this.settings.getInt("CommitDialog.size.x");
            int y = this.settings.getInt("CommitDialog.size.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialSize();
        }
    }

    public String getComment() {
        if (this.projectProperties != null && this.issue != null && this.issue.length() > 0) {
            if (this.projectProperties.isAppend()) {
                return String.valueOf(this.commitCommentArea.getComment()) + "\n" + this.projectProperties.getResolvedMessage(this.issue) + "\n";
            }
            return String.valueOf(this.projectProperties.getResolvedMessage(this.issue)) + "\n" + this.commitCommentArea.getComment();
        }
        return this.commitCommentArea.getComment();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
            if (this.commentProperties != null && this.commentProperties.getMinimumLogMessageSize() != 0) {
                this.okButton.setEnabled(false);
            }
        }
        return button;
    }

    protected Label createWrappingLabel(Composite parent) {
        Label label = new Label(parent, 16448);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.horizontalIndent = 0;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 400;
        label.setLayoutData((Object)data);
        return label;
    }

    public void setOldComment(String comment) {
        this.commitCommentArea.setProposedComment(comment);
    }

    public void setOldAuthor(String oldAuthor) {
        this.author = oldAuthor;
    }

    public String getAuthor() {
        return this.author;
    }
}

