/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.io.InputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.tigris.subversion.subclipse.core.resources.BaseResource;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class BaseResourceStorage
extends PlatformObject
implements IStorage,
IEncodedStorage {
    private BaseResource baseResource;

    public BaseResourceStorage(BaseResource baseResource) {
        this.baseResource = baseResource;
    }

    public InputStream getContents() throws CoreException {
        ISVNClientAdapter svnClient = this.baseResource.getRepository().getSVNClient();
        try {
            return svnClient.getContent(this.baseResource.getFile(), this.baseResource.getRevision());
        }
        catch (SVNClientException e) {
            throw new CoreException((IStatus)new Status(4, "org.tigris.subversion.subclipse.core", 0, "Failed in BaseFile.getContents()", (Throwable)e));
        }
    }

    public IPath getFullPath() {
        return this.baseResource.getPath();
    }

    public String getName() {
        return this.baseResource.getName();
    }

    public boolean isReadOnly() {
        return true;
    }

    public String getCharset() throws CoreException {
        return this.baseResource.getCharset();
    }
}

