/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.formatter.Indents;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.SelectionConverter;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.ui.actions.SelectionDispatchAction;

public class SurroundWithBeginRescueAction
extends SelectionDispatchAction {
    public static final String SURROUND_WTH_BEGIN_RESCUE = "SurroundWithBeginRescue";
    private RubyEditor fEditor;

    public SurroundWithBeginRescueAction(RubyEditor rubyEditor) {
        super((IWorkbenchSite)rubyEditor.getEditorSite());
        this.setText("Surround with begin...rescue");
        this.fEditor = rubyEditor;
        this.setEnabled(this.fEditor != null && SelectionConverter.getInputAsRubyScript(this.fEditor) != null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.surround_with_try_catch_action");
    }

    public void run(ITextSelection iTextSelection) {
        try {
            this.createChange(iTextSelection, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, SurroundWithBeginRescueAction.getDialogTitle(), "Error occurred while surrounding code with begin..rescue block");
        }
    }

    private static String getDialogTitle() {
        return "Surround with begin...rescue";
    }

    private IFile getFile() {
        IRubyScript iRubyScript = this.getRubyScript();
        return (IFile)RubyModelUtil.toOriginal(iRubyScript).getResource();
    }

    private IRubyScript getRubyScript() {
        return SelectionConverter.getInputAsRubyScript(this.fEditor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createChange(ITextSelection iTextSelection, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 2);
        IPath iPath = this.getFile().getFullPath();
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        try {
            try {
                iTextFileBufferManager.connect(iPath, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                IDocument iDocument = iTextFileBufferManager.getTextFileBuffer(iPath).getDocument();
                String string = this.createBeginRescueBlock(iDocument, iTextSelection);
                iDocument.replace(iTextSelection.getOffset(), iTextSelection.getLength(), string);
            }
            catch (BadLocationException badLocationException) {
                throw new CoreException((IStatus)new Status(4, RubyPlugin.getPluginId(), 4, badLocationException.getMessage(), (Throwable)badLocationException));
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            iTextFileBufferManager.disconnect(iPath, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        iTextFileBufferManager.disconnect(iPath, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        iProgressMonitor.done();
    }

    private String createBeginRescueBlock(IDocument iDocument, ITextSelection iTextSelection) throws BadLocationException, RubyModelException {
        String string = iTextSelection.getText();
        String string2 = iDocument.getLineDelimiter(0);
        Map map = this.getRubyScript().getRubyProject().getOptions(true);
        int n = iTextSelection.getStartLine();
        String string3 = iDocument.get(iDocument.getLineOffset(n), iDocument.getLineLength(n));
        int n2 = Indents.measureIndentUnits((CharSequence)string3, (int)Indents.getTabWidth((Map)map), (int)Indents.getIndentWidth((Map)map));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("begin");
        stringBuffer.append(string2);
        stringBuffer.append(Indents.createIndentString((int)(n2 + 1), (Map)map));
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append(Indents.createIndentString((int)n2, (Map)map));
        stringBuffer.append("rescue StandardError => e");
        stringBuffer.append(string2);
        stringBuffer.append(Indents.createIndentString((int)(n2 + 1), (Map)map));
        stringBuffer.append("puts e");
        stringBuffer.append(string2);
        stringBuffer.append(Indents.createIndentString((int)n2, (Map)map));
        stringBuffer.append("end");
        stringBuffer.append(string2);
        stringBuffer.append(Indents.createIndentString((int)n2, (Map)map));
        return stringBuffer.toString();
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(iTextSelection.getLength() > 0 && this.fEditor != null && SelectionConverter.getInputAsRubyScript(this.fEditor) != null);
    }
}

