/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyAnnotation;

public class RubyMarkerAnnotation
extends MarkerAnnotation
implements IRubyAnnotation {
    public static final String RUBY_MARKER_TYPE_PREFIX = "org.rubypeople.rdt";
    public static final String ERROR_ANNOTATION_TYPE = "org.rubypeople.rdt.ui.error";
    public static final String WARNING_ANNOTATION_TYPE = "org.rubypeople.rdt.ui.warning";
    public static final String INFO_ANNOTATION_TYPE = "org.rubypeople.rdt.ui.info";
    public static final String TASK_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.task";
    private IRubyAnnotation fOverlay;

    public RubyMarkerAnnotation(IMarker iMarker) {
        super(iMarker);
    }

    public String[] getArguments() {
        return null;
    }

    public int getId() {
        IMarker iMarker = this.getMarker();
        if (iMarker == null || !iMarker.exists()) {
            return -1;
        }
        if (this.isProblem()) {
            return iMarker.getAttribute("id", -1);
        }
        return -1;
    }

    public boolean isProblem() {
        String string = this.getType();
        return WARNING_ANNOTATION_TYPE.equals(string) || ERROR_ANNOTATION_TYPE.equals(string);
    }

    public void setOverlay(IRubyAnnotation iRubyAnnotation) {
        if (this.fOverlay != null) {
            this.fOverlay.removeOverlaid(this);
        }
        this.fOverlay = iRubyAnnotation;
        if (!this.isMarkedDeleted()) {
            this.markDeleted(this.fOverlay != null);
        }
        if (this.fOverlay != null) {
            this.fOverlay.addOverlaid(this);
        }
    }

    public boolean hasOverlay() {
        return this.fOverlay != null;
    }

    public IRubyAnnotation getOverlay() {
        return this.fOverlay;
    }

    public void addOverlaid(IRubyAnnotation iRubyAnnotation) {
    }

    public void removeOverlaid(IRubyAnnotation iRubyAnnotation) {
    }

    public Iterator getOverlaidIterator() {
        return null;
    }

    public IRubyScript getRubyScript() {
        IRubyElement iRubyElement = RubyCore.create((IResource)this.getMarker().getResource());
        if (iRubyElement instanceof IRubyScript) {
            return (IRubyScript)iRubyElement;
        }
        return null;
    }
}

