/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.preferences.PreferencePageSupport;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesMessages;
import org.rubypeople.rdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.rubypeople.rdt.internal.ui.preferences.TodoTaskConfigurationBlock;

public class TodoTaskPreferencePage
extends PropertyAndPreferencePage {
    public static final String PREF_ID = "org.rubypeople.rdt.ui.preferences.TodoTaskPreferencePage";
    public static final String PROP_ID = "org.rubypeople.rdt.ui.propertyPages.TodoTaskPreferencePage";
    private TodoTaskConfigurationBlock fConfigurationBlock;

    public TodoTaskPreferencePage() {
        this.setPreferenceStore(RubyPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.TodoTaskPreferencePage_description);
        this.setTitle(PreferencesMessages.TodoTaskPreferencePage_title);
    }

    public void createControl(Composite composite) {
        this.fConfigurationBlock = new TodoTaskConfigurationBlock(this.getNewStatusChangedListener(), this.getProject());
        super.createControl(composite);
        if (this.isProjectPreferencePage()) {
            WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.rubypeople.rdt.ui.tasktags_property_page_context");
        } else {
            WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.rubypeople.rdt.ui.tasktags_preference_page_context");
        }
    }

    protected String getPreferencePageID() {
        return PREF_ID;
    }

    protected String getPropertyPageID() {
        return PROP_ID;
    }

    protected Control createPreferenceContent(Composite composite) {
        return this.fConfigurationBlock.createContents(composite);
    }

    protected boolean hasProjectSpecificOptions(IProject iProject) {
        return this.fConfigurationBlock.hasProjectSpecificOptions();
    }

    protected void openWorkspacePreferences() {
        TodoTaskPreferencePage todoTaskPreferencePage = new TodoTaskPreferencePage();
        PreferencePageSupport.showPreferencePage(this.getShell(), PREF_ID, (IPreferencePage)todoTaskPreferencePage);
    }

    protected void enablePreferenceContent(boolean bl) {
        this.fConfigurationBlock.setEnabled(bl);
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.performDefaults();
        }
    }

    public boolean performOk() {
        boolean bl;
        boolean bl2 = bl = !this.isProjectPreferencePage() || this.useProjectSettings();
        if (this.fConfigurationBlock != null && !this.fConfigurationBlock.performOk(bl)) {
            return false;
        }
        return super.performOk();
    }

    public void dispose() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.dispose();
        }
        super.dispose();
    }

    public void setElement(IAdaptable iAdaptable) {
        super.setElement(iAdaptable);
        this.setDescription(null);
    }
}

