/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.rubypeople.rdt.core.ILoadpathEntry;

public class LoadpathEntry
implements ILoadpathEntry {
    private static final String TYPE_PROJECT = "project";
    private String rootID;
    private int entryKind;
    private IPath path;
    private IPath[] inclusionPatterns;
    private char[][] fullInclusionPatternChars;
    private IPath[] exclusionPatterns;
    private char[][] fullExclusionPatternChars;
    private static final char[][] UNINIT_PATTERNS = new char[][]{"Non-initialized yet".toCharArray()};
    public static final IPath[] INCLUDE_ALL = new IPath[0];
    public static final IPath[] EXCLUDE_NONE = new IPath[0];
    private IProject project;
    private boolean isExported;

    public LoadpathEntry(IProject iProject) {
        this(2, iProject.getFullPath(), INCLUDE_ALL, EXCLUDE_NONE, true);
        this.project = iProject;
    }

    public LoadpathEntry(int n, IPath iPath, IPath[] iPathArray, IPath[] iPathArray2, boolean bl) {
        this.path = iPath;
        this.entryKind = n;
        this.inclusionPatterns = iPathArray;
        this.exclusionPatterns = iPathArray2;
        if (iPathArray != INCLUDE_ALL && iPathArray.length > 0) {
            this.fullInclusionPatternChars = UNINIT_PATTERNS;
        }
        if (iPathArray2.length > 0) {
            this.fullExclusionPatternChars = UNINIT_PATTERNS;
        }
        this.isExported = bl;
    }

    public IPath getPath() {
        return this.path;
    }

    public IProject getProject() {
        return this.project;
    }

    public int getEntryKind() {
        return this.entryKind;
    }

    static String kindToString(int n) {
        switch (n) {
            case 2: {
                return TYPE_PROJECT;
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 4: {
                return "var";
            }
            case 5: {
                return "con";
            }
        }
        return "unknown";
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<pathentry type=\"");
        stringBuffer.append(String.valueOf(LoadpathEntry.kindToString(this.entryKind)) + "\" ");
        stringBuffer.append("path=\"" + this.getPath() + "\"/>");
        return stringBuffer.toString();
    }

    public String rootID() {
        if (this.rootID == null) {
            switch (this.entryKind) {
                case 1: {
                    this.rootID = "[LIB]" + this.path;
                    break;
                }
                case 2: {
                    this.rootID = "[PRJ]" + this.path;
                    break;
                }
                case 3: {
                    this.rootID = "[SRC]" + this.path;
                    break;
                }
                case 4: {
                    this.rootID = "[VAR]" + this.path;
                    break;
                }
                case 5: {
                    this.rootID = "[CON]" + this.path;
                    break;
                }
                default: {
                    this.rootID = "";
                }
            }
        }
        return this.rootID;
    }

    public char[][] fullExclusionPatternChars() {
        if (this.fullExclusionPatternChars == UNINIT_PATTERNS) {
            int n = this.exclusionPatterns.length;
            this.fullExclusionPatternChars = new char[n][];
            IPath iPath = this.path.removeTrailingSeparator();
            int n2 = 0;
            while (n2 < n) {
                this.fullExclusionPatternChars[n2] = iPath.append(this.exclusionPatterns[n2]).toString().toCharArray();
                ++n2;
            }
        }
        return this.fullExclusionPatternChars;
    }

    public char[][] fullInclusionPatternChars() {
        if (this.fullInclusionPatternChars == UNINIT_PATTERNS) {
            int n = this.inclusionPatterns.length;
            this.fullInclusionPatternChars = new char[n][];
            IPath iPath = this.path.removeTrailingSeparator();
            int n2 = 0;
            while (n2 < n) {
                this.fullInclusionPatternChars[n2] = iPath.append(this.inclusionPatterns[n2]).toString().toCharArray();
                ++n2;
            }
        }
        return this.fullInclusionPatternChars;
    }

    public boolean isExported() {
        return this.isExported;
    }

    public IPath[] getExclusionPatterns() {
        return null;
    }

    public IPath[] getInclusionPatterns() {
        return null;
    }
}

