/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.graph;

import edu.umd.cs.findbugs.graph.AbstractEdge;
import edu.umd.cs.findbugs.graph.AbstractVertex;
import edu.umd.cs.findbugs.graph.Graph;
import edu.umd.cs.findbugs.graph.GraphEdge;
import edu.umd.cs.findbugs.graph.GraphVertex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraph<EdgeType extends AbstractEdge<EdgeType, VertexType>, VertexType extends AbstractVertex<EdgeType, VertexType>>
implements Graph<EdgeType, VertexType> {
    private ArrayList<VertexType> vertexList = new ArrayList();
    private ArrayList<EdgeType> edgeList = new ArrayList();
    private int maxVertexLabel = 0;
    private int nextVertexId = 0;
    private int maxEdgeLabel = 0;

    @Override
    public int getNumEdges() {
        return this.edgeList.size();
    }

    @Override
    public int getNumVertices() {
        return this.vertexList.size();
    }

    @Override
    public Iterator<EdgeType> edgeIterator() {
        return this.edgeList.iterator();
    }

    @Override
    public Iterator<VertexType> vertexIterator() {
        return this.vertexList.iterator();
    }

    @Override
    public void addVertex(VertexType v) {
        this.vertexList.add(v);
        ((AbstractVertex)v).setId(this.nextVertexId++);
        ((AbstractVertex)v).setLabel(this.maxVertexLabel++);
    }

    @Override
    public boolean containsVertex(VertexType v) {
        for (AbstractVertex existingVertex : this.vertexList) {
            if (v != existingVertex) continue;
            return true;
        }
        return false;
    }

    @Override
    public EdgeType createEdge(VertexType source, VertexType target) {
        EdgeType edge = this.allocateEdge(source, target);
        this.edgeList.add(edge);
        ((AbstractVertex)source).addOutgoingEdge(edge);
        ((AbstractVertex)target).addIncomingEdge(edge);
        ((AbstractEdge)edge).setLabel(this.maxEdgeLabel++);
        return edge;
    }

    @Override
    public EdgeType lookupEdge(VertexType source, VertexType target) {
        Iterator<EdgeType> i = this.outgoingEdgeIterator(source);
        while (i.hasNext()) {
            AbstractEdge edge = (AbstractEdge)i.next();
            if (edge.getTarget() != target) continue;
            return (EdgeType)edge;
        }
        return null;
    }

    @Override
    public int getNumVertexLabels() {
        return this.maxVertexLabel;
    }

    @Override
    public void setNumVertexLabels(int numLabels) {
        this.maxVertexLabel = numLabels;
    }

    @Override
    public int getNumEdgeLabels() {
        return this.maxEdgeLabel;
    }

    @Override
    public void setNumEdgeLabels(int numLabels) {
        this.maxEdgeLabel = numLabels;
    }

    @Override
    public void removeEdge(EdgeType edge) {
        if (!this.edgeList.remove(edge)) {
            throw new IllegalArgumentException("removing nonexistent edge!");
        }
        ((AbstractVertex)((AbstractEdge)edge).getSource()).removeOutgoingEdge(edge);
        ((AbstractVertex)((AbstractEdge)edge).getTarget()).removeIncomingEdge(edge);
    }

    @Override
    public void removeVertex(VertexType v) {
        if (!this.vertexList.remove(v)) {
            throw new IllegalArgumentException("removing nonexistent vertex!");
        }
        Iterator<EdgeType> i = this.incomingEdgeIterator(v);
        while (i.hasNext()) {
            this.removeEdge((EdgeType)((AbstractEdge)i.next()));
        }
        i = this.outgoingEdgeIterator(v);
        while (i.hasNext()) {
            this.removeEdge((EdgeType)((AbstractEdge)i.next()));
        }
    }

    @Override
    public Iterator<EdgeType> outgoingEdgeIterator(VertexType source) {
        return new OutgoingEdgeIterator(source);
    }

    @Override
    public Iterator<EdgeType> incomingEdgeIterator(VertexType target) {
        return new IncomingEdgeIterator(target);
    }

    @Override
    public int getNumIncomingEdges(VertexType vertex) {
        int count = 0;
        for (Object e = ((AbstractVertex)vertex).firstIncomingEdge; e != null; e = ((AbstractEdge)e).getNextIncomingEdge()) {
            ++count;
        }
        return count;
    }

    @Override
    public int getNumOutgoingEdges(VertexType vertex) {
        int count = 0;
        for (Object e = ((AbstractVertex)vertex).firstOutgoingEdge; e != null; e = ((AbstractEdge)e).getNextOutgoingEdge()) {
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<VertexType> successorIterator(VertexType source) {
        return new Iterator<VertexType>((AbstractVertex)source){
            private Iterator<EdgeType> iter;
            private final /* synthetic */ AbstractVertex val$source;
            {
                this.val$source = abstractVertex;
                this.iter = AbstractGraph.this.outgoingEdgeIterator(this.val$source);
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public VertexType next() {
                return ((AbstractEdge)this.iter.next()).getTarget();
            }

            @Override
            public void remove() {
                this.iter.remove();
            }

            @Override
            public /* synthetic */ Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Iterator<VertexType> predecessorIterator(VertexType target) {
        return new Iterator<VertexType>((AbstractVertex)target){
            private Iterator<EdgeType> iter;
            private final /* synthetic */ AbstractVertex val$target;
            {
                this.val$target = abstractVertex;
                this.iter = AbstractGraph.this.incomingEdgeIterator(this.val$target);
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public VertexType next() {
                return ((AbstractEdge)this.iter.next()).getSource();
            }

            @Override
            public void remove() {
                this.iter.remove();
            }

            @Override
            public /* synthetic */ Object next() {
                return this.next();
            }
        };
    }

    protected abstract EdgeType allocateEdge(VertexType var1, VertexType var2);

    @Override
    public /* synthetic */ Iterator predecessorIterator(GraphVertex x0) {
        return this.predecessorIterator((VertexType)((AbstractVertex)x0));
    }

    @Override
    public /* synthetic */ Iterator successorIterator(GraphVertex x0) {
        return this.successorIterator((VertexType)((AbstractVertex)x0));
    }

    @Override
    public /* synthetic */ int getNumOutgoingEdges(GraphVertex x0) {
        return this.getNumOutgoingEdges((VertexType)((AbstractVertex)x0));
    }

    @Override
    public /* synthetic */ int getNumIncomingEdges(GraphVertex x0) {
        return this.getNumIncomingEdges((VertexType)((AbstractVertex)x0));
    }

    @Override
    public /* synthetic */ Iterator incomingEdgeIterator(GraphVertex x0) {
        return this.incomingEdgeIterator((VertexType)((AbstractVertex)x0));
    }

    @Override
    public /* synthetic */ Iterator outgoingEdgeIterator(GraphVertex x0) {
        return this.outgoingEdgeIterator((VertexType)((AbstractVertex)x0));
    }

    @Override
    public /* synthetic */ void removeVertex(GraphVertex x0) {
        this.removeVertex((VertexType)((AbstractVertex)x0));
    }

    @Override
    public /* synthetic */ void removeEdge(GraphEdge x0) {
        this.removeEdge((EdgeType)((AbstractEdge)x0));
    }

    @Override
    public /* synthetic */ GraphEdge lookupEdge(GraphVertex x0, GraphVertex x1) {
        return this.lookupEdge((VertexType)((AbstractVertex)x0), (VertexType)((AbstractVertex)x1));
    }

    @Override
    public /* synthetic */ GraphEdge createEdge(GraphVertex x0, GraphVertex x1) {
        return this.createEdge((VertexType)((AbstractVertex)x0), (VertexType)((AbstractVertex)x1));
    }

    @Override
    public /* synthetic */ boolean containsVertex(GraphVertex x0) {
        return this.containsVertex((VertexType)((AbstractVertex)x0));
    }

    @Override
    public /* synthetic */ void addVertex(GraphVertex x0) {
        this.addVertex((VertexType)((AbstractVertex)x0));
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IncomingEdgeIterator<EdgeType extends AbstractEdge<EdgeType, VertexType>, VertexType extends AbstractVertex<EdgeType, VertexType>>
    implements Iterator<EdgeType> {
        private EdgeType edge;

        public IncomingEdgeIterator(VertexType target) {
            this.edge = ((AbstractVertex)target).getFirstIncomingEdge();
        }

        @Override
        public boolean hasNext() {
            return this.edge != null;
        }

        @Override
        public EdgeType next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            EdgeType result = this.edge;
            this.edge = ((AbstractEdge)this.edge).getNextIncomingEdge();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ Object next() {
            return this.next();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutgoingEdgeIterator<EdgeType extends AbstractEdge<EdgeType, VertexType>, VertexType extends AbstractVertex<EdgeType, VertexType>>
    implements Iterator<EdgeType> {
        private EdgeType edge;

        public OutgoingEdgeIterator(VertexType source) {
            this.edge = ((AbstractVertex)source).getFirstOutgoingEdge();
        }

        @Override
        public boolean hasNext() {
            return this.edge != null;
        }

        @Override
        public EdgeType next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            EdgeType result = this.edge;
            this.edge = ((AbstractEdge)this.edge).getNextOutgoingEdge();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ Object next() {
            return this.next();
        }
    }
}

