/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.epic.core.parser.PerlToken;
import org.epic.perleditor.editors.TokensListIterator;

class TokensList
implements List,
RandomAccess {
    private final Comparator tokenPosComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            PerlToken p1 = (PerlToken)((Object)o1);
            PerlToken p2 = (PerlToken)((Object)o2);
            return p1.getOffset() - p2.getOffset();
        }
    };
    private final PerlToken OFFSET_TOKEN = new PerlToken();
    private PerlToken[] tokens = new PerlToken[2000];
    private int i;
    private PerlToken[] syncBuffer;
    private int syncOffset;
    private int syncCount;
    private int syncBufferAlloc;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.perleditor.editors.TokensList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public void add(PerlToken t) {
        if (this.i == this.tokens.length) {
            this.expand(Math.min(this.tokens.length, 30000));
        }
        if (this.i == this.syncOffset) {
            if (this.syncBuffer == null || this.syncBuffer.length < this.syncCount) {
                ++this.syncBufferAlloc;
                this.syncBuffer = new PerlToken[this.syncCount + this.syncBufferAlloc * 4];
            }
            System.arraycopy(this.tokens, this.syncOffset, this.syncBuffer, 0, this.syncCount);
            this.syncOffset = -1;
        }
        this.tokens[this.i] = t;
        ++this.i;
        if (!$assertionsDisabled && !this.noOverlaps()) {
            throw new AssertionError();
        }
    }

    public Object get(int i) {
        return this.tokens[i];
    }

    public boolean isEmpty() {
        return this.i == 0;
    }

    public int size() {
        return this.i;
    }

    public void addSync() {
        if (this.i > this.syncOffset) {
            if (this.i + this.syncCount > this.tokens.length) {
                this.expand(this.i + this.syncCount - this.tokens.length);
            }
            System.arraycopy(this.syncBuffer, 0, this.tokens, this.i, this.syncCount);
        } else if (this.i < this.syncOffset) {
            System.arraycopy(this.tokens, this.syncOffset, this.tokens, this.i, this.syncCount);
        }
        this.i += this.syncCount;
    }

    public void markSync(int offset) {
        this.syncOffset = offset;
        this.syncCount = this.i - this.syncOffset;
    }

    public void truncate(int offset) {
        this.i = offset;
    }

    private void expand(int count) {
        PerlToken[] tmp = this.tokens;
        this.tokens = new PerlToken[this.tokens.length + count];
        System.arraycopy(tmp, 0, this.tokens, 0, tmp.length);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray() {
        PerlToken[] ret = new PerlToken[this.i];
        System.arraycopy(this.tokens, 0, ret, 0, this.i);
        return ret;
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public int indexOf(Object o) {
        if (o == null) {
            return -1;
        }
        int j = 0;
        while (j < this.i) {
            if (this.tokens[j].equals(o)) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        if (o == null) {
            return -1;
        }
        int j = this.i - 1;
        while (j >= 0) {
            if (this.tokens[j].equals(o)) {
                return j;
            }
            --j;
        }
        return -1;
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public Iterator iterator() {
        return new TokensListIterator(this);
    }

    public ListIterator listIterator() {
        return new TokensListIterator(this);
    }

    public ListIterator listIterator(int index) {
        return new TokensListIterator(this, index);
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.i) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.i);
        }
        System.arraycopy(this.tokens, 0, a, 0, this.i);
        if (a.length > this.i) {
            a[this.i] = null;
        }
        return a;
    }

    public List subList(int fromIndex, int toIndex) {
        Object[] ret = new Object[toIndex - fromIndex];
        System.arraycopy(this.tokens, fromIndex, ret, 0, ret.length);
        return Collections.unmodifiableList(Arrays.asList(ret));
    }

    public void dump() {
        int size = this.size();
        System.err.println("Dumping " + size + " token(s):");
        int i = 0;
        while (i < size) {
            System.err.println(String.valueOf(i) + ": " + this.get(i));
            ++i;
        }
        System.err.println("----- end of tokens dump");
    }

    public int getTokenIndexPreceding(int offset) {
        int i = Collections.binarySearch(this, this.perlTokenWithOffset(offset), this.tokenPosComparator);
        if (i >= 0) {
            return i;
        }
        return -(i + 1) - 1;
    }

    boolean noOverlaps() {
        return true;
    }

    private PerlToken perlTokenWithOffset(int offset) {
        this.OFFSET_TOKEN.setOffset(offset);
        return this.OFFSET_TOKEN;
    }
}

