function advPromptSubmit() {
	if(window.windowData && typeof window.windowData.fields == "object"){
		var result = new Array();
		for(var i in window.windowData.fields){
			var fieldData = window.windowData.fields[i];

			switch(fieldData.type){
				case "textarea":
					var field = dhtml.getElementById(fieldData.name, "textarea");
					if(field){
						// Check for required field
						if(fieldData.required && (field.value).trim().length == 0){
							alert(_("Please fill in field \"%s\"").replace(/%s/g,fieldData.label));
							field.focus();
							return false;
						}
						result[fieldData.name] = (field.value).trim();
					// Field not found
					}else{
						return false;
					}

				case "combineddatetime":
					if(fieldData.combinedDateTimePicker){
						result[fieldData.name] = {
							start: fieldData.combinedDateTimePicker.getStartValue(),
							end: fieldData.combinedDateTimePicker.getEndValue()
						};
					}
					break;
				case "normal":
				case "email":
				default:
					var field = dhtml.getElementById(fieldData.name, "input");
					if(field){
						// Check for required field
						if(fieldData.required && (field.value).trim().length == 0){
							alert(_("Please fill in field \"%s\"").replace(/%s/g,fieldData.label));
							field.focus();
							return false;
						}
						// Check for validation of field
						switch(fieldData.type){
							case "email":
								if(!validateEmailAddress((field.value).trim(), true)){
									// Alert is done by validateEmailAddress when it fails
									field.focus();
									return false;
								}
								break;
						}
						result[fieldData.name] = (field.value).trim();
					// Field not found
					}else{
						return false;
					}
					break;
			}

		}
		// This point is only reached when all checks are passed
		window.resultCallBack(result, window.callBackData);
		return true;
	// Cannot find window.windowData or window.windowData.field is not an array
	}else{
		return false;
	}
}
