<?php
function getModuleName(){
	return "restoreitemslistmodule";
}

function getModuleType(){
	return "list";
}

function getDialogTitle(){
	return _("Restore deleted Items");
}

function getIncludes(){
	return array(
			"client/layout/js/restoreitems.js",
			"client/widgets/tablewidget.js",
			"client/modules/".getModuleName().".js"
		);
}

function getJavaScript_onload(){ ?>
	
	// pass the last parameter [data] with has_no_menu = true 
	module.init(moduleID,null, null, {has_no_menu:true} );

	//sometimes the menu is there but in hidden mode, so use this method to show the main menu. [a workaround]
	webclient.menu.showMenu();
	
	var data = new Object();
	data["storeid"] = <?=get("storeid","false","'")?>;
	data["entryid"] = <?=get("parententryid","false","'")?>;
	module.setData(data);
	
	module.list();
	webclient.xmlrequest.sendRequest();
	
<?php } // getJavaSctipt_onload
function getJavaScript_other(){ ?>
	var tableWidget;
<?php }

function getBody(){ ?>
	<input id="entryid" type="hidden">
	<input id="parent_entryid" type="hidden">
	<div id="conflict"></div>
	<div id="restoreitemstable" class="restoreItemTable"></div>
	<div id="restoreitems_status"></div>
<?php }

function getMenuButtons(){
	return array(
		array(
			'id'=>"restore_item",
			'name'=>_("Restore"),
			'title'=>_("Restore the selected items"),
			'callback'=>'restore_selected_items'
		),
		array(
			'id'=>"restoreall",
			'name'=>_("Restore All"),
			'title'=>_("Restore all"),
			'callback'=>'permanent_restore_all'
		),
		array(
			'id'=>"seperator",
			'name'=>"",
			'title'=>"",
			'callback'=>""
		),
		array(
			'id'=>"purge",
			'name'=>_("Permanent Delete"),
			'title'=>_("Permanent delete selected items"),
			'callback'=>'permanent_delete_items'
		),
		array(
			'id'=>"deleteall",
			'name'=>_("Delete All"),
			'title'=>_("Permanent delete All"),
			'callback'=>'permanent_delete_all'
		),
		array(
			'id'=>"seperator",
			'name'=>"",
			'title'=>"",
			'callback'=>""
		),
		array(
			'id'=>"close",
			'name'=>_("Close"),
			'title'=>_("Close"),
			'callback'=>"function(){window.close();}"
		)
	);
}
?>