<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1464 $
 * $Id: EditROE.php 1464 2007-11-23 01:25:37Z ipso $
 * $Date: 2007-11-22 17:25:37 -0800 (Thu, 22 Nov 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

//Debug::setVerbosity(11);

if ( !$permission->Check('roe','enabled')
		OR !( $permission->Check('roe','edit') OR $permission->Check('roe','edit_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Record Of Employment')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'roe_data',
												'setup_data',
												'user_id'
												) ) );

$roef = new ROEFactory();

if ( isset($roe_data) ) {
	if ( $roe_data['first_date'] != '' ) {
		$roe_data['first_date'] = TTDate::parseDateTime($roe_data['first_date']);
	}
	if ( $roe_data['last_date'] != '' ) {
		$roe_data['last_date'] = TTDate::parseDateTime($roe_data['last_date']);
	}
	if ( $roe_data['pay_period_end_date'] != '' ) {
		$roe_data['pay_period_end_date'] = TTDate::parseDateTime($roe_data['pay_period_end_date']);
	}
	if ( $roe_data['recall_date'] != '' ) {
		$roe_data['recall_date'] = TTDate::parseDateTime($roe_data['recall_date']);
	}
}

$ugdlf = new UserGenericDataListFactory();
$ugdf = new UserGenericDataFactory();

$action = Misc::findSubmitButton();
switch ($action) {
	case 'submit':
		//Debug::setVerbosity(11);
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		//Save report setup data
		$ugdlf->getByCompanyIdAndScriptAndDefault( $current_company->getId(), $roef->getTable() );
		if ( $ugdlf->getRecordCount() > 0 ) {
			$ugdf->setID( $ugdlf->getCurrent()->getID() );
		}
		$ugdf->setCompany( $current_company->getId() );
		$ugdf->setName( $title );
		$ugdf->setScript( $roef->getTable() );
		$ugdf->setData( $setup_data );
		$ugdf->setDefault( TRUE );
		if ( $ugdf->isValid() ) {
			$ugdf->Save();
		}

		if ( !empty($roe_data['id']) ) {
			$roef->setId( $roe_data['id'] );
		}

		$roef->setUser( $roe_data['user_id'] );
		$roef->setPayPeriodType( $roe_data['pay_period_type_id'] );
		$roef->setCode( $roe_data['code_id'] );

		if ( $roe_data['first_date'] != '' ) {
			$roef->setFirstDate( $roe_data['first_date'] );
		}
		if ( $roe_data['last_date'] != '' ) {
			$roef->setLastDate( $roe_data['last_date']);
		}
		if ( $roe_data['pay_period_end_date'] != '' ) {
			$roef->setPayPeriodEndDate( $roe_data['pay_period_end_date'] );
		}
		if ( $roe_data['recall_date'] != '' ) {
			$roef->setRecallDate( $roe_data['recall_date'] );
		}

		$roef->setSerial( $roe_data['serial'] );
		$roef->setComments( $roe_data['comments'] );

		if ( $roef->isValid() ) {
			$roef->setEnableReCalculate( TRUE );
			if ( isset($roe_data['generate_pay_stub']) AND $roe_data['generate_pay_stub'] == 1 ) {
				$roef->setEnableGeneratePayStub(TRUE );
			} else {
				$roef->setEnableGeneratePayStub( FALSE );
			}
			$roef->Save();

			$ugsf = new UserGenericStatusFactory();
			$ugsf->setUser( $current_user->getId() );
			$ugsf->setBatchID( $ugsf->getNextBatchId() );
			$ugsf->setQueue( UserGenericStatusFactory::getStaticQueue() );
			$ugsf->saveQueue();

			$next_page = URLBuilder::getURL( array('user_id' => $roe_data['user_id'] ), '../roe/ROEList.php');

			Redirect::Page( URLBuilder::getURL( array('batch_id' => $ugsf->getBatchID(), 'batch_title' => 'Record of Employement', 'batch_next_page' => $next_page), '../users/UserGenericStatusList.php') );

			unset($ugsf);

			//Redirect::Page( URLBuilder::getURL( array('user_id' => $roe_data['user_id'] ), 'ROEList.php') );

			break;
		}

	default:
		$ugdlf->getByCompanyIdAndScriptAndDefault( $current_company->getId(), $roef->getTable() );
		if ( $ugdlf->getRecordCount() > 0 ) {
			Debug::Text('Found Company Report Setup!', __FILE__, __LINE__, __METHOD__,10);
			$ugd_obj = $ugdlf->getCurrent();
			$setup_data = $ugd_obj->getData();
		}
		unset($ugd_obj);

		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$roelf = new ROEListFactory();

			$roelf->getById( $id );

			foreach ($roelf as $roe) {
				//Debug::Arr($department,'Department', __FILE__, __LINE__, __METHOD__,10);

				$roe_data = array(
									'id' => $roe->getId(),
									'user_id' => $roe->getUser(),
									'pay_period_type_id' => $roe->getPayPeriodType(),
									'code_id' => $roe->getCode(),
									'first_date' => $roe->getFirstDate(),
									'last_date' => $roe->getLastDate(),
									'pay_period_end_date' => $roe->getPayPeriodEndDate(),
									'recall_date' => $roe->getRecallDate(),
									'insurable_hours' => $roe->getInsurableHours(),
									'insurable_earnings' => $roe->getInsurableEarnings(),
									'vacation_pay' => $roe->getVacationPay(),
									'serial' => $roe->getSerial(),
									'comments' => $roe->getComments(),
									'created_date' => $roe->getCreatedDate(),
									'created_by' => $roe->getCreatedBy(),
									'updated_date' => $roe->getUpdatedDate(),
									'updated_by' => $roe->getUpdatedBy(),
									'deleted_date' => $roe->getDeletedDate(),
									'deleted_by' => $roe->getDeletedBy()
								);
			}
		} elseif ( !isset($action))  {
			//Get all the data we should need for this ROE in regards to pay period and such
			//Guess for end dates...

			//get User data for hire date
			$ulf = new UserListFactory();
			$user_obj = $ulf->getById($user_id)->getCurrent();

			$plf = new PunchListFactory();

			//Is there a previous ROE? If so, find first shift back since ROE was issued.
			$rlf = new ROEListFactory();
			$rlf->getLastROEByUserId( $user_id );
			if ( $rlf->getRecordCount() > 0 ) {
				$roe_obj = $rlf->getCurrent();

				Debug::Text('Previous ROE Last Date: '. TTDate::getDate('DATE+TIME', $roe_obj->getLastDate() ) , __FILE__, __LINE__, __METHOD__,10);
				//$plf->getFirstPunchByUserIDAndEpoch( $user_id, $roe_obj->getLastDate() );
				$plf->getNextPunchByUserIdAndEpoch( $user_id, $roe_obj->getLastDate() );
				if ( $plf->getRecordCount() > 0 ) {
					$first_date = $plf->getCurrent()->getTimeStamp();
				}
			}

			if ( !isset($first_date) OR $first_date == '' ) {
				$first_date = $user_obj->getHireDate();
			}
			Debug::Text('First Date: '. TTDate::getDate('DATE+TIME', $first_date) , __FILE__, __LINE__, __METHOD__,10);

			//Get last shift worked (not scheduled)
			$plf->getLastPunchByUserId( $user_id );
			if ( $plf->getRecordCount() > 0 ) {
				$punch_obj = $plf->getCurrent();
				$last_date = $punch_obj->getPunchControlObject()->getUserDateObject()->getDateStamp();
			} else {
				$last_date = TTDate::getTime();
			}

			Debug::Text('Last Punch Date: '. TTDate::getDate('DATE+TIME', $last_date) , __FILE__, __LINE__, __METHOD__,10);

			//Get pay period of last shift workd
			$plf = new PayPeriodListFactory();
			$pay_period_obj = $plf->getByUserIdAndEndDate( $user_id, $last_date )->getCurrent();

			$pay_period_type_id = FALSE;
			if ( is_object( $pay_period_obj->getPayPeriodScheduleObject() ) ) {
				$pay_period_type_id = $pay_period_obj->getPayPeriodScheduleObject()->getType();
			}
			$roe_data = array(
								'user_id' => $user_id,
								'pay_period_type_id' => $pay_period_type_id,
								'first_date' => $first_date,
								'last_date' => $last_date,
								'pay_period_end_date' => $pay_period_obj->getEndDate()
								);
		}

		//Select box options;
		$roe_data['code_options'] = $roef->getOptions('code');

		$ppsf = new PayPeriodScheduleFactory();
		$roe_data['pay_period_type_options'] = $ppsf->getOptions('type');
		unset($roe_data['pay_period_type_options'][5]);

		$user_options = UserListFactory::getByCompanyIdArray( $current_company->getId(), FALSE );
		$smarty->assign_by_ref('user_options', $user_options);

		//PSEA accounts
		$psealf = new PayStubEntryAccountListFactory();
		$earning_pay_stub_entry_account_options = $psealf->getByCompanyIdAndStatusIdAndTypeIdArray( $current_company->getId(), 10, array(10,30,40), TRUE );
		$smarty->assign_by_ref('earning_pay_stub_entry_account_options', $earning_pay_stub_entry_account_options);

		$smarty->assign_by_ref('roe_data', $roe_data);
		$smarty->assign_by_ref('setup_data', $setup_data);

		break;
}

$smarty->assign_by_ref('roef', $roef);

$smarty->display('roe/EditROE.tpl');
?>