<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1808 $
 * $Id: cron.php 1808 2008-04-08 17:20:17Z ipso $
 * $Date: 2008-04-08 10:20:17 -0700 (Tue, 08 Apr 2008) $
 */
/*
 * Cron replica
 * Run this script every minute from the real cron.
 *
 */
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'global.inc.php');
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'CLI.inc.php');

//$current_epoch = strtotime('28-Mar-08 1:30 PM');
$current_epoch = TTDate::getTime();

$executed_jobs = 0;

$cjlf = new CronJobListFactory();
$job_arr = $cjlf->getArrayByListFactory( $cjlf->getAll() );
$total_jobs = count($job_arr);
foreach( $job_arr as $job_id => $job_name ) {
	//Get each cronjob row again individually incase the status has changed.
	$cjlf = new CronJobListFactory();
	$cjlf->getById( $job_id ); //Let Execute determine if job is running or not so it can find orphans.
	if ( $cjlf->getRecordCount() > 0 ) {
		foreach( $cjlf as $cjf_obj ) {
			//Debug::text('Checking if Job ID: '. $job_id .' is scheduled to run...', __FILE__, __LINE__, __METHOD__, 0);
			if ( $cjf_obj->isScheduledToRun( $current_epoch ) == TRUE ) {
				$executed_jobs++;
				$cjf_obj->Execute( $config_vars['path']['php_cli'], dirname(__FILE__) );
			}
		}
	}
}
echo "NOTE: Jobs are scheduled to run at specific times, therefore only some jobs are executed each time this file is run.\n";
echo "Jobs Executed: $executed_jobs of $total_jobs\n";
Debug::text('CRON: Jobs Executed: '. $executed_jobs .' of '. $total_jobs, __FILE__, __LINE__, __METHOD__, 0);

//Save file to log directory with the last executed date, so we know if the CRON daemon is actually calling us.
$file_name = $config_vars['path']['log'] . DIRECTORY_SEPARATOR .'timetrex_cron_last_executed.log';
file_put_contents( $file_name, TTDate::getDate('DATE+TIME', time() )."\n" );

Debug::writeToLog();
Debug::Display();
?>