/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego;

import br.arca.morcego.Balancer;
import br.arca.morcego.Config;
import br.arca.morcego.Matrix3D;
import br.arca.morcego.Node;
import br.arca.morcego.Spinner;
import br.arca.morcego.Vertex;
import java.awt.Graphics;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Graph
extends Vector {
    private Node focus;
    private Node centerNode;
    private Matrix3D rotation;
    private Hashtable nodesFromName = new Hashtable();
    private Vertex origin;
    private boolean rotating;
    private Spinner spinner;
    private Balancer balancer;

    public Graph() {
        this.rotation = new Matrix3D();
        this.rotation.setIdentity();
        this.origin = new Vertex((Integer)Config.getValue("originX"), (Integer)Config.getValue("originY"), (Integer)Config.getValue("originZ"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Node node) {
        if (node.getGraph() != this) {
            node.setGraph(this);
        }
        if (this.nodeFromName(node.getName()) == null) {
            super.add(node);
            this.nodesFromName.put(node.getName(), node);
        }
        if (this.balancer != null) {
            Balancer balancer = this.balancer;
            synchronized (balancer) {
                this.balancer.awake();
            }
        }
    }

    public void navigateTo(Node node) {
        if (this.centerNode != null) {
            this.centerNode.unCenter();
        }
        this.centerNode = node;
        node.center();
    }

    public boolean contains(int x, int y) {
        int i = this.size();
        while (i > 0) {
            if (!((Node)this.elementAt(--i)).contains(x, y)) continue;
            this.focus = (Node)this.elementAt(i);
            return true;
        }
        return false;
    }

    public synchronized void paint(Graphics g) {
        Collections.sort(this, this.getStrategy());
        for (int i = 0; i < this.size(); ++i) {
            try {
                ((Node)this.elementAt(i)).paint(g);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Comparator getStrategy() {
        return new RenderingStrategy();
    }

    public void rotateNodes() {
        if (!this.rotation.isIdentity()) {
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                Node node = (Node)e.nextElement();
                this.rotation.transform(node);
                node.proj();
            }
            if (!this.rotating) {
                this.rotation.setIdentity();
            }
        }
    }

    public void removeNode(Node node) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.elementAt(i) != node) continue;
            this.remove(i);
        }
        if (this.focus == node) {
            this.focus = null;
        }
        this.nodesFromName.remove(node.getName());
    }

    public void rotate(float xtheta, float ytheta) {
        if (xtheta > ((Float)Config.getValue("maxTheta")).floatValue()) {
            xtheta = ((Float)Config.getValue("maxTheta")).floatValue();
        } else if (xtheta < -((Float)Config.getValue("maxTheta")).floatValue()) {
            xtheta = -((Float)Config.getValue("maxTheta")).floatValue();
        } else if (xtheta > 0.0f && xtheta < ((Float)Config.getValue("minTheta")).floatValue()) {
            xtheta = ((Float)Config.getValue("minTheta")).floatValue();
        } else if (xtheta < 0.0f && xtheta > -((Float)Config.getValue("minTheta")).floatValue()) {
            xtheta = -((Float)Config.getValue("minTheta")).floatValue();
        }
        if (ytheta > ((Float)Config.getValue("maxTheta")).floatValue()) {
            ytheta = ((Float)Config.getValue("maxTheta")).floatValue();
        } else if (ytheta < -((Float)Config.getValue("maxTheta")).floatValue()) {
            ytheta = -((Float)Config.getValue("maxTheta")).floatValue();
        } else if (ytheta > 0.0f && ytheta < ((Float)Config.getValue("minTheta")).floatValue()) {
            ytheta = ((Float)Config.getValue("minTheta")).floatValue();
        } else if (ytheta < 0.0f && ytheta > ((Float)Config.getValue("minTheta")).floatValue()) {
            ytheta = -((Float)Config.getValue("minTheta")).floatValue();
        }
        this.rotation.setIdentity();
        this.rotation.xrot(-xtheta);
        this.rotation.yrot(-ytheta);
    }

    public Node nodeFromName(String nodeName) {
        Node node = (Node)this.nodesFromName.get(nodeName);
        return node;
    }

    public Node getFocus() {
        return this.focus;
    }

    public Node getCenterNode() {
        return this.centerNode;
    }

    public Vertex getOrigin() {
        return this.origin;
    }

    public boolean isRotating() {
        return this.rotating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRotating(boolean rotating) {
        this.rotating = rotating;
        if (rotating && this.spinner != null) {
            Spinner spinner = this.spinner;
            synchronized (spinner) {
                this.spinner.notify();
            }
        }
    }

    public Matrix3D getRotation() {
        return this.rotation;
    }

    public void setSpinner(Spinner spinner) {
        this.spinner = spinner;
    }

    public void setBalancer(Balancer balancer) {
        this.balancer = balancer;
    }

    public boolean connected(Node node) {
        Enumeration e = node.getLinkList();
        while (e.hasMoreElements()) {
            if (this.nodeFromName((String)e.nextElement()) == null) continue;
            return true;
        }
        return false;
    }

    private final class RenderingStrategy
    implements Comparator {
        private RenderingStrategy() {
        }

        public int compare(Object o1, Object o2) {
            if (((Node)o1).z < ((Node)o2).z) {
                return -1;
            }
            if (((Node)o1).z == ((Node)o2).z) {
                return 0;
            }
            return 1;
        }
    }
}

