/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.structure;

import br.arca.morcego.Config;
import br.arca.morcego.Morcego;
import br.arca.morcego.physics.Matrix3x3;
import br.arca.morcego.physics.PositionedObject;
import br.arca.morcego.physics.Vector3D;
import br.arca.morcego.run.Balancer;
import br.arca.morcego.run.Feeder;
import br.arca.morcego.run.Rotator;
import br.arca.morcego.structure.GraphElement;
import br.arca.morcego.structure.GraphElementFactory;
import br.arca.morcego.structure.Link;
import br.arca.morcego.structure.Node;
import br.arca.morcego.transport.Transport;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.MouseInputListener;

public class Graph
extends Component
implements MouseInputListener,
PositionedObject,
Runnable {
    private Vector nodes;
    private Vector links;
    private Node centerNode;
    private Hashtable nodesFromId = new Hashtable();
    private Rotator rotator;
    private Matrix3x3 rotation;
    private Vector3D orientation;
    private Balancer balancer;
    private Feeder feeder;
    private int dragSpeedX;
    private int dragSpeedY;
    private boolean focusFixed = false;
    private Vector elements = new Vector();
    private GraphElement oldFocus;
    private float depth;
    private GraphElement focus;
    private int previousX;
    private int previousY;

    public Graph() {
        this.nodes = new Vector();
        this.links = new Vector();
        this.rotation = new Matrix3x3();
        this.orientation = new Vector3D(1.0f, 0.0f, 0.0f);
    }

    public void addElement(GraphElement e) {
        e.setGraph(this);
        this.elements.add(e);
    }

    public void addNode(Node node) {
        if (this.getNodeById(node.getId()) == null) {
            this.addElement(node);
            this.nodes.add(node);
            this.nodesFromId.put(node.getId(), node);
            Enumeration e = node.getLinkList();
            while (e.hasMoreElements()) {
                String neighbourName = (String)e.nextElement();
                Node neighbour = this.getNodeById(neighbourName);
                if (neighbour == null) continue;
                Link link = GraphElementFactory.createLink(node, neighbour);
                this.addElement(link);
                this.links.add(link);
            }
            if (this.balancer != null) {
                Balancer balancer = this.balancer;
                synchronized (balancer) {
                    this.balancer.awake();
                }
            }
        }
    }

    private synchronized void order() {
        Collections.sort(this.elements, new RenderingStrategy());
    }

    public void navigateTo(Node node) {
        this.center(node);
        this.notifyFeeder();
    }

    public void center(Node newCenter) {
        if (this.centerNode != null) {
            this.centerNode.unCenter();
        }
        this.centerNode = newCenter;
        newCenter.center();
    }

    public void removeNode(Node node) {
        Link link;
        this.elements.remove(node);
        this.nodes.remove(node);
        if (this.focus == node) {
            this.focus = null;
        }
        this.nodesFromId.remove(node.getId());
        Vector<Link> removedLinks = new Vector<Link>();
        Enumeration e = this.links.elements();
        while (e.hasMoreElements()) {
            link = (Link)e.nextElement();
            if (!link.hasNode(node)) continue;
            removedLinks.add(link);
        }
        e = removedLinks.elements();
        while (e.hasMoreElements()) {
            link = (Link)e.nextElement();
            this.elements.remove(link);
            this.links.remove(link);
        }
    }

    public Node getNodeById(String nodeId) {
        Node node = (Node)this.nodesFromId.get(nodeId);
        return node;
    }

    public Node getCenterNode() {
        return this.centerNode;
    }

    public boolean connected(Node node) {
        Enumeration e = node.getLinkList();
        while (e.hasMoreElements()) {
            if (this.getNodeById((String)e.nextElement()) == null) continue;
            return true;
        }
        return false;
    }

    private void savePosition(MouseEvent e) {
        this.previousX = e.getX();
        this.previousY = e.getY();
    }

    public boolean contains(MouseEvent e) {
        if (this.focusFixed) {
            return true;
        }
        this.order();
        boolean contains = false;
        int i = this.elements.size() - 1;
        while (i >= 0 && !contains) {
            GraphElement component = (GraphElement)this.elements.elementAt(i);
            if (component.visible() && component.contains(e)) {
                this.oldFocus = this.focus;
                this.focus = component;
                contains = true;
            }
            --i;
        }
        if (!contains) {
            this.oldFocus = this.focus;
            this.focus = null;
        }
        if (this.focus != this.oldFocus) {
            if (this.focus != null) {
                this.focus.mouseEntered(e);
            }
            if (this.oldFocus != null) {
                this.oldFocus.mouseExited(e);
            }
        }
        return true;
    }

    public void paint(Graphics g) {
        Vector vector = this.elements;
        synchronized (vector) {
            this.order();
            Enumeration e = this.elements.elements();
            while (e.hasMoreElements()) {
                GraphElement element = (GraphElement)e.nextElement();
                if (!element.visible()) continue;
                element.paint(g);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.rotator.stop();
        if (this.contains(e) && this.focus != null) {
            this.focus.mouseClicked(e);
        }
        this.savePosition(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.rotator.stop();
        if (this.focus != null) {
            this.focus.mousePressed(e);
        }
        this.savePosition(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.focus != null) {
            this.focus.mouseReleased(e);
        } else if (Math.abs(this.dragSpeedX) + Math.abs(this.dragSpeedY) > 4) {
            this.rotator.spin(this.dragSpeedY / 5, -this.dragSpeedX / 5);
        }
        this.savePosition(e);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.focus != null) {
            this.focus.mouseDragged(e);
        } else {
            this.dragSpeedX = e.getX() - this.previousX;
            this.dragSpeedY = e.getY() - this.previousY;
            this.rotate(this.dragSpeedY, -this.dragSpeedX);
        }
        Morcego.notifyRenderer();
        this.savePosition(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (this.contains(e) && this.focus != null) {
            this.focus.mouseMoved(e);
        }
        this.savePosition(e);
    }

    public Vector getNodes() {
        return this.nodes;
    }

    public Vector getLinks() {
        return this.links;
    }

    public void notifyFeeder() {
        Feeder feeder = this.feeder;
        synchronized (feeder) {
            this.feeder.notifyFeeder();
        }
    }

    public void notifyBalancer() {
        Balancer balancer = this.balancer;
        synchronized (balancer) {
            this.balancer.awake();
        }
    }

    public void run() {
        Object firstGraph = null;
        Class transportClass = null;
        Transport transport = null;
        try {
            transportClass = Config.getClass("morcego.transportClass");
            transport = (Transport)transportClass.newInstance();
            transport.setup();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.feeder = new Feeder(this, transport);
        this.balancer = new Balancer(this);
        this.rotator = new Rotator(this);
        Thread feedingThread = new Thread(this.feeder);
        Thread balanceThread = new Thread(this.balancer);
        Thread spinningThread = new Thread(this.rotator);
        feedingThread.start();
        spinningThread.start();
        Node firstNode = Config.getNode("morcego.startNode");
        this.addNode(firstNode);
        this.navigateTo(firstNode);
        balanceThread.start();
    }

    public void fixFocus() {
        this.focusFixed = true;
    }

    public void releaseFocus() {
        this.focusFixed = false;
        this.focus = null;
    }

    public Vector3D getOrientation() {
        return this.orientation;
    }

    public synchronized void rotate(float xTheta, float yTheta) {
        Enumeration e = this.getNodes().elements();
        while (e.hasMoreElements()) {
            Node node = (Node)e.nextElement();
            node.rotate(xTheta, yTheta);
        }
        this.getOrientation().rotate(xTheta, yTheta);
        Morcego.getCamera().adjustPosition(this);
    }

    public Node getFocus() {
        return (Node)this.focus;
    }

    public Vector getElements() {
        return this.elements;
    }

    private final class RenderingStrategy
    implements Comparator {
        RenderingStrategy() {
        }

        public int compare(Object o1, Object o2) {
            if (((GraphElement)o1).getDepth() > ((GraphElement)o2).getDepth()) {
                return -1;
            }
            if (((GraphElement)o1).getDepth() == ((GraphElement)o2).getDepth()) {
                return 0;
            }
            return 1;
        }
    }
}

