/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphTransferable;
import org.jgraph.graph.ParentMap;
import org.jgraph.pad.GPConverter;
import org.jgraph.pad.GPGraph;
import org.jgraph.pad.GPTransferable;
import org.jgraph.pad.GPUserObject;
import org.jgraph.pad.ImageCell;
import org.jgraph.pad.ImageIconBean;
import org.jgraph.pad.TextCell;
import org.jgraph.plaf.basic.BasicGraphUI;

public class GPGraphUI
extends BasicGraphUI {
    public GPGraph getGPGraph() {
        return (GPGraph)this.graph;
    }

    protected TransferHandler createTransferHandler() {
        return new GPTransferHandler();
    }

    protected void paintBackground(Graphics graphics) {
        Rectangle rectangle = this.graph.getBounds();
        if (this.getGPGraph().getBackgroundImage() != null) {
            double d = this.graph.getScale();
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.scale(d, d);
            graphics.drawImage(this.getGPGraph().getBackgroundImage(), 0, 0, this.graph);
            graphics2D.setTransform(affineTransform);
        } else if (this.getGPGraph().isPageVisible()) {
            int n = (int)this.getGPGraph().getPageFormat().getWidth();
            int n2 = (int)this.getGPGraph().getPageFormat().getHeight();
            Point point = this.graph.toScreen(new Point(n, n2));
            n = point.x;
            n2 = point.y;
            graphics.setColor(this.graph.getHandleColor());
            graphics.fillRect(0, 0, this.graph.getWidth(), this.graph.getHeight());
            graphics.setColor(Color.darkGray);
            graphics.fillRect(3, 3, n, n2);
            graphics.setColor(this.graph.getBackground());
            graphics.fillRect(1, 1, n - 1, n2 - 1);
            rectangle = new Rectangle(0, 0, n, n2);
        }
        if (this.graph.isGridVisible()) {
            this.paintGrid(this.graph.getGridSize(), graphics, rectangle);
        }
    }

    public class GPTransferHandler
    extends BasicGraphUI.GraphTransferHandler {
        public GPTransferHandler() {
            super(GPGraphUI.this);
        }

        protected GraphTransferable create(JGraph jGraph, Object[] objectArray, Map map, Rectangle rectangle, ConnectionSet connectionSet, ParentMap parentMap) {
            String string = GPConverter.toGXL(GPGraphUI.this.getGPGraph(), objectArray);
            return new GPTransferable(string, objectArray, map, rectangle, connectionSet, parentMap);
        }

        public boolean importDataImpl(JComponent jComponent, Transferable transferable) {
            block21: {
                if (super.importDataImpl(jComponent, transferable)) {
                    return true;
                }
                if (!GPGraphUI.this.graph.isDropEnabled() || !(jComponent instanceof JGraph)) break block21;
                try {
                    JGraph jGraph = (JGraph)jComponent;
                    if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        Point point = null;
                        if (GPGraphUI.this.getInsertionLocation() != null) {
                            point = jGraph.fromScreen(jGraph.snap(new Point(GPGraphUI.this.getInsertionLocation())));
                        }
                        int n = jGraph.getGridSize();
                        if (point == null) {
                            point = new Point(n, n);
                        }
                        Hashtable<DefaultGraphCell, Object> hashtable = new Hashtable<DefaultGraphCell, Object>();
                        LinkedList<DefaultGraphCell> linkedList = new LinkedList<DefaultGraphCell>();
                        List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            Dimension dimension;
                            Object object;
                            File file = (File)iterator.next();
                            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                            hashtable2.put("name", file.getName());
                            hashtable2.put(GPUserObject.keyURI, file.toURL().toString());
                            hashtable2.put("path", file.getAbsolutePath());
                            URL uRL = file.toURL();
                            ImageIconBean imageIconBean = null;
                            String string = file.getName();
                            if (uRL.toString().toLowerCase().endsWith(".gif") || uRL.toString().toLowerCase().endsWith(".jpg") || uRL.toString().toLowerCase().endsWith(".jpeg") || uRL.toString().toLowerCase().endsWith(".png")) {
                                imageIconBean = new ImageIconBean(uRL);
                                string = "";
                            }
                            GPUserObject gPUserObject = new GPUserObject(string, hashtable2);
                            DefaultGraphCell defaultGraphCell = imageIconBean != null ? new ImageCell(gPUserObject) : new DefaultGraphCell(gPUserObject);
                            defaultGraphCell.add(new DefaultPort());
                            if (imageIconBean == null) {
                                object = GPGraphUI.this.graphLayoutCache.getMapping(defaultGraphCell, true);
                                dimension = jGraph.snap(GPGraphUI.this.getPreferredSize(jGraph, (CellView)object));
                                if (dimension == null) {
                                    dimension = new Dimension(2 * n, 2 * n);
                                } else {
                                    dimension.width += 10;
                                }
                                jGraph.snap(dimension);
                                ++dimension.width;
                                ++dimension.height;
                            } else {
                                dimension = new Dimension(imageIconBean.getIconWidth(), imageIconBean.getIconHeight());
                            }
                            object = GraphConstants.createMap();
                            GraphConstants.setBounds((Map)object, new Rectangle(point, dimension));
                            if (imageIconBean != null) {
                                GraphConstants.setIcon((Map)object, imageIconBean);
                            } else {
                                GraphConstants.setBorderColor((Map)object, Color.black);
                            }
                            hashtable.put(defaultGraphCell, object);
                            linkedList.add(defaultGraphCell);
                            point.translate(0, dimension.height + (int)(1.5 * (double)n));
                            jGraph.snap(point);
                        }
                        if (!linkedList.isEmpty()) {
                            jGraph.getGraphLayoutCache().insert(linkedList.toArray(), hashtable, null, null, null);
                            jGraph.requestFocus();
                            return true;
                        }
                    } else {
                        Object object;
                        TextCell textCell = null;
                        Map map = GraphConstants.createMap();
                        DataFlavor dataFlavor = DataFlavor.selectBestTextFlavor(transferable.getTransferDataFlavors());
                        if (dataFlavor != null && textCell == null) {
                            object = dataFlavor.getReaderForText(transferable);
                            StringBuffer stringBuffer = new StringBuffer();
                            char[] cArray = new char[1];
                            while (((Reader)object).read(cArray) != -1) {
                                stringBuffer.append(cArray);
                            }
                            Point point = jGraph.fromScreen(jGraph.snap(new Point(GPGraphUI.this.getInsertionLocation())));
                            int n = jGraph.getGridSize();
                            if (point == null) {
                                point = new Point(n, n);
                            }
                            textCell = new TextCell(new String(stringBuffer));
                            ((DefaultGraphCell)textCell).add(new DefaultPort());
                            CellView cellView = GPGraphUI.this.graphLayoutCache.getMapping(textCell, true);
                            Dimension dimension = jGraph.snap(GPGraphUI.this.getPreferredSize(jGraph, cellView));
                            if (dimension == null) {
                                dimension = new Dimension(2 * n, 2 * n);
                            }
                            GraphConstants.setBounds(map, new Rectangle(point, dimension));
                        }
                        if (textCell != null) {
                            object = new Hashtable();
                            object.put(textCell, map);
                            jGraph.getModel().insert(new Object[]{textCell}, (Map)object, null, null, null);
                        }
                    }
                }
                catch (Exception exception) {}
            }
            return false;
        }
    }
}

