/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jgraph.JGraph;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.DefaultGraphCellEditor;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;
import org.jgraph.pad.EllipseCell;
import org.jgraph.pad.EllipseView;
import org.jgraph.pad.GPGraphUI;
import org.jgraph.pad.ImageCell;
import org.jgraph.pad.TextCell;

public class GPGraph
extends JGraph {
    public static String FILE_FORMAT_VERSION = "PAD-1.0";
    protected boolean pagevisible = false;
    protected transient PageFormat pageFormat = new PageFormat();
    protected Image background = null;
    protected Hashtable writeProperties = new Hashtable();
    protected transient Color defaultBorderColor = Color.black;
    public static VertexRenderer renderer = new ScaledVertexRenderer();

    public GPGraph() {
        this(null);
    }

    public GPGraph(GraphModel graphModel) {
        this(graphModel, (GraphLayoutCache)null);
    }

    public GPGraph(GraphModel graphModel, GraphLayoutCache graphLayoutCache) {
        super(graphModel, graphLayoutCache, null);
    }

    public Serializable getArchiveableState() {
        Object[] objectArray = this.getGraphLayoutCache().order(this.getAll());
        Map map = GraphConstants.createAttributes(objectArray, this.getGraphLayoutCache());
        Vector<Object> vector = new Vector<Object>();
        vector.add(FILE_FORMAT_VERSION);
        vector.add(objectArray);
        vector.add(map);
        vector.add(this.writeProperties);
        vector.add(new Boolean(this.isEditable()));
        vector.add(new Boolean(this.isBendable()));
        vector.add(new Boolean(this.isCloneable()));
        vector.add(new Boolean(this.isConnectable()));
        vector.add(new Boolean(this.isDisconnectable()));
        vector.add(new Boolean(this.isDisconnectOnMove()));
        vector.add(new Boolean(this.isDoubleBuffered()));
        vector.add(new Boolean(this.isDragEnabled()));
        vector.add(new Boolean(this.isDropEnabled()));
        vector.add(new Boolean(this.isMoveable()));
        vector.add(new Boolean(this.isPageVisible()));
        vector.add(new Boolean(this.isSelectNewCells()));
        vector.add(new Boolean(this.isSizeable()));
        vector.add(new Boolean(this.isGridVisible()));
        vector.add(new Boolean(this.isGridEnabled()));
        vector.add(new Integer(this.getGridSize()));
        vector.add(new Integer(this.getGridMode()));
        vector.add(new Double(this.getScale()));
        return vector;
    }

    public void setArchivedState(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            Object e = vector.get(0);
            if (e instanceof String) {
                if (e.equals(FILE_FORMAT_VERSION)) {
                    int n = 1;
                    Object[] objectArray = (Object[])vector.get(n++);
                    Map map = (Map)vector.get(n++);
                    this.getGraphLayoutCache().insert(objectArray, map, null, null, null);
                    this.setWriteProperties((Hashtable)vector.get(n++));
                    this.setEditable((Boolean)vector.get(n++));
                    this.setBendable((Boolean)vector.get(n++));
                    this.setCloneable((Boolean)vector.get(n++));
                    this.setConnectable((Boolean)vector.get(n++));
                    this.setDisconnectable((Boolean)vector.get(n++));
                    this.setDisconnectOnMove((Boolean)vector.get(n++));
                    this.setDoubleBuffered((Boolean)vector.get(n++));
                    this.setDragEnabled((Boolean)vector.get(n++));
                    this.setDropEnabled((Boolean)vector.get(n++));
                    this.setMoveable((Boolean)vector.get(n++));
                    this.setPageVisible((Boolean)vector.get(n++));
                    this.setSelectNewCells((Boolean)vector.get(n++));
                    this.setSizeable((Boolean)vector.get(n++));
                    this.setGridVisible((Boolean)vector.get(n++));
                    this.setGridEnabled((Boolean)vector.get(n++));
                    this.setGridSize((Integer)vector.get(n++));
                    this.setGridMode((Integer)vector.get(n++));
                    this.setScale((Double)vector.get(n++));
                } else {
                    System.out.println("Unknown file format: " + e);
                }
            } else {
                Object[] objectArray = (Object[])vector.get(0);
                Map map = (Map)vector.get(1);
                this.getGraphLayoutCache().insert(objectArray, map, null, null, null);
                this.setWriteProperties((Hashtable)vector.get(2));
            }
        }
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageVisible(boolean bl) {
        this.pagevisible = bl;
    }

    public boolean isPageVisible() {
        return this.pagevisible;
    }

    public void setBackgroundImage(Image image) {
        this.background = image;
    }

    public Image getBackgroundImage() {
        return this.background;
    }

    protected VertexView createVertexView(Object object, CellMapper cellMapper) {
        if (object instanceof EllipseCell) {
            return new EllipseView(object, this, cellMapper);
        }
        if (object instanceof ImageCell) {
            return new ScaledVertexView(object, this, cellMapper);
        }
        if (object instanceof TextCell && ((TextCell)object).isMultiLined()) {
            return new MultiLinedView(object, this, cellMapper);
        }
        return super.createVertexView(object, cellMapper);
    }

    public boolean isGroup(Object object) {
        CellView cellView = this.getGraphLayoutCache().getMapping(object, false);
        if (cellView != null) {
            return !cellView.isLeaf();
        }
        return false;
    }

    public boolean isVertex(Object object) {
        if (!(object instanceof Port) && !(object instanceof Edge)) {
            return !this.isGroup(object) && object != null;
        }
        return false;
    }

    public boolean isPort(Object object) {
        return object instanceof Port;
    }

    public boolean isEdge(Object object) {
        return object instanceof Edge;
    }

    public Object[] getSelectionVertices() {
        Object[] objectArray = this.getSelectionCells();
        Object[] objectArray2 = DefaultGraphModel.getDescendants(this.getModel(), objectArray).toArray();
        return this.getVertices(objectArray2);
    }

    public Object[] getVertices(Object[] objectArray) {
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                if (this.isVertex(objectArray[n])) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        return null;
    }

    public Object[] getSelectionEdges() {
        return this.getEdges(this.getSelectionCells());
    }

    public Object[] getAll() {
        return this.getDescendants(this.getRoots());
    }

    public Object[] getEdges(Object[] objectArray) {
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                if (this.isEdge(objectArray[n])) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        return null;
    }

    public Object getNeighbour(Object object, Object object2) {
        Object object3 = this.getSourceVertex(object);
        if (object2 == object3) {
            return this.getTargetVertex(object);
        }
        return object3;
    }

    public Object getSourceVertex(Object object) {
        Object object2 = this.graphModel.getSource(object);
        return this.graphModel.getParent(object2);
    }

    public Object getTargetVertex(Object object) {
        Object object2 = this.graphModel.getTarget(object);
        return this.graphModel.getParent(object2);
    }

    public CellView getSourceView(Object object) {
        Object object2 = this.getSourceVertex(object);
        return this.getGraphLayoutCache().getMapping(object2, false);
    }

    public CellView getTargetView(Object object) {
        Object object2 = this.getTargetVertex(object);
        return this.getGraphLayoutCache().getMapping(object2, false);
    }

    public Object[] getEdgesBetween(Object object, Object object2) {
        ArrayList arrayList = new ArrayList();
        Set set = DefaultGraphModel.getEdges(this.graphModel, new Object[]{object});
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object object3 = this.getSourceVertex(e);
            Object object4 = this.getTargetVertex(e);
            if ((object3 != object || object4 != object2) && (object3 != object2 || object4 != object)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent != null && (object = this.getFirstCellForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
            String string = this.convertValueToString(object);
            String string2 = "<html>";
            if (string != null && string.length() > 0) {
                string2 = string2 + "<strong>" + string + "</strong><br>";
            }
            return string2 + this.getToolTipForCell(object) + "</html>";
        }
        return null;
    }

    protected String getToolTipForCell(Object object) {
        List list;
        CellView cellView = this.getGraphLayoutCache().getMapping(object, false);
        String string = "";
        Rectangle rectangle = cellView.getBounds();
        if (rectangle != null) {
            string = string + "Location: " + rectangle.x + ", " + rectangle.y + "<br>";
            string = string + "Size: " + rectangle.width + ", " + rectangle.height + "<br>";
        }
        if ((list = GraphConstants.getPoints(cellView.getAttributes())) != null) {
            string = string + "Points: " + list.size() + "<br>";
        }
        if (!(object instanceof Edge) && !(object instanceof Port)) {
            string = string + "Children: " + this.graphModel.getChildCount(object) + "<br>";
            int n = DefaultGraphModel.getEdges(this.getModel(), new Object[]{object}).size();
            string = string + "Edges: " + n;
        } else if (object instanceof Edge) {
            String string2;
            Object object2;
            Edge edge = (Edge)object;
            Object object3 = this.graphModel.getSource(edge);
            if (object3 != null) {
                object2 = this.convertValueToString(this.graphModel.getParent(object3));
                string2 = this.convertValueToString(object3);
                string = string + "Source: " + (String)object2 + ":" + string2 + "<br>";
            }
            if ((object2 = this.graphModel.getTarget(edge)) != null) {
                string2 = this.convertValueToString(this.graphModel.getParent(object2));
                String string3 = this.convertValueToString(object2);
                string = string + "Target: " + string2 + "/" + string3 + "<br>";
            }
        }
        return string;
    }

    public void updateUI() {
        this.setUI(new GPGraphUI());
        this.invalidate();
    }

    public boolean isNeighbour(Object object, Object object2) {
        Object[] objectArray = this.getEdgesBetween(object, object2);
        return objectArray != null && objectArray.length > 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pageFormat = new PageFormat();
    }

    public Hashtable getWriteProperties() {
        return this.writeProperties;
    }

    public void setWriteProperties(Hashtable hashtable) {
        this.writeProperties = hashtable;
    }

    class MultiLinedView
    extends VertexView {
        final MultiLinedRenderer renderer = new MultiLinedRenderer();
        final MultiLinedEditor editor = new MultiLinedEditor();

        public MultiLinedView(Object object, JGraph jGraph, CellMapper cellMapper) {
            super(object, jGraph, cellMapper);
        }

        public CellViewRenderer getRenderer() {
            return this.renderer;
        }

        public GraphCellEditor getEditor() {
            return this.editor;
        }

        class MultiLinedRenderer
        extends JTextArea
        implements CellViewRenderer {
            MultiLinedRenderer() {
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
            }

            public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
                this.setText(cellView.getCell().toString());
                Map map = cellView.getAllAttributes();
                this.installAttributes(jGraph, map);
                return this;
            }

            protected void installAttributes(JGraph jGraph, Map map) {
                this.setOpaque(GraphConstants.isOpaque(map));
                Color color = GraphConstants.getForeground(map);
                this.setForeground(color != null ? color : jGraph.getForeground());
                Color color2 = GraphConstants.getBackground(map);
                this.setBackground(color2 != null ? color2 : jGraph.getBackground());
                Font font = GraphConstants.getFont(map);
                this.setFont(font != null ? font : jGraph.getFont());
                Border border = GraphConstants.getBorder(map);
                Color color3 = GraphConstants.getBorderColor(map);
                if (border != null) {
                    this.setBorder(border);
                } else if (color3 != null) {
                    int n = Math.max(1, Math.round(GraphConstants.getLineWidth(map)));
                    this.setBorder(BorderFactory.createLineBorder(color3, n));
                }
            }
        }

        class MultiLinedEditor
        extends DefaultGraphCellEditor {
            public Component getGraphCellEditorComponent(JGraph jGraph, Object object, boolean bl) {
                Component component = super.getGraphCellEditorComponent(jGraph, object, bl);
                CellView cellView = jGraph.getGraphLayoutCache().getMapping(object, false);
                this.editingComponent.setBounds(cellView.getBounds());
                Font font = GraphConstants.getFont(cellView.getAllAttributes());
                this.editingComponent.setFont(font != null ? font : jGraph.getFont());
                return component;
            }

            protected GraphCellEditor createGraphCellEditor() {
                return new RealCellEditor();
            }

            protected Container createContainer() {
                return new ModifiedEditorContainer();
            }

            class ModifiedEditorContainer
            extends DefaultGraphCellEditor.EditorContainer {
                ModifiedEditorContainer() {
                    super(MultiLinedEditor.this);
                }

                public void doLayout() {
                    super.doLayout();
                    Dimension dimension = this.getSize();
                    Dimension dimension2 = MultiLinedEditor.this.editingComponent.getSize();
                    MultiLinedEditor.this.editingComponent.setSize(dimension2.width - 2, dimension2.height);
                    this.setSize(dimension.width, this.getPreferredSize().height);
                }
            }

            class RealCellEditor
            extends AbstractCellEditor
            implements GraphCellEditor {
                JTextArea editorComponent = new JTextArea();

                public RealCellEditor() {
                    this.editorComponent.setBorder(UIManager.getBorder("Tree.editorBorder"));
                    this.editorComponent.setLineWrap(true);
                    this.editorComponent.setWrapStyleWord(true);
                    this.editorComponent.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
                    this.editorComponent.getActionMap().put("enter", new AbstractAction(this){
                        private final /* synthetic */ RealCellEditor this$3;
                        {
                            this.this$3 = realCellEditor;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            this.this$3.stopCellEditing();
                        }
                    });
                }

                public Component getGraphCellEditorComponent(JGraph jGraph, Object object, boolean bl) {
                    this.editorComponent.setText(object.toString());
                    this.editorComponent.selectAll();
                    return this.editorComponent;
                }

                public Object getCellEditorValue() {
                    return this.editorComponent.getText();
                }

                public boolean stopCellEditing() {
                    CellView cellView = MultiLinedEditor.this.graph.getGraphLayoutCache().getMapping(MultiLinedEditor.this.graph.getEditingCell(), false);
                    Map map = cellView.getAllAttributes();
                    Rectangle rectangle = GraphConstants.getBounds(map);
                    Rectangle rectangle2 = this.editorComponent.getBounds();
                    rectangle.setBounds(rectangle.x, rectangle.y, rectangle2.width, rectangle2.height);
                    return super.stopCellEditing();
                }

                public boolean shouldSelectCell(EventObject eventObject) {
                    this.editorComponent.requestFocus();
                    return super.shouldSelectCell(eventObject);
                }
            }
        }
    }

    public static class ScaledVertexRenderer
    extends VertexRenderer {
        public void paint(Graphics graphics) {
            Icon icon = this.getIcon();
            this.setIcon(null);
            Dimension dimension = this.getSize();
            Image image = null;
            if (icon instanceof ImageIcon) {
                image = ((ImageIcon)icon).getImage();
            }
            if (image != null) {
                graphics.drawImage(image, 0, 0, dimension.width - 1, dimension.height - 1, this.graph);
            }
            super.paint(graphics);
        }
    }

    public class ScaledVertexView
    extends VertexView {
        public ScaledVertexView(Object object, JGraph jGraph, CellMapper cellMapper) {
            super(object, jGraph, cellMapper);
        }

        public CellViewRenderer getRenderer() {
            return renderer;
        }
    }
}

