
##############################################################################
#
# Message boxes for warnings and errors. <Peter.Bienstman@UGent.be>
#
##############################################################################

import sys, os
from mnemosyne.core.exceptions import *
from qt import *



##############################################################################
#
# Display extra errors generated by the library.
#
#  We don't provide these strings in libmnemosyne because they need to be
#  exposed to Qt's internationalisation mechanism.
#
##############################################################################

def messagebox_errors(self, e):

    # Kludgy...
    
    if isinstance(e, ConfigError):
        msg = self.trUtf8("Error in config.py:")
    elif isinstance(e, PluginError):
        msg = self.trUtf8("Error when running plugin:")
    elif isinstance(e, LoadError):
        msg = self.trUtf8("Unable to load file.")       
    elif isinstance(e, InvalidFormatError):
        msg = self.trUtf8("Invalid file format.")
    elif isinstance(e, SaveError):
        msg = self.trUtf8("Unable to save file.")   
    elif isinstance(e, XMLError):
        msg = self.trUtf8("Unable to parse XML:")
    elif isinstance(e, EncodingError):
        msg = self.trUtf8("Unrecognised encoding.")
    elif isinstance(e, MissingAnswerError):
        msg = self.trUtf8("Missing answer on line:")
    elif isinstance(e, LoadErrorCreateTmp):               
        msg = self.trUtf8("Unable to load database.\nCreating tmp file.")
         
    if e.info:
        msg = QString(msg).append(QString("\n")).append(e.info)
                                   
    QMessageBox.critical(None, self.trUtf8("Mnemosyne"), msg,
                         self.trUtf8("&OK"), "", "", 0, -1)



##############################################################################
#
# queryOverwriteFile
#
##############################################################################

def queryOverwriteFile(self, fileName):
    
    status = QMessageBox.warning(None,
                                 self.trUtf8("Mnemosyne"),
                                 self.trUtf8("File exists:")\
                                 .append(QString("\n" + fileName)),
                                 self.trUtf8("&Overwrite"),
                                 self.trUtf8("&Cancel"),
                                 "", 1, -1)
    if status == 0:
        return True
    else:
        return False
