/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _POINT_H
#define _POINT_H

#include <iostream>

namespace uta {

///
class Point
{
 public:
  ///
  Point() : x(0), y(0) {;};
  ///
  Point(int x_, int y_) : x(x_), y(y_) {;};
 
  Point& operator+=(const Point& p)                             
    {  x += p.x; y += p.y;  return *this; }
  ///
  Point& operator-=(const Point& p)                             
    {  x -= p.x; y -= p.y;  return *this; }
  ///
  ~Point() {};
  ///
  friend Point operator+(const Point& p, const Point& q)
    { return Point(p) += q; }
  ///
  friend Point operator-(const Point& p, const Point& q)
    { return Point(p) -= q; }   
  ///
  friend bool operator==(const Point &p, const Point &q)
    { return (p.x == q.x) && (p.y == q.y); };
  ///
  friend bool operator!=(const Point &p, const Point &q)
    { return (p.x != q.x) || (p.y != q.y); };
  ///
  friend bool operator<=(const Point &p, const Point &q)
    { return (p.x <= q.x) && (p.y <= q.y); };
  ///
  friend bool operator>=(const Point &p, const Point &q)
    { return (p.x >= q.x) && (p.y >= q.y); };
  ///
  friend bool operator<(const Point &p, const Point &q)
    { return (p.x < q.x) && (p.y < q.y); };
  ///
  friend bool operator>(const Point &p, const Point &q)
    { return (p.x > q.x) && (p.y > q.y); };
  ///
  friend std::ostream& operator<<(std::ostream& s, const Point& p)
    {
      s << "(" << p.x << ":" << p.y << ")";
      return s;
    }  
  ///
  int x;
  ///
  int y;

};

}

#endif
