/** @file etk_tooltips.h */
#ifndef _ETK_TOOLTIPS_H_
#define _ETK_TOOLTIPS_H_

#include "etk_widget.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @defgroup Etk_Tooltips Etk_Tooltips
 * @{
 */

void etk_tooltips_init();
void etk_tooltips_shutdown();

void etk_tooltips_enable();
void etk_tooltips_disable();

void etk_tooltips_tip_set(Etk_Widget *widget, const char *text);
const char *etk_tooltips_tip_get(Etk_Widget *widget);

Etk_Bool etk_tooltips_tip_visible();

void etk_tooltips_pop_up(Etk_Widget *widget);
void etk_tooltips_pop_down();

/** @} */

#ifdef __cplusplus
}
#endif

#endif
