/** @file etk_main.h */
#ifndef _ETK_MAIN_H_
#define _ETK_MAIN_H_

#include <Evas.h>

#include "etk_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @defgroup Etk_Main The main functions of Etk
 * @brief The main functions of Etk, used to initialize or shutdown Etk, and to control the main loop
 * @{
 */

int  etk_init(int argc, char **argv);
int  etk_init_full(int argc, char **argv, const char *custom_opts);
int  etk_shutdown(void);

void etk_main(void);
void etk_main_quit(void);
void etk_main_iterate(void);

/** @} */

#ifdef __cplusplus
}
#endif

#endif
