require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&HEADER_ENVELOPE_H)) {
    eval 'sub HEADER_ENVELOPE_H () {1;}' unless defined(&HEADER_ENVELOPE_H);
    if(defined(&OPENSSL_ALGORITHM_DEFINES)) {
	require 'openssl/opensslconf.ph';
    } else {
	eval 'sub OPENSSL_ALGORITHM_DEFINES () {1;}' unless defined(&OPENSSL_ALGORITHM_DEFINES);
	require 'openssl/opensslconf.ph';
	undef(&OPENSSL_ALGORITHM_DEFINES) if defined(&OPENSSL_ALGORITHM_DEFINES);
    }
    require 'openssl/ossl_typ.ph';
    require 'openssl/symhacks.ph';
    unless(defined(&OPENSSL_NO_BIO)) {
	require 'openssl/bio.ph';
    }
    if(defined(&OPENSSL_FIPS)) {
	require 'openssl/fips.ph';
    }
    eval 'sub EVP_MAX_MD_SIZE () {64;}' unless defined(&EVP_MAX_MD_SIZE);
    eval 'sub EVP_MAX_KEY_LENGTH () {32;}' unless defined(&EVP_MAX_KEY_LENGTH);
    eval 'sub EVP_MAX_IV_LENGTH () {16;}' unless defined(&EVP_MAX_IV_LENGTH);
    eval 'sub EVP_MAX_BLOCK_LENGTH () {32;}' unless defined(&EVP_MAX_BLOCK_LENGTH);
    eval 'sub PKCS5_SALT_LEN () {8;}' unless defined(&PKCS5_SALT_LEN);
    eval 'sub PKCS5_DEFAULT_ITER () {2048;}' unless defined(&PKCS5_DEFAULT_ITER);
    require 'openssl/objects.ph';
    eval 'sub EVP_PK_RSA () {0x1;}' unless defined(&EVP_PK_RSA);
    eval 'sub EVP_PK_DSA () {0x2;}' unless defined(&EVP_PK_DSA);
    eval 'sub EVP_PK_DH () {0x4;}' unless defined(&EVP_PK_DH);
    eval 'sub EVP_PK_EC () {0x8;}' unless defined(&EVP_PK_EC);
    eval 'sub EVP_PKT_SIGN () {0x10;}' unless defined(&EVP_PKT_SIGN);
    eval 'sub EVP_PKT_ENC () {0x20;}' unless defined(&EVP_PKT_ENC);
    eval 'sub EVP_PKT_EXCH () {0x40;}' unless defined(&EVP_PKT_EXCH);
    eval 'sub EVP_PKS_RSA () {0x100;}' unless defined(&EVP_PKS_RSA);
    eval 'sub EVP_PKS_DSA () {0x200;}' unless defined(&EVP_PKS_DSA);
    eval 'sub EVP_PKS_EC () {0x400;}' unless defined(&EVP_PKS_EC);
    eval 'sub EVP_PKT_EXP () {0x1000;}' unless defined(&EVP_PKT_EXP);
    eval 'sub EVP_PKEY_NONE () { &NID_undef;}' unless defined(&EVP_PKEY_NONE);
    eval 'sub EVP_PKEY_RSA () { &NID_rsaEncryption;}' unless defined(&EVP_PKEY_RSA);
    eval 'sub EVP_PKEY_RSA2 () { &NID_rsa;}' unless defined(&EVP_PKEY_RSA2);
    eval 'sub EVP_PKEY_DSA () { &NID_dsa;}' unless defined(&EVP_PKEY_DSA);
    eval 'sub EVP_PKEY_DSA1 () { &NID_dsa_2;}' unless defined(&EVP_PKEY_DSA1);
    eval 'sub EVP_PKEY_DSA2 () { &NID_dsaWithSHA;}' unless defined(&EVP_PKEY_DSA2);
    eval 'sub EVP_PKEY_DSA3 () { &NID_dsaWithSHA1;}' unless defined(&EVP_PKEY_DSA3);
    eval 'sub EVP_PKEY_DSA4 () { &NID_dsaWithSHA1_2;}' unless defined(&EVP_PKEY_DSA4);
    eval 'sub EVP_PKEY_DH () { &NID_dhKeyAgreement;}' unless defined(&EVP_PKEY_DH);
    eval 'sub EVP_PKEY_EC () { &NID_X9_62_id_ecPublicKey;}' unless defined(&EVP_PKEY_EC);
    if(defined(&__cplusplus)) {
    }
    unless(defined(&OPENSSL_NO_RSA)) {
    }
    unless(defined(&OPENSSL_NO_DSA)) {
    }
    unless(defined(&OPENSSL_NO_DH)) {
    }
    unless(defined(&OPENSSL_NO_EC)) {
    }
    eval 'sub EVP_PKEY_MO_SIGN () {0x1;}' unless defined(&EVP_PKEY_MO_SIGN);
    eval 'sub EVP_PKEY_MO_VERIFY () {0x2;}' unless defined(&EVP_PKEY_MO_VERIFY);
    eval 'sub EVP_PKEY_MO_ENCRYPT () {0x4;}' unless defined(&EVP_PKEY_MO_ENCRYPT);
    eval 'sub EVP_PKEY_MO_DECRYPT () {0x8;}' unless defined(&EVP_PKEY_MO_DECRYPT);
    if(0) {
	eval 'sub EVP_rsa_md2 () {
	    eval q( &EVP_PKEY_MD_add( &NID_md2WithRSAEncryption,  &EVP_rsa_pkcs1(), &EVP_md2()));
	}' unless defined(&EVP_rsa_md2);
	eval 'sub EVP_rsa_md5 () {
	    eval q( &EVP_PKEY_MD_add( &NID_md5WithRSAEncryption,  &EVP_rsa_pkcs1(), &EVP_md5()));
	}' unless defined(&EVP_rsa_md5);
	eval 'sub EVP_rsa_sha0 () {
	    eval q( &EVP_PKEY_MD_add( &NID_shaWithRSAEncryption,  &EVP_rsa_pkcs1(), &EVP_sha()));
	}' unless defined(&EVP_rsa_sha0);
	eval 'sub EVP_rsa_sha1 () {
	    eval q( &EVP_PKEY_MD_add( &NID_sha1WithRSAEncryption,  &EVP_rsa_pkcs1(), &EVP_sha1()));
	}' unless defined(&EVP_rsa_sha1);
	eval 'sub EVP_rsa_ripemd160 () {
	    eval q( &EVP_PKEY_MD_add( &NID_ripemd160WithRSA,  &EVP_rsa_pkcs1(), &EVP_ripemd160()));
	}' unless defined(&EVP_rsa_ripemd160);
	eval 'sub EVP_rsa_mdc2 () {
	    eval q( &EVP_PKEY_MD_add( &NID_mdc2WithRSA,  &EVP_rsa_octet_string(), &EVP_mdc2()));
	}' unless defined(&EVP_rsa_mdc2);
	eval 'sub EVP_dsa_sha () {
	    eval q( &EVP_PKEY_MD_add( &NID_dsaWithSHA,  &EVP_dsa(), &EVP_sha()));
	}' unless defined(&EVP_dsa_sha);
	eval 'sub EVP_dsa_sha1 () {
	    eval q( &EVP_PKEY_MD_add( &NID_dsaWithSHA1,  &EVP_dsa(), &EVP_sha1()));
	}' unless defined(&EVP_dsa_sha1);
    }
    unless(defined(&EVP_MD)) {
	eval 'sub EVP_MD_FLAG_ONESHOT () {0x1;}' unless defined(&EVP_MD_FLAG_ONESHOT);
	eval 'sub EVP_MD_FLAG_FIPS () {0x400;}' unless defined(&EVP_MD_FLAG_FIPS);
	eval 'sub EVP_MD_FLAG_SVCTX () {0x800;}' unless defined(&EVP_MD_FLAG_SVCTX);
	eval 'sub EVP_PKEY_NULL_method () { &NULL, &NULL,{0,0,0,0};}' unless defined(&EVP_PKEY_NULL_method);
	unless(defined(&OPENSSL_NO_DSA)) {
	    eval 'sub EVP_PKEY_DSA_method () {( &evp_sign_method *) &DSA_sign, ( &evp_verify_method *) &DSA_verify, { &EVP_PKEY_DSA, &EVP_PKEY_DSA2, &EVP_PKEY_DSA3,  &EVP_PKEY_DSA4,0};}' unless defined(&EVP_PKEY_DSA_method);
	} else {
	    eval 'sub EVP_PKEY_DSA_method () { &EVP_PKEY_NULL_method;}' unless defined(&EVP_PKEY_DSA_method);
	}
	unless(defined(&OPENSSL_NO_ECDSA)) {
	    eval 'sub EVP_PKEY_ECDSA_method () {( &evp_sign_method *) &ECDSA_sign, ( &evp_verify_method *) &ECDSA_verify, { &EVP_PKEY_EC,0,0,0};}' unless defined(&EVP_PKEY_ECDSA_method);
	} else {
	    eval 'sub EVP_PKEY_ECDSA_method () { &EVP_PKEY_NULL_method;}' unless defined(&EVP_PKEY_ECDSA_method);
	}
	unless(defined(&OPENSSL_NO_RSA)) {
	    eval 'sub EVP_PKEY_RSA_method () {( &evp_sign_method *) &RSA_sign, ( &evp_verify_method *) &RSA_verify, { &EVP_PKEY_RSA, &EVP_PKEY_RSA2,0,0};}' unless defined(&EVP_PKEY_RSA_method);
	    eval 'sub EVP_PKEY_RSA_ASN1_OCTET_STRING_method () {( &evp_sign_method *) &RSA_sign_ASN1_OCTET_STRING, ( &evp_verify_method *) &RSA_verify_ASN1_OCTET_STRING, { &EVP_PKEY_RSA, &EVP_PKEY_RSA2,0,0};}' unless defined(&EVP_PKEY_RSA_ASN1_OCTET_STRING_method);
	} else {
	    eval 'sub EVP_PKEY_RSA_method () { &EVP_PKEY_NULL_method;}' unless defined(&EVP_PKEY_RSA_method);
	    eval 'sub EVP_PKEY_RSA_ASN1_OCTET_STRING_method () { &EVP_PKEY_NULL_method;}' unless defined(&EVP_PKEY_RSA_ASN1_OCTET_STRING_method);
	}
    }
    eval 'sub EVP_MD_CTX_FLAG_ONESHOT () {0x1;}' unless defined(&EVP_MD_CTX_FLAG_ONESHOT);
    eval 'sub EVP_MD_CTX_FLAG_CLEANED () {0x2;}' unless defined(&EVP_MD_CTX_FLAG_CLEANED);
    eval 'sub EVP_MD_CTX_FLAG_REUSE () {0x4;}' unless defined(&EVP_MD_CTX_FLAG_REUSE);
    eval 'sub EVP_MD_CTX_FLAG_NON_FIPS_ALLOW () {0x8;}' unless defined(&EVP_MD_CTX_FLAG_NON_FIPS_ALLOW);
    eval 'sub EVP_MD_CTX_FLAG_PAD_MASK () {0xf0;}' unless defined(&EVP_MD_CTX_FLAG_PAD_MASK);
    eval 'sub EVP_MD_CTX_FLAG_PAD_PKCS1 () {0x;}' unless defined(&EVP_MD_CTX_FLAG_PAD_PKCS1);
    eval 'sub EVP_MD_CTX_FLAG_PAD_X931 () {0x10;}' unless defined(&EVP_MD_CTX_FLAG_PAD_X931);
    eval 'sub EVP_MD_CTX_FLAG_PAD_PSS () {0x20;}' unless defined(&EVP_MD_CTX_FLAG_PAD_PSS);
    eval 'sub M_EVP_MD_CTX_FLAG_PSS_SALT {
        my($ctx) = @_;
	    eval q((( ($ctx->{flags})>>16) &0xffff));
    }' unless defined(&M_EVP_MD_CTX_FLAG_PSS_SALT);
    eval 'sub EVP_MD_CTX_FLAG_PSS_MDLEN () {0xffff;}' unless defined(&EVP_MD_CTX_FLAG_PSS_MDLEN);
    eval 'sub EVP_MD_CTX_FLAG_PSS_MREC () {0xfffe;}' unless defined(&EVP_MD_CTX_FLAG_PSS_MREC);
    eval 'sub EVP_CIPH_STREAM_CIPHER () {0x;}' unless defined(&EVP_CIPH_STREAM_CIPHER);
    eval 'sub EVP_CIPH_ECB_MODE () {0x1;}' unless defined(&EVP_CIPH_ECB_MODE);
    eval 'sub EVP_CIPH_CBC_MODE () {0x2;}' unless defined(&EVP_CIPH_CBC_MODE);
    eval 'sub EVP_CIPH_CFB_MODE () {0x3;}' unless defined(&EVP_CIPH_CFB_MODE);
    eval 'sub EVP_CIPH_OFB_MODE () {0x4;}' unless defined(&EVP_CIPH_OFB_MODE);
    eval 'sub EVP_CIPH_MODE () {0x7;}' unless defined(&EVP_CIPH_MODE);
    eval 'sub EVP_CIPH_VARIABLE_LENGTH () {0x8;}' unless defined(&EVP_CIPH_VARIABLE_LENGTH);
    eval 'sub EVP_CIPH_CUSTOM_IV () {0x10;}' unless defined(&EVP_CIPH_CUSTOM_IV);
    eval 'sub EVP_CIPH_ALWAYS_CALL_INIT () {0x20;}' unless defined(&EVP_CIPH_ALWAYS_CALL_INIT);
    eval 'sub EVP_CIPH_CTRL_INIT () {0x40;}' unless defined(&EVP_CIPH_CTRL_INIT);
    eval 'sub EVP_CIPH_CUSTOM_KEY_LENGTH () {0x80;}' unless defined(&EVP_CIPH_CUSTOM_KEY_LENGTH);
    eval 'sub EVP_CIPH_NO_PADDING () {0x100;}' unless defined(&EVP_CIPH_NO_PADDING);
    eval 'sub EVP_CIPH_RAND_KEY () {0x200;}' unless defined(&EVP_CIPH_RAND_KEY);
    eval 'sub EVP_CIPH_FLAG_FIPS () {0x400;}' unless defined(&EVP_CIPH_FLAG_FIPS);
    eval 'sub EVP_CIPH_FLAG_NON_FIPS_ALLOW () {0x800;}' unless defined(&EVP_CIPH_FLAG_NON_FIPS_ALLOW);
    eval 'sub EVP_CIPH_FLAG_DEFAULT_ASN1 () {0x1000;}' unless defined(&EVP_CIPH_FLAG_DEFAULT_ASN1);
    eval 'sub EVP_CIPH_FLAG_LENGTH_BITS () {0x2000;}' unless defined(&EVP_CIPH_FLAG_LENGTH_BITS);
    eval 'sub EVP_CTRL_INIT () {0x;}' unless defined(&EVP_CTRL_INIT);
    eval 'sub EVP_CTRL_SET_KEY_LENGTH () {0x1;}' unless defined(&EVP_CTRL_SET_KEY_LENGTH);
    eval 'sub EVP_CTRL_GET_RC2_KEY_BITS () {0x2;}' unless defined(&EVP_CTRL_GET_RC2_KEY_BITS);
    eval 'sub EVP_CTRL_SET_RC2_KEY_BITS () {0x3;}' unless defined(&EVP_CTRL_SET_RC2_KEY_BITS);
    eval 'sub EVP_CTRL_GET_RC5_ROUNDS () {0x4;}' unless defined(&EVP_CTRL_GET_RC5_ROUNDS);
    eval 'sub EVP_CTRL_SET_RC5_ROUNDS () {0x5;}' unless defined(&EVP_CTRL_SET_RC5_ROUNDS);
    eval 'sub EVP_CTRL_SET_ACSS_MODE () {0x6;}' unless defined(&EVP_CTRL_SET_ACSS_MODE);
    eval 'sub EVP_CTRL_RAND_KEY () {0x7;}' unless defined(&EVP_CTRL_RAND_KEY);
    unless(defined(&OPENSSL_NO_RSA)) {
	eval 'sub EVP_PKEY_assign_RSA {
	    my($pkey,$rsa) = @_;
    	    eval q( &EVP_PKEY_assign(, &EVP_PKEY_RSA, ($rsa)));
	}' unless defined(&EVP_PKEY_assign_RSA);
    }
    unless(defined(&OPENSSL_NO_DSA)) {
	eval 'sub EVP_PKEY_assign_DSA {
	    my($pkey,$dsa) = @_;
    	    eval q( &EVP_PKEY_assign(, &EVP_PKEY_DSA, ($dsa)));
	}' unless defined(&EVP_PKEY_assign_DSA);
    }
    unless(defined(&OPENSSL_NO_DH)) {
	eval 'sub EVP_PKEY_assign_DH {
	    my($pkey,$dh) = @_;
    	    eval q( &EVP_PKEY_assign(, &EVP_PKEY_DH, ($dh)));
	}' unless defined(&EVP_PKEY_assign_DH);
    }
    unless(defined(&OPENSSL_NO_EC)) {
	eval 'sub EVP_PKEY_assign_EC_KEY {
	    my($pkey,$eckey) = @_;
    	    eval q( &EVP_PKEY_assign(, &EVP_PKEY_EC, ($eckey)));
	}' unless defined(&EVP_PKEY_assign_EC_KEY);
    }
    eval 'sub EVP_get_digestbynid {
        my($a) = @_;
	    eval q( &EVP_get_digestbyname( &OBJ_nid2sn($a)));
    }' unless defined(&EVP_get_digestbynid);
    eval 'sub EVP_get_digestbyobj {
        my($a) = @_;
	    eval q( &EVP_get_digestbynid( &OBJ_obj2nid($a)));
    }' unless defined(&EVP_get_digestbyobj);
    eval 'sub EVP_get_cipherbynid {
        my($a) = @_;
	    eval q( &EVP_get_cipherbyname( &OBJ_nid2sn($a)));
    }' unless defined(&EVP_get_cipherbynid);
    eval 'sub EVP_get_cipherbyobj {
        my($a) = @_;
	    eval q( &EVP_get_cipherbynid( &OBJ_obj2nid($a)));
    }' unless defined(&EVP_get_cipherbyobj);
    eval 'sub M_EVP_MD_size {
        my($e) = @_;
	    eval q((($e)-> &md_size));
    }' unless defined(&M_EVP_MD_size);
    eval 'sub M_EVP_MD_block_size {
        my($e) = @_;
	    eval q((($e)-> &block_size));
    }' unless defined(&M_EVP_MD_block_size);
    eval 'sub M_EVP_MD_CTX_set_flags {
        my($ctx,$flgs) = @_;
	    eval q((($ctx)-> &flags|=($flgs)));
    }' unless defined(&M_EVP_MD_CTX_set_flags);
    eval 'sub M_EVP_MD_CTX_clear_flags {
        my($ctx,$flgs) = @_;
	    eval q((($ctx)-> &flags&=~($flgs)));
    }' unless defined(&M_EVP_MD_CTX_clear_flags);
    eval 'sub M_EVP_MD_CTX_test_flags {
        my($ctx,$flgs) = @_;
	    eval q((($ctx)-> &flags($flgs)));
    }' unless defined(&M_EVP_MD_CTX_test_flags);
    eval 'sub M_EVP_MD_type {
        my($e) = @_;
	    eval q((($e)-> &type));
    }' unless defined(&M_EVP_MD_type);
    eval 'sub M_EVP_MD_CTX_type {
        my($e) = @_;
	    eval q( &M_EVP_MD_type( &M_EVP_MD_CTX_md($e)));
    }' unless defined(&M_EVP_MD_CTX_type);
    eval 'sub M_EVP_MD_CTX_md {
        my($e) = @_;
	    eval q((($e)-> &digest));
    }' unless defined(&M_EVP_MD_CTX_md);
    eval 'sub M_EVP_CIPHER_CTX_set_flags {
        my($ctx,$flgs) = @_;
	    eval q((($ctx)-> &flags|=($flgs)));
    }' unless defined(&M_EVP_CIPHER_CTX_set_flags);
    eval 'sub EVP_MD_nid {
        my($e) = @_;
	    eval q( &EVP_MD_type($e));
    }' unless defined(&EVP_MD_nid);
    eval 'sub EVP_MD_name {
        my($e) = @_;
	    eval q( &OBJ_nid2sn( &EVP_MD_nid($e)));
    }' unless defined(&EVP_MD_name);
    eval 'sub EVP_MD_CTX_size {
        my($e) = @_;
	    eval q( &EVP_MD_size( &EVP_MD_CTX_md($e)));
    }' unless defined(&EVP_MD_CTX_size);
    eval 'sub EVP_MD_CTX_block_size {
        my($e) = @_;
	    eval q( &EVP_MD_block_size( &EVP_MD_CTX_md($e)));
    }' unless defined(&EVP_MD_CTX_block_size);
    eval 'sub EVP_MD_CTX_type {
        my($e) = @_;
	    eval q( &EVP_MD_type( &EVP_MD_CTX_md($e)));
    }' unless defined(&EVP_MD_CTX_type);
    eval 'sub EVP_CIPHER_name {
        my($e) = @_;
	    eval q( &OBJ_nid2sn( &EVP_CIPHER_nid($e)));
    }' unless defined(&EVP_CIPHER_name);
    eval 'sub EVP_CIPHER_mode {
        my($e) = @_;
	    eval q(( &EVP_CIPHER_flags($e) &  &EVP_CIPH_MODE));
    }' unless defined(&EVP_CIPHER_mode);
    eval 'sub EVP_CIPHER_CTX_type {
        my($c) = @_;
	    eval q( &EVP_CIPHER_type( &EVP_CIPHER_CTX_cipher($c)));
    }' unless defined(&EVP_CIPHER_CTX_type);
    eval 'sub EVP_CIPHER_CTX_mode {
        my($e) = @_;
	    eval q(( &EVP_CIPHER_CTX_flags($e) &  &EVP_CIPH_MODE));
    }' unless defined(&EVP_CIPHER_CTX_mode);
    eval 'sub EVP_ENCODE_LENGTH {
        my($l) = @_;
	    eval q(((($l+2)/3*4)+($l/48+1)*2+80));
    }' unless defined(&EVP_ENCODE_LENGTH);
    eval 'sub EVP_DECODE_LENGTH {
        my($l) = @_;
	    eval q((($l+3)/4*3+80));
    }' unless defined(&EVP_DECODE_LENGTH);
    eval 'sub EVP_SignInit_ex {
        my($a,$b,$c) = @_;
	    eval q( &EVP_DigestInit_ex($a,$b,$c));
    }' unless defined(&EVP_SignInit_ex);
    eval 'sub EVP_SignInit {
        my($a,$b) = @_;
	    eval q( &EVP_DigestInit($a,$b));
    }' unless defined(&EVP_SignInit);
    eval 'sub EVP_SignUpdate {
        my($a,$b,$c) = @_;
	    eval q( &EVP_DigestUpdate($a,$b,$c));
    }' unless defined(&EVP_SignUpdate);
    eval 'sub EVP_VerifyInit_ex {
        my($a,$b,$c) = @_;
	    eval q( &EVP_DigestInit_ex($a,$b,$c));
    }' unless defined(&EVP_VerifyInit_ex);
    eval 'sub EVP_VerifyInit {
        my($a,$b) = @_;
	    eval q( &EVP_DigestInit($a,$b));
    }' unless defined(&EVP_VerifyInit);
    eval 'sub EVP_VerifyUpdate {
        my($a,$b,$c) = @_;
	    eval q( &EVP_DigestUpdate($a,$b,$c));
    }' unless defined(&EVP_VerifyUpdate);
    eval 'sub EVP_OpenUpdate {
        my($a,$b,$c,$d,$e) = @_;
	    eval q( &EVP_DecryptUpdate($a,$b,$c,$d,$e));
    }' unless defined(&EVP_OpenUpdate);
    eval 'sub EVP_SealUpdate {
        my($a,$b,$c,$d,$e) = @_;
	    eval q( &EVP_EncryptUpdate($a,$b,$c,$d,$e));
    }' unless defined(&EVP_SealUpdate);
    if(defined(&CONST_STRICT)) {
    } else {
	eval 'sub BIO_set_md {
	    my($b,$md) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_SET_MD,0,$md));
	}' unless defined(&BIO_set_md);
    }
    eval 'sub BIO_get_md {
        my($b,$mdp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_MD,0,$mdp));
    }' unless defined(&BIO_get_md);
    eval 'sub BIO_get_md_ctx {
        my($b,$mdcp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_MD_CTX,0,$mdcp));
    }' unless defined(&BIO_get_md_ctx);
    eval 'sub BIO_set_md_ctx {
        my($b,$mdcp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_MD_CTX,0,$mdcp));
    }' unless defined(&BIO_set_md_ctx);
    eval 'sub BIO_get_cipher_status {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_CIPHER_STATUS,0, &NULL));
    }' unless defined(&BIO_get_cipher_status);
    eval 'sub BIO_get_cipher_ctx {
        my($b,$c_pp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_CIPHER_CTX,0,$c_pp));
    }' unless defined(&BIO_get_cipher_ctx);
    eval 'sub EVP_add_cipher_alias {
        my($n,$alias) = @_;
	    eval q( &OBJ_NAME_add(($alias), &OBJ_NAME_TYPE_CIPHER_METH| &OBJ_NAME_ALIAS,($n)));
    }' unless defined(&EVP_add_cipher_alias);
    eval 'sub EVP_add_digest_alias {
        my($n,$alias) = @_;
	    eval q( &OBJ_NAME_add(($alias), &OBJ_NAME_TYPE_MD_METH| &OBJ_NAME_ALIAS,($n)));
    }' unless defined(&EVP_add_digest_alias);
    eval 'sub EVP_delete_cipher_alias {
        my($alias) = @_;
	    eval q( &OBJ_NAME_remove($alias, &OBJ_NAME_TYPE_CIPHER_METH| &OBJ_NAME_ALIAS););
    }' unless defined(&EVP_delete_cipher_alias);
    eval 'sub EVP_delete_digest_alias {
        my($alias) = @_;
	    eval q( &OBJ_NAME_remove($alias, &OBJ_NAME_TYPE_MD_METH| &OBJ_NAME_ALIAS););
    }' unless defined(&EVP_delete_digest_alias);
    unless(defined(&OPENSSL_NO_BIO)) {
    }
    unless(defined(&OPENSSL_NO_MD2)) {
    }
    unless(defined(&OPENSSL_NO_MD4)) {
    }
    unless(defined(&OPENSSL_NO_MD5)) {
    }
    unless(defined(&OPENSSL_NO_SHA)) {
    }
    unless(defined(&OPENSSL_NO_SHA256)) {
    }
    unless(defined(&OPENSSL_NO_SHA512)) {
    }
    unless(defined(&OPENSSL_NO_MDC2)) {
    }
    unless(defined(&OPENSSL_NO_RIPEMD)) {
    }
    unless(defined(&OPENSSL_NO_DES)) {
	eval 'sub EVP_des_cfb () { &EVP_des_cfb64;}' unless defined(&EVP_des_cfb);
	eval 'sub EVP_des_ede_cfb () { &EVP_des_ede_cfb64;}' unless defined(&EVP_des_ede_cfb);
	if(0) {
	}
	eval 'sub EVP_des_ede3_cfb () { &EVP_des_ede3_cfb64;}' unless defined(&EVP_des_ede3_cfb);
	if(0) {
	    if(defined(&OPENSSL_OPENBSD_DEV_CRYPTO)) {
	    }
	}
    }
    unless(defined(&OPENSSL_NO_RC4)) {
    }
    unless(defined(&OPENSSL_NO_IDEA)) {
	eval 'sub EVP_idea_cfb () { &EVP_idea_cfb64;}' unless defined(&EVP_idea_cfb);
    }
    unless(defined(&OPENSSL_NO_RC2)) {
	eval 'sub EVP_rc2_cfb () { &EVP_rc2_cfb64;}' unless defined(&EVP_rc2_cfb);
    }
    unless(defined(&OPENSSL_NO_BF)) {
	eval 'sub EVP_bf_cfb () { &EVP_bf_cfb64;}' unless defined(&EVP_bf_cfb);
    }
    unless(defined(&OPENSSL_NO_CAST)) {
	eval 'sub EVP_cast5_cfb () { &EVP_cast5_cfb64;}' unless defined(&EVP_cast5_cfb);
    }
    unless(defined(&OPENSSL_NO_RC5)) {
	eval 'sub EVP_rc5_32_12_16_cfb () { &EVP_rc5_32_12_16_cfb64;}' unless defined(&EVP_rc5_32_12_16_cfb);
    }
    unless(defined(&OPENSSL_NO_AES)) {
	eval 'sub EVP_aes_128_cfb () { &EVP_aes_128_cfb128;}' unless defined(&EVP_aes_128_cfb);
	if(0) {
	}
	eval 'sub EVP_aes_192_cfb () { &EVP_aes_192_cfb128;}' unless defined(&EVP_aes_192_cfb);
	if(0) {
	}
	eval 'sub EVP_aes_256_cfb () { &EVP_aes_256_cfb128;}' unless defined(&EVP_aes_256_cfb);
	if(0) {
	}
    }
    unless(defined(&OPENSSL_NO_ACSS)) {
    }
    unless(defined(&OPENSSL_NO_CAMELLIA)) {
	eval 'sub EVP_camellia_128_cfb () { &EVP_camellia_128_cfb128;}' unless defined(&EVP_camellia_128_cfb);
	eval 'sub EVP_camellia_192_cfb () { &EVP_camellia_192_cfb128;}' unless defined(&EVP_camellia_192_cfb);
	eval 'sub EVP_camellia_256_cfb () { &EVP_camellia_256_cfb128;}' unless defined(&EVP_camellia_256_cfb);
    }
    unless(defined(&OPENSSL_NO_SEED)) {
	eval 'sub EVP_seed_cfb () { &EVP_seed_cfb128;}' unless defined(&EVP_seed_cfb);
    }
    if(defined(&OPENSSL_LOAD_CONF)) {
	eval 'sub OpenSSL_add_all_algorithms () {
	    eval q( &OPENSSL_add_all_algorithms_conf());
	}' unless defined(&OpenSSL_add_all_algorithms);
    } else {
	eval 'sub OpenSSL_add_all_algorithms () {
	    eval q( &OPENSSL_add_all_algorithms_noconf());
	}' unless defined(&OpenSSL_add_all_algorithms);
    }
    eval 'sub SSLeay_add_all_algorithms () {
        eval q( &OpenSSL_add_all_algorithms());
    }' unless defined(&SSLeay_add_all_algorithms);
    eval 'sub SSLeay_add_all_ciphers () {
        eval q( &OpenSSL_add_all_ciphers());
    }' unless defined(&SSLeay_add_all_ciphers);
    eval 'sub SSLeay_add_all_digests () {
        eval q( &OpenSSL_add_all_digests());
    }' unless defined(&SSLeay_add_all_digests);
    unless(defined(&OPENSSL_NO_RSA)) {
    }
    unless(defined(&OPENSSL_NO_DSA)) {
    }
    unless(defined(&OPENSSL_NO_DH)) {
    }
    unless(defined(&OPENSSL_NO_EC)) {
    }
    if(defined(&OPENSSL_FIPS)) {
	unless(defined(&OPENSSL_NO_ENGINE)) {
	}
    }
    eval 'sub EVP_F_AES_INIT_KEY () {133;}' unless defined(&EVP_F_AES_INIT_KEY);
    eval 'sub EVP_F_ALG_MODULE_INIT () {138;}' unless defined(&EVP_F_ALG_MODULE_INIT);
    eval 'sub EVP_F_CAMELLIA_INIT_KEY () {159;}' unless defined(&EVP_F_CAMELLIA_INIT_KEY);
    eval 'sub EVP_F_D2I_PKEY () {100;}' unless defined(&EVP_F_D2I_PKEY);
    eval 'sub EVP_F_DO_EVP_ENC_ENGINE () {140;}' unless defined(&EVP_F_DO_EVP_ENC_ENGINE);
    eval 'sub EVP_F_DO_EVP_ENC_ENGINE_FULL () {141;}' unless defined(&EVP_F_DO_EVP_ENC_ENGINE_FULL);
    eval 'sub EVP_F_DO_EVP_MD_ENGINE () {139;}' unless defined(&EVP_F_DO_EVP_MD_ENGINE);
    eval 'sub EVP_F_DO_EVP_MD_ENGINE_FULL () {142;}' unless defined(&EVP_F_DO_EVP_MD_ENGINE_FULL);
    eval 'sub EVP_F_DSAPKEY2PKCS8 () {134;}' unless defined(&EVP_F_DSAPKEY2PKCS8);
    eval 'sub EVP_F_DSA_PKEY2PKCS8 () {135;}' unless defined(&EVP_F_DSA_PKEY2PKCS8);
    eval 'sub EVP_F_ECDSA_PKEY2PKCS8 () {129;}' unless defined(&EVP_F_ECDSA_PKEY2PKCS8);
    eval 'sub EVP_F_ECKEY_PKEY2PKCS8 () {132;}' unless defined(&EVP_F_ECKEY_PKEY2PKCS8);
    eval 'sub EVP_F_EVP_CIPHERINIT () {137;}' unless defined(&EVP_F_EVP_CIPHERINIT);
    eval 'sub EVP_F_EVP_CIPHERINIT_EX () {123;}' unless defined(&EVP_F_EVP_CIPHERINIT_EX);
    eval 'sub EVP_F_EVP_CIPHER_CTX_CTRL () {124;}' unless defined(&EVP_F_EVP_CIPHER_CTX_CTRL);
    eval 'sub EVP_F_EVP_CIPHER_CTX_SET_KEY_LENGTH () {122;}' unless defined(&EVP_F_EVP_CIPHER_CTX_SET_KEY_LENGTH);
    eval 'sub EVP_F_EVP_DECRYPTFINAL_EX () {101;}' unless defined(&EVP_F_EVP_DECRYPTFINAL_EX);
    eval 'sub EVP_F_EVP_DIGESTINIT () {136;}' unless defined(&EVP_F_EVP_DIGESTINIT);
    eval 'sub EVP_F_EVP_DIGESTINIT_EX () {128;}' unless defined(&EVP_F_EVP_DIGESTINIT_EX);
    eval 'sub EVP_F_EVP_ENCRYPTFINAL_EX () {127;}' unless defined(&EVP_F_EVP_ENCRYPTFINAL_EX);
    eval 'sub EVP_F_EVP_MD_CTX_COPY_EX () {110;}' unless defined(&EVP_F_EVP_MD_CTX_COPY_EX);
    eval 'sub EVP_F_EVP_OPENINIT () {102;}' unless defined(&EVP_F_EVP_OPENINIT);
    eval 'sub EVP_F_EVP_PBE_ALG_ADD () {115;}' unless defined(&EVP_F_EVP_PBE_ALG_ADD);
    eval 'sub EVP_F_EVP_PBE_CIPHERINIT () {116;}' unless defined(&EVP_F_EVP_PBE_CIPHERINIT);
    eval 'sub EVP_F_EVP_PKCS82PKEY () {111;}' unless defined(&EVP_F_EVP_PKCS82PKEY);
    eval 'sub EVP_F_EVP_PKEY2PKCS8_BROKEN () {113;}' unless defined(&EVP_F_EVP_PKEY2PKCS8_BROKEN);
    eval 'sub EVP_F_EVP_PKEY_COPY_PARAMETERS () {103;}' unless defined(&EVP_F_EVP_PKEY_COPY_PARAMETERS);
    eval 'sub EVP_F_EVP_PKEY_DECRYPT () {104;}' unless defined(&EVP_F_EVP_PKEY_DECRYPT);
    eval 'sub EVP_F_EVP_PKEY_ENCRYPT () {105;}' unless defined(&EVP_F_EVP_PKEY_ENCRYPT);
    eval 'sub EVP_F_EVP_PKEY_GET1_DH () {119;}' unless defined(&EVP_F_EVP_PKEY_GET1_DH);
    eval 'sub EVP_F_EVP_PKEY_GET1_DSA () {120;}' unless defined(&EVP_F_EVP_PKEY_GET1_DSA);
    eval 'sub EVP_F_EVP_PKEY_GET1_ECDSA () {130;}' unless defined(&EVP_F_EVP_PKEY_GET1_ECDSA);
    eval 'sub EVP_F_EVP_PKEY_GET1_EC_KEY () {131;}' unless defined(&EVP_F_EVP_PKEY_GET1_EC_KEY);
    eval 'sub EVP_F_EVP_PKEY_GET1_RSA () {121;}' unless defined(&EVP_F_EVP_PKEY_GET1_RSA);
    eval 'sub EVP_F_EVP_PKEY_NEW () {106;}' unless defined(&EVP_F_EVP_PKEY_NEW);
    eval 'sub EVP_F_EVP_RIJNDAEL () {126;}' unless defined(&EVP_F_EVP_RIJNDAEL);
    eval 'sub EVP_F_EVP_SIGNFINAL () {107;}' unless defined(&EVP_F_EVP_SIGNFINAL);
    eval 'sub EVP_F_EVP_VERIFYFINAL () {108;}' unless defined(&EVP_F_EVP_VERIFYFINAL);
    eval 'sub EVP_F_PKCS5_PBE_KEYIVGEN () {117;}' unless defined(&EVP_F_PKCS5_PBE_KEYIVGEN);
    eval 'sub EVP_F_PKCS5_V2_PBE_KEYIVGEN () {118;}' unless defined(&EVP_F_PKCS5_V2_PBE_KEYIVGEN);
    eval 'sub EVP_F_PKCS8_SET_BROKEN () {112;}' unless defined(&EVP_F_PKCS8_SET_BROKEN);
    eval 'sub EVP_F_RC2_MAGIC_TO_METH () {109;}' unless defined(&EVP_F_RC2_MAGIC_TO_METH);
    eval 'sub EVP_F_RC5_CTRL () {125;}' unless defined(&EVP_F_RC5_CTRL);
    eval 'sub EVP_R_AES_KEY_SETUP_FAILED () {143;}' unless defined(&EVP_R_AES_KEY_SETUP_FAILED);
    eval 'sub EVP_R_ASN1_LIB () {140;}' unless defined(&EVP_R_ASN1_LIB);
    eval 'sub EVP_R_BAD_BLOCK_LENGTH () {136;}' unless defined(&EVP_R_BAD_BLOCK_LENGTH);
    eval 'sub EVP_R_BAD_DECRYPT () {100;}' unless defined(&EVP_R_BAD_DECRYPT);
    eval 'sub EVP_R_BAD_KEY_LENGTH () {137;}' unless defined(&EVP_R_BAD_KEY_LENGTH);
    eval 'sub EVP_R_BN_DECODE_ERROR () {112;}' unless defined(&EVP_R_BN_DECODE_ERROR);
    eval 'sub EVP_R_BN_PUBKEY_ERROR () {113;}' unless defined(&EVP_R_BN_PUBKEY_ERROR);
    eval 'sub EVP_R_CAMELLIA_KEY_SETUP_FAILED () {157;}' unless defined(&EVP_R_CAMELLIA_KEY_SETUP_FAILED);
    eval 'sub EVP_R_CIPHER_PARAMETER_ERROR () {122;}' unless defined(&EVP_R_CIPHER_PARAMETER_ERROR);
    eval 'sub EVP_R_CTRL_NOT_IMPLEMENTED () {132;}' unless defined(&EVP_R_CTRL_NOT_IMPLEMENTED);
    eval 'sub EVP_R_CTRL_OPERATION_NOT_IMPLEMENTED () {133;}' unless defined(&EVP_R_CTRL_OPERATION_NOT_IMPLEMENTED);
    eval 'sub EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH () {138;}' unless defined(&EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH);
    eval 'sub EVP_R_DECODE_ERROR () {114;}' unless defined(&EVP_R_DECODE_ERROR);
    eval 'sub EVP_R_DIFFERENT_KEY_TYPES () {101;}' unless defined(&EVP_R_DIFFERENT_KEY_TYPES);
    eval 'sub EVP_R_DISABLED_FOR_FIPS () {144;}' unless defined(&EVP_R_DISABLED_FOR_FIPS);
    eval 'sub EVP_R_ENCODE_ERROR () {115;}' unless defined(&EVP_R_ENCODE_ERROR);
    eval 'sub EVP_R_ERROR_LOADING_SECTION () {145;}' unless defined(&EVP_R_ERROR_LOADING_SECTION);
    eval 'sub EVP_R_ERROR_SETTING_FIPS_MODE () {146;}' unless defined(&EVP_R_ERROR_SETTING_FIPS_MODE);
    eval 'sub EVP_R_EVP_PBE_CIPHERINIT_ERROR () {119;}' unless defined(&EVP_R_EVP_PBE_CIPHERINIT_ERROR);
    eval 'sub EVP_R_EXPECTING_AN_RSA_KEY () {127;}' unless defined(&EVP_R_EXPECTING_AN_RSA_KEY);
    eval 'sub EVP_R_EXPECTING_A_DH_KEY () {128;}' unless defined(&EVP_R_EXPECTING_A_DH_KEY);
    eval 'sub EVP_R_EXPECTING_A_DSA_KEY () {129;}' unless defined(&EVP_R_EXPECTING_A_DSA_KEY);
    eval 'sub EVP_R_EXPECTING_A_ECDSA_KEY () {141;}' unless defined(&EVP_R_EXPECTING_A_ECDSA_KEY);
    eval 'sub EVP_R_EXPECTING_A_EC_KEY () {142;}' unless defined(&EVP_R_EXPECTING_A_EC_KEY);
    eval 'sub EVP_R_FIPS_MODE_NOT_SUPPORTED () {147;}' unless defined(&EVP_R_FIPS_MODE_NOT_SUPPORTED);
    eval 'sub EVP_R_INITIALIZATION_ERROR () {134;}' unless defined(&EVP_R_INITIALIZATION_ERROR);
    eval 'sub EVP_R_INPUT_NOT_INITIALIZED () {111;}' unless defined(&EVP_R_INPUT_NOT_INITIALIZED);
    eval 'sub EVP_R_INVALID_FIPS_MODE () {148;}' unless defined(&EVP_R_INVALID_FIPS_MODE);
    eval 'sub EVP_R_INVALID_KEY_LENGTH () {130;}' unless defined(&EVP_R_INVALID_KEY_LENGTH);
    eval 'sub EVP_R_IV_TOO_LARGE () {102;}' unless defined(&EVP_R_IV_TOO_LARGE);
    eval 'sub EVP_R_KEYGEN_FAILURE () {120;}' unless defined(&EVP_R_KEYGEN_FAILURE);
    eval 'sub EVP_R_MISSING_PARAMETERS () {103;}' unless defined(&EVP_R_MISSING_PARAMETERS);
    eval 'sub EVP_R_NO_CIPHER_SET () {131;}' unless defined(&EVP_R_NO_CIPHER_SET);
    eval 'sub EVP_R_NO_DIGEST_SET () {139;}' unless defined(&EVP_R_NO_DIGEST_SET);
    eval 'sub EVP_R_NO_DSA_PARAMETERS () {116;}' unless defined(&EVP_R_NO_DSA_PARAMETERS);
    eval 'sub EVP_R_NO_SIGN_FUNCTION_CONFIGURED () {104;}' unless defined(&EVP_R_NO_SIGN_FUNCTION_CONFIGURED);
    eval 'sub EVP_R_NO_VERIFY_FUNCTION_CONFIGURED () {105;}' unless defined(&EVP_R_NO_VERIFY_FUNCTION_CONFIGURED);
    eval 'sub EVP_R_PKCS8_UNKNOWN_BROKEN_TYPE () {117;}' unless defined(&EVP_R_PKCS8_UNKNOWN_BROKEN_TYPE);
    eval 'sub EVP_R_PUBLIC_KEY_NOT_RSA () {106;}' unless defined(&EVP_R_PUBLIC_KEY_NOT_RSA);
    eval 'sub EVP_R_UNKNOWN_OPTION () {149;}' unless defined(&EVP_R_UNKNOWN_OPTION);
    eval 'sub EVP_R_UNKNOWN_PBE_ALGORITHM () {121;}' unless defined(&EVP_R_UNKNOWN_PBE_ALGORITHM);
    eval 'sub EVP_R_UNSUPORTED_NUMBER_OF_ROUNDS () {135;}' unless defined(&EVP_R_UNSUPORTED_NUMBER_OF_ROUNDS);
    eval 'sub EVP_R_UNSUPPORTED_CIPHER () {107;}' unless defined(&EVP_R_UNSUPPORTED_CIPHER);
    eval 'sub EVP_R_UNSUPPORTED_KEYLENGTH () {123;}' unless defined(&EVP_R_UNSUPPORTED_KEYLENGTH);
    eval 'sub EVP_R_UNSUPPORTED_KEY_DERIVATION_FUNCTION () {124;}' unless defined(&EVP_R_UNSUPPORTED_KEY_DERIVATION_FUNCTION);
    eval 'sub EVP_R_UNSUPPORTED_KEY_SIZE () {108;}' unless defined(&EVP_R_UNSUPPORTED_KEY_SIZE);
    eval 'sub EVP_R_UNSUPPORTED_PRF () {125;}' unless defined(&EVP_R_UNSUPPORTED_PRF);
    eval 'sub EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM () {118;}' unless defined(&EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM);
    eval 'sub EVP_R_UNSUPPORTED_SALT_TYPE () {126;}' unless defined(&EVP_R_UNSUPPORTED_SALT_TYPE);
    eval 'sub EVP_R_WRONG_FINAL_BLOCK_LENGTH () {109;}' unless defined(&EVP_R_WRONG_FINAL_BLOCK_LENGTH);
    eval 'sub EVP_R_WRONG_PUBLIC_KEY_TYPE () {110;}' unless defined(&EVP_R_WRONG_PUBLIC_KEY_TYPE);
    eval 'sub EVP_R_SEED_KEY_SETUP_FAILED () {162;}' unless defined(&EVP_R_SEED_KEY_SETUP_FAILED);
    if(defined(&__cplusplus)) {
    }
}
1;
