require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_IXGBE_TYPE_H_)) {
    eval 'sub _IXGBE_TYPE_H_ () {1;}' unless defined(&_IXGBE_TYPE_H_);
    eval 'sub IXGBE_INTEL_VENDOR_ID () {0x8086;}' unless defined(&IXGBE_INTEL_VENDOR_ID);
    eval 'sub IXGBE_DEV_ID_82598AF_DUAL_PORT () {0x10c6;}' unless defined(&IXGBE_DEV_ID_82598AF_DUAL_PORT);
    eval 'sub IXGBE_DEV_ID_82598AF_SINGLE_PORT () {0x10c7;}' unless defined(&IXGBE_DEV_ID_82598AF_SINGLE_PORT);
    eval 'sub IXGBE_DEV_ID_82598AT () {0x10c8;}' unless defined(&IXGBE_DEV_ID_82598AT);
    eval 'sub IXGBE_DEV_ID_82598AT_DUAL_PORT () {0x10d7;}' unless defined(&IXGBE_DEV_ID_82598AT_DUAL_PORT);
    eval 'sub IXGBE_DEV_ID_82598EB_CX4 () {0x10dd;}' unless defined(&IXGBE_DEV_ID_82598EB_CX4);
    eval 'sub IXGBE_DEV_ID_82598_CX4_DUAL_PORT () {0x10ec;}' unless defined(&IXGBE_DEV_ID_82598_CX4_DUAL_PORT);
    eval 'sub IXGBE_DEV_ID_82598_DA_DUAL_PORT () {0x10f1;}' unless defined(&IXGBE_DEV_ID_82598_DA_DUAL_PORT);
    eval 'sub IXGBE_DEV_ID_82598_SR_DUAL_PORT_EM () {0x10e1;}' unless defined(&IXGBE_DEV_ID_82598_SR_DUAL_PORT_EM);
    eval 'sub IXGBE_DEV_ID_82598EB_XF_LR () {0x10f4;}' unless defined(&IXGBE_DEV_ID_82598EB_XF_LR);
    eval 'sub IXGBE_CTRL () {0x;}' unless defined(&IXGBE_CTRL);
    eval 'sub IXGBE_STATUS () {0x8;}' unless defined(&IXGBE_STATUS);
    eval 'sub IXGBE_CTRL_EXT () {0x18;}' unless defined(&IXGBE_CTRL_EXT);
    eval 'sub IXGBE_ESDP () {0x20;}' unless defined(&IXGBE_ESDP);
    eval 'sub IXGBE_EODSDP () {0x28;}' unless defined(&IXGBE_EODSDP);
    eval 'sub IXGBE_LEDCTL () {0x200;}' unless defined(&IXGBE_LEDCTL);
    eval 'sub IXGBE_FRTIMER () {0x48;}' unless defined(&IXGBE_FRTIMER);
    eval 'sub IXGBE_TCPTIMER () {0x4c;}' unless defined(&IXGBE_TCPTIMER);
    eval 'sub IXGBE_EEC () {0x10010;}' unless defined(&IXGBE_EEC);
    eval 'sub IXGBE_EERD () {0x10014;}' unless defined(&IXGBE_EERD);
    eval 'sub IXGBE_FLA () {0x1001c;}' unless defined(&IXGBE_FLA);
    eval 'sub IXGBE_EEMNGCTL () {0x10110;}' unless defined(&IXGBE_EEMNGCTL);
    eval 'sub IXGBE_EEMNGDATA () {0x10114;}' unless defined(&IXGBE_EEMNGDATA);
    eval 'sub IXGBE_FLMNGCTL () {0x10118;}' unless defined(&IXGBE_FLMNGCTL);
    eval 'sub IXGBE_FLMNGDATA () {0x1011c;}' unless defined(&IXGBE_FLMNGDATA);
    eval 'sub IXGBE_FLMNGCNT () {0x10120;}' unless defined(&IXGBE_FLMNGCNT);
    eval 'sub IXGBE_FLOP () {0x1013c;}' unless defined(&IXGBE_FLOP);
    eval 'sub IXGBE_GRC () {0x10200;}' unless defined(&IXGBE_GRC);
    eval 'sub IXGBE_EICR () {0x800;}' unless defined(&IXGBE_EICR);
    eval 'sub IXGBE_EICS () {0x808;}' unless defined(&IXGBE_EICS);
    eval 'sub IXGBE_EIMS () {0x880;}' unless defined(&IXGBE_EIMS);
    eval 'sub IXGBE_EIMC () {0x888;}' unless defined(&IXGBE_EIMC);
    eval 'sub IXGBE_EIAC () {0x810;}' unless defined(&IXGBE_EIAC);
    eval 'sub IXGBE_EIAM () {0x890;}' unless defined(&IXGBE_EIAM);
    eval 'sub IXGBE_EITR {
        my($_i) = @_;
	    eval q(((($_i) <= 23) ? (0x820 + (($_i) * 4)) : (0x12300 + (($_i) * 4))));
    }' unless defined(&IXGBE_EITR);
    eval 'sub IXGBE_IVAR {
        my($_i) = @_;
	    eval q((0x900 + (($_i) * 4)));
    }' unless defined(&IXGBE_IVAR);
    eval 'sub IXGBE_MSIXT () {0x;}' unless defined(&IXGBE_MSIXT);
    eval 'sub IXGBE_MSIXPBA () {0x2000;}' unless defined(&IXGBE_MSIXPBA);
    eval 'sub IXGBE_PBACL {
        my($_i) = @_;
	    eval q(((($_i) == 0) ? (0x11068) : (0x110c0 + (($_i) * 4))));
    }' unless defined(&IXGBE_PBACL);
    eval 'sub IXGBE_GPIE () {0x898;}' unless defined(&IXGBE_GPIE);
    eval 'sub IXGBE_PFCTOP () {0x3008;}' unless defined(&IXGBE_PFCTOP);
    eval 'sub IXGBE_FCTTV {
        my($_i) = @_;
	    eval q((0x3200 + (($_i) * 4)));
    }' unless defined(&IXGBE_FCTTV);
    eval 'sub IXGBE_FCRTL {
        my($_i) = @_;
	    eval q((0x3220 + (($_i) * 8)));
    }' unless defined(&IXGBE_FCRTL);
    eval 'sub IXGBE_FCRTH {
        my($_i) = @_;
	    eval q((0x3260 + (($_i) * 8)));
    }' unless defined(&IXGBE_FCRTH);
    eval 'sub IXGBE_FCRTV () {0x32a0;}' unless defined(&IXGBE_FCRTV);
    eval 'sub IXGBE_TFCS () {0xce00;}' unless defined(&IXGBE_TFCS);
    eval 'sub IXGBE_RDBAL {
        my($_i) = @_;
	    eval q(((($_i) < 64) ? (0x1000 + (($_i) * 0x40)) : (0xd000 + (($_i - 64) * 0x40))));
    }' unless defined(&IXGBE_RDBAL);
    eval 'sub IXGBE_RDBAH {
        my($_i) = @_;
	    eval q(((($_i) < 64) ? (0x1004 + (($_i) * 0x40)) : (0xd004 + (($_i - 64) * 0x40))));
    }' unless defined(&IXGBE_RDBAH);
    eval 'sub IXGBE_RDLEN {
        my($_i) = @_;
	    eval q(((($_i) < 64) ? (0x1008 + (($_i) * 0x40)) : (0xd008 + (($_i - 64) * 0x40))));
    }' unless defined(&IXGBE_RDLEN);
    eval 'sub IXGBE_RDH {
        my($_i) = @_;
	    eval q(((($_i) < 64) ? (0x1010 + (($_i) * 0x40)) : (0xd010 + (($_i - 64) * 0x40))));
    }' unless defined(&IXGBE_RDH);
    eval 'sub IXGBE_RDT {
        my($_i) = @_;
	    eval q(((($_i) < 64) ? (0x1018 + (($_i) * 0x40)) : (0xd018 + (($_i - 64) * 0x40))));
    }' unless defined(&IXGBE_RDT);
    eval 'sub IXGBE_RXDCTL {
        my($_i) = @_;
	    eval q(((($_i) < 64) ? (0x1028 + (($_i) * 0x40)) : (0xd028 + (($_i - 64) * 0x40))));
    }' unless defined(&IXGBE_RXDCTL);
    eval 'sub IXGBE_SRRCTL {
        my($_i) = @_;
	    eval q(((($_i) <= 15) ? (0x2100 + (($_i) * 4)) : ((($_i) < 64) ? (0x1014 + (($_i) * 0x40)) : (0xd014 + (($_i - 64) * 0x40)))));
    }' unless defined(&IXGBE_SRRCTL);
    eval 'sub IXGBE_DCA_RXCTRL {
        my($_i) = @_;
	    eval q(((($_i) <= 15) ? (0x2200 + (($_i) * 4)) : ((($_i) < 64) ? (0x100c + (($_i) * 0x40)) : (0xd00c + (($_i - 64) * 0x40)))));
    }' unless defined(&IXGBE_DCA_RXCTRL);
    eval 'sub IXGBE_RDRXCTL () {0x2f00;}' unless defined(&IXGBE_RDRXCTL);
    eval 'sub IXGBE_RXPBSIZE {
        my($_i) = @_;
	    eval q((0x3c00 + (($_i) * 4)));
    }' unless defined(&IXGBE_RXPBSIZE);
    eval 'sub IXGBE_RXCTRL () {0x3000;}' unless defined(&IXGBE_RXCTRL);
    eval 'sub IXGBE_DROPEN () {0x3d04;}' unless defined(&IXGBE_DROPEN);
    eval 'sub IXGBE_RXPBSIZE_SHIFT () {10;}' unless defined(&IXGBE_RXPBSIZE_SHIFT);
    eval 'sub IXGBE_RXCSUM () {0x5000;}' unless defined(&IXGBE_RXCSUM);
    eval 'sub IXGBE_RFCTL () {0x5008;}' unless defined(&IXGBE_RFCTL);
    eval 'sub IXGBE_MTA {
        my($_i) = @_;
	    eval q((0x5200 + (($_i) * 4)));
    }' unless defined(&IXGBE_MTA);
    eval 'sub IXGBE_RAL {
        my($_i) = @_;
	    eval q(((($_i) <= 15) ? (0x5400 + (($_i) * 8)) : (0xa200 + (($_i) * 8))));
    }' unless defined(&IXGBE_RAL);
    eval 'sub IXGBE_RAH {
        my($_i) = @_;
	    eval q(((($_i) <= 15) ? (0x5404 + (($_i) * 8)) : (0xa204 + (($_i) * 8))));
    }' unless defined(&IXGBE_RAH);
    eval 'sub IXGBE_PSRTYPE {
        my($_i) = @_;
	    eval q(((($_i) <= 15) ? (0x5480 + (($_i) * 4)) : (0xea00 + (($_i) * 4))));
    }' unless defined(&IXGBE_PSRTYPE);
    eval 'sub IXGBE_VFTA {
        my($_i) = @_;
	    eval q((0xa000 + (($_i) * 4)));
    }' unless defined(&IXGBE_VFTA);
    eval 'sub IXGBE_VFTAVIND {
        my($_j, $_i) = @_;
	    eval q((0xa200 + (($_j) * 0x200) + (($_i) * 4)));
    }' unless defined(&IXGBE_VFTAVIND);
    eval 'sub IXGBE_FCTRL () {0x5080;}' unless defined(&IXGBE_FCTRL);
    eval 'sub IXGBE_VLNCTRL () {0x5088;}' unless defined(&IXGBE_VLNCTRL);
    eval 'sub IXGBE_MCSTCTRL () {0x5090;}' unless defined(&IXGBE_MCSTCTRL);
    eval 'sub IXGBE_MRQC () {0x5818;}' unless defined(&IXGBE_MRQC);
    eval 'sub IXGBE_IMIR {
        my($_i) = @_;
	    eval q((0x5a80 + (($_i) * 4)));
    }' unless defined(&IXGBE_IMIR);
    eval 'sub IXGBE_IMIREXT {
        my($_i) = @_;
	    eval q((0x5aa0 + (($_i) * 4)));
    }' unless defined(&IXGBE_IMIREXT);
    eval 'sub IXGBE_IMIRVP () {0x5ac0;}' unless defined(&IXGBE_IMIRVP);
    eval 'sub IXGBE_VMD_CTL () {0x581c;}' unless defined(&IXGBE_VMD_CTL);
    eval 'sub IXGBE_RETA {
        my($_i) = @_;
	    eval q((0x5c00 + (($_i) * 4)));
    }' unless defined(&IXGBE_RETA);
    eval 'sub IXGBE_RSSRK {
        my($_i) = @_;
	    eval q((0x5c80 + (($_i) * 4)));
    }' unless defined(&IXGBE_RSSRK);
    eval 'sub IXGBE_TDBAL {
        my($_i) = @_;
	    eval q((0x6000 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDBAL);
    eval 'sub IXGBE_TDBAH {
        my($_i) = @_;
	    eval q((0x6004 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDBAH);
    eval 'sub IXGBE_TDLEN {
        my($_i) = @_;
	    eval q((0x6008 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDLEN);
    eval 'sub IXGBE_TDH {
        my($_i) = @_;
	    eval q((0x6010 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDH);
    eval 'sub IXGBE_TDT {
        my($_i) = @_;
	    eval q((0x6018 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDT);
    eval 'sub IXGBE_TXDCTL {
        my($_i) = @_;
	    eval q((0x6028 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TXDCTL);
    eval 'sub IXGBE_TDWBAL {
        my($_i) = @_;
	    eval q((0x6038 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDWBAL);
    eval 'sub IXGBE_TDWBAH {
        my($_i) = @_;
	    eval q((0x603c + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDWBAH);
    eval 'sub IXGBE_DTXCTL () {0x7e00;}' unless defined(&IXGBE_DTXCTL);
    eval 'sub IXGBE_DCA_TXCTRL {
        my($_i) = @_;
	    eval q((0x7200 + (($_i) * 4)));
    }' unless defined(&IXGBE_DCA_TXCTRL);
    eval 'sub IXGBE_TIPG () {0xcb00;}' unless defined(&IXGBE_TIPG);
    eval 'sub IXGBE_TXPBSIZE {
        my($_i) = @_;
	    eval q((0xcc00 + (($_i) *0x4)));
    }' unless defined(&IXGBE_TXPBSIZE);
    eval 'sub IXGBE_MNGTXMAP () {0xcd10;}' unless defined(&IXGBE_MNGTXMAP);
    eval 'sub IXGBE_TIPG_FIBER_DEFAULT () {3;}' unless defined(&IXGBE_TIPG_FIBER_DEFAULT);
    eval 'sub IXGBE_TXPBSIZE_SHIFT () {10;}' unless defined(&IXGBE_TXPBSIZE_SHIFT);
    eval 'sub IXGBE_WUC () {0x5800;}' unless defined(&IXGBE_WUC);
    eval 'sub IXGBE_WUFC () {0x5808;}' unless defined(&IXGBE_WUFC);
    eval 'sub IXGBE_WUS () {0x5810;}' unless defined(&IXGBE_WUS);
    eval 'sub IXGBE_IPAV () {0x5838;}' unless defined(&IXGBE_IPAV);
    eval 'sub IXGBE_IP4AT () {0x5840;}' unless defined(&IXGBE_IP4AT);
    eval 'sub IXGBE_IP6AT () {0x5880;}' unless defined(&IXGBE_IP6AT);
    eval 'sub IXGBE_WUPL () {0x5900;}' unless defined(&IXGBE_WUPL);
    eval 'sub IXGBE_WUPM () {0x5a00;}' unless defined(&IXGBE_WUPM);
    eval 'sub IXGBE_FHFT () {0x9000;}' unless defined(&IXGBE_FHFT);
    eval 'sub IXGBE_RMCS () {0x3d00;}' unless defined(&IXGBE_RMCS);
    eval 'sub IXGBE_DPMCS () {0x7f40;}' unless defined(&IXGBE_DPMCS);
    eval 'sub IXGBE_PDPMCS () {0xcd00;}' unless defined(&IXGBE_PDPMCS);
    eval 'sub IXGBE_RUPPBMR () {0x50a0;}' unless defined(&IXGBE_RUPPBMR);
    eval 'sub IXGBE_RT2CR {
        my($_i) = @_;
	    eval q((0x3c20 + (($_i) * 4)));
    }' unless defined(&IXGBE_RT2CR);
    eval 'sub IXGBE_RT2SR {
        my($_i) = @_;
	    eval q((0x3c40 + (($_i) * 4)));
    }' unless defined(&IXGBE_RT2SR);
    eval 'sub IXGBE_TDTQ2TCCR {
        my($_i) = @_;
	    eval q((0x602c + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDTQ2TCCR);
    eval 'sub IXGBE_TDTQ2TCSR {
        my($_i) = @_;
	    eval q((0x622c + (($_i) * 0x40)));
    }' unless defined(&IXGBE_TDTQ2TCSR);
    eval 'sub IXGBE_TDPT2TCCR {
        my($_i) = @_;
	    eval q((0xcd20 + (($_i) * 4)));
    }' unless defined(&IXGBE_TDPT2TCCR);
    eval 'sub IXGBE_TDPT2TCSR {
        my($_i) = @_;
	    eval q((0xcd40 + (($_i) * 4)));
    }' unless defined(&IXGBE_TDPT2TCSR);
    eval 'sub IXGBE_LSECTXCTRL () {0x8a04;}' unless defined(&IXGBE_LSECTXCTRL);
    eval 'sub IXGBE_LSECTXSCL () {0x8a08;}' unless defined(&IXGBE_LSECTXSCL);
    eval 'sub IXGBE_LSECTXSCH () {0x8a0c;}' unless defined(&IXGBE_LSECTXSCH);
    eval 'sub IXGBE_LSECTXSA () {0x8a10;}' unless defined(&IXGBE_LSECTXSA);
    eval 'sub IXGBE_LSECTXPN0 () {0x8a14;}' unless defined(&IXGBE_LSECTXPN0);
    eval 'sub IXGBE_LSECTXPN1 () {0x8a18;}' unless defined(&IXGBE_LSECTXPN1);
    eval 'sub IXGBE_LSECTXKEY0 {
        my($_n) = @_;
	    eval q((0x8a1c + (4* ($_n))));
    }' unless defined(&IXGBE_LSECTXKEY0);
    eval 'sub IXGBE_LSECTXKEY1 {
        my($_n) = @_;
	    eval q((0x8a2c + (4* ($_n))));
    }' unless defined(&IXGBE_LSECTXKEY1);
    eval 'sub IXGBE_LSECRXCTRL () {0x8f04;}' unless defined(&IXGBE_LSECRXCTRL);
    eval 'sub IXGBE_LSECRXSCL () {0x8f08;}' unless defined(&IXGBE_LSECRXSCL);
    eval 'sub IXGBE_LSECRXSCH () {0x8f0c;}' unless defined(&IXGBE_LSECRXSCH);
    eval 'sub IXGBE_LSECRXSA {
        my($_i) = @_;
	    eval q((0x8f10 + (4* ($_i))));
    }' unless defined(&IXGBE_LSECRXSA);
    eval 'sub IXGBE_LSECRXPN {
        my($_i) = @_;
	    eval q((0x8f18 + (4* ($_i))));
    }' unless defined(&IXGBE_LSECRXPN);
    eval 'sub IXGBE_LSECRXKEY {
        my($_n, $_m) = @_;
	    eval q((0x8f20 + ((0x10 * ($_n)) + (4* ($_m)))));
    }' unless defined(&IXGBE_LSECRXKEY);
    eval 'sub IXGBE_IPSTXIDX () {0x8900;}' unless defined(&IXGBE_IPSTXIDX);
    eval 'sub IXGBE_IPSTXSALT () {0x8904;}' unless defined(&IXGBE_IPSTXSALT);
    eval 'sub IXGBE_IPSTXKEY {
        my($_i) = @_;
	    eval q((0x8908 + (4* ($_i))));
    }' unless defined(&IXGBE_IPSTXKEY);
    eval 'sub IXGBE_IPSRXIDX () {0x8e00;}' unless defined(&IXGBE_IPSRXIDX);
    eval 'sub IXGBE_IPSRXIPADDR {
        my($_i) = @_;
	    eval q((0x8e04 + (4* ($_i))));
    }' unless defined(&IXGBE_IPSRXIPADDR);
    eval 'sub IXGBE_IPSRXSPI () {0x8e14;}' unless defined(&IXGBE_IPSRXSPI);
    eval 'sub IXGBE_IPSRXIPIDX () {0x8e18;}' unless defined(&IXGBE_IPSRXIPIDX);
    eval 'sub IXGBE_IPSRXKEY {
        my($_i) = @_;
	    eval q((0x8e1c + (4* ($_i))));
    }' unless defined(&IXGBE_IPSRXKEY);
    eval 'sub IXGBE_IPSRXSALT () {0x8e2c;}' unless defined(&IXGBE_IPSRXSALT);
    eval 'sub IXGBE_IPSRXMOD () {0x8e30;}' unless defined(&IXGBE_IPSRXMOD);
    eval 'sub IXGBE_CRCERRS () {0x4000;}' unless defined(&IXGBE_CRCERRS);
    eval 'sub IXGBE_ILLERRC () {0x4004;}' unless defined(&IXGBE_ILLERRC);
    eval 'sub IXGBE_ERRBC () {0x4008;}' unless defined(&IXGBE_ERRBC);
    eval 'sub IXGBE_MSPDC () {0x4010;}' unless defined(&IXGBE_MSPDC);
    eval 'sub IXGBE_MPC {
        my($_i) = @_;
	    eval q((0x3fa0 + (($_i) * 4)));
    }' unless defined(&IXGBE_MPC);
    eval 'sub IXGBE_MLFC () {0x4034;}' unless defined(&IXGBE_MLFC);
    eval 'sub IXGBE_MRFC () {0x4038;}' unless defined(&IXGBE_MRFC);
    eval 'sub IXGBE_RLEC () {0x4040;}' unless defined(&IXGBE_RLEC);
    eval 'sub IXGBE_LXONTXC () {0x3f60;}' unless defined(&IXGBE_LXONTXC);
    eval 'sub IXGBE_LXONRXC () {0xcf60;}' unless defined(&IXGBE_LXONRXC);
    eval 'sub IXGBE_LXOFFTXC () {0x3f68;}' unless defined(&IXGBE_LXOFFTXC);
    eval 'sub IXGBE_LXOFFRXC () {0xcf68;}' unless defined(&IXGBE_LXOFFRXC);
    eval 'sub IXGBE_PXONTXC {
        my($_i) = @_;
	    eval q((0x3f00 + (($_i) * 4)));
    }' unless defined(&IXGBE_PXONTXC);
    eval 'sub IXGBE_PXONRXC {
        my($_i) = @_;
	    eval q((0xcf00 + (($_i) * 4)));
    }' unless defined(&IXGBE_PXONRXC);
    eval 'sub IXGBE_PXOFFTXC {
        my($_i) = @_;
	    eval q((0x3f20 + (($_i) * 4)));
    }' unless defined(&IXGBE_PXOFFTXC);
    eval 'sub IXGBE_PXOFFRXC {
        my($_i) = @_;
	    eval q((0xcf20 + (($_i) * 4)));
    }' unless defined(&IXGBE_PXOFFRXC);
    eval 'sub IXGBE_PRC64 () {0x405c;}' unless defined(&IXGBE_PRC64);
    eval 'sub IXGBE_PRC127 () {0x4060;}' unless defined(&IXGBE_PRC127);
    eval 'sub IXGBE_PRC255 () {0x4064;}' unless defined(&IXGBE_PRC255);
    eval 'sub IXGBE_PRC511 () {0x4068;}' unless defined(&IXGBE_PRC511);
    eval 'sub IXGBE_PRC1023 () {0x406c;}' unless defined(&IXGBE_PRC1023);
    eval 'sub IXGBE_PRC1522 () {0x4070;}' unless defined(&IXGBE_PRC1522);
    eval 'sub IXGBE_GPRC () {0x4074;}' unless defined(&IXGBE_GPRC);
    eval 'sub IXGBE_BPRC () {0x4078;}' unless defined(&IXGBE_BPRC);
    eval 'sub IXGBE_MPRC () {0x407c;}' unless defined(&IXGBE_MPRC);
    eval 'sub IXGBE_GPTC () {0x4080;}' unless defined(&IXGBE_GPTC);
    eval 'sub IXGBE_GORCL () {0x4088;}' unless defined(&IXGBE_GORCL);
    eval 'sub IXGBE_GORCH () {0x408c;}' unless defined(&IXGBE_GORCH);
    eval 'sub IXGBE_GOTCL () {0x4090;}' unless defined(&IXGBE_GOTCL);
    eval 'sub IXGBE_GOTCH () {0x4094;}' unless defined(&IXGBE_GOTCH);
    eval 'sub IXGBE_RNBC {
        my($_i) = @_;
	    eval q((0x3fc0 + (($_i) * 4)));
    }' unless defined(&IXGBE_RNBC);
    eval 'sub IXGBE_RUC () {0x40a4;}' unless defined(&IXGBE_RUC);
    eval 'sub IXGBE_RFC () {0x40a8;}' unless defined(&IXGBE_RFC);
    eval 'sub IXGBE_ROC () {0x40ac;}' unless defined(&IXGBE_ROC);
    eval 'sub IXGBE_RJC () {0x40b0;}' unless defined(&IXGBE_RJC);
    eval 'sub IXGBE_MNGPRC () {0x40b4;}' unless defined(&IXGBE_MNGPRC);
    eval 'sub IXGBE_MNGPDC () {0x40b8;}' unless defined(&IXGBE_MNGPDC);
    eval 'sub IXGBE_MNGPTC () {0xcf90;}' unless defined(&IXGBE_MNGPTC);
    eval 'sub IXGBE_TORL () {0x40c0;}' unless defined(&IXGBE_TORL);
    eval 'sub IXGBE_TORH () {0x40c4;}' unless defined(&IXGBE_TORH);
    eval 'sub IXGBE_TPR () {0x40d0;}' unless defined(&IXGBE_TPR);
    eval 'sub IXGBE_TPT () {0x40d4;}' unless defined(&IXGBE_TPT);
    eval 'sub IXGBE_PTC64 () {0x40d8;}' unless defined(&IXGBE_PTC64);
    eval 'sub IXGBE_PTC127 () {0x40dc;}' unless defined(&IXGBE_PTC127);
    eval 'sub IXGBE_PTC255 () {0x40e0;}' unless defined(&IXGBE_PTC255);
    eval 'sub IXGBE_PTC511 () {0x40e4;}' unless defined(&IXGBE_PTC511);
    eval 'sub IXGBE_PTC1023 () {0x40e8;}' unless defined(&IXGBE_PTC1023);
    eval 'sub IXGBE_PTC1522 () {0x40ec;}' unless defined(&IXGBE_PTC1522);
    eval 'sub IXGBE_MPTC () {0x40f0;}' unless defined(&IXGBE_MPTC);
    eval 'sub IXGBE_BPTC () {0x40f4;}' unless defined(&IXGBE_BPTC);
    eval 'sub IXGBE_XEC () {0x4120;}' unless defined(&IXGBE_XEC);
    eval 'sub IXGBE_RQSMR {
        my($_i) = @_;
	    eval q((0x2300 + (($_i) * 4)));
    }' unless defined(&IXGBE_RQSMR);
    eval 'sub IXGBE_TQSMR {
        my($_i) = @_;
	    eval q(((($_i) <= 7) ? (0x7300 + (($_i) * 4)) : (0x8600 + (($_i) * 4))));
    }' unless defined(&IXGBE_TQSMR);
    eval 'sub IXGBE_QPRC {
        my($_i) = @_;
	    eval q((0x1030 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_QPRC);
    eval 'sub IXGBE_QPTC {
        my($_i) = @_;
	    eval q((0x6030 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_QPTC);
    eval 'sub IXGBE_QBRC {
        my($_i) = @_;
	    eval q((0x1034 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_QBRC);
    eval 'sub IXGBE_QBTC {
        my($_i) = @_;
	    eval q((0x6034 + (($_i) * 0x40)));
    }' unless defined(&IXGBE_QBTC);
    eval 'sub IXGBE_MAVTV {
        my($_i) = @_;
	    eval q((0x5010 + (($_i) * 4)));
    }' unless defined(&IXGBE_MAVTV);
    eval 'sub IXGBE_MFUTP {
        my($_i) = @_;
	    eval q((0x5030 + (($_i) * 4)));
    }' unless defined(&IXGBE_MFUTP);
    eval 'sub IXGBE_MANC () {0x5820;}' unless defined(&IXGBE_MANC);
    eval 'sub IXGBE_MFVAL () {0x5824;}' unless defined(&IXGBE_MFVAL);
    eval 'sub IXGBE_MANC2H () {0x5860;}' unless defined(&IXGBE_MANC2H);
    eval 'sub IXGBE_MDEF {
        my($_i) = @_;
	    eval q((0x5890 + (($_i) * 4)));
    }' unless defined(&IXGBE_MDEF);
    eval 'sub IXGBE_MIPAF () {0x58b0;}' unless defined(&IXGBE_MIPAF);
    eval 'sub IXGBE_MMAL {
        my($_i) = @_;
	    eval q((0x5910 + (($_i) * 8)));
    }' unless defined(&IXGBE_MMAL);
    eval 'sub IXGBE_MMAH {
        my($_i) = @_;
	    eval q((0x5914 + (($_i) * 8)));
    }' unless defined(&IXGBE_MMAH);
    eval 'sub IXGBE_FTFT () {0x9400;}' unless defined(&IXGBE_FTFT);
    eval 'sub IXGBE_HICR () {0x15f00;}' unless defined(&IXGBE_HICR);
    eval 'sub IXGBE_FWSTS () {0x15f0c;}' unless defined(&IXGBE_FWSTS);
    eval 'sub IXGBE_HSMC0R () {0x15f04;}' unless defined(&IXGBE_HSMC0R);
    eval 'sub IXGBE_HSMC1R () {0x15f08;}' unless defined(&IXGBE_HSMC1R);
    eval 'sub IXGBE_SWSR () {0x15f10;}' unless defined(&IXGBE_SWSR);
    eval 'sub IXGBE_HFDR () {0x15fe8;}' unless defined(&IXGBE_HFDR);
    eval 'sub IXGBE_FLEX_MNG () {0x15800;}' unless defined(&IXGBE_FLEX_MNG);
    eval 'sub IXGBE_GCR () {0x11000;}' unless defined(&IXGBE_GCR);
    eval 'sub IXGBE_GTV () {0x11004;}' unless defined(&IXGBE_GTV);
    eval 'sub IXGBE_FUNCTAG () {0x11008;}' unless defined(&IXGBE_FUNCTAG);
    eval 'sub IXGBE_GLT () {0x1100c;}' unless defined(&IXGBE_GLT);
    eval 'sub IXGBE_GSCL_1 () {0x11010;}' unless defined(&IXGBE_GSCL_1);
    eval 'sub IXGBE_GSCL_2 () {0x11014;}' unless defined(&IXGBE_GSCL_2);
    eval 'sub IXGBE_GSCL_3 () {0x11018;}' unless defined(&IXGBE_GSCL_3);
    eval 'sub IXGBE_GSCL_4 () {0x1101c;}' unless defined(&IXGBE_GSCL_4);
    eval 'sub IXGBE_GSCN_0 () {0x11020;}' unless defined(&IXGBE_GSCN_0);
    eval 'sub IXGBE_GSCN_1 () {0x11024;}' unless defined(&IXGBE_GSCN_1);
    eval 'sub IXGBE_GSCN_2 () {0x11028;}' unless defined(&IXGBE_GSCN_2);
    eval 'sub IXGBE_GSCN_3 () {0x1102c;}' unless defined(&IXGBE_GSCN_3);
    eval 'sub IXGBE_FACTPS () {0x10150;}' unless defined(&IXGBE_FACTPS);
    eval 'sub IXGBE_PCIEANACTL () {0x11040;}' unless defined(&IXGBE_PCIEANACTL);
    eval 'sub IXGBE_SWSM () {0x10140;}' unless defined(&IXGBE_SWSM);
    eval 'sub IXGBE_FWSM () {0x10148;}' unless defined(&IXGBE_FWSM);
    eval 'sub IXGBE_GSSR () {0x10160;}' unless defined(&IXGBE_GSSR);
    eval 'sub IXGBE_MREVID () {0x11064;}' unless defined(&IXGBE_MREVID);
    eval 'sub IXGBE_DCA_ID () {0x11070;}' unless defined(&IXGBE_DCA_ID);
    eval 'sub IXGBE_DCA_CTRL () {0x11074;}' unless defined(&IXGBE_DCA_CTRL);
    eval 'sub IXGBE_RDSTATCTL () {0x2c20;}' unless defined(&IXGBE_RDSTATCTL);
    eval 'sub IXGBE_RDSTAT {
        my($_i) = @_;
	    eval q((0x2c00 + (($_i) * 4)));
    }' unless defined(&IXGBE_RDSTAT);
    eval 'sub IXGBE_RDHMPN () {0x2f08;}' unless defined(&IXGBE_RDHMPN);
    eval 'sub IXGBE_RIC_DW {
        my($_i) = @_;
	    eval q((0x2f10 + (($_i) * 4)));
    }' unless defined(&IXGBE_RIC_DW);
    eval 'sub IXGBE_RDPROBE () {0x2f20;}' unless defined(&IXGBE_RDPROBE);
    eval 'sub IXGBE_TDSTATCTL () {0x7c20;}' unless defined(&IXGBE_TDSTATCTL);
    eval 'sub IXGBE_TDSTAT {
        my($_i) = @_;
	    eval q((0x7c00 + (($_i) * 4)));
    }' unless defined(&IXGBE_TDSTAT);
    eval 'sub IXGBE_TDHMPN () {0x7f08;}' unless defined(&IXGBE_TDHMPN);
    eval 'sub IXGBE_TIC_DW {
        my($_i) = @_;
	    eval q((0x7f10 + (($_i) * 4)));
    }' unless defined(&IXGBE_TIC_DW);
    eval 'sub IXGBE_TDPROBE () {0x7f20;}' unless defined(&IXGBE_TDPROBE);
    eval 'sub IXGBE_TXBUFCTRL () {0xc600;}' unless defined(&IXGBE_TXBUFCTRL);
    eval 'sub IXGBE_TXBUFDATA0 () {0xc610;}' unless defined(&IXGBE_TXBUFDATA0);
    eval 'sub IXGBE_TXBUFDATA1 () {0xc614;}' unless defined(&IXGBE_TXBUFDATA1);
    eval 'sub IXGBE_TXBUFDATA2 () {0xc618;}' unless defined(&IXGBE_TXBUFDATA2);
    eval 'sub IXGBE_TXBUFDATA3 () {0xc61c;}' unless defined(&IXGBE_TXBUFDATA3);
    eval 'sub IXGBE_RXBUFCTRL () {0x3600;}' unless defined(&IXGBE_RXBUFCTRL);
    eval 'sub IXGBE_RXBUFDATA0 () {0x3610;}' unless defined(&IXGBE_RXBUFDATA0);
    eval 'sub IXGBE_RXBUFDATA1 () {0x3614;}' unless defined(&IXGBE_RXBUFDATA1);
    eval 'sub IXGBE_RXBUFDATA2 () {0x3618;}' unless defined(&IXGBE_RXBUFDATA2);
    eval 'sub IXGBE_RXBUFDATA3 () {0x361c;}' unless defined(&IXGBE_RXBUFDATA3);
    eval 'sub IXGBE_PCIE_DIAG {
        my($_i) = @_;
	    eval q((0x11090 + (($_i) * 4)));
    }' unless defined(&IXGBE_PCIE_DIAG);
    eval 'sub IXGBE_RFVAL () {0x50a4;}' unless defined(&IXGBE_RFVAL);
    eval 'sub IXGBE_MDFTC1 () {0x42b8;}' unless defined(&IXGBE_MDFTC1);
    eval 'sub IXGBE_MDFTC2 () {0x42c0;}' unless defined(&IXGBE_MDFTC2);
    eval 'sub IXGBE_MDFTFIFO1 () {0x42c4;}' unless defined(&IXGBE_MDFTFIFO1);
    eval 'sub IXGBE_MDFTFIFO2 () {0x42c8;}' unless defined(&IXGBE_MDFTFIFO2);
    eval 'sub IXGBE_MDFTS () {0x42cc;}' unless defined(&IXGBE_MDFTS);
    eval 'sub IXGBE_RXDATAWRPTR {
        my($_i) = @_;
	    eval q((0x3700 + (($_i) * 4)));
    }' unless defined(&IXGBE_RXDATAWRPTR);
    eval 'sub IXGBE_RXDESCWRPTR {
        my($_i) = @_;
	    eval q((0x3710 + (($_i) * 4)));
    }' unless defined(&IXGBE_RXDESCWRPTR);
    eval 'sub IXGBE_RXDATARDPTR {
        my($_i) = @_;
	    eval q((0x3720 + (($_i) * 4)));
    }' unless defined(&IXGBE_RXDATARDPTR);
    eval 'sub IXGBE_RXDESCRDPTR {
        my($_i) = @_;
	    eval q((0x3730 + (($_i) * 4)));
    }' unless defined(&IXGBE_RXDESCRDPTR);
    eval 'sub IXGBE_TXDATAWRPTR {
        my($_i) = @_;
	    eval q((0xc700 + (($_i) * 4)));
    }' unless defined(&IXGBE_TXDATAWRPTR);
    eval 'sub IXGBE_TXDESCWRPTR {
        my($_i) = @_;
	    eval q((0xc710 + (($_i) * 4)));
    }' unless defined(&IXGBE_TXDESCWRPTR);
    eval 'sub IXGBE_TXDATARDPTR {
        my($_i) = @_;
	    eval q((0xc720 + (($_i) * 4)));
    }' unless defined(&IXGBE_TXDATARDPTR);
    eval 'sub IXGBE_TXDESCRDPTR {
        my($_i) = @_;
	    eval q((0xc730 + (($_i) * 4)));
    }' unless defined(&IXGBE_TXDESCRDPTR);
    eval 'sub IXGBE_PCIEECCCTL () {0x1106c;}' unless defined(&IXGBE_PCIEECCCTL);
    eval 'sub IXGBE_PBTXECC () {0xc300;}' unless defined(&IXGBE_PBTXECC);
    eval 'sub IXGBE_PBRXECC () {0x3300;}' unless defined(&IXGBE_PBRXECC);
    eval 'sub IXGBE_GHECCR () {0x110b0;}' unless defined(&IXGBE_GHECCR);
    eval 'sub IXGBE_PCS1GCFIG () {0x4200;}' unless defined(&IXGBE_PCS1GCFIG);
    eval 'sub IXGBE_PCS1GLCTL () {0x4208;}' unless defined(&IXGBE_PCS1GLCTL);
    eval 'sub IXGBE_PCS1GLSTA () {0x420c;}' unless defined(&IXGBE_PCS1GLSTA);
    eval 'sub IXGBE_PCS1GDBG0 () {0x4210;}' unless defined(&IXGBE_PCS1GDBG0);
    eval 'sub IXGBE_PCS1GDBG1 () {0x4214;}' unless defined(&IXGBE_PCS1GDBG1);
    eval 'sub IXGBE_PCS1GANA () {0x4218;}' unless defined(&IXGBE_PCS1GANA);
    eval 'sub IXGBE_PCS1GANLP () {0x421c;}' unless defined(&IXGBE_PCS1GANLP);
    eval 'sub IXGBE_PCS1GANNP () {0x4220;}' unless defined(&IXGBE_PCS1GANNP);
    eval 'sub IXGBE_PCS1GANLPNP () {0x4224;}' unless defined(&IXGBE_PCS1GANLPNP);
    eval 'sub IXGBE_HLREG0 () {0x4240;}' unless defined(&IXGBE_HLREG0);
    eval 'sub IXGBE_HLREG1 () {0x4244;}' unless defined(&IXGBE_HLREG1);
    eval 'sub IXGBE_PAP () {0x4248;}' unless defined(&IXGBE_PAP);
    eval 'sub IXGBE_MACA () {0x424c;}' unless defined(&IXGBE_MACA);
    eval 'sub IXGBE_APAE () {0x4250;}' unless defined(&IXGBE_APAE);
    eval 'sub IXGBE_ARD () {0x4254;}' unless defined(&IXGBE_ARD);
    eval 'sub IXGBE_AIS () {0x4258;}' unless defined(&IXGBE_AIS);
    eval 'sub IXGBE_MSCA () {0x425c;}' unless defined(&IXGBE_MSCA);
    eval 'sub IXGBE_MSRWD () {0x4260;}' unless defined(&IXGBE_MSRWD);
    eval 'sub IXGBE_MLADD () {0x4264;}' unless defined(&IXGBE_MLADD);
    eval 'sub IXGBE_MHADD () {0x4268;}' unless defined(&IXGBE_MHADD);
    eval 'sub IXGBE_TREG () {0x426c;}' unless defined(&IXGBE_TREG);
    eval 'sub IXGBE_PCSS1 () {0x4288;}' unless defined(&IXGBE_PCSS1);
    eval 'sub IXGBE_PCSS2 () {0x428c;}' unless defined(&IXGBE_PCSS2);
    eval 'sub IXGBE_XPCSS () {0x4290;}' unless defined(&IXGBE_XPCSS);
    eval 'sub IXGBE_SERDESC () {0x4298;}' unless defined(&IXGBE_SERDESC);
    eval 'sub IXGBE_MACS () {0x429c;}' unless defined(&IXGBE_MACS);
    eval 'sub IXGBE_AUTOC () {0x42a0;}' unless defined(&IXGBE_AUTOC);
    eval 'sub IXGBE_LINKS () {0x42a4;}' unless defined(&IXGBE_LINKS);
    eval 'sub IXGBE_AUTOC2 () {0x42a8;}' unless defined(&IXGBE_AUTOC2);
    eval 'sub IXGBE_AUTOC3 () {0x42ac;}' unless defined(&IXGBE_AUTOC3);
    eval 'sub IXGBE_ANLP1 () {0x42b0;}' unless defined(&IXGBE_ANLP1);
    eval 'sub IXGBE_ANLP2 () {0x42b4;}' unless defined(&IXGBE_ANLP2);
    eval 'sub IXGBE_ATLASCTL () {0x4800;}' unless defined(&IXGBE_ATLASCTL);
    eval 'sub IXGBE_CTRL_GIO_DIS () {0x4;}' unless defined(&IXGBE_CTRL_GIO_DIS);
    eval 'sub IXGBE_CTRL_LNK_RST () {0x8;}' unless defined(&IXGBE_CTRL_LNK_RST);
    eval 'sub IXGBE_CTRL_RST () {0x4000000;}' unless defined(&IXGBE_CTRL_RST);
    eval 'sub IXGBE_FACTPS_LFS () {0x40000000;}' unless defined(&IXGBE_FACTPS_LFS);
    eval 'sub IXGBE_MHADD_MFS_MASK () {0xffff0000;}' unless defined(&IXGBE_MHADD_MFS_MASK);
    eval 'sub IXGBE_MHADD_MFS_SHIFT () {16;}' unless defined(&IXGBE_MHADD_MFS_SHIFT);
    eval 'sub IXGBE_CTRL_EXT_NS_DIS () {0x10000;}' unless defined(&IXGBE_CTRL_EXT_NS_DIS);
    eval 'sub IXGBE_CTRL_EXT_RO_DIS () {0x20000;}' unless defined(&IXGBE_CTRL_EXT_RO_DIS);
    eval 'sub IXGBE_CTRL_EXT_DRV_LOAD () {0x10000000;}' unless defined(&IXGBE_CTRL_EXT_DRV_LOAD);
    eval 'sub IXGBE_DCA_CTRL_DCA_ENABLE () {0x;}' unless defined(&IXGBE_DCA_CTRL_DCA_ENABLE);
    eval 'sub IXGBE_DCA_CTRL_DCA_DISABLE () {0x1;}' unless defined(&IXGBE_DCA_CTRL_DCA_DISABLE);
    eval 'sub IXGBE_DCA_CTRL_DCA_MODE_CB1 () {0x;}' unless defined(&IXGBE_DCA_CTRL_DCA_MODE_CB1);
    eval 'sub IXGBE_DCA_CTRL_DCA_MODE_CB2 () {0x2;}' unless defined(&IXGBE_DCA_CTRL_DCA_MODE_CB2);
    eval 'sub IXGBE_DCA_RXCTRL_CPUID_MASK () {0x1f;}' unless defined(&IXGBE_DCA_RXCTRL_CPUID_MASK);
    eval 'sub IXGBE_DCA_RXCTRL_DESC_DCA_EN () {(1<< 5);}' unless defined(&IXGBE_DCA_RXCTRL_DESC_DCA_EN);
    eval 'sub IXGBE_DCA_RXCTRL_HEAD_DCA_EN () {(1<< 6);}' unless defined(&IXGBE_DCA_RXCTRL_HEAD_DCA_EN);
    eval 'sub IXGBE_DCA_RXCTRL_DATA_DCA_EN () {(1<< 7);}' unless defined(&IXGBE_DCA_RXCTRL_DATA_DCA_EN);
    eval 'sub IXGBE_DCA_TXCTRL_CPUID_MASK () {0x1f;}' unless defined(&IXGBE_DCA_TXCTRL_CPUID_MASK);
    eval 'sub IXGBE_DCA_TXCTRL_DESC_DCA_EN () {(1<< 5);}' unless defined(&IXGBE_DCA_TXCTRL_DESC_DCA_EN);
    eval 'sub IXGBE_DCA_TXCTRL_TX_WB_RO_EN () {(1<< 11);}' unless defined(&IXGBE_DCA_TXCTRL_TX_WB_RO_EN);
    eval 'sub IXGBE_DCA_MAX_QUEUES_82598 () {16;}' unless defined(&IXGBE_DCA_MAX_QUEUES_82598);
    eval 'sub IXGBE_MSCA_NP_ADDR_MASK () {0xffff;}' unless defined(&IXGBE_MSCA_NP_ADDR_MASK);
    eval 'sub IXGBE_MSCA_NP_ADDR_SHIFT () {0;}' unless defined(&IXGBE_MSCA_NP_ADDR_SHIFT);
    eval 'sub IXGBE_MSCA_DEV_TYPE_MASK () {0x1f0000;}' unless defined(&IXGBE_MSCA_DEV_TYPE_MASK);
    eval 'sub IXGBE_MSCA_DEV_TYPE_SHIFT () {16;}' unless defined(&IXGBE_MSCA_DEV_TYPE_SHIFT);
    eval 'sub IXGBE_MSCA_PHY_ADDR_MASK () {0x3e00000;}' unless defined(&IXGBE_MSCA_PHY_ADDR_MASK);
    eval 'sub IXGBE_MSCA_PHY_ADDR_SHIFT () {21;}' unless defined(&IXGBE_MSCA_PHY_ADDR_SHIFT);
    eval 'sub IXGBE_MSCA_OP_CODE_MASK () {0xc000000;}' unless defined(&IXGBE_MSCA_OP_CODE_MASK);
    eval 'sub IXGBE_MSCA_OP_CODE_SHIFT () {26;}' unless defined(&IXGBE_MSCA_OP_CODE_SHIFT);
    eval 'sub IXGBE_MSCA_ADDR_CYCLE () {0x;}' unless defined(&IXGBE_MSCA_ADDR_CYCLE);
    eval 'sub IXGBE_MSCA_WRITE () {0x4000000;}' unless defined(&IXGBE_MSCA_WRITE);
    eval 'sub IXGBE_MSCA_READ () {0x8000000;}' unless defined(&IXGBE_MSCA_READ);
    eval 'sub IXGBE_MSCA_READ_AUTOINC () {0xc000000;}' unless defined(&IXGBE_MSCA_READ_AUTOINC);
    eval 'sub IXGBE_MSCA_ST_CODE_MASK () {0x30000000;}' unless defined(&IXGBE_MSCA_ST_CODE_MASK);
    eval 'sub IXGBE_MSCA_ST_CODE_SHIFT () {28;}' unless defined(&IXGBE_MSCA_ST_CODE_SHIFT);
    eval 'sub IXGBE_MSCA_NEW_PROTOCOL () {0x;}' unless defined(&IXGBE_MSCA_NEW_PROTOCOL);
    eval 'sub IXGBE_MSCA_OLD_PROTOCOL () {0x10000000;}' unless defined(&IXGBE_MSCA_OLD_PROTOCOL);
    eval 'sub IXGBE_MSCA_MDI_COMMAND () {0x40000000;}' unless defined(&IXGBE_MSCA_MDI_COMMAND);
    eval 'sub IXGBE_MSCA_MDI_IN_PROG_EN () {0x80000000;}' unless defined(&IXGBE_MSCA_MDI_IN_PROG_EN);
    eval 'sub IXGBE_MSRWD_WRITE_DATA_MASK () {0xffff;}' unless defined(&IXGBE_MSRWD_WRITE_DATA_MASK);
    eval 'sub IXGBE_MSRWD_WRITE_DATA_SHIFT () {0;}' unless defined(&IXGBE_MSRWD_WRITE_DATA_SHIFT);
    eval 'sub IXGBE_MSRWD_READ_DATA_MASK () {0xffff0000;}' unless defined(&IXGBE_MSRWD_READ_DATA_MASK);
    eval 'sub IXGBE_MSRWD_READ_DATA_SHIFT () {16;}' unless defined(&IXGBE_MSRWD_READ_DATA_SHIFT);
    eval 'sub IXGBE_ATLAS_PDN_LPBK () {0x24;}' unless defined(&IXGBE_ATLAS_PDN_LPBK);
    eval 'sub IXGBE_ATLAS_PDN_10G () {0xb;}' unless defined(&IXGBE_ATLAS_PDN_10G);
    eval 'sub IXGBE_ATLAS_PDN_1G () {0xc;}' unless defined(&IXGBE_ATLAS_PDN_1G);
    eval 'sub IXGBE_ATLAS_PDN_AN () {0xd;}' unless defined(&IXGBE_ATLAS_PDN_AN);
    eval 'sub IXGBE_ATLASCTL_WRITE_CMD () {0x10000;}' unless defined(&IXGBE_ATLASCTL_WRITE_CMD);
    eval 'sub IXGBE_ATLAS_PDN_TX_REG_EN () {0x10;}' unless defined(&IXGBE_ATLAS_PDN_TX_REG_EN);
    eval 'sub IXGBE_ATLAS_PDN_TX_10G_QL_ALL () {0xf0;}' unless defined(&IXGBE_ATLAS_PDN_TX_10G_QL_ALL);
    eval 'sub IXGBE_ATLAS_PDN_TX_1G_QL_ALL () {0xf0;}' unless defined(&IXGBE_ATLAS_PDN_TX_1G_QL_ALL);
    eval 'sub IXGBE_ATLAS_PDN_TX_AN_QL_ALL () {0xf0;}' unless defined(&IXGBE_ATLAS_PDN_TX_AN_QL_ALL);
    eval 'sub IXGBE_MDIO_PMA_PMD_DEV_TYPE () {0x1;}' unless defined(&IXGBE_MDIO_PMA_PMD_DEV_TYPE);
    eval 'sub IXGBE_MDIO_PCS_DEV_TYPE () {0x3;}' unless defined(&IXGBE_MDIO_PCS_DEV_TYPE);
    eval 'sub IXGBE_MDIO_PHY_XS_DEV_TYPE () {0x4;}' unless defined(&IXGBE_MDIO_PHY_XS_DEV_TYPE);
    eval 'sub IXGBE_MDIO_AUTO_NEG_DEV_TYPE () {0x7;}' unless defined(&IXGBE_MDIO_AUTO_NEG_DEV_TYPE);
    eval 'sub IXGBE_MDIO_VENDOR_SPECIFIC_1_DEV_TYPE () {0x1e;}' unless defined(&IXGBE_MDIO_VENDOR_SPECIFIC_1_DEV_TYPE);
    eval 'sub IXGBE_TWINAX_DEV () {1;}' unless defined(&IXGBE_TWINAX_DEV);
    eval 'sub IXGBE_MDIO_COMMAND_TIMEOUT () {100;}' unless defined(&IXGBE_MDIO_COMMAND_TIMEOUT);
    eval 'sub IXGBE_MDIO_VENDOR_SPECIFIC_1_CONTROL () {0x;}' unless defined(&IXGBE_MDIO_VENDOR_SPECIFIC_1_CONTROL);
    eval 'sub IXGBE_MDIO_VENDOR_SPECIFIC_1_STATUS () {0x1;}' unless defined(&IXGBE_MDIO_VENDOR_SPECIFIC_1_STATUS);
    eval 'sub IXGBE_MDIO_VENDOR_SPECIFIC_1_LINK_STATUS () {0x8;}' unless defined(&IXGBE_MDIO_VENDOR_SPECIFIC_1_LINK_STATUS);
    eval 'sub IXGBE_MDIO_VENDOR_SPECIFIC_1_SPEED_STATUS () {0x10;}' unless defined(&IXGBE_MDIO_VENDOR_SPECIFIC_1_SPEED_STATUS);
    eval 'sub IXGBE_MDIO_VENDOR_SPECIFIC_1_10G_SPEED () {0x18;}' unless defined(&IXGBE_MDIO_VENDOR_SPECIFIC_1_10G_SPEED);
    eval 'sub IXGBE_MDIO_VENDOR_SPECIFIC_1_1G_SPEED () {0x10;}' unless defined(&IXGBE_MDIO_VENDOR_SPECIFIC_1_1G_SPEED);
    eval 'sub IXGBE_MDIO_AUTO_NEG_CONTROL () {0x;}' unless defined(&IXGBE_MDIO_AUTO_NEG_CONTROL);
    eval 'sub IXGBE_MDIO_AUTO_NEG_STATUS () {0x1;}' unless defined(&IXGBE_MDIO_AUTO_NEG_STATUS);
    eval 'sub IXGBE_MDIO_PHY_XS_CONTROL () {0x;}' unless defined(&IXGBE_MDIO_PHY_XS_CONTROL);
    eval 'sub IXGBE_MDIO_PHY_XS_RESET () {0x8000;}' unless defined(&IXGBE_MDIO_PHY_XS_RESET);
    eval 'sub IXGBE_MDIO_PHY_ID_HIGH () {0x2;}' unless defined(&IXGBE_MDIO_PHY_ID_HIGH);
    eval 'sub IXGBE_MDIO_PHY_ID_LOW () {0x3;}' unless defined(&IXGBE_MDIO_PHY_ID_LOW);
    eval 'sub IXGBE_MDIO_PHY_SPEED_ABILITY () {0x4;}' unless defined(&IXGBE_MDIO_PHY_SPEED_ABILITY);
    eval 'sub IXGBE_MDIO_PHY_SPEED_10G () {0x1;}' unless defined(&IXGBE_MDIO_PHY_SPEED_10G);
    eval 'sub IXGBE_MDIO_PHY_SPEED_1G () {0x10;}' unless defined(&IXGBE_MDIO_PHY_SPEED_1G);
    eval 'sub IXGBE_MDIO_PHY_LOW_POWER_MODE () {0x800;}' unless defined(&IXGBE_MDIO_PHY_LOW_POWER_MODE);
    eval 'sub IXGBE_MII_SPEED_SELECTION_REG () {0x10;}' unless defined(&IXGBE_MII_SPEED_SELECTION_REG);
    eval 'sub IXGBE_MII_RESTART () {0x200;}' unless defined(&IXGBE_MII_RESTART);
    eval 'sub IXGBE_MII_AUTONEG_COMPLETE () {0x20;}' unless defined(&IXGBE_MII_AUTONEG_COMPLETE);
    eval 'sub IXGBE_MII_AUTONEG_REG () {0x;}' unless defined(&IXGBE_MII_AUTONEG_REG);
    eval 'sub IXGBE_PHY_REVISION_MASK () {0xfffffff0;}' unless defined(&IXGBE_PHY_REVISION_MASK);
    eval 'sub IXGBE_MAX_PHY_ADDR () {32;}' unless defined(&IXGBE_MAX_PHY_ADDR);
    eval 'sub TN1010_PHY_ID () {0xa19410;}' unless defined(&TN1010_PHY_ID);
    eval 'sub TNX_FW_REV () {0xb;}' unless defined(&TNX_FW_REV);
    eval 'sub QT2022_PHY_ID () {0x43a400;}' unless defined(&QT2022_PHY_ID);
    eval 'sub ATH_PHY_ID () {0x3429050;}' unless defined(&ATH_PHY_ID);
    eval 'sub IXGBE_M88E1145_E_PHY_ID () {0x1410cd0;}' unless defined(&IXGBE_M88E1145_E_PHY_ID);
    eval 'sub IXGBE_PHY_INIT_OFFSET_NL () {0x2b;}' unless defined(&IXGBE_PHY_INIT_OFFSET_NL);
    eval 'sub IXGBE_CONTROL_MASK_NL () {0xf000;}' unless defined(&IXGBE_CONTROL_MASK_NL);
    eval 'sub IXGBE_DATA_MASK_NL () {0xfff;}' unless defined(&IXGBE_DATA_MASK_NL);
    eval 'sub IXGBE_CONTROL_SHIFT_NL () {12;}' unless defined(&IXGBE_CONTROL_SHIFT_NL);
    eval 'sub IXGBE_DELAY_NL () {0;}' unless defined(&IXGBE_DELAY_NL);
    eval 'sub IXGBE_DATA_NL () {1;}' unless defined(&IXGBE_DATA_NL);
    eval 'sub IXGBE_CONTROL_NL () {0xf;}' unless defined(&IXGBE_CONTROL_NL);
    eval 'sub IXGBE_CONTROL_EOL_NL () {0xfff;}' unless defined(&IXGBE_CONTROL_EOL_NL);
    eval 'sub IXGBE_CONTROL_SOL_NL () {0x;}' unless defined(&IXGBE_CONTROL_SOL_NL);
    eval 'sub IXGBE_SDP0_GPIEN () {0x1;}' unless defined(&IXGBE_SDP0_GPIEN);
    eval 'sub IXGBE_SDP1_GPIEN () {0x2;}' unless defined(&IXGBE_SDP1_GPIEN);
    eval 'sub IXGBE_GPIE_MSIX_MODE () {0x10;}' unless defined(&IXGBE_GPIE_MSIX_MODE);
    eval 'sub IXGBE_GPIE_OCD () {0x20;}' unless defined(&IXGBE_GPIE_OCD);
    eval 'sub IXGBE_GPIE_EIMEN () {0x40;}' unless defined(&IXGBE_GPIE_EIMEN);
    eval 'sub IXGBE_GPIE_EIAME () {0x40000000;}' unless defined(&IXGBE_GPIE_EIAME);
    eval 'sub IXGBE_GPIE_PBA_SUPPORT () {0x80000000;}' unless defined(&IXGBE_GPIE_PBA_SUPPORT);
    eval 'sub IXGBE_TFCS_TXOFF () {0x1;}' unless defined(&IXGBE_TFCS_TXOFF);
    eval 'sub IXGBE_TFCS_TXOFF0 () {0x100;}' unless defined(&IXGBE_TFCS_TXOFF0);
    eval 'sub IXGBE_TFCS_TXOFF1 () {0x200;}' unless defined(&IXGBE_TFCS_TXOFF1);
    eval 'sub IXGBE_TFCS_TXOFF2 () {0x400;}' unless defined(&IXGBE_TFCS_TXOFF2);
    eval 'sub IXGBE_TFCS_TXOFF3 () {0x800;}' unless defined(&IXGBE_TFCS_TXOFF3);
    eval 'sub IXGBE_TFCS_TXOFF4 () {0x1000;}' unless defined(&IXGBE_TFCS_TXOFF4);
    eval 'sub IXGBE_TFCS_TXOFF5 () {0x2000;}' unless defined(&IXGBE_TFCS_TXOFF5);
    eval 'sub IXGBE_TFCS_TXOFF6 () {0x4000;}' unless defined(&IXGBE_TFCS_TXOFF6);
    eval 'sub IXGBE_TFCS_TXOFF7 () {0x8000;}' unless defined(&IXGBE_TFCS_TXOFF7);
    eval 'sub IXGBE_TCPTIMER_KS () {0x100;}' unless defined(&IXGBE_TCPTIMER_KS);
    eval 'sub IXGBE_TCPTIMER_COUNT_ENABLE () {0x200;}' unless defined(&IXGBE_TCPTIMER_COUNT_ENABLE);
    eval 'sub IXGBE_TCPTIMER_COUNT_FINISH () {0x400;}' unless defined(&IXGBE_TCPTIMER_COUNT_FINISH);
    eval 'sub IXGBE_TCPTIMER_LOOP () {0x800;}' unless defined(&IXGBE_TCPTIMER_LOOP);
    eval 'sub IXGBE_TCPTIMER_DURATION_MASK () {0xff;}' unless defined(&IXGBE_TCPTIMER_DURATION_MASK);
    eval 'sub IXGBE_HLREG0_TXCRCEN () {0x1;}' unless defined(&IXGBE_HLREG0_TXCRCEN);
    eval 'sub IXGBE_HLREG0_RXCRCSTRP () {0x2;}' unless defined(&IXGBE_HLREG0_RXCRCSTRP);
    eval 'sub IXGBE_HLREG0_JUMBOEN () {0x4;}' unless defined(&IXGBE_HLREG0_JUMBOEN);
    eval 'sub IXGBE_HLREG0_TXPADEN () {0x400;}' unless defined(&IXGBE_HLREG0_TXPADEN);
    eval 'sub IXGBE_HLREG0_TXPAUSEEN () {0x1000;}' unless defined(&IXGBE_HLREG0_TXPAUSEEN);
    eval 'sub IXGBE_HLREG0_RXPAUSEEN () {0x4000;}' unless defined(&IXGBE_HLREG0_RXPAUSEEN);
    eval 'sub IXGBE_HLREG0_LPBK () {0x8000;}' unless defined(&IXGBE_HLREG0_LPBK);
    eval 'sub IXGBE_HLREG0_MDCSPD () {0x10000;}' unless defined(&IXGBE_HLREG0_MDCSPD);
    eval 'sub IXGBE_HLREG0_CONTMDC () {0x20000;}' unless defined(&IXGBE_HLREG0_CONTMDC);
    eval 'sub IXGBE_HLREG0_CTRLFLTR () {0x40000;}' unless defined(&IXGBE_HLREG0_CTRLFLTR);
    eval 'sub IXGBE_HLREG0_PREPEND () {0xf00000;}' unless defined(&IXGBE_HLREG0_PREPEND);
    eval 'sub IXGBE_HLREG0_PRIPAUSEEN () {0x1000000;}' unless defined(&IXGBE_HLREG0_PRIPAUSEEN);
    eval 'sub IXGBE_HLREG0_RXPAUSERECDA () {0x6000000;}' unless defined(&IXGBE_HLREG0_RXPAUSERECDA);
    eval 'sub IXGBE_HLREG0_RXLNGTHERREN () {0x8000000;}' unless defined(&IXGBE_HLREG0_RXLNGTHERREN);
    eval 'sub IXGBE_HLREG0_RXPADSTRIPEN () {0x10000000;}' unless defined(&IXGBE_HLREG0_RXPADSTRIPEN);
    eval 'sub IXGBE_VMD_CTL_VMDQ_EN () {0x1;}' unless defined(&IXGBE_VMD_CTL_VMDQ_EN);
    eval 'sub IXGBE_VMD_CTL_VMDQ_FILTER () {0x2;}' unless defined(&IXGBE_VMD_CTL_VMDQ_FILTER);
    eval 'sub IXGBE_RDHMPN_RDICADDR () {0x7ff800;}' unless defined(&IXGBE_RDHMPN_RDICADDR);
    eval 'sub IXGBE_RDHMPN_RDICRDREQ () {0x800000;}' unless defined(&IXGBE_RDHMPN_RDICRDREQ);
    eval 'sub IXGBE_RDHMPN_RDICADDR_SHIFT () {11;}' unless defined(&IXGBE_RDHMPN_RDICADDR_SHIFT);
    eval 'sub IXGBE_TDHMPN_TDICADDR () {0x3ff800;}' unless defined(&IXGBE_TDHMPN_TDICADDR);
    eval 'sub IXGBE_TDHMPN_TDICRDREQ () {0x800000;}' unless defined(&IXGBE_TDHMPN_TDICRDREQ);
    eval 'sub IXGBE_TDHMPN_TDICADDR_SHIFT () {11;}' unless defined(&IXGBE_TDHMPN_TDICADDR_SHIFT);
    eval 'sub IXGBE_RXCSUM_IPPCSE () {0x1000;}' unless defined(&IXGBE_RXCSUM_IPPCSE);
    eval 'sub IXGBE_RXCSUM_PCSD () {0x2000;}' unless defined(&IXGBE_RXCSUM_PCSD);
    eval 'sub IXGBE_FCRTL_XONE () {0x80000000;}' unless defined(&IXGBE_FCRTL_XONE);
    eval 'sub IXGBE_FCRTH_FCEN () {0x80000000;}' unless defined(&IXGBE_FCRTH_FCEN);
    eval 'sub IXGBE_PAP_TXPAUSECNT_MASK () {0xffff;}' unless defined(&IXGBE_PAP_TXPAUSECNT_MASK);
    eval 'sub IXGBE_RMCS_RRM () {0x2;}' unless defined(&IXGBE_RMCS_RRM);
    eval 'sub IXGBE_RMCS_RAC () {0x4;}' unless defined(&IXGBE_RMCS_RAC);
    eval 'sub IXGBE_RMCS_DFP () { &IXGBE_RMCS_RAC;}' unless defined(&IXGBE_RMCS_DFP);
    eval 'sub IXGBE_RMCS_TFCE_802_3X () {0x8;}' unless defined(&IXGBE_RMCS_TFCE_802_3X);
    eval 'sub IXGBE_RMCS_TFCE_PRIORITY () {0x10;}' unless defined(&IXGBE_RMCS_TFCE_PRIORITY);
    eval 'sub IXGBE_RMCS_ARBDIS () {0x40;}' unless defined(&IXGBE_RMCS_ARBDIS);
    eval 'sub IXGBE_EICR_RTX_QUEUE () {0xffff;}' unless defined(&IXGBE_EICR_RTX_QUEUE);
    eval 'sub IXGBE_EICR_GPI_SDP0 () {0x1000000;}' unless defined(&IXGBE_EICR_GPI_SDP0);
    eval 'sub IXGBE_EICR_GPI_SDP1 () {0x2000000;}' unless defined(&IXGBE_EICR_GPI_SDP1);
    eval 'sub IXGBE_EICR_LSC () {0x100000;}' unless defined(&IXGBE_EICR_LSC);
    eval 'sub IXGBE_EICR_MNG () {0x400000;}' unless defined(&IXGBE_EICR_MNG);
    eval 'sub IXGBE_EICR_PBUR () {0x10000000;}' unless defined(&IXGBE_EICR_PBUR);
    eval 'sub IXGBE_EICR_DHER () {0x20000000;}' unless defined(&IXGBE_EICR_DHER);
    eval 'sub IXGBE_EICR_TCP_TIMER () {0x40000000;}' unless defined(&IXGBE_EICR_TCP_TIMER);
    eval 'sub IXGBE_EICR_OTHER () {0x80000000;}' unless defined(&IXGBE_EICR_OTHER);
    eval 'sub IXGBE_EICS_RTX_QUEUE () { &IXGBE_EICR_RTX_QUEUE;}' unless defined(&IXGBE_EICS_RTX_QUEUE);
    eval 'sub IXGBE_EICS_GPI_SDP0 () { &IXGBE_EICR_GPI_SDP0;}' unless defined(&IXGBE_EICS_GPI_SDP0);
    eval 'sub IXGBE_EICS_GPI_SDP1 () { &IXGBE_EICR_GPI_SDP1;}' unless defined(&IXGBE_EICS_GPI_SDP1);
    eval 'sub IXGBE_EICS_LSC () { &IXGBE_EICR_LSC;}' unless defined(&IXGBE_EICS_LSC);
    eval 'sub IXGBE_EICS_MNG () { &IXGBE_EICR_MNG;}' unless defined(&IXGBE_EICS_MNG);
    eval 'sub IXGBE_EICS_PBUR () { &IXGBE_EICR_PBUR;}' unless defined(&IXGBE_EICS_PBUR);
    eval 'sub IXGBE_EICS_DHER () { &IXGBE_EICR_DHER;}' unless defined(&IXGBE_EICS_DHER);
    eval 'sub IXGBE_EICS_TCP_TIMER () { &IXGBE_EICR_TCP_TIMER;}' unless defined(&IXGBE_EICS_TCP_TIMER);
    eval 'sub IXGBE_EICS_OTHER () { &IXGBE_EICR_OTHER;}' unless defined(&IXGBE_EICS_OTHER);
    eval 'sub IXGBE_EIMS_RTX_QUEUE () { &IXGBE_EICR_RTX_QUEUE;}' unless defined(&IXGBE_EIMS_RTX_QUEUE);
    eval 'sub IXGBE_EIMS_GPI_SDP0 () { &IXGBE_EICR_GPI_SDP0;}' unless defined(&IXGBE_EIMS_GPI_SDP0);
    eval 'sub IXGBE_EIMS_GPI_SDP1 () { &IXGBE_EICR_GPI_SDP1;}' unless defined(&IXGBE_EIMS_GPI_SDP1);
    eval 'sub IXGBE_EIMS_LSC () { &IXGBE_EICR_LSC;}' unless defined(&IXGBE_EIMS_LSC);
    eval 'sub IXGBE_EIMS_MNG () { &IXGBE_EICR_MNG;}' unless defined(&IXGBE_EIMS_MNG);
    eval 'sub IXGBE_EIMS_PBUR () { &IXGBE_EICR_PBUR;}' unless defined(&IXGBE_EIMS_PBUR);
    eval 'sub IXGBE_EIMS_DHER () { &IXGBE_EICR_DHER;}' unless defined(&IXGBE_EIMS_DHER);
    eval 'sub IXGBE_EIMS_TCP_TIMER () { &IXGBE_EICR_TCP_TIMER;}' unless defined(&IXGBE_EIMS_TCP_TIMER);
    eval 'sub IXGBE_EIMS_OTHER () { &IXGBE_EICR_OTHER;}' unless defined(&IXGBE_EIMS_OTHER);
    eval 'sub IXGBE_EIMC_RTX_QUEUE () { &IXGBE_EICR_RTX_QUEUE;}' unless defined(&IXGBE_EIMC_RTX_QUEUE);
    eval 'sub IXGBE_EIMC_GPI_SDP0 () { &IXGBE_EICR_GPI_SDP0;}' unless defined(&IXGBE_EIMC_GPI_SDP0);
    eval 'sub IXGBE_EIMC_GPI_SDP1 () { &IXGBE_EICR_GPI_SDP1;}' unless defined(&IXGBE_EIMC_GPI_SDP1);
    eval 'sub IXGBE_EIMC_LSC () { &IXGBE_EICR_LSC;}' unless defined(&IXGBE_EIMC_LSC);
    eval 'sub IXGBE_EIMC_MNG () { &IXGBE_EICR_MNG;}' unless defined(&IXGBE_EIMC_MNG);
    eval 'sub IXGBE_EIMC_PBUR () { &IXGBE_EICR_PBUR;}' unless defined(&IXGBE_EIMC_PBUR);
    eval 'sub IXGBE_EIMC_DHER () { &IXGBE_EICR_DHER;}' unless defined(&IXGBE_EIMC_DHER);
    eval 'sub IXGBE_EIMC_TCP_TIMER () { &IXGBE_EICR_TCP_TIMER;}' unless defined(&IXGBE_EIMC_TCP_TIMER);
    eval 'sub IXGBE_EIMC_OTHER () { &IXGBE_EICR_OTHER;}' unless defined(&IXGBE_EIMC_OTHER);
    eval 'sub IXGBE_EIMS_ENABLE_MASK () {(  &IXGBE_EIMS_RTX_QUEUE |  &IXGBE_EIMS_LSC |  &IXGBE_EIMS_TCP_TIMER |  &IXGBE_EIMS_OTHER);}' unless defined(&IXGBE_EIMS_ENABLE_MASK);
    eval 'sub IXGBE_IMIR_PORT_IM_EN () {0x10000;}' unless defined(&IXGBE_IMIR_PORT_IM_EN);
    eval 'sub IXGBE_IMIR_PORT_BP () {0x20000;}' unless defined(&IXGBE_IMIR_PORT_BP);
    eval 'sub IXGBE_IMIREXT_SIZE_BP () {0x1000;}' unless defined(&IXGBE_IMIREXT_SIZE_BP);
    eval 'sub IXGBE_IMIREXT_CTRL_URG () {0x2000;}' unless defined(&IXGBE_IMIREXT_CTRL_URG);
    eval 'sub IXGBE_IMIREXT_CTRL_ACK () {0x4000;}' unless defined(&IXGBE_IMIREXT_CTRL_ACK);
    eval 'sub IXGBE_IMIREXT_CTRL_PSH () {0x8000;}' unless defined(&IXGBE_IMIREXT_CTRL_PSH);
    eval 'sub IXGBE_IMIREXT_CTRL_RST () {0x10000;}' unless defined(&IXGBE_IMIREXT_CTRL_RST);
    eval 'sub IXGBE_IMIREXT_CTRL_SYN () {0x20000;}' unless defined(&IXGBE_IMIREXT_CTRL_SYN);
    eval 'sub IXGBE_IMIREXT_CTRL_FIN () {0x40000;}' unless defined(&IXGBE_IMIREXT_CTRL_FIN);
    eval 'sub IXGBE_IMIREXT_CTRL_BP () {0x80000;}' unless defined(&IXGBE_IMIREXT_CTRL_BP);
    eval 'sub IXGBE_IRQ_CLEAR_MASK () {0xffffffff;}' unless defined(&IXGBE_IRQ_CLEAR_MASK);
    eval 'sub IXGBE_IVAR_REG_NUM () {25;}' unless defined(&IXGBE_IVAR_REG_NUM);
    eval 'sub IXGBE_IVAR_TXRX_ENTRY () {96;}' unless defined(&IXGBE_IVAR_TXRX_ENTRY);
    eval 'sub IXGBE_IVAR_RX_ENTRY () {64;}' unless defined(&IXGBE_IVAR_RX_ENTRY);
    eval 'sub IXGBE_IVAR_RX_QUEUE {
        my($_i) = @_;
	    eval q((0+ ($_i)));
    }' unless defined(&IXGBE_IVAR_RX_QUEUE);
    eval 'sub IXGBE_IVAR_TX_QUEUE {
        my($_i) = @_;
	    eval q((64+ ($_i)));
    }' unless defined(&IXGBE_IVAR_TX_QUEUE);
    eval 'sub IXGBE_IVAR_TX_ENTRY () {32;}' unless defined(&IXGBE_IVAR_TX_ENTRY);
    eval 'sub IXGBE_IVAR_TCP_TIMER_INDEX () {96;}' unless defined(&IXGBE_IVAR_TCP_TIMER_INDEX);
    eval 'sub IXGBE_IVAR_OTHER_CAUSES_INDEX () {97;}' unless defined(&IXGBE_IVAR_OTHER_CAUSES_INDEX);
    eval 'sub IXGBE_MSIX_VECTOR {
        my($_i) = @_;
	    eval q((0+ ($_i)));
    }' unless defined(&IXGBE_MSIX_VECTOR);
    eval 'sub IXGBE_IVAR_ALLOC_VAL () {0x80;}' unless defined(&IXGBE_IVAR_ALLOC_VAL);
    eval 'sub IXGBE_VLNCTRL_VET () {0xffff;}' unless defined(&IXGBE_VLNCTRL_VET);
    eval 'sub IXGBE_VLNCTRL_CFI () {0x10000000;}' unless defined(&IXGBE_VLNCTRL_CFI);
    eval 'sub IXGBE_VLNCTRL_CFIEN () {0x20000000;}' unless defined(&IXGBE_VLNCTRL_CFIEN);
    eval 'sub IXGBE_VLNCTRL_VFE () {0x40000000;}' unless defined(&IXGBE_VLNCTRL_VFE);
    eval 'sub IXGBE_VLNCTRL_VME () {0x80000000;}' unless defined(&IXGBE_VLNCTRL_VME);
    eval 'sub IXGBE_ETHERNET_IEEE_VLAN_TYPE () {0x8100;}' unless defined(&IXGBE_ETHERNET_IEEE_VLAN_TYPE);
    eval 'sub IXGBE_STATUS_LAN_ID () {0xc;}' unless defined(&IXGBE_STATUS_LAN_ID);
    eval 'sub IXGBE_STATUS_GIO () {0x80000;}' unless defined(&IXGBE_STATUS_GIO);
    eval 'sub IXGBE_STATUS_LAN_ID_0 () {0x;}' unless defined(&IXGBE_STATUS_LAN_ID_0);
    eval 'sub IXGBE_STATUS_LAN_ID_1 () {0x4;}' unless defined(&IXGBE_STATUS_LAN_ID_1);
    eval 'sub IXGBE_ESDP_SDP4 () {0x1;}' unless defined(&IXGBE_ESDP_SDP4);
    eval 'sub IXGBE_ESDP_SDP5 () {0x2;}' unless defined(&IXGBE_ESDP_SDP5);
    eval 'sub IXGBE_ESDP_SDP4_DIR () {0x4;}' unless defined(&IXGBE_ESDP_SDP4_DIR);
    eval 'sub IXGBE_ESDP_SDP5_DIR () {0x8;}' unless defined(&IXGBE_ESDP_SDP5_DIR);
    eval 'sub IXGBE_LED_IVRT_BASE () {0x40;}' unless defined(&IXGBE_LED_IVRT_BASE);
    eval 'sub IXGBE_LED_BLINK_BASE () {0x80;}' unless defined(&IXGBE_LED_BLINK_BASE);
    eval 'sub IXGBE_LED_MODE_MASK_BASE () {0xf;}' unless defined(&IXGBE_LED_MODE_MASK_BASE);
    eval 'sub IXGBE_LED_OFFSET {
        my($_base, $_i) = @_;
	    eval q(($_base << (8* ($_i))));
    }' unless defined(&IXGBE_LED_OFFSET);
    eval 'sub IXGBE_LED_MODE_SHIFT {
        my($_i) = @_;
	    eval q((8*($_i)));
    }' unless defined(&IXGBE_LED_MODE_SHIFT);
    eval 'sub IXGBE_LED_IVRT {
        my($_i) = @_;
	    eval q( &IXGBE_LED_OFFSET( &IXGBE_LED_IVRT_BASE, $_i));
    }' unless defined(&IXGBE_LED_IVRT);
    eval 'sub IXGBE_LED_BLINK {
        my($_i) = @_;
	    eval q( &IXGBE_LED_OFFSET( &IXGBE_LED_BLINK_BASE, $_i));
    }' unless defined(&IXGBE_LED_BLINK);
    eval 'sub IXGBE_LED_MODE_MASK {
        my($_i) = @_;
	    eval q( &IXGBE_LED_OFFSET( &IXGBE_LED_MODE_MASK_BASE, $_i));
    }' unless defined(&IXGBE_LED_MODE_MASK);
    eval 'sub IXGBE_LED_LINK_UP () {0x;}' unless defined(&IXGBE_LED_LINK_UP);
    eval 'sub IXGBE_LED_LINK_10G () {0x1;}' unless defined(&IXGBE_LED_LINK_10G);
    eval 'sub IXGBE_LED_MAC () {0x2;}' unless defined(&IXGBE_LED_MAC);
    eval 'sub IXGBE_LED_FILTER () {0x3;}' unless defined(&IXGBE_LED_FILTER);
    eval 'sub IXGBE_LED_LINK_ACTIVE () {0x4;}' unless defined(&IXGBE_LED_LINK_ACTIVE);
    eval 'sub IXGBE_LED_LINK_1G () {0x5;}' unless defined(&IXGBE_LED_LINK_1G);
    eval 'sub IXGBE_LED_ON () {0xe;}' unless defined(&IXGBE_LED_ON);
    eval 'sub IXGBE_LED_OFF () {0xf;}' unless defined(&IXGBE_LED_OFF);
    eval 'sub IXGBE_AUTOC_KX4_SUPP () {0x80000000;}' unless defined(&IXGBE_AUTOC_KX4_SUPP);
    eval 'sub IXGBE_AUTOC_KX_SUPP () {0x40000000;}' unless defined(&IXGBE_AUTOC_KX_SUPP);
    eval 'sub IXGBE_AUTOC_PAUSE () {0x30000000;}' unless defined(&IXGBE_AUTOC_PAUSE);
    eval 'sub IXGBE_AUTOC_RF () {0x8000000;}' unless defined(&IXGBE_AUTOC_RF);
    eval 'sub IXGBE_AUTOC_PD_TMR () {0x6000000;}' unless defined(&IXGBE_AUTOC_PD_TMR);
    eval 'sub IXGBE_AUTOC_AN_RX_LOOSE () {0x1000000;}' unless defined(&IXGBE_AUTOC_AN_RX_LOOSE);
    eval 'sub IXGBE_AUTOC_AN_RX_DRIFT () {0x800000;}' unless defined(&IXGBE_AUTOC_AN_RX_DRIFT);
    eval 'sub IXGBE_AUTOC_AN_RX_ALIGN () {0x7c0000;}' unless defined(&IXGBE_AUTOC_AN_RX_ALIGN);
    eval 'sub IXGBE_AUTOC_AN_RESTART () {0x1000;}' unless defined(&IXGBE_AUTOC_AN_RESTART);
    eval 'sub IXGBE_AUTOC_FLU () {0x1;}' unless defined(&IXGBE_AUTOC_FLU);
    eval 'sub IXGBE_AUTOC_LMS_SHIFT () {13;}' unless defined(&IXGBE_AUTOC_LMS_SHIFT);
    eval 'sub IXGBE_AUTOC_LMS_MASK () {(0x7 <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_MASK);
    eval 'sub IXGBE_AUTOC_LMS_1G_LINK_NO_AN () {(0x <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_1G_LINK_NO_AN);
    eval 'sub IXGBE_AUTOC_LMS_10G_LINK_NO_AN () {(0x1 <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_10G_LINK_NO_AN);
    eval 'sub IXGBE_AUTOC_LMS_1G_AN () {(0x2 <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_1G_AN);
    eval 'sub IXGBE_AUTOC_LMS_KX4_AN () {(0x4 <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_KX4_AN);
    eval 'sub IXGBE_AUTOC_LMS_KX4_AN_1G_AN () {(0x6 <<  &IXGBE_AUTOC_LMS_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_KX4_AN_1G_AN);
    eval 'sub IXGBE_AUTOC_LMS_ATTACH_TYPE () {(0x7 <<  &IXGBE_AUTOC_10G_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC_LMS_ATTACH_TYPE);
    eval 'sub IXGBE_AUTOC_1G_PMA_PMD () {0x200;}' unless defined(&IXGBE_AUTOC_1G_PMA_PMD);
    eval 'sub IXGBE_AUTOC_10G_PMA_PMD () {0x180;}' unless defined(&IXGBE_AUTOC_10G_PMA_PMD);
    eval 'sub IXGBE_AUTOC_10G_PMA_PMD_SHIFT () {7;}' unless defined(&IXGBE_AUTOC_10G_PMA_PMD_SHIFT);
    eval 'sub IXGBE_AUTOC_1G_PMA_PMD_SHIFT () {9;}' unless defined(&IXGBE_AUTOC_1G_PMA_PMD_SHIFT);
    eval 'sub IXGBE_AUTOC_10G_XAUI () {(0x <<  &IXGBE_AUTOC_10G_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC_10G_XAUI);
    eval 'sub IXGBE_AUTOC_10G_KX4 () {(0x1 <<  &IXGBE_AUTOC_10G_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC_10G_KX4);
    eval 'sub IXGBE_AUTOC_10G_CX4 () {(0x2 <<  &IXGBE_AUTOC_10G_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC_10G_CX4);
    eval 'sub IXGBE_AUTOC_1G_BX () {(0x <<  &IXGBE_AUTOC_1G_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC_1G_BX);
    eval 'sub IXGBE_AUTOC_1G_KX () {(0x1 <<  &IXGBE_AUTOC_1G_PMA_PMD_SHIFT);}' unless defined(&IXGBE_AUTOC_1G_KX);
    eval 'sub IXGBE_LINKS_KX_AN_COMP () {0x80000000;}' unless defined(&IXGBE_LINKS_KX_AN_COMP);
    eval 'sub IXGBE_LINKS_UP () {0x40000000;}' unless defined(&IXGBE_LINKS_UP);
    eval 'sub IXGBE_LINKS_SPEED () {0x20000000;}' unless defined(&IXGBE_LINKS_SPEED);
    eval 'sub IXGBE_LINKS_MODE () {0x18000000;}' unless defined(&IXGBE_LINKS_MODE);
    eval 'sub IXGBE_LINKS_RX_MODE () {0x6000000;}' unless defined(&IXGBE_LINKS_RX_MODE);
    eval 'sub IXGBE_LINKS_TX_MODE () {0x1800000;}' unless defined(&IXGBE_LINKS_TX_MODE);
    eval 'sub IXGBE_LINKS_XGXS_EN () {0x400000;}' unless defined(&IXGBE_LINKS_XGXS_EN);
    eval 'sub IXGBE_LINKS_PCS_1G_EN () {0x200000;}' unless defined(&IXGBE_LINKS_PCS_1G_EN);
    eval 'sub IXGBE_LINKS_1G_AN_EN () {0x100000;}' unless defined(&IXGBE_LINKS_1G_AN_EN);
    eval 'sub IXGBE_LINKS_KX_AN_IDLE () {0x80000;}' unless defined(&IXGBE_LINKS_KX_AN_IDLE);
    eval 'sub IXGBE_LINKS_1G_SYNC () {0x40000;}' unless defined(&IXGBE_LINKS_1G_SYNC);
    eval 'sub IXGBE_LINKS_10G_ALIGN () {0x20000;}' unless defined(&IXGBE_LINKS_10G_ALIGN);
    eval 'sub IXGBE_LINKS_10G_LANE_SYNC () {0x17000;}' unless defined(&IXGBE_LINKS_10G_LANE_SYNC);
    eval 'sub IXGBE_LINKS_TL_FAULT () {0x1000;}' unless defined(&IXGBE_LINKS_TL_FAULT);
    eval 'sub IXGBE_LINKS_SIGNAL () {0xf00;}' unless defined(&IXGBE_LINKS_SIGNAL);
    eval 'sub IXGBE_LINK_UP_TIME () {90;}' unless defined(&IXGBE_LINK_UP_TIME);
    eval 'sub IXGBE_AUTO_NEG_TIME () {45;}' unless defined(&IXGBE_AUTO_NEG_TIME);
    eval 'sub FIBER_LINK_UP_LIMIT () {50;}' unless defined(&FIBER_LINK_UP_LIMIT);
    eval 'sub IXGBE_PCS1GLSTA_LINK_OK () {1;}' unless defined(&IXGBE_PCS1GLSTA_LINK_OK);
    eval 'sub IXGBE_PCS1GLSTA_SYNK_OK () {0x10;}' unless defined(&IXGBE_PCS1GLSTA_SYNK_OK);
    eval 'sub IXGBE_PCS1GLSTA_AN_COMPLETE () {0x10000;}' unless defined(&IXGBE_PCS1GLSTA_AN_COMPLETE);
    eval 'sub IXGBE_PCS1GLSTA_AN_PAGE_RX () {0x20000;}' unless defined(&IXGBE_PCS1GLSTA_AN_PAGE_RX);
    eval 'sub IXGBE_PCS1GLSTA_AN_TIMED_OUT () {0x40000;}' unless defined(&IXGBE_PCS1GLSTA_AN_TIMED_OUT);
    eval 'sub IXGBE_PCS1GLSTA_AN_REMOTE_FAULT () {0x80000;}' unless defined(&IXGBE_PCS1GLSTA_AN_REMOTE_FAULT);
    eval 'sub IXGBE_PCS1GLSTA_AN_ERROR_RWS () {0x100000;}' unless defined(&IXGBE_PCS1GLSTA_AN_ERROR_RWS);
    eval 'sub IXGBE_PCS1GANA_SYM_PAUSE () {0x80;}' unless defined(&IXGBE_PCS1GANA_SYM_PAUSE);
    eval 'sub IXGBE_PCS1GANA_ASM_PAUSE () {0x100;}' unless defined(&IXGBE_PCS1GANA_ASM_PAUSE);
    eval 'sub IXGBE_PCS1GLCTL_AN_1G_TIMEOUT_EN () {0x40000;}' unless defined(&IXGBE_PCS1GLCTL_AN_1G_TIMEOUT_EN);
    eval 'sub IXGBE_PCS1GLCTL_FLV_LINK_UP () {1;}' unless defined(&IXGBE_PCS1GLCTL_FLV_LINK_UP);
    eval 'sub IXGBE_PCS1GLCTL_FORCE_LINK () {0x20;}' unless defined(&IXGBE_PCS1GLCTL_FORCE_LINK);
    eval 'sub IXGBE_PCS1GLCTL_LOW_LINK_LATCH () {0x40;}' unless defined(&IXGBE_PCS1GLCTL_LOW_LINK_LATCH);
    eval 'sub IXGBE_PCS1GLCTL_AN_ENABLE () {0x10000;}' unless defined(&IXGBE_PCS1GLCTL_AN_ENABLE);
    eval 'sub IXGBE_PCS1GLCTL_AN_RESTART () {0x20000;}' unless defined(&IXGBE_PCS1GLCTL_AN_RESTART);
    eval 'sub IXGBE_SWSM_SMBI () {0x1;}' unless defined(&IXGBE_SWSM_SMBI);
    eval 'sub IXGBE_SWSM_SWESMBI () {0x2;}' unless defined(&IXGBE_SWSM_SWESMBI);
    eval 'sub IXGBE_SWSM_WMNG () {0x4;}' unless defined(&IXGBE_SWSM_WMNG);
    eval 'sub IXGBE_GSSR_EEP_SM () {0x1;}' unless defined(&IXGBE_GSSR_EEP_SM);
    eval 'sub IXGBE_GSSR_PHY0_SM () {0x2;}' unless defined(&IXGBE_GSSR_PHY0_SM);
    eval 'sub IXGBE_GSSR_PHY1_SM () {0x4;}' unless defined(&IXGBE_GSSR_PHY1_SM);
    eval 'sub IXGBE_GSSR_MAC_CSR_SM () {0x8;}' unless defined(&IXGBE_GSSR_MAC_CSR_SM);
    eval 'sub IXGBE_GSSR_FLASH_SM () {0x10;}' unless defined(&IXGBE_GSSR_FLASH_SM);
    eval 'sub IXGBE_EEC_SK () {0x1;}' unless defined(&IXGBE_EEC_SK);
    eval 'sub IXGBE_EEC_CS () {0x2;}' unless defined(&IXGBE_EEC_CS);
    eval 'sub IXGBE_EEC_DI () {0x4;}' unless defined(&IXGBE_EEC_DI);
    eval 'sub IXGBE_EEC_DO () {0x8;}' unless defined(&IXGBE_EEC_DO);
    eval 'sub IXGBE_EEC_FWE_MASK () {0x30;}' unless defined(&IXGBE_EEC_FWE_MASK);
    eval 'sub IXGBE_EEC_FWE_DIS () {0x10;}' unless defined(&IXGBE_EEC_FWE_DIS);
    eval 'sub IXGBE_EEC_FWE_EN () {0x20;}' unless defined(&IXGBE_EEC_FWE_EN);
    eval 'sub IXGBE_EEC_FWE_SHIFT () {4;}' unless defined(&IXGBE_EEC_FWE_SHIFT);
    eval 'sub IXGBE_EEC_REQ () {0x40;}' unless defined(&IXGBE_EEC_REQ);
    eval 'sub IXGBE_EEC_GNT () {0x80;}' unless defined(&IXGBE_EEC_GNT);
    eval 'sub IXGBE_EEC_PRES () {0x100;}' unless defined(&IXGBE_EEC_PRES);
    eval 'sub IXGBE_EEC_ARD () {0x200;}' unless defined(&IXGBE_EEC_ARD);
    eval 'sub IXGBE_EEC_ADDR_SIZE () {0x400;}' unless defined(&IXGBE_EEC_ADDR_SIZE);
    eval 'sub IXGBE_EEC_SIZE () {0x7800;}' unless defined(&IXGBE_EEC_SIZE);
    eval 'sub IXGBE_EEC_SIZE_SHIFT () {11;}' unless defined(&IXGBE_EEC_SIZE_SHIFT);
    eval 'sub IXGBE_EEPROM_WORD_SIZE_SHIFT () {6;}' unless defined(&IXGBE_EEPROM_WORD_SIZE_SHIFT);
    eval 'sub IXGBE_EEPROM_OPCODE_BITS () {8;}' unless defined(&IXGBE_EEPROM_OPCODE_BITS);
    eval 'sub IXGBE_EEPROM_CHECKSUM () {0x3f;}' unless defined(&IXGBE_EEPROM_CHECKSUM);
    eval 'sub IXGBE_EEPROM_SUM () {0xbaba;}' unless defined(&IXGBE_EEPROM_SUM);
    eval 'sub IXGBE_PCIE_ANALOG_PTR () {0x3;}' unless defined(&IXGBE_PCIE_ANALOG_PTR);
    eval 'sub IXGBE_ATLAS0_CONFIG_PTR () {0x4;}' unless defined(&IXGBE_ATLAS0_CONFIG_PTR);
    eval 'sub IXGBE_ATLAS1_CONFIG_PTR () {0x5;}' unless defined(&IXGBE_ATLAS1_CONFIG_PTR);
    eval 'sub IXGBE_PCIE_GENERAL_PTR () {0x6;}' unless defined(&IXGBE_PCIE_GENERAL_PTR);
    eval 'sub IXGBE_PCIE_CONFIG0_PTR () {0x7;}' unless defined(&IXGBE_PCIE_CONFIG0_PTR);
    eval 'sub IXGBE_PCIE_CONFIG1_PTR () {0x8;}' unless defined(&IXGBE_PCIE_CONFIG1_PTR);
    eval 'sub IXGBE_CORE0_PTR () {0x9;}' unless defined(&IXGBE_CORE0_PTR);
    eval 'sub IXGBE_CORE1_PTR () {0xa;}' unless defined(&IXGBE_CORE1_PTR);
    eval 'sub IXGBE_MAC0_PTR () {0xb;}' unless defined(&IXGBE_MAC0_PTR);
    eval 'sub IXGBE_MAC1_PTR () {0xc;}' unless defined(&IXGBE_MAC1_PTR);
    eval 'sub IXGBE_CSR0_CONFIG_PTR () {0xd;}' unless defined(&IXGBE_CSR0_CONFIG_PTR);
    eval 'sub IXGBE_CSR1_CONFIG_PTR () {0xe;}' unless defined(&IXGBE_CSR1_CONFIG_PTR);
    eval 'sub IXGBE_FW_PTR () {0xf;}' unless defined(&IXGBE_FW_PTR);
    eval 'sub IXGBE_PBANUM0_PTR () {0x15;}' unless defined(&IXGBE_PBANUM0_PTR);
    eval 'sub IXGBE_PBANUM1_PTR () {0x16;}' unless defined(&IXGBE_PBANUM1_PTR);
    eval 'sub IXGBE_ISCSI_BOOT_CAPS () {0x33;}' unless defined(&IXGBE_ISCSI_BOOT_CAPS);
    eval 'sub IXGBE_ISCSI_SETUP_PORT_0 () {0x30;}' unless defined(&IXGBE_ISCSI_SETUP_PORT_0);
    eval 'sub IXGBE_ISCSI_SETUP_PORT_1 () {0x34;}' unless defined(&IXGBE_ISCSI_SETUP_PORT_1);
    eval 'sub IXGBE_EEPROM_MAX_RETRY_SPI () {5000;}' unless defined(&IXGBE_EEPROM_MAX_RETRY_SPI);
    eval 'sub IXGBE_EEPROM_STATUS_RDY_SPI () {0x1;}' unless defined(&IXGBE_EEPROM_STATUS_RDY_SPI);
    eval 'sub IXGBE_EEPROM_READ_OPCODE_SPI () {0x3;}' unless defined(&IXGBE_EEPROM_READ_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_WRITE_OPCODE_SPI () {0x2;}' unless defined(&IXGBE_EEPROM_WRITE_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_A8_OPCODE_SPI () {0x8;}' unless defined(&IXGBE_EEPROM_A8_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_WREN_OPCODE_SPI () {0x6;}' unless defined(&IXGBE_EEPROM_WREN_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_WRDI_OPCODE_SPI () {0x4;}' unless defined(&IXGBE_EEPROM_WRDI_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_RDSR_OPCODE_SPI () {0x5;}' unless defined(&IXGBE_EEPROM_RDSR_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_WRSR_OPCODE_SPI () {0x1;}' unless defined(&IXGBE_EEPROM_WRSR_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_ERASE4K_OPCODE_SPI () {0x20;}' unless defined(&IXGBE_EEPROM_ERASE4K_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_ERASE64K_OPCODE_SPI () {0xd8;}' unless defined(&IXGBE_EEPROM_ERASE64K_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_ERASE256_OPCODE_SPI () {0xdb;}' unless defined(&IXGBE_EEPROM_ERASE256_OPCODE_SPI);
    eval 'sub IXGBE_EEPROM_READ_REG_DATA () {16;}' unless defined(&IXGBE_EEPROM_READ_REG_DATA);
    eval 'sub IXGBE_EEPROM_READ_REG_DONE () {2;}' unless defined(&IXGBE_EEPROM_READ_REG_DONE);
    eval 'sub IXGBE_EEPROM_READ_REG_START () {1;}' unless defined(&IXGBE_EEPROM_READ_REG_START);
    eval 'sub IXGBE_EEPROM_READ_ADDR_SHIFT () {2;}' unless defined(&IXGBE_EEPROM_READ_ADDR_SHIFT);
    eval 'sub IXGBE_ETH_LENGTH_OF_ADDRESS () {6;}' unless defined(&IXGBE_ETH_LENGTH_OF_ADDRESS);
    unless(defined(&IXGBE_EEPROM_GRANT_ATTEMPTS)) {
	eval 'sub IXGBE_EEPROM_GRANT_ATTEMPTS () {1000;}' unless defined(&IXGBE_EEPROM_GRANT_ATTEMPTS);
    }
    unless(defined(&IXGBE_EERD_ATTEMPTS)) {
	eval 'sub IXGBE_EERD_ATTEMPTS () {100000;}' unless defined(&IXGBE_EERD_ATTEMPTS);
    }
    eval 'sub IXGBE_PCI_LINK_STATUS () {0xb2;}' unless defined(&IXGBE_PCI_LINK_STATUS);
    eval 'sub IXGBE_PCI_LINK_WIDTH () {0x3f0;}' unless defined(&IXGBE_PCI_LINK_WIDTH);
    eval 'sub IXGBE_PCI_LINK_WIDTH_1 () {0x10;}' unless defined(&IXGBE_PCI_LINK_WIDTH_1);
    eval 'sub IXGBE_PCI_LINK_WIDTH_2 () {0x20;}' unless defined(&IXGBE_PCI_LINK_WIDTH_2);
    eval 'sub IXGBE_PCI_LINK_WIDTH_4 () {0x40;}' unless defined(&IXGBE_PCI_LINK_WIDTH_4);
    eval 'sub IXGBE_PCI_LINK_WIDTH_8 () {0x80;}' unless defined(&IXGBE_PCI_LINK_WIDTH_8);
    eval 'sub IXGBE_PCI_LINK_SPEED () {0xf;}' unless defined(&IXGBE_PCI_LINK_SPEED);
    eval 'sub IXGBE_PCI_LINK_SPEED_2500 () {0x1;}' unless defined(&IXGBE_PCI_LINK_SPEED_2500);
    eval 'sub IXGBE_PCI_LINK_SPEED_5000 () {0x2;}' unless defined(&IXGBE_PCI_LINK_SPEED_5000);
    eval 'sub IXGBE_PCI_HEADER_TYPE_REGISTER () {0xe;}' unless defined(&IXGBE_PCI_HEADER_TYPE_REGISTER);
    eval 'sub IXGBE_PCI_HEADER_TYPE_MULTIFUNC () {0x80;}' unless defined(&IXGBE_PCI_HEADER_TYPE_MULTIFUNC);
    eval 'sub IXGBE_PCI_MASTER_DISABLE_TIMEOUT () {800;}' unless defined(&IXGBE_PCI_MASTER_DISABLE_TIMEOUT);
    eval 'sub IXGBE_IS_MULTICAST {
        my($Address) = @_;
	    eval q(((( &uint8_t *)($Address))[0] & (( &uint8_t)0x1)));
    }' unless defined(&IXGBE_IS_MULTICAST);
    eval 'sub IXGBE_IS_BROADCAST {
        my($Address) = @_;
	    eval q((((( &uint8_t *)($Address))[0] == (( &uint8_t)0xff))  && ((( &uint8_t *)($Address))[1] == (( &uint8_t)0xff))));
    }' unless defined(&IXGBE_IS_BROADCAST);
    eval 'sub IXGBE_RAH_VIND_MASK () {0x3c0000;}' unless defined(&IXGBE_RAH_VIND_MASK);
    eval 'sub IXGBE_RAH_VIND_SHIFT () {18;}' unless defined(&IXGBE_RAH_VIND_SHIFT);
    eval 'sub IXGBE_RAH_AV () {0x80000000;}' unless defined(&IXGBE_RAH_AV);
    eval 'sub IXGBE_RFCTL_ISCSI_DIS () {0x1;}' unless defined(&IXGBE_RFCTL_ISCSI_DIS);
    eval 'sub IXGBE_RFCTL_ISCSI_DWC_MASK () {0x3e;}' unless defined(&IXGBE_RFCTL_ISCSI_DWC_MASK);
    eval 'sub IXGBE_RFCTL_ISCSI_DWC_SHIFT () {1;}' unless defined(&IXGBE_RFCTL_ISCSI_DWC_SHIFT);
    eval 'sub IXGBE_RFCTL_NFSW_DIS () {0x40;}' unless defined(&IXGBE_RFCTL_NFSW_DIS);
    eval 'sub IXGBE_RFCTL_NFSR_DIS () {0x80;}' unless defined(&IXGBE_RFCTL_NFSR_DIS);
    eval 'sub IXGBE_RFCTL_NFS_VER_MASK () {0x300;}' unless defined(&IXGBE_RFCTL_NFS_VER_MASK);
    eval 'sub IXGBE_RFCTL_NFS_VER_SHIFT () {8;}' unless defined(&IXGBE_RFCTL_NFS_VER_SHIFT);
    eval 'sub IXGBE_RFCTL_NFS_VER_2 () {0;}' unless defined(&IXGBE_RFCTL_NFS_VER_2);
    eval 'sub IXGBE_RFCTL_NFS_VER_3 () {1;}' unless defined(&IXGBE_RFCTL_NFS_VER_3);
    eval 'sub IXGBE_RFCTL_NFS_VER_4 () {2;}' unless defined(&IXGBE_RFCTL_NFS_VER_4);
    eval 'sub IXGBE_RFCTL_IPV6_DIS () {0x400;}' unless defined(&IXGBE_RFCTL_IPV6_DIS);
    eval 'sub IXGBE_RFCTL_IPV6_XSUM_DIS () {0x800;}' unless defined(&IXGBE_RFCTL_IPV6_XSUM_DIS);
    eval 'sub IXGBE_RFCTL_IPFRSP_DIS () {0x4000;}' unless defined(&IXGBE_RFCTL_IPFRSP_DIS);
    eval 'sub IXGBE_RFCTL_IPV6_EX_DIS () {0x10000;}' unless defined(&IXGBE_RFCTL_IPV6_EX_DIS);
    eval 'sub IXGBE_RFCTL_NEW_IPV6_EXT_DIS () {0x20000;}' unless defined(&IXGBE_RFCTL_NEW_IPV6_EXT_DIS);
    eval 'sub IXGBE_TXDCTL_ENABLE () {0x2000000;}' unless defined(&IXGBE_TXDCTL_ENABLE);
    eval 'sub IXGBE_TXDCTL_SWFLSH () {0x4000000;}' unless defined(&IXGBE_TXDCTL_SWFLSH);
    eval 'sub IXGBE_TX_PAD_ENABLE () {0x400;}' unless defined(&IXGBE_TX_PAD_ENABLE);
    eval 'sub IXGBE_JUMBO_FRAME_ENABLE () {0x4;}' unless defined(&IXGBE_JUMBO_FRAME_ENABLE);
    eval 'sub IXGBE_MAX_FRAME_SZ () {0x40040000;}' unless defined(&IXGBE_MAX_FRAME_SZ);
    eval 'sub IXGBE_TDWBAL_HEAD_WB_ENABLE () {0x1;}' unless defined(&IXGBE_TDWBAL_HEAD_WB_ENABLE);
    eval 'sub IXGBE_TDWBAL_SEQNUM_WB_ENABLE () {0x2;}' unless defined(&IXGBE_TDWBAL_SEQNUM_WB_ENABLE);
    eval 'sub IXGBE_RXCTRL_RXEN () {0x1;}' unless defined(&IXGBE_RXCTRL_RXEN);
    eval 'sub IXGBE_RXCTRL_DMBYPS () {0x2;}' unless defined(&IXGBE_RXCTRL_DMBYPS);
    eval 'sub IXGBE_RXDCTL_ENABLE () {0x2000000;}' unless defined(&IXGBE_RXDCTL_ENABLE);
    eval 'sub IXGBE_FCTRL_SBP () {0x2;}' unless defined(&IXGBE_FCTRL_SBP);
    eval 'sub IXGBE_FCTRL_MPE () {0x100;}' unless defined(&IXGBE_FCTRL_MPE);
    eval 'sub IXGBE_FCTRL_UPE () {0x200;}' unless defined(&IXGBE_FCTRL_UPE);
    eval 'sub IXGBE_FCTRL_BAM () {0x400;}' unless defined(&IXGBE_FCTRL_BAM);
    eval 'sub IXGBE_FCTRL_PMCF () {0x1000;}' unless defined(&IXGBE_FCTRL_PMCF);
    eval 'sub IXGBE_FCTRL_DPF () {0x2000;}' unless defined(&IXGBE_FCTRL_DPF);
    eval 'sub IXGBE_FCTRL_RPFCE () {0x4000;}' unless defined(&IXGBE_FCTRL_RPFCE);
    eval 'sub IXGBE_FCTRL_RFCE () {0x8000;}' unless defined(&IXGBE_FCTRL_RFCE);
    eval 'sub IXGBE_MRQC_RSSEN () {0x1;}' unless defined(&IXGBE_MRQC_RSSEN);
    eval 'sub IXGBE_MRQC_RSS_FIELD_MASK () {0xffff0000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_MASK);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV4_TCP () {0x10000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV4_TCP);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV4 () {0x20000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV4);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV6_EX_TCP () {0x40000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV6_EX_TCP);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV6_EX () {0x80000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV6_EX);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV6 () {0x100000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV6);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV6_TCP () {0x200000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV6_TCP);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV4_UDP () {0x400000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV4_UDP);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV6_UDP () {0x800000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV6_UDP);
    eval 'sub IXGBE_MRQC_RSS_FIELD_IPV6_EX_UDP () {0x1000000;}' unless defined(&IXGBE_MRQC_RSS_FIELD_IPV6_EX_UDP);
    eval 'sub IXGBE_TXD_POPTS_IXSM () {0x1;}' unless defined(&IXGBE_TXD_POPTS_IXSM);
    eval 'sub IXGBE_TXD_POPTS_TXSM () {0x2;}' unless defined(&IXGBE_TXD_POPTS_TXSM);
    eval 'sub IXGBE_TXD_CMD_EOP () {0x1000000;}' unless defined(&IXGBE_TXD_CMD_EOP);
    eval 'sub IXGBE_TXD_CMD_IFCS () {0x2000000;}' unless defined(&IXGBE_TXD_CMD_IFCS);
    eval 'sub IXGBE_TXD_CMD_IC () {0x4000000;}' unless defined(&IXGBE_TXD_CMD_IC);
    eval 'sub IXGBE_TXD_CMD_RS () {0x8000000;}' unless defined(&IXGBE_TXD_CMD_RS);
    eval 'sub IXGBE_TXD_CMD_DEXT () {0x20000000;}' unless defined(&IXGBE_TXD_CMD_DEXT);
    eval 'sub IXGBE_TXD_CMD_VLE () {0x40000000;}' unless defined(&IXGBE_TXD_CMD_VLE);
    eval 'sub IXGBE_TXD_STAT_DD () {0x1;}' unless defined(&IXGBE_TXD_STAT_DD);
    eval 'sub IXGBE_RXD_STAT_DD () {0x1;}' unless defined(&IXGBE_RXD_STAT_DD);
    eval 'sub IXGBE_RXD_STAT_EOP () {0x2;}' unless defined(&IXGBE_RXD_STAT_EOP);
    eval 'sub IXGBE_RXD_STAT_VP () {0x8;}' unless defined(&IXGBE_RXD_STAT_VP);
    eval 'sub IXGBE_RXD_STAT_UDPCS () {0x10;}' unless defined(&IXGBE_RXD_STAT_UDPCS);
    eval 'sub IXGBE_RXD_STAT_L4CS () {0x20;}' unless defined(&IXGBE_RXD_STAT_L4CS);
    eval 'sub IXGBE_RXD_STAT_IPCS () {0x40;}' unless defined(&IXGBE_RXD_STAT_IPCS);
    eval 'sub IXGBE_RXD_STAT_PIF () {0x80;}' unless defined(&IXGBE_RXD_STAT_PIF);
    eval 'sub IXGBE_RXD_STAT_CRCV () {0x100;}' unless defined(&IXGBE_RXD_STAT_CRCV);
    eval 'sub IXGBE_RXD_STAT_VEXT () {0x200;}' unless defined(&IXGBE_RXD_STAT_VEXT);
    eval 'sub IXGBE_RXD_STAT_UDPV () {0x400;}' unless defined(&IXGBE_RXD_STAT_UDPV);
    eval 'sub IXGBE_RXD_STAT_DYNINT () {0x800;}' unless defined(&IXGBE_RXD_STAT_DYNINT);
    eval 'sub IXGBE_RXD_STAT_ACK () {0x8000;}' unless defined(&IXGBE_RXD_STAT_ACK);
    eval 'sub IXGBE_RXD_ERR_CE () {0x1;}' unless defined(&IXGBE_RXD_ERR_CE);
    eval 'sub IXGBE_RXD_ERR_LE () {0x2;}' unless defined(&IXGBE_RXD_ERR_LE);
    eval 'sub IXGBE_RXD_ERR_PE () {0x8;}' unless defined(&IXGBE_RXD_ERR_PE);
    eval 'sub IXGBE_RXD_ERR_OSE () {0x10;}' unless defined(&IXGBE_RXD_ERR_OSE);
    eval 'sub IXGBE_RXD_ERR_USE () {0x20;}' unless defined(&IXGBE_RXD_ERR_USE);
    eval 'sub IXGBE_RXD_ERR_TCPE () {0x40;}' unless defined(&IXGBE_RXD_ERR_TCPE);
    eval 'sub IXGBE_RXD_ERR_IPE () {0x80;}' unless defined(&IXGBE_RXD_ERR_IPE);
    eval 'sub IXGBE_RXDADV_HBO () {0x800000;}' unless defined(&IXGBE_RXDADV_HBO);
    eval 'sub IXGBE_RXDADV_ERR_CE () {0x1000000;}' unless defined(&IXGBE_RXDADV_ERR_CE);
    eval 'sub IXGBE_RXDADV_ERR_LE () {0x2000000;}' unless defined(&IXGBE_RXDADV_ERR_LE);
    eval 'sub IXGBE_RXDADV_ERR_PE () {0x8000000;}' unless defined(&IXGBE_RXDADV_ERR_PE);
    eval 'sub IXGBE_RXDADV_ERR_OSE () {0x10000000;}' unless defined(&IXGBE_RXDADV_ERR_OSE);
    eval 'sub IXGBE_RXDADV_ERR_USE () {0x20000000;}' unless defined(&IXGBE_RXDADV_ERR_USE);
    eval 'sub IXGBE_RXDADV_ERR_TCPE () {0x40000000;}' unless defined(&IXGBE_RXDADV_ERR_TCPE);
    eval 'sub IXGBE_RXDADV_ERR_IPE () {0x80000000;}' unless defined(&IXGBE_RXDADV_ERR_IPE);
    eval 'sub IXGBE_RXD_VLAN_ID_MASK () {0xfff;}' unless defined(&IXGBE_RXD_VLAN_ID_MASK);
    eval 'sub IXGBE_RXD_PRI_MASK () {0xe000;}' unless defined(&IXGBE_RXD_PRI_MASK);
    eval 'sub IXGBE_RXD_PRI_SHIFT () {13;}' unless defined(&IXGBE_RXD_PRI_SHIFT);
    eval 'sub IXGBE_RXD_CFI_MASK () {0x1000;}' unless defined(&IXGBE_RXD_CFI_MASK);
    eval 'sub IXGBE_RXD_CFI_SHIFT () {12;}' unless defined(&IXGBE_RXD_CFI_SHIFT);
    eval 'sub IXGBE_SRRCTL_BSIZEPKT_SHIFT () {10;}' unless defined(&IXGBE_SRRCTL_BSIZEPKT_SHIFT);
    eval 'sub IXGBE_SRRCTL_BSIZEPKT_MASK () {0x7f;}' unless defined(&IXGBE_SRRCTL_BSIZEPKT_MASK);
    eval 'sub IXGBE_SRRCTL_BSIZEHDR_MASK () {0x3f00;}' unless defined(&IXGBE_SRRCTL_BSIZEHDR_MASK);
    eval 'sub IXGBE_SRRCTL_DESCTYPE_LEGACY () {0x;}' unless defined(&IXGBE_SRRCTL_DESCTYPE_LEGACY);
    eval 'sub IXGBE_SRRCTL_DESCTYPE_ADV_ONEBUF () {0x2000000;}' unless defined(&IXGBE_SRRCTL_DESCTYPE_ADV_ONEBUF);
    eval 'sub IXGBE_SRRCTL_DESCTYPE_HDR_SPLIT () {0x4000000;}' unless defined(&IXGBE_SRRCTL_DESCTYPE_HDR_SPLIT);
    eval 'sub IXGBE_SRRCTL_DESCTYPE_HDR_REPLICATION_LARGE_PKT () {0x8000000;}' unless defined(&IXGBE_SRRCTL_DESCTYPE_HDR_REPLICATION_LARGE_PKT);
    eval 'sub IXGBE_SRRCTL_DESCTYPE_HDR_SPLIT_ALWAYS () {0xa000000;}' unless defined(&IXGBE_SRRCTL_DESCTYPE_HDR_SPLIT_ALWAYS);
    eval 'sub IXGBE_SRRCTL_DESCTYPE_MASK () {0xe000000;}' unless defined(&IXGBE_SRRCTL_DESCTYPE_MASK);
    eval 'sub IXGBE_RXDPS_HDRSTAT_HDRSP () {0x8000;}' unless defined(&IXGBE_RXDPS_HDRSTAT_HDRSP);
    eval 'sub IXGBE_RXDPS_HDRSTAT_HDRLEN_MASK () {0x3ff;}' unless defined(&IXGBE_RXDPS_HDRSTAT_HDRLEN_MASK);
    eval 'sub IXGBE_RXDADV_RSSTYPE_MASK () {0xf;}' unless defined(&IXGBE_RXDADV_RSSTYPE_MASK);
    eval 'sub IXGBE_RXDADV_PKTTYPE_MASK () {0xfff0;}' unless defined(&IXGBE_RXDADV_PKTTYPE_MASK);
    eval 'sub IXGBE_RXDADV_HDRBUFLEN_MASK () {0x7fe0;}' unless defined(&IXGBE_RXDADV_HDRBUFLEN_MASK);
    eval 'sub IXGBE_RXDADV_HDRBUFLEN_SHIFT () {5;}' unless defined(&IXGBE_RXDADV_HDRBUFLEN_SHIFT);
    eval 'sub IXGBE_RXDADV_SPLITHEADER_EN () {0x1000;}' unless defined(&IXGBE_RXDADV_SPLITHEADER_EN);
    eval 'sub IXGBE_RXDADV_SPH () {0x8000;}' unless defined(&IXGBE_RXDADV_SPH);
    eval 'sub IXGBE_RXDADV_RSSTYPE_NONE () {0x;}' unless defined(&IXGBE_RXDADV_RSSTYPE_NONE);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV4_TCP () {0x1;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV4_TCP);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV4 () {0x2;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV4);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV6_TCP () {0x3;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV6_TCP);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV6_EX () {0x4;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV6_EX);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV6 () {0x5;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV6);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV6_TCP_EX () {0x6;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV6_TCP_EX);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV4_UDP () {0x7;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV4_UDP);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV6_UDP () {0x8;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV6_UDP);
    eval 'sub IXGBE_RXDADV_RSSTYPE_IPV6_UDP_EX () {0x9;}' unless defined(&IXGBE_RXDADV_RSSTYPE_IPV6_UDP_EX);
    eval 'sub IXGBE_RXDADV_PKTTYPE_NONE () {0x;}' unless defined(&IXGBE_RXDADV_PKTTYPE_NONE);
    eval 'sub IXGBE_RXDADV_PKTTYPE_IPV4 () {0x10;}' unless defined(&IXGBE_RXDADV_PKTTYPE_IPV4);
    eval 'sub IXGBE_RXDADV_PKTTYPE_IPV4_EX () {0x20;}' unless defined(&IXGBE_RXDADV_PKTTYPE_IPV4_EX);
    eval 'sub IXGBE_RXDADV_PKTTYPE_IPV6 () {0x40;}' unless defined(&IXGBE_RXDADV_PKTTYPE_IPV6);
    eval 'sub IXGBE_RXDADV_PKTTYPE_IPV6_EX () {0x80;}' unless defined(&IXGBE_RXDADV_PKTTYPE_IPV6_EX);
    eval 'sub IXGBE_RXDADV_PKTTYPE_TCP () {0x100;}' unless defined(&IXGBE_RXDADV_PKTTYPE_TCP);
    eval 'sub IXGBE_RXDADV_PKTTYPE_UDP () {0x200;}' unless defined(&IXGBE_RXDADV_PKTTYPE_UDP);
    eval 'sub IXGBE_RXDADV_PKTTYPE_SCTP () {0x400;}' unless defined(&IXGBE_RXDADV_PKTTYPE_SCTP);
    eval 'sub IXGBE_RXDADV_PKTTYPE_NFS () {0x800;}' unless defined(&IXGBE_RXDADV_PKTTYPE_NFS);
    eval 'sub IXGBE_RXD_ERR_FRAME_ERR_MASK () {(  &IXGBE_RXD_ERR_CE |  &IXGBE_RXD_ERR_LE |  &IXGBE_RXD_ERR_PE |  &IXGBE_RXD_ERR_OSE |  &IXGBE_RXD_ERR_USE);}' unless defined(&IXGBE_RXD_ERR_FRAME_ERR_MASK);
    eval 'sub IXGBE_RXDADV_ERR_FRAME_ERR_MASK () {(  &IXGBE_RXDADV_ERR_CE |  &IXGBE_RXDADV_ERR_LE |  &IXGBE_RXDADV_ERR_PE |  &IXGBE_RXDADV_ERR_OSE |  &IXGBE_RXDADV_ERR_USE);}' unless defined(&IXGBE_RXDADV_ERR_FRAME_ERR_MASK);
    eval 'sub IXGBE_MCSTCTRL_MFE () {0x4;}' unless defined(&IXGBE_MCSTCTRL_MFE);
    eval 'sub IXGBE_REQ_TX_DESCRIPTOR_MULTIPLE () {8;}' unless defined(&IXGBE_REQ_TX_DESCRIPTOR_MULTIPLE);
    eval 'sub IXGBE_REQ_RX_DESCRIPTOR_MULTIPLE () {8;}' unless defined(&IXGBE_REQ_RX_DESCRIPTOR_MULTIPLE);
    eval 'sub IXGBE_REQ_TX_BUFFER_GRANULARITY () {1024;}' unless defined(&IXGBE_REQ_TX_BUFFER_GRANULARITY);
    eval 'sub IXGBE_RX_DESC_SPECIAL_VLAN_MASK () {0xfff;}' unless defined(&IXGBE_RX_DESC_SPECIAL_VLAN_MASK);
    eval 'sub IXGBE_RX_DESC_SPECIAL_PRI_MASK () {0xe000;}' unless defined(&IXGBE_RX_DESC_SPECIAL_PRI_MASK);
    eval 'sub IXGBE_RX_DESC_SPECIAL_PRI_SHIFT () {0xd;}' unless defined(&IXGBE_RX_DESC_SPECIAL_PRI_SHIFT);
    eval 'sub IXGBE_TX_DESC_SPECIAL_PRI_SHIFT () { &IXGBE_RX_DESC_SPECIAL_PRI_SHIFT;}' unless defined(&IXGBE_TX_DESC_SPECIAL_PRI_SHIFT);
    unless(defined(&__le16)) {
	eval 'sub __le8 () { &uint8_t;}' unless defined(&__le8);
	eval 'sub __le16 () { &uint16_t;}' unless defined(&__le16);
	eval 'sub __le32 () { &uint32_t;}' unless defined(&__le32);
	eval 'sub __le64 () { &uint64_t;}' unless defined(&__le64);
    }
    eval 'sub IXGBE_ADVTXD_DTALEN_MASK () {0xffff;}' unless defined(&IXGBE_ADVTXD_DTALEN_MASK);
    eval 'sub IXGBE_ADVTXD_DTYP_MASK () {0xf00000;}' unless defined(&IXGBE_ADVTXD_DTYP_MASK);
    eval 'sub IXGBE_ADVTXD_DTYP_CTXT () {0x200000;}' unless defined(&IXGBE_ADVTXD_DTYP_CTXT);
    eval 'sub IXGBE_ADVTXD_DTYP_DATA () {0x300000;}' unless defined(&IXGBE_ADVTXD_DTYP_DATA);
    eval 'sub IXGBE_ADVTXD_DCMD_EOP () { &IXGBE_TXD_CMD_EOP;}' unless defined(&IXGBE_ADVTXD_DCMD_EOP);
    eval 'sub IXGBE_ADVTXD_DCMD_IFCS () { &IXGBE_TXD_CMD_IFCS;}' unless defined(&IXGBE_ADVTXD_DCMD_IFCS);
    eval 'sub IXGBE_ADVTXD_DCMD_RS () { &IXGBE_TXD_CMD_RS;}' unless defined(&IXGBE_ADVTXD_DCMD_RS);
    eval 'sub IXGBE_ADVTXD_DCMD_DDTYP_ISCSI () {0x10000000;}' unless defined(&IXGBE_ADVTXD_DCMD_DDTYP_ISCSI);
    eval 'sub IXGBE_ADVTXD_DCMD_DEXT () { &IXGBE_TXD_CMD_DEXT;}' unless defined(&IXGBE_ADVTXD_DCMD_DEXT);
    eval 'sub IXGBE_ADVTXD_DCMD_VLE () { &IXGBE_TXD_CMD_VLE;}' unless defined(&IXGBE_ADVTXD_DCMD_VLE);
    eval 'sub IXGBE_ADVTXD_DCMD_TSE () {0x80000000;}' unless defined(&IXGBE_ADVTXD_DCMD_TSE);
    eval 'sub IXGBE_ADVTXD_STAT_DD () { &IXGBE_TXD_STAT_DD;}' unless defined(&IXGBE_ADVTXD_STAT_DD);
    eval 'sub IXGBE_ADVTXD_STAT_SN_CRC () {0x2;}' unless defined(&IXGBE_ADVTXD_STAT_SN_CRC);
    eval 'sub IXGBE_ADVTXD_STAT_RSV () {0xc;}' unless defined(&IXGBE_ADVTXD_STAT_RSV);
    eval 'sub IXGBE_ADVTXD_IDX_SHIFT () {4;}' unless defined(&IXGBE_ADVTXD_IDX_SHIFT);
    eval 'sub IXGBE_ADVTXD_CC () {0x80;}' unless defined(&IXGBE_ADVTXD_CC);
    eval 'sub IXGBE_ADVTXD_POPTS_SHIFT () {8;}' unless defined(&IXGBE_ADVTXD_POPTS_SHIFT);
    eval 'sub IXGBE_ADVTXD_POPTS_IXSM () {( &IXGBE_TXD_POPTS_IXSM <<  &IXGBE_ADVTXD_POPTS_SHIFT);}' unless defined(&IXGBE_ADVTXD_POPTS_IXSM);
    eval 'sub IXGBE_ADVTXD_POPTS_TXSM () {( &IXGBE_TXD_POPTS_TXSM <<  &IXGBE_ADVTXD_POPTS_SHIFT);}' unless defined(&IXGBE_ADVTXD_POPTS_TXSM);
    eval 'sub IXGBE_ADVTXD_POPTS_ISCO_1ST () {0x;}' unless defined(&IXGBE_ADVTXD_POPTS_ISCO_1ST);
    eval 'sub IXGBE_ADVTXD_POPTS_ISCO_MDL () {0x800;}' unless defined(&IXGBE_ADVTXD_POPTS_ISCO_MDL);
    eval 'sub IXGBE_ADVTXD_POPTS_ISCO_LAST () {0x1000;}' unless defined(&IXGBE_ADVTXD_POPTS_ISCO_LAST);
    eval 'sub IXGBE_ADVTXD_POPTS_ISCO_FULL () {0x1800;}' unless defined(&IXGBE_ADVTXD_POPTS_ISCO_FULL);
    eval 'sub IXGBE_ADVTXD_POPTS_RSV () {0x2000;}' unless defined(&IXGBE_ADVTXD_POPTS_RSV);
    eval 'sub IXGBE_ADVTXD_PAYLEN_SHIFT () {14;}' unless defined(&IXGBE_ADVTXD_PAYLEN_SHIFT);
    eval 'sub IXGBE_ADVTXD_MACLEN_SHIFT () {9;}' unless defined(&IXGBE_ADVTXD_MACLEN_SHIFT);
    eval 'sub IXGBE_ADVTXD_VLAN_SHIFT () {16;}' unless defined(&IXGBE_ADVTXD_VLAN_SHIFT);
    eval 'sub IXGBE_ADVTXD_TUCMD_IPV4 () {0x400;}' unless defined(&IXGBE_ADVTXD_TUCMD_IPV4);
    eval 'sub IXGBE_ADVTXD_TUCMD_IPV6 () {0x;}' unless defined(&IXGBE_ADVTXD_TUCMD_IPV6);
    eval 'sub IXGBE_ADVTXD_TUCMD_L4T_UDP () {0x;}' unless defined(&IXGBE_ADVTXD_TUCMD_L4T_UDP);
    eval 'sub IXGBE_ADVTXD_TUCMD_L4T_TCP () {0x800;}' unless defined(&IXGBE_ADVTXD_TUCMD_L4T_TCP);
    eval 'sub IXGBE_ADVTXD_TUCMD_L4T_SCTP () {0x1000;}' unless defined(&IXGBE_ADVTXD_TUCMD_L4T_SCTP);
    eval 'sub IXGBE_ADVTXD_TUCMD_MKRREQ () {0x2000;}' unless defined(&IXGBE_ADVTXD_TUCMD_MKRREQ);
    eval 'sub IXGBE_ADVTXD_L4LEN_SHIFT () {8;}' unless defined(&IXGBE_ADVTXD_L4LEN_SHIFT);
    eval 'sub IXGBE_ADVTXD_MSS_SHIFT () {16;}' unless defined(&IXGBE_ADVTXD_MSS_SHIFT);
    eval 'sub IXGBE_LINK_SPEED_UNKNOWN () {0;}' unless defined(&IXGBE_LINK_SPEED_UNKNOWN);
    eval 'sub IXGBE_LINK_SPEED_100_FULL () {0x8;}' unless defined(&IXGBE_LINK_SPEED_100_FULL);
    eval 'sub IXGBE_LINK_SPEED_1GB_FULL () {0x20;}' unless defined(&IXGBE_LINK_SPEED_1GB_FULL);
    eval 'sub IXGBE_LINK_SPEED_10GB_FULL () {0x80;}' unless defined(&IXGBE_LINK_SPEED_10GB_FULL);
    eval 'sub IXGBE_LINK_SPEED_82598_AUTONEG () {( &IXGBE_LINK_SPEED_1GB_FULL |  &IXGBE_LINK_SPEED_10GB_FULL);}' unless defined(&IXGBE_LINK_SPEED_82598_AUTONEG);
    eval("sub ixgbe_eeprom_uninitialized () { 0; }") unless defined(&ixgbe_eeprom_uninitialized);
    eval("sub ixgbe_eeprom_spi () { 1; }") unless defined(&ixgbe_eeprom_spi);
    eval("sub ixgbe_eeprom_none () { 2; }") unless defined(&ixgbe_eeprom_none);
    eval("sub ixgbe_mac_unknown () { 0; }") unless defined(&ixgbe_mac_unknown);
    eval("sub ixgbe_mac_82598EB () { 1; }") unless defined(&ixgbe_mac_82598EB);
    eval("sub ixgbe_num_macs () { 2; }") unless defined(&ixgbe_num_macs);
    eval("sub ixgbe_phy_unknown () { 0; }") unless defined(&ixgbe_phy_unknown);
    eval("sub ixgbe_phy_tn () { 1; }") unless defined(&ixgbe_phy_tn);
    eval("sub ixgbe_phy_qt () { 2; }") unless defined(&ixgbe_phy_qt);
    eval("sub ixgbe_phy_xaui () { 3; }") unless defined(&ixgbe_phy_xaui);
    eval("sub ixgbe_phy_nl () { 4; }") unless defined(&ixgbe_phy_nl);
    eval("sub ixgbe_phy_generic () { 5; }") unless defined(&ixgbe_phy_generic);
    eval("sub ixgbe_media_type_unknown () { 0; }") unless defined(&ixgbe_media_type_unknown);
    eval("sub ixgbe_media_type_fiber () { 1; }") unless defined(&ixgbe_media_type_fiber);
    eval("sub ixgbe_media_type_copper () { 2; }") unless defined(&ixgbe_media_type_copper);
    eval("sub ixgbe_media_type_backplane () { 3; }") unless defined(&ixgbe_media_type_backplane);
    eval("sub ixgbe_media_type_virtual () { 4; }") unless defined(&ixgbe_media_type_virtual);
    eval("sub ixgbe_fc_none () { 0; }") unless defined(&ixgbe_fc_none);
    eval("sub ixgbe_fc_rx_pause () { 1; }") unless defined(&ixgbe_fc_rx_pause);
    eval("sub ixgbe_fc_tx_pause () { 2; }") unless defined(&ixgbe_fc_tx_pause);
    eval("sub ixgbe_fc_full () { 3; }") unless defined(&ixgbe_fc_full);
    eval("sub ixgbe_fc_default () { 4; }") unless defined(&ixgbe_fc_default);
    eval("sub ixgbe_bus_type_unknown () { 0; }") unless defined(&ixgbe_bus_type_unknown);
    eval("sub ixgbe_bus_type_pci () { 1; }") unless defined(&ixgbe_bus_type_pci);
    eval("sub ixgbe_bus_type_pcix () { 2; }") unless defined(&ixgbe_bus_type_pcix);
    eval("sub ixgbe_bus_type_pci_express () { 3; }") unless defined(&ixgbe_bus_type_pci_express);
    eval("sub ixgbe_bus_type_reserved () { 4; }") unless defined(&ixgbe_bus_type_reserved);
    eval("sub ixgbe_bus_speed_unknown () { 0; }") unless defined(&ixgbe_bus_speed_unknown);
    eval("sub ixgbe_bus_speed_33 () { 1; }") unless defined(&ixgbe_bus_speed_33);
    eval("sub ixgbe_bus_speed_66 () { 2; }") unless defined(&ixgbe_bus_speed_66);
    eval("sub ixgbe_bus_speed_100 () { 3; }") unless defined(&ixgbe_bus_speed_100);
    eval("sub ixgbe_bus_speed_120 () { 4; }") unless defined(&ixgbe_bus_speed_120);
    eval("sub ixgbe_bus_speed_133 () { 5; }") unless defined(&ixgbe_bus_speed_133);
    eval("sub ixgbe_bus_speed_2500 () { 6; }") unless defined(&ixgbe_bus_speed_2500);
    eval("sub ixgbe_bus_speed_5000 () { 7; }") unless defined(&ixgbe_bus_speed_5000);
    eval("sub ixgbe_bus_speed_reserved () { 8; }") unless defined(&ixgbe_bus_speed_reserved);
    eval("sub ixgbe_bus_width_unknown () { 0; }") unless defined(&ixgbe_bus_width_unknown);
    eval("sub ixgbe_bus_width_pcie_x1 () { 1; }") unless defined(&ixgbe_bus_width_pcie_x1);
    eval("sub ixgbe_bus_width_pcie_x2 () { 2; }") unless defined(&ixgbe_bus_width_pcie_x2);
    eval("sub ixgbe_bus_width_pcie_x4 () { 4; }") unless defined(&ixgbe_bus_width_pcie_x4);
    eval("sub ixgbe_bus_width_pcie_x8 () { 8; }") unless defined(&ixgbe_bus_width_pcie_x8);
    eval("sub ixgbe_bus_width_32 () { 9; }") unless defined(&ixgbe_bus_width_32);
    eval("sub ixgbe_bus_width_64 () { 10; }") unless defined(&ixgbe_bus_width_64);
    eval("sub ixgbe_bus_width_reserved () { 11; }") unless defined(&ixgbe_bus_width_reserved);
    eval 'sub ixgbe_hw () {( &hw,  &func, ...) (( &hw)-> ($mac->{ops}->{func}) !=  &NULL) ? ( &hw)-> ($mac->{ops}->{func})( &hw,  &__VA_ARGS__) :  &IXGBE_NOT_IMPLEMENTED;}' unless defined(&ixgbe_hw);
    eval 'sub ixgbe_ee () {( &hw,  &func, ...) (( &hw)-> ($eeprom->{ops}->{func}) !=  &NULL) ? ( &hw)-> ($eeprom->{ops}->{func})( &hw,  &__VA_ARGS__) :  &IXGBE_NOT_IMPLEMENTED;}' unless defined(&ixgbe_ee);
    eval 'sub IXGBE_SUCCESS () {0;}' unless defined(&IXGBE_SUCCESS);
    eval 'sub IXGBE_ERR_EEPROM () {-1;}' unless defined(&IXGBE_ERR_EEPROM);
    eval 'sub IXGBE_ERR_EEPROM_CHECKSUM () {-2;}' unless defined(&IXGBE_ERR_EEPROM_CHECKSUM);
    eval 'sub IXGBE_ERR_PHY () {-3;}' unless defined(&IXGBE_ERR_PHY);
    eval 'sub IXGBE_ERR_CONFIG () {-4;}' unless defined(&IXGBE_ERR_CONFIG);
    eval 'sub IXGBE_ERR_PARAM () {-5;}' unless defined(&IXGBE_ERR_PARAM);
    eval 'sub IXGBE_ERR_MAC_TYPE () {-6;}' unless defined(&IXGBE_ERR_MAC_TYPE);
    eval 'sub IXGBE_ERR_UNKNOWN_PHY () {-7;}' unless defined(&IXGBE_ERR_UNKNOWN_PHY);
    eval 'sub IXGBE_ERR_LINK_SETUP () {-8;}' unless defined(&IXGBE_ERR_LINK_SETUP);
    eval 'sub IXGBE_ERR_ADAPTER_STOPPED () {-9;}' unless defined(&IXGBE_ERR_ADAPTER_STOPPED);
    eval 'sub IXGBE_ERR_INVALID_MAC_ADDR () {-10;}' unless defined(&IXGBE_ERR_INVALID_MAC_ADDR);
    eval 'sub IXGBE_ERR_DEVICE_NOT_SUPPORTED () {-11;}' unless defined(&IXGBE_ERR_DEVICE_NOT_SUPPORTED);
    eval 'sub IXGBE_ERR_MASTER_REQUESTS_PENDING () {-12;}' unless defined(&IXGBE_ERR_MASTER_REQUESTS_PENDING);
    eval 'sub IXGBE_ERR_INVALID_LINK_SETTINGS () {-13;}' unless defined(&IXGBE_ERR_INVALID_LINK_SETTINGS);
    eval 'sub IXGBE_ERR_AUTONEG_NOT_COMPLETE () {-14;}' unless defined(&IXGBE_ERR_AUTONEG_NOT_COMPLETE);
    eval 'sub IXGBE_ERR_RESET_FAILED () {-15;}' unless defined(&IXGBE_ERR_RESET_FAILED);
    eval 'sub IXGBE_ERR_SWFW_SYNC () {-16;}' unless defined(&IXGBE_ERR_SWFW_SYNC);
    eval 'sub IXGBE_ERR_PHY_ADDR_INVALID () {-17;}' unless defined(&IXGBE_ERR_PHY_ADDR_INVALID);
    eval 'sub IXGBE_NOT_IMPLEMENTED () {0x7fffffff;}' unless defined(&IXGBE_NOT_IMPLEMENTED);
    eval 'sub UNREFERENCED_PARAMETER {
        my($_p) = @_;
	    eval q();
    }' unless defined(&UNREFERENCED_PARAMETER);
}
1;
