require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ISP_OPENBSD_H)) {
    eval 'sub _ISP_OPENBSD_H () {1;}' unless defined(&_ISP_OPENBSD_H);
    require 'sys/types.ph';
    require 'sys/param.ph';
    require 'sys/systm.ph';
    require 'sys/kernel.ph';
    require 'sys/errno.ph';
    require 'sys/ioctl.ph';
    require 'sys/device.ph';
    require 'sys/malloc.ph';
    require 'sys/buf.ph';
    require 'sys/proc.ph';
    require 'sys/user.ph';
    require 'sys/queue.ph';
    if(!(defined( &__sparc__)  && !defined( &__sparcv9__))) {
	require 'machine/bus.ph';
    }
    require 'scsi/scsi_all.ph';
    require 'scsi/scsiconf.ph';
    require 'scsi/scsi_message.ph';
    require 'scsi/scsi_debug.ph';
    require 'uvm/uvm_extern.ph';
    if(defined( &__sparcv9__ ) || defined( &__sparc__)) {
	eval 'sub ISP_SBUS_SUPPORTED () {1;}' unless defined(&ISP_SBUS_SUPPORTED);
    } else {
	eval 'sub ISP_SBUS_SUPPORTED () {0;}' unless defined(&ISP_SBUS_SUPPORTED);
    }
    eval 'sub ISP_PLATFORM_VERSION_MAJOR () {5;}' unless defined(&ISP_PLATFORM_VERSION_MAJOR);
    eval 'sub ISP_PLATFORM_VERSION_MINOR () {9;}' unless defined(&ISP_PLATFORM_VERSION_MINOR);
    if(!(defined( &__sparc__)  && !defined( &__sparcv9__))) {
	eval 'sub isp_dmatag () { ($isp_osinfo->{dmatag});}' unless defined(&isp_dmatag);
	eval 'sub isp_cdmap () { ($isp_osinfo->{cdmap});}' unless defined(&isp_cdmap);
	eval 'sub isp_bus_tag () { ($isp_osinfo->{bus_tag});}' unless defined(&isp_bus_tag);
	eval 'sub isp_bus_handle () { ($isp_osinfo->{bus_handle});}' unless defined(&isp_bus_handle);
    }
    eval 'sub discovered () { ($un->{_discovered});}' unless defined(&discovered);
    eval 'sub MUST_POLL {
        my($isp) = @_;
	    eval q(( ($isp->{isp_osinfo}->{onintstack}) ||  ($isp->{isp_osinfo}->{no_mbox_ints})));
    }' unless defined(&MUST_POLL);
    eval 'sub ISP_LOCK () { &isp_lock;}' unless defined(&ISP_LOCK);
    eval 'sub ISP_UNLOCK () { &isp_unlock;}' unless defined(&ISP_UNLOCK);
    eval 'sub ISP2100_SCRLEN () {0x1000;}' unless defined(&ISP2100_SCRLEN);
    eval 'sub MEMZERO () { &bzero;}' unless defined(&MEMZERO);
    eval 'sub MEMCPY {
        my($dst, $src, $amt) = @_;
	    eval q( &bcopy(($src), ($dst), ($amt)));
    }' unless defined(&MEMCPY);
    eval 'sub SNPRINTF () { &snprintf;}' unless defined(&SNPRINTF);
    eval 'sub USEC_DELAY () { &isp_delay;}' unless defined(&USEC_DELAY);
    eval 'sub USEC_SLEEP {
        my($isp, $x) = @_;
	    eval q( &delay($x));
    }' unless defined(&USEC_SLEEP);
    eval 'sub NANOTIME_T () {\'struct timespec\';}' unless defined(&NANOTIME_T);
    eval 'sub GET_NANOTIME {
        my($x) = @_;
	    eval q(*($x) =  &isp_nanotime);
    }' unless defined(&GET_NANOTIME);
    eval 'sub GET_NANOSEC {
        my($x) = @_;
	    eval q(((($x)-> &tv_sec * 1000000000+ ($x)-> &tv_nsec)));
    }' unless defined(&GET_NANOSEC);
    eval 'sub NANOTIME_SUB () { &isp_nanotime_sub;}' unless defined(&NANOTIME_SUB);
    eval 'sub MAXISPREQUEST {
        my($isp) = @_;
	    eval q((( &IS_FC($isp) ||  &IS_ULTRA2($isp))? 1024: 256));
    }' unless defined(&MAXISPREQUEST);
    if(!(defined( &__sparc__)  && !defined( &__sparcv9__))) {
	eval 'sub MEMORYBARRIER {
	    my($isp, $type, $offset, $size) = @_;
    	    eval q( &switch ($type) {  &case  &SYNC_REQUEST: {  &off_t  &off = ( &off_t) $offset *  &QENTRY_LEN;  &bus_dmamap_sync( ($isp->{isp_dmatag}),  ($isp->{isp_cdmap}),  &off, $size,  &BUS_DMASYNC_PREWRITE);  &break; }  &case  &SYNC_RESULT: {  &off_t  &off = ( &off_t) $offset *  &QENTRY_LEN +  &ISP_QUEUE_SIZE( &RQUEST_QUEUE_LEN($isp));  &bus_dmamap_sync( ($isp->{isp_dmatag}),  ($isp->{isp_cdmap}),  &off, $size,  &BUS_DMASYNC_POSTREAD);  &break; }  &case  &SYNC_SFORDEV: {  &off_t  &off = ( &off_t) $offset;  &bus_dmamap_sync( ($isp->{isp_dmatag}),  ($isp->{isp_cdmap}),  &off, $size,  &BUS_DMASYNC_PREWRITE);  &break; }  &case  &SYNC_SFORCPU: {  &off_t  &off = ( &off_t) $offset;  &bus_dmamap_sync( ($isp->{isp_dmatag}),  ($isp->{isp_cdmap}),  &off, $size,  &BUS_DMASYNC_POSTREAD);  &break; }  &case  &SYNC_REG:  &bus_space_barrier( ($isp->{isp_bus_tag}),  ($isp->{isp_bus_handle}), $offset, $size,  &BUS_SPACE_BARRIER_READ);  &break;  &default:  &break; });
	}' unless defined(&MEMORYBARRIER);
    } else {
	eval 'sub MEMORYBARRIER {
	    my($isp, $type, $offset, $size) = @_;
    	    eval q();
	}' unless defined(&MEMORYBARRIER);
    }
    eval 'sub MBOX_ACQUIRE () { &isp_mbox_acquire;}' unless defined(&MBOX_ACQUIRE);
    eval 'sub MBOX_WAIT_COMPLETE () { &isp_mbox_wait_complete;}' unless defined(&MBOX_WAIT_COMPLETE);
    eval 'sub MBOX_NOTIFY_COMPLETE () { &isp_mbox_notify_done;}' unless defined(&MBOX_NOTIFY_COMPLETE);
    eval 'sub MBOX_RELEASE () { &isp_mbox_release;}' unless defined(&MBOX_RELEASE);
    eval 'sub FC_SCRATCH_ACQUIRE {
        my($isp) = @_;
	    eval q( &if ( ($isp->{isp_osinfo}->{fcbsy})) {  &isp_prt($isp,  &ISP_LOGWARN, \\"FC scratch area busy (line %d)!\\",  &__LINE__); }  &else  ($isp->{isp_osinfo}->{fcbsy}) = 1);
    }' unless defined(&FC_SCRATCH_ACQUIRE);
    eval 'sub FC_SCRATCH_RELEASE {
        my($isp) = @_;
	    eval q( ($isp->{isp_osinfo}->{fcbsy}) = 0);
    }' unless defined(&FC_SCRATCH_RELEASE);
    unless(defined(&SCSI_GOOD)) {
	eval 'sub SCSI_GOOD () {0x;}' unless defined(&SCSI_GOOD);
    }
    unless(defined(&SCSI_CHECK)) {
	eval 'sub SCSI_CHECK () {0x2;}' unless defined(&SCSI_CHECK);
    }
    unless(defined(&SCSI_BUSY)) {
	eval 'sub SCSI_BUSY () {0x8;}' unless defined(&SCSI_BUSY);
    }
    unless(defined(&SCSI_QFULL)) {
	eval 'sub SCSI_QFULL () {0x28;}' unless defined(&SCSI_QFULL);
    }
    eval 'sub XS_T () {\'struct scsi_xfer\';}' unless defined(&XS_T);
    if(!(defined( &__sparc__)  && !defined( &__sparcv9__))) {
	eval 'sub XS_DMA_ADDR_T () { &bus_addr_t;}' unless defined(&XS_DMA_ADDR_T);
    } else {
	eval 'sub XS_DMA_ADDR_T () { &u_int32_t;}' unless defined(&XS_DMA_ADDR_T);
    }
    eval 'sub XS_CHANNEL {
        my($xs) = @_;
	    eval q(((($xs)-> ($sc_link->{flags}) &  &SDEV_2NDBUS)? 1: 0));
    }' unless defined(&XS_CHANNEL);
    eval 'sub XS_ISP {
        my($xs) = @_;
	    eval q(($xs)-> ($sc_link->{adapter_softc}));
    }' unless defined(&XS_ISP);
    eval 'sub XS_LUN {
        my($xs) = @_;
	    eval q(( ($xs)-> ($sc_link->{lun})));
    }' unless defined(&XS_LUN);
    eval 'sub XS_TGT {
        my($xs) = @_;
	    eval q(( ($xs)-> ($sc_link->{target})));
    }' unless defined(&XS_TGT);
    eval 'sub XS_CDBP {
        my($xs) = @_;
	    eval q(( ($xs)-> &cmd));
    }' unless defined(&XS_CDBP);
    eval 'sub XS_CDBLEN {
        my($xs) = @_;
	    eval q(($xs)-> &cmdlen);
    }' unless defined(&XS_CDBLEN);
    eval 'sub XS_XFRLEN {
        my($xs) = @_;
	    eval q(($xs)-> &datalen);
    }' unless defined(&XS_XFRLEN);
    eval 'sub XS_TIME {
        my($xs) = @_;
	    eval q(($xs)-> &timeout);
    }' unless defined(&XS_TIME);
    eval 'sub XS_RESID {
        my($xs) = @_;
	    eval q(($xs)-> &resid);
    }' unless defined(&XS_RESID);
    eval 'sub XS_STSP {
        my($xs) = @_;
	    eval q((($xs)-> &status));
    }' unless defined(&XS_STSP);
    eval 'sub XS_SNSP {
        my($xs) = @_;
	    eval q((($xs)-> &sense));
    }' unless defined(&XS_SNSP);
    eval 'sub XS_SNSLEN {
        my($xs) = @_;
	    eval q(($sizeof{$xs}-> &sense));
    }' unless defined(&XS_SNSLEN);
    eval 'sub XS_SNSKEY {
        my($xs) = @_;
	    eval q((($xs)-> ($sense->{flags})));
    }' unless defined(&XS_SNSKEY);
    eval 'sub XS_TAG_P {
        my($xs) = @_;
	    eval q(((($xs)-> &flags &  &SCSI_POLL) != 0));
    }' unless defined(&XS_TAG_P);
    eval 'sub XS_TAG_TYPE {
        my($xs) = @_;
	    eval q( &REQFLAG_STAG);
    }' unless defined(&XS_TAG_TYPE);
    eval 'sub XS_SETERR {
        my($xs, $v) = @_;
	    eval q(($xs)-> &error = $v);
    }' unless defined(&XS_SETERR);
    eval 'sub HBA_NOERROR () { &XS_NOERROR;}' unless defined(&HBA_NOERROR);
    eval 'sub HBA_BOTCH () { &XS_DRIVER_STUFFUP;}' unless defined(&HBA_BOTCH);
    eval 'sub HBA_CMDTIMEOUT () { &XS_TIMEOUT;}' unless defined(&HBA_CMDTIMEOUT);
    eval 'sub HBA_SELTIMEOUT () { &XS_SELTIMEOUT;}' unless defined(&HBA_SELTIMEOUT);
    eval 'sub HBA_TGTBSY () { &XS_BUSY;}' unless defined(&HBA_TGTBSY);
    eval 'sub HBA_BUSRESET () { &XS_RESET;}' unless defined(&HBA_BUSRESET);
    eval 'sub HBA_ABORTED () { &XS_DRIVER_STUFFUP;}' unless defined(&HBA_ABORTED);
    eval 'sub HBA_DATAOVR () { &XS_DRIVER_STUFFUP;}' unless defined(&HBA_DATAOVR);
    eval 'sub HBA_ARQFAIL () { &XS_DRIVER_STUFFUP;}' unless defined(&HBA_ARQFAIL);
    eval 'sub XS_ERR {
        my($xs) = @_;
	    eval q(($xs)-> &error);
    }' unless defined(&XS_ERR);
    eval 'sub XS_NOERR {
        my($xs) = @_;
	    eval q(($xs)-> &error ==  &XS_NOERROR);
    }' unless defined(&XS_NOERR);
    eval 'sub XS_INITERR {
        my($xs) = @_;
	    eval q(($xs)-> &error = 0,  &XS_CMD_S_CLEAR($xs));
    }' unless defined(&XS_INITERR);
    eval 'sub XS_SAVE_SENSE {
        my($xs, $sp, $len) = @_;
	    eval q( &if ( ($xs->{error}) ==  &XS_NOERROR) {  ($xs->{error}) =  &XS_SENSE; }  &bcopy($sp, ($xs)-> &sense,  &imin( &XS_SNSLEN($xs), $len)));
    }' unless defined(&XS_SAVE_SENSE);
    eval 'sub XS_SET_STATE_STAT {
        my($a, $b, $c) = @_;
	    eval q();
    }' unless defined(&XS_SET_STATE_STAT);
    eval 'sub DEFAULT_IID {
        my($isp) = @_;
	    eval q(($isp)-> ($isp_osinfo->{_iid}));
    }' unless defined(&DEFAULT_IID);
    eval 'sub DEFAULT_LOOPID {
        my($x) = @_;
	    eval q(107);
    }' unless defined(&DEFAULT_LOOPID);
    eval 'sub DEFAULT_NODEWWN {
        my($isp) = @_;
	    eval q(($isp)-> ($isp_osinfo->{un}->{_wwn}));
    }' unless defined(&DEFAULT_NODEWWN);
    eval 'sub DEFAULT_PORTWWN {
        my($isp) = @_;
	    eval q(($isp)-> ($isp_osinfo->{un}->{_wwn}));
    }' unless defined(&DEFAULT_PORTWWN);
    eval 'sub ISP_NODEWWN {
        my($isp) = @_;
	    eval q( &FCPARAM($isp)-> &isp_wwnn_nvram);
    }' unless defined(&ISP_NODEWWN);
    eval 'sub ISP_PORTWWN {
        my($isp) = @_;
	    eval q( &FCPARAM($isp)-> &isp_wwpn_nvram);
    }' unless defined(&ISP_PORTWWN);
    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
	if(defined(&ISP_SBUS_SUPPORTED)) {
	    eval 'sub ISP_IOXPUT_8 {
	        my($isp, $s, $d) = @_;
    		eval q(*($d) = $s);
	    }' unless defined(&ISP_IOXPUT_8);
	    eval 'sub ISP_IOXPUT_16 {
	        my($isp, $s, $d) = @_;
    		eval q(*($d) = ( ($i$sp->{i$sp_bustype}) ==  &ISP_BT_SBUS)? $s :  &swap16($s));
	    }' unless defined(&ISP_IOXPUT_16);
	    eval 'sub ISP_IOXPUT_32 {
	        my($isp, $s, $d) = @_;
    		eval q(*($d) = ( ($i$sp->{i$sp_bustype}) ==  &ISP_BT_SBUS)? $s :  &swap32($s));
	    }' unless defined(&ISP_IOXPUT_32);
	    eval 'sub ISP_IOXGET_8 {
	        my($isp, $s, $d) = @_;
    		eval q($d = (*(( &u_int8_t *)$s)));
	    }' unless defined(&ISP_IOXGET_8);
	    eval 'sub ISP_IOXGET_16 {
	        my($isp, $s, $d) = @_;
    		eval q($d = ( ($i$sp->{i$sp_bustype}) ==  &ISP_BT_SBUS)? *(( &u_int16_t *)$s) :  &swap16(*(( &u_int16_t *)$s)));
	    }' unless defined(&ISP_IOXGET_16);
	    eval 'sub ISP_IOXGET_32 {
	        my($isp, $s, $d) = @_;
    		eval q($d = ( ($i$sp->{i$sp_bustype}) ==  &ISP_BT_SBUS)? *(( &u_int32_t *)$s) :  &swap32(*(( &u_int32_t *)$s)));
	    }' unless defined(&ISP_IOXGET_32);
	} else {
	    eval 'sub ISP_IOXPUT_8 {
	        my($isp, $s, $d) = @_;
    		eval q(*($d) = $s);
	    }' unless defined(&ISP_IOXPUT_8);
	    eval 'sub ISP_IOXPUT_16 {
	        my($isp, $s, $d) = @_;
    		eval q(*($d) =  &swap16($s));
	    }' unless defined(&ISP_IOXPUT_16);
	    eval 'sub ISP_IOXPUT_32 {
	        my($isp, $s, $d) = @_;
    		eval q(*($d) =  &swap32($s));
	    }' unless defined(&ISP_IOXPUT_32);
	    eval 'sub ISP_IOXGET_8 {
	        my($isp, $s, $d) = @_;
    		eval q($d = (*(( &u_int8_t *)$s)));
	    }' unless defined(&ISP_IOXGET_8);
	    eval 'sub ISP_IOXGET_16 {
	        my($isp, $s, $d) = @_;
    		eval q($d =  &swap16(*(( &u_int16_t *)$s)));
	    }' unless defined(&ISP_IOXGET_16);
	    eval 'sub ISP_IOXGET_32 {
	        my($isp, $s, $d) = @_;
    		eval q($d =  &swap32(*(( &u_int32_t *)$s)));
	    }' unless defined(&ISP_IOXGET_32);
	}
	eval 'sub ISP_SWIZZLE_NVRAM_WORD {
	    my($isp, $rp) = @_;
    	    eval q(*$rp =  &swap16(*$rp));
	}' unless defined(&ISP_SWIZZLE_NVRAM_WORD);
	eval 'sub ISP_SWIZZLE_NVRAM_LONG {
	    my($isp, $rp) = @_;
    	    eval q(*$rp =  &swap32(*$rp));
	}' unless defined(&ISP_SWIZZLE_NVRAM_LONG);
	eval 'sub ISP_IOZGET_8 {
	    my($isp, $s, $d) = @_;
    	    eval q($d = (*(( &u_int8_t *)$s)));
	}' unless defined(&ISP_IOZGET_8);
	eval 'sub ISP_IOZGET_16 {
	    my($isp, $s, $d) = @_;
    	    eval q($d = (*(( &u_int16_t *)$s)));
	}' unless defined(&ISP_IOZGET_16);
	eval 'sub ISP_IOZGET_32 {
	    my($isp, $s, $d) = @_;
    	    eval q($d = (*(( &u_int32_t *)$s)));
	}' unless defined(&ISP_IOZGET_32);
	eval 'sub ISP_IOZPUT_8 {
	    my($isp, $s, $d) = @_;
    	    eval q(*($d) = $s);
	}' unless defined(&ISP_IOZPUT_8);
	eval 'sub ISP_IOZPUT_16 {
	    my($isp, $s, $d) = @_;
    	    eval q(*($d) = $s);
	}' unless defined(&ISP_IOZPUT_16);
	eval 'sub ISP_IOZPUT_32 {
	    my($isp, $s, $d) = @_;
    	    eval q(*($d) = $s);
	}' unless defined(&ISP_IOZPUT_32);
    } else {
	eval 'sub ISP_IOXPUT_8 {
	    my($isp, $s, $d) = @_;
    	    eval q(*($d) = $s);
	}' unless defined(&ISP_IOXPUT_8);
	eval 'sub ISP_IOXPUT_16 {
	    my($isp, $s, $d) = @_;
    	    eval q(*($d) = $s);
	}' unless defined(&ISP_IOXPUT_16);
	eval 'sub ISP_IOXPUT_32 {
	    my($isp, $s, $d) = @_;
    	    eval q(*($d) = $s);
	}' unless defined(&ISP_IOXPUT_32);
	eval 'sub ISP_IOXGET_8 {
	    my($isp, $s, $d) = @_;
    	    eval q($d = *($s));
	}' unless defined(&ISP_IOXGET_8);
	eval 'sub ISP_IOXGET_16 {
	    my($isp, $s, $d) = @_;
    	    eval q($d = *($s));
	}' unless defined(&ISP_IOXGET_16);
	eval 'sub ISP_IOXGET_32 {
	    my($isp, $s, $d) = @_;
    	    eval q($d = *($s));
	}' unless defined(&ISP_IOXGET_32);
	eval 'sub ISP_SWIZZLE_NVRAM_WORD {
	    my($isp, $rp) = @_;
    	    eval q();
	}' unless defined(&ISP_SWIZZLE_NVRAM_WORD);
	eval 'sub ISP_SWIZZLE_NVRAM_LONG {
	    my($isp, $rp) = @_;
    	    eval q();
	}' unless defined(&ISP_SWIZZLE_NVRAM_LONG);
	eval 'sub ISP_IOZPUT_8 {
	    my($isp, $s, $d) = @_;
    	    eval q(*($d) = $s);
	}' unless defined(&ISP_IOZPUT_8);
	eval 'sub ISP_IOZPUT_16 {
	    my($isp, $s, $d) = @_;
    	    eval q(*($d) =  &swap16($s));
	}' unless defined(&ISP_IOZPUT_16);
	eval 'sub ISP_IOZPUT_32 {
	    my($isp, $s, $d) = @_;
    	    eval q(*($d) =  &swap32($s));
	}' unless defined(&ISP_IOZPUT_32);
	eval 'sub ISP_IOZGET_8 {
	    my($isp, $s, $d) = @_;
    	    eval q($d = (*(( &u_int8_t *)($s))));
	}' unless defined(&ISP_IOZGET_8);
	eval 'sub ISP_IOZGET_16 {
	    my($isp, $s, $d) = @_;
    	    eval q($d =  &swap16(*(( &u_int16_t *)($s))));
	}' unless defined(&ISP_IOZGET_16);
	eval 'sub ISP_IOZGET_32 {
	    my($isp, $s, $d) = @_;
    	    eval q($d =  &swap32(*(( &u_int32_t *)($s))));
	}' unless defined(&ISP_IOZGET_32);
    }
    eval 'sub ISP_SWAP16 {
        my($isp, $s) = @_;
	    eval q( &swap16($s));
    }' unless defined(&ISP_SWAP16);
    eval 'sub ISP_SWAP32 {
        my($isp, $s) = @_;
	    eval q( &swap32($s));
    }' unless defined(&ISP_SWAP32);
    require 'dev/ic/ispreg.ph';
    require 'dev/ic/ispvar.ph';
    require 'dev/ic/ispmbox.ph';
    eval 'sub isp_name () { ($isp_osinfo->{_dev}->{dv_xname});}' unless defined(&isp_name);
    eval 'sub isp_unit () { ($isp_osinfo->{_dev}->{dv_unit});}' unless defined(&isp_unit);
    eval 'sub XS_PSTS_INWDOG () {0x10000;}' unless defined(&XS_PSTS_INWDOG);
    eval 'sub XS_PSTS_GRACE () {0x20000;}' unless defined(&XS_PSTS_GRACE);
    eval 'sub XS_PSTS_TIMED () {0x40000;}' unless defined(&XS_PSTS_TIMED);
    eval 'sub XS_PSTS_ALL () { &SCSI_PRIVATE;}' unless defined(&XS_PSTS_ALL);
    eval 'sub XS_CMD_S_WDOG {
        my($xs) = @_;
	    eval q(($xs)-> &flags |=  &XS_PSTS_INWDOG);
    }' unless defined(&XS_CMD_S_WDOG);
    eval 'sub XS_CMD_C_WDOG {
        my($xs) = @_;
	    eval q(($xs)-> &flags &= ~ &XS_PSTS_INWDOG);
    }' unless defined(&XS_CMD_C_WDOG);
    eval 'sub XS_CMD_WDOG_P {
        my($xs) = @_;
	    eval q(((($xs)-> &flags &  &XS_PSTS_INWDOG) != 0));
    }' unless defined(&XS_CMD_WDOG_P);
    eval 'sub XS_CMD_S_TIMER {
        my($xs) = @_;
	    eval q(($xs)-> &flags |=  &XS_PSTS_TIMED);
    }' unless defined(&XS_CMD_S_TIMER);
    eval 'sub XS_CMD_C_TIMER {
        my($xs) = @_;
	    eval q(($xs)-> &flags &= ~ &XS_PSTS_TIMED);
    }' unless defined(&XS_CMD_C_TIMER);
    eval 'sub XS_CMD_TIMER_P {
        my($xs) = @_;
	    eval q(((($xs)-> &flags &  &XS_PSTS_TIMED) != 0));
    }' unless defined(&XS_CMD_TIMER_P);
    eval 'sub XS_CMD_S_GRACE {
        my($xs) = @_;
	    eval q(($xs)-> &flags |=  &XS_PSTS_GRACE);
    }' unless defined(&XS_CMD_S_GRACE);
    eval 'sub XS_CMD_C_GRACE {
        my($xs) = @_;
	    eval q(($xs)-> &flags &= ~ &XS_PSTS_GRACE);
    }' unless defined(&XS_CMD_C_GRACE);
    eval 'sub XS_CMD_GRACE_P {
        my($xs) = @_;
	    eval q(((($xs)-> &flags &  &XS_PSTS_GRACE) != 0));
    }' unless defined(&XS_CMD_GRACE_P);
    eval 'sub XS_CMD_S_DONE {
        my($xs) = @_;
	    eval q(($xs)-> &flags |=  &ITSDONE);
    }' unless defined(&XS_CMD_S_DONE);
    eval 'sub XS_CMD_C_DONE {
        my($xs) = @_;
	    eval q(($xs)-> &flags &= ~ &ITSDONE);
    }' unless defined(&XS_CMD_C_DONE);
    eval 'sub XS_CMD_DONE_P {
        my($xs) = @_;
	    eval q(((($xs)-> &flags &  &ITSDONE) != 0));
    }' unless defined(&XS_CMD_DONE_P);
    eval 'sub XS_CMD_S_CLEAR {
        my($xs) = @_;
	    eval q(($xs)-> &flags &= ~ &XS_PSTS_ALL);
    }' unless defined(&XS_CMD_S_CLEAR);
    require 'dev/ic/isp_library.ph';
}
1;
