require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&L64854_CHANNEL_SCSI)) {
    sub L64854_CHANNEL_SCSI () {	1;}
}
unless(defined(&L64854_CHANNEL_ENET)) {
    sub L64854_CHANNEL_ENET () {	2;}
}
unless(defined(&L64854_CHANNEL_PP)) {
    sub L64854_CHANNEL_PP () {	3;}
}
unless(defined(&L64854_GCSR)) {
    sub L64854_GCSR {
	my($sc) = @_;
	eval q(( &bus_space_read_4(($sc)-> &sc_bustag, ($sc)-> &sc_regs,  &L64854_REG_CSR)));
    }
}
unless(defined(&L64854_SCSR)) {
    sub L64854_SCSR {
	my($sc, $csr) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bustag, ($sc)-> &sc_regs,  &L64854_REG_CSR, $csr));
    }
}
unless(defined(&DMA_RESET)) {
    sub DMA_RESET {
	my($sc) = @_;
	eval q(((($sc)-> &reset)($sc)));
    }
}
unless(defined(&DMA_INTR)) {
    sub DMA_INTR {
	my($sc) = @_;
	eval q(((($sc)-> &intr)($sc)));
    }
}
unless(defined(&DMA_SETUP)) {
    sub DMA_SETUP {
	my($sc, $a, $l, $d, $s) = @_;
	eval q(((($sc)-> &setup)($sc, $a, $l, $d, $s)));
    }
}
unless(defined(&DMA_ISACTIVE)) {
    sub DMA_ISACTIVE {
	my($sc) = @_;
	eval q((($sc)-> &sc_active));
    }
}
unless(defined(&DMA_ENINTR)) {
    sub DMA_ENINTR {
	my($sc) = @_;
	eval q( &do {  &u_int32_t  &csr =  &L64854_GCSR($sc);  &csr |=  &L64854_INT_EN;  &L64854_SCSR($sc,  &csr); }  &while (0));
    }
}
unless(defined(&DMA_ISINTR)) {
    sub DMA_ISINTR {
	my($sc) = @_;
	eval q(( &L64854_GCSR($sc) & ( &D_INT_PEND| &D_ERR_PEND)));
    }
}
unless(defined(&DMA_GO)) {
    sub DMA_GO {
	my($sc) = @_;
	eval q( &do {  &u_int32_t  &csr =  &L64854_GCSR($sc);  &csr |=  &D_EN_DMA;  &L64854_SCSR($sc,  &csr);  ($sc->{sc_active}) = 1; }  &while (0));
    }
}
1;
