require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&LOCAL_ADDR0_RAM)) {
    sub LOCAL_ADDR0_RAM () {	(0x |  &LASBA_ENABLE);}
}
unless(defined(&LOCAL_ADDR0_FPGA)) {
    sub LOCAL_ADDR0_FPGA () {	(0x14000000 |  &LASBA_ENABLE);}
}
unless(defined(&MAILBOX0_8Zo_V1)) {
    sub MAILBOX0_8Zo_V1 () {	0;}
}
unless(defined(&MAILBOX0_8Zo_V2)) {
    sub MAILBOX0_8Zo_V2 () {	1;}
}
unless(defined(&MAILBOX0_Ze_V1)) {
    sub MAILBOX0_Ze_V1 () {	2;}
}
unless(defined(&CONTROL_FPGA_LOADED)) {
    sub CONTROL_FPGA_LOADED () {	 &CONTROL_GPI;}
}
unless(defined(&FPGA_ID)) {
    sub FPGA_ID () {	0x;}
}
unless(defined(&FPGA_VERSION)) {
    sub FPGA_VERSION () {	0x4;}
}
unless(defined(&FPGA_CPU_START)) {
    sub FPGA_CPU_START () {	0x8;}
}
unless(defined(&FPGA_CPU_STOP)) {
    sub FPGA_CPU_STOP () {	0xc;}
}
unless(defined(&FPGA_MISC)) {
    sub FPGA_MISC () {	0x10;}
}
unless(defined(&FPGA_IDT_MODE)) {
    sub FPGA_IDT_MODE () {	0x14;}
}
unless(defined(&FPGA_UART_IRQ_STAT)) {
    sub FPGA_UART_IRQ_STAT () {	0x18;}
}
unless(defined(&FPGA_CLEAR_TIMER0_IRQ)) {
    sub FPGA_CLEAR_TIMER0_IRQ () {	0x1c;}
}
unless(defined(&FPGA_CLEAR_TIMER1_IRQ)) {
    sub FPGA_CLEAR_TIMER1_IRQ () {	0x20;}
}
unless(defined(&FPGA_CLEAR_TIMER2_IRQ)) {
    sub FPGA_CLEAR_TIMER2_IRQ () {	0x24;}
}
unless(defined(&FPGA_TEST)) {
    sub FPGA_TEST () {	0x28;}
}
unless(defined(&FPGA_TEST_COUNT)) {
    sub FPGA_TEST_COUNT () {	0x2c;}
}
unless(defined(&FPGA_TIMER_SELECT)) {
    sub FPGA_TIMER_SELECT () {	0x30;}
}
unless(defined(&FPGA_PR_UART_IRQ_STAT)) {
    sub FPGA_PR_UART_IRQ_STAT () {	0x34;}
}
unless(defined(&FPGA_RAM_WAIT_STATE)) {
    sub FPGA_RAM_WAIT_STATE () {	0x38;}
}
unless(defined(&FPGA_UART_WAIT_STATE)) {
    sub FPGA_UART_WAIT_STATE () {	0x3c;}
}
unless(defined(&FPGA_TIMER_WAIT_STATE)) {
    sub FPGA_TIMER_WAIT_STATE () {	0x40;}
}
unless(defined(&FPGA_ACK_WAIT_STATE)) {
    sub FPGA_ACK_WAIT_STATE () {	0x44;}
}
unless(defined(&FPGA_ZE_ID)) {
    sub FPGA_ZE_ID () {	0x;}
}
unless(defined(&FPGA_ZE_VERSION)) {
    sub FPGA_ZE_VERSION () {	0x4;}
}
unless(defined(&FPGA_ZE_CPU_START)) {
    sub FPGA_ZE_CPU_START () {	0x8;}
}
unless(defined(&FPGA_ZE_CPU_STOP)) {
    sub FPGA_ZE_CPU_STOP () {	0xc;}
}
unless(defined(&FPGA_ZE_CTRL)) {
    sub FPGA_ZE_CTRL () {	0x10;}
}
unless(defined(&FPGA_ZE_ZBUS_WAIT)) {
    sub FPGA_ZE_ZBUS_WAIT () {	0x14;}
}
unless(defined(&FPGA_ZE_TIMER_DIV)) {
    sub FPGA_ZE_TIMER_DIV () {	0x18;}
}
unless(defined(&FPGA_ZE_TIMER_IRQ_ACK)) {
    sub FPGA_ZE_TIMER_IRQ_ACK () {	0x1c;}
}
unless(defined(&FPGA_ID_8Zo_V1)) {
    sub FPGA_ID_8Zo_V1 () {	0x95;}
}
unless(defined(&FPGA_ID_8Zo_V2)) {
    sub FPGA_ID_8Zo_V2 () {	0x84;}
}
unless(defined(&FPGA_ID_Ze_V1)) {
    sub FPGA_ID_Ze_V1 () {	0x89;}
}
unless(defined(&ZE_TIMER_DIV_1M)) {
    sub ZE_TIMER_DIV_1M () {	0x;}
}
unless(defined(&ZE_TIMER_DIV_256K)) {
    sub ZE_TIMER_DIV_256K () {	0x1;}
}
unless(defined(&ZE_TIMER_DIV_128K)) {
    sub ZE_TIMER_DIV_128K () {	0x2;}
}
unless(defined(&ZE_TIMER_DIV_32K)) {
    sub ZE_TIMER_DIV_32K () {	0x3;}
}
unless(defined(&ZFIRM_MAX_BLOCKS)) {
    sub ZFIRM_MAX_BLOCKS () {	16;}
}
unless(defined(&ZFC_FUNCTION_NORMAL)) {
    sub ZFC_FUNCTION_NORMAL () {	0;}
}
unless(defined(&ZFC_FUNCTION_TEST)) {
    sub ZFC_FUNCTION_TEST () {	1;}
}
unless(defined(&ZFB_TYPE_FIRMWARE)) {
    sub ZFB_TYPE_FIRMWARE () {	0;}
}
unless(defined(&ZFB_TYPE_FPGA)) {
    sub ZFB_TYPE_FPGA () {	1;}
}
unless(defined(&ZFIRM_MAX_CHANNELS)) {
    sub ZFIRM_MAX_CHANNELS () {	64;}
}
unless(defined(&ZFIRM_SIG_OFF)) {
    sub ZFIRM_SIG_OFF () {	0x180;}
}
unless(defined(&ZFIRM_CTRLADDR_OFF)) {
    sub ZFIRM_CTRLADDR_OFF () {	0x184;}
}
unless(defined(&ZFIRM_SIG)) {
    sub ZFIRM_SIG () {	0x5557465a;}
}
unless(defined(&ZFIRM_HLT)) {
    sub ZFIRM_HLT () {	0x59505b5c;}
}
unless(defined(&ZFIRM_RST)) {
    sub ZFIRM_RST () {	0x56040674;}
}
unless(defined(&ZFIRM_BRDCTL_SIZE)) {
    sub ZFIRM_BRDCTL_SIZE () {	64;}
}
unless(defined(&ZFIRM_CHNCTL_SIZE)) {
    sub ZFIRM_CHNCTL_SIZE () {	96;}
}
unless(defined(&ZFIRM_BUFCTL_SIZE)) {
    sub ZFIRM_BUFCTL_SIZE () {	64;}
}
unless(defined(&ZFIRM_CHNCTL_OFF)) {
    sub ZFIRM_CHNCTL_OFF {
	my($chan, $reg) = @_;
	eval q(( &ZFIRM_BRDCTL_SIZE + (($chan) *  &ZFIRM_CHNCTL_SIZE) + ($reg)));
    }
}
unless(defined(&ZFIRM_BUFCTL_OFF)) {
    sub ZFIRM_BUFCTL_OFF {
	my($chan, $reg) = @_;
	eval q(( &ZFIRM_CHNCTL_OFF( &ZFIRM_MAX_CHANNELS, 0) + (($chan) *  &ZFIRM_BUFCTL_SIZE) + ($reg)));
    }
}
unless(defined(&BRDCTL_NCHANNEL)) {
    sub BRDCTL_NCHANNEL () {	0x;}
}
unless(defined(&BRDCTL_FWVERSION)) {
    sub BRDCTL_FWVERSION () {	0x4;}
}
unless(defined(&BRDCTL_C_OS)) {
    sub BRDCTL_C_OS () {	0x8;}
}
unless(defined(&BRDCTL_DRVERSION)) {
    sub BRDCTL_DRVERSION () {	0xc;}
}
unless(defined(&BRDCTL_INACTIVITY)) {
    sub BRDCTL_INACTIVITY () {	0x10;}
}
unless(defined(&BRDCTL_HCMD_CHANNEL)) {
    sub BRDCTL_HCMD_CHANNEL () {	0x14;}
}
unless(defined(&BRDCTL_HCMD_PARAM)) {
    sub BRDCTL_HCMD_PARAM () {	0x18;}
}
unless(defined(&BRDCTL_FWCMD_CHANNEL)) {
    sub BRDCTL_FWCMD_CHANNEL () {	0x1c;}
}
unless(defined(&BRDCTL_FWCMD_PARAM)) {
    sub BRDCTL_FWCMD_PARAM () {	0x20;}
}
unless(defined(&BRDCTL_INT_QUEUE_OFF)) {
    sub BRDCTL_INT_QUEUE_OFF () {	0x24;}
}
unless(defined(&CHNCTL_OP_MODE)) {
    sub CHNCTL_OP_MODE () {	0x;}
}
unless(defined(&CHNCTL_INTR_ENABLE)) {
    sub CHNCTL_INTR_ENABLE () {	0x4;}
}
unless(defined(&CHNCTL_SW_FLOW)) {
    sub CHNCTL_SW_FLOW () {	0x8;}
}
unless(defined(&CHNCTL_FLOW_STATUS)) {
    sub CHNCTL_FLOW_STATUS () {	0xc;}
}
unless(defined(&CHNCTL_COMM_BAUD)) {
    sub CHNCTL_COMM_BAUD () {	0x10;}
}
unless(defined(&CHNCTL_COMM_PARITY)) {
    sub CHNCTL_COMM_PARITY () {	0x14;}
}
unless(defined(&CHNCTL_COMM_DATA_L)) {
    sub CHNCTL_COMM_DATA_L () {	0x18;}
}
unless(defined(&CHNCTL_COMM_FLAGS)) {
    sub CHNCTL_COMM_FLAGS () {	0x1c;}
}
unless(defined(&CHNCTL_HW_FLOW)) {
    sub CHNCTL_HW_FLOW () {	0x20;}
}
unless(defined(&CHNCTL_RS_CONTROL)) {
    sub CHNCTL_RS_CONTROL () {	0x24;}
}
unless(defined(&CHNCTL_RS_STATUS)) {
    sub CHNCTL_RS_STATUS () {	0x28;}
}
unless(defined(&CHNCTL_FLOW_XON)) {
    sub CHNCTL_FLOW_XON () {	0x2c;}
}
unless(defined(&CHNCTL_FLOW_XOFF)) {
    sub CHNCTL_FLOW_XOFF () {	0x30;}
}
unless(defined(&CHNCTL_HW_OVERFLOW)) {
    sub CHNCTL_HW_OVERFLOW () {	0x34;}
}
unless(defined(&CHNCTL_SW_OVERFLOW)) {
    sub CHNCTL_SW_OVERFLOW () {	0x38;}
}
unless(defined(&CHNCTL_COMM_ERROR)) {
    sub CHNCTL_COMM_ERROR () {	0x3c;}
}
unless(defined(&CHNCTL_ICHAR)) {
    sub CHNCTL_ICHAR () {	0x40;}
}
unless(defined(&BUFCTL_FLAG_DMA)) {
    sub BUFCTL_FLAG_DMA () {	0x;}
}
unless(defined(&BUFCTL_TX_BUFADDR)) {
    sub BUFCTL_TX_BUFADDR () {	0x4;}
}
unless(defined(&BUFCTL_TX_BUFSIZE)) {
    sub BUFCTL_TX_BUFSIZE () {	0x8;}
}
unless(defined(&BUFCTL_TX_THRESHOLD)) {
    sub BUFCTL_TX_THRESHOLD () {	0xc;}
}
unless(defined(&BUFCTL_TX_GET)) {
    sub BUFCTL_TX_GET () {	0x10;}
}
unless(defined(&BUFCTL_TX_PUT)) {
    sub BUFCTL_TX_PUT () {	0x14;}
}
unless(defined(&BUFCTL_RX_BUFADDR)) {
    sub BUFCTL_RX_BUFADDR () {	0x18;}
}
unless(defined(&BUFCTL_RX_BUFSIZE)) {
    sub BUFCTL_RX_BUFSIZE () {	0x1c;}
}
unless(defined(&BUFCTL_RX_THRESHOLD)) {
    sub BUFCTL_RX_THRESHOLD () {	0x20;}
}
unless(defined(&BUFCTL_RX_GET)) {
    sub BUFCTL_RX_GET () {	0x24;}
}
unless(defined(&BUFCTL_RX_PUT)) {
    sub BUFCTL_RX_PUT () {	0x28;}
}
unless(defined(&C_OS_SVR3)) {
    sub C_OS_SVR3 () {	0x10;}
}
unless(defined(&C_OS_XENIX)) {
    sub C_OS_XENIX () {	0x11;}
}
unless(defined(&C_OS_SCO)) {
    sub C_OS_SCO () {	0x12;}
}
unless(defined(&C_OS_SVR4)) {
    sub C_OS_SVR4 () {	0x20;}
}
unless(defined(&C_OS_UXWARE)) {
    sub C_OS_UXWARE () {	0x21;}
}
unless(defined(&C_OS_LINUX)) {
    sub C_OS_LINUX () {	0x30;}
}
unless(defined(&C_OS_SOLARIS)) {
    sub C_OS_SOLARIS () {	0x40;}
}
unless(defined(&C_OS_BSD)) {
    sub C_OS_BSD () {	0x50;}
}
unless(defined(&C_OS_DOS)) {
    sub C_OS_DOS () {	0x70;}
}
unless(defined(&C_OS_NT)) {
    sub C_OS_NT () {	0x80;}
}
unless(defined(&C_OS_OS2)) {
    sub C_OS_OS2 () {	0x90;}
}
unless(defined(&C_OS_MACOS)) {
    sub C_OS_MACOS () {	0xa0;}
}
unless(defined(&C_OS_AIX)) {
    sub C_OS_AIX () {	0xb0;}
}
unless(defined(&C_CH_DISABLE)) {
    sub C_CH_DISABLE () {	0x;}
}
unless(defined(&C_CH_TXENABLE)) {
    sub C_CH_TXENABLE () {	0x1;}
}
unless(defined(&C_CH_RXENABLE)) {
    sub C_CH_RXENABLE () {	0x2;}
}
unless(defined(&C_CH_ENABLE)) {
    sub C_CH_ENABLE () {	0x3;}
}
unless(defined(&C_CH_LOOPBACK)) {
    sub C_CH_LOOPBACK () {	0x4;}
}
unless(defined(&C_PR_NONE)) {
    sub C_PR_NONE () {	0x;}
}
unless(defined(&C_PR_ODD)) {
    sub C_PR_ODD () {	0x1;}
}
unless(defined(&C_PR_EVEN)) {
    sub C_PR_EVEN () {	0x2;}
}
unless(defined(&C_PR_MARK)) {
    sub C_PR_MARK () {	0x4;}
}
unless(defined(&C_PR_SPACE)) {
    sub C_PR_SPACE () {	0x8;}
}
unless(defined(&C_PR_PARITY)) {
    sub C_PR_PARITY () {	0xff;}
}
unless(defined(&C_PR_DISCARD)) {
    sub C_PR_DISCARD () {	0x100;}
}
unless(defined(&C_PR_IGNORE)) {
    sub C_PR_IGNORE () {	0x200;}
}
unless(defined(&C_DL_CS5)) {
    sub C_DL_CS5 () {	0x1;}
}
unless(defined(&C_DL_CS6)) {
    sub C_DL_CS6 () {	0x2;}
}
unless(defined(&C_DL_CS7)) {
    sub C_DL_CS7 () {	0x4;}
}
unless(defined(&C_DL_CS8)) {
    sub C_DL_CS8 () {	0x8;}
}
unless(defined(&C_DL_CS)) {
    sub C_DL_CS () {	0xf;}
}
unless(defined(&C_DL_1STOP)) {
    sub C_DL_1STOP () {	0x10;}
}
unless(defined(&C_DL_15STOP)) {
    sub C_DL_15STOP () {	0x20;}
}
unless(defined(&C_DL_2STOP)) {
    sub C_DL_2STOP () {	0x40;}
}
unless(defined(&C_DL_STOP)) {
    sub C_DL_STOP () {	0xf0;}
}
unless(defined(&C_IN_DISABLE)) {
    sub C_IN_DISABLE () {	0x;}
}
unless(defined(&C_IN_TXBEMPTY)) {
    sub C_IN_TXBEMPTY () {	0x1;}
}
unless(defined(&C_IN_TXLOWWM)) {
    sub C_IN_TXLOWWM () {	0x2;}
}
unless(defined(&C_IN_TXFEMPTY)) {
    sub C_IN_TXFEMPTY () {	0x4;}
}
unless(defined(&C_IN_RXHIWM)) {
    sub C_IN_RXHIWM () {	0x10;}
}
unless(defined(&C_IN_RXNNDT)) {
    sub C_IN_RXNNDT () {	0x20;}
}
unless(defined(&C_IN_MDCD)) {
    sub C_IN_MDCD () {	0x100;}
}
unless(defined(&C_IN_MDSR)) {
    sub C_IN_MDSR () {	0x200;}
}
unless(defined(&C_IN_MRI)) {
    sub C_IN_MRI () {	0x400;}
}
unless(defined(&C_IN_MCTS)) {
    sub C_IN_MCTS () {	0x800;}
}
unless(defined(&C_IN_RXBRK)) {
    sub C_IN_RXBRK () {	0x1000;}
}
unless(defined(&C_IN_PR_ERROR)) {
    sub C_IN_PR_ERROR () {	0x2000;}
}
unless(defined(&C_IN_FR_ERROR)) {
    sub C_IN_FR_ERROR () {	0x4000;}
}
unless(defined(&C_IN_OVR_ERROR)) {
    sub C_IN_OVR_ERROR () {	0x8000;}
}
unless(defined(&C_IN_RXOFL)) {
    sub C_IN_RXOFL () {	0x10000;}
}
unless(defined(&C_IN_IOCTLW)) {
    sub C_IN_IOCTLW () {	0x20000;}
}
unless(defined(&C_IN_MRTS)) {
    sub C_IN_MRTS () {	0x40000;}
}
unless(defined(&C_IN_ICHAR)) {
    sub C_IN_ICHAR () {	0x80000;}
}
unless(defined(&C_FL_OXX)) {
    sub C_FL_OXX () {	0x1;}
}
unless(defined(&C_FL_IXX)) {
    sub C_FL_IXX () {	0x2;}
}
unless(defined(&C_FL_OIXANY)) {
    sub C_FL_OIXANY () {	0x4;}
}
unless(defined(&C_FL_SWFLOW)) {
    sub C_FL_SWFLOW () {	0xf;}
}
unless(defined(&C_FS_TXIDLE)) {
    sub C_FS_TXIDLE () {	0x;}
}
unless(defined(&C_FS_SENDING)) {
    sub C_FS_SENDING () {	0x1;}
}
unless(defined(&C_FS_SWFLOW)) {
    sub C_FS_SWFLOW () {	0x2;}
}
unless(defined(&C_RS_PARAM)) {
    sub C_RS_PARAM () {	0x80000000;}
}
unless(defined(&C_RS_RTS)) {
    sub C_RS_RTS () {	0x1;}
}
unless(defined(&C_RS_DTR)) {
    sub C_RS_DTR () {	0x4;}
}
unless(defined(&C_RS_DCD)) {
    sub C_RS_DCD () {	0x100;}
}
unless(defined(&C_RS_DSR)) {
    sub C_RS_DSR () {	0x200;}
}
unless(defined(&C_RS_RI)) {
    sub C_RS_RI () {	0x400;}
}
unless(defined(&C_RS_CTS)) {
    sub C_RS_CTS () {	0x800;}
}
unless(defined(&C_CM_RESET)) {
    sub C_CM_RESET () {	0x1;}
}
unless(defined(&C_CM_IOCTL)) {
    sub C_CM_IOCTL () {	0x2;}
}
unless(defined(&C_CM_IOCTLW)) {
    sub C_CM_IOCTLW () {	0x3;}
}
unless(defined(&C_CM_IOCTLM)) {
    sub C_CM_IOCTLM () {	0x4;}
}
unless(defined(&C_CM_SENDXOFF)) {
    sub C_CM_SENDXOFF () {	0x10;}
}
unless(defined(&C_CM_SENDXON)) {
    sub C_CM_SENDXON () {	0x11;}
}
unless(defined(&C_CM_CLFLOW)) {
    sub C_CM_CLFLOW () {	0x12;}
}
unless(defined(&C_CM_SENDBRK)) {
    sub C_CM_SENDBRK () {	0x41;}
}
unless(defined(&C_CM_INTBACK)) {
    sub C_CM_INTBACK () {	0x42;}
}
unless(defined(&C_CM_SET_BREAK)) {
    sub C_CM_SET_BREAK () {	0x43;}
}
unless(defined(&C_CM_CLR_BREAK)) {
    sub C_CM_CLR_BREAK () {	0x44;}
}
unless(defined(&C_CM_CMD_DONE)) {
    sub C_CM_CMD_DONE () {	0x45;}
}
unless(defined(&C_CM_INTBACK2)) {
    sub C_CM_INTBACK2 () {	0x46;}
}
unless(defined(&C_CM_TINACT)) {
    sub C_CM_TINACT () {	0x51;}
}
unless(defined(&C_CM_IRQ_ENBL)) {
    sub C_CM_IRQ_ENBL () {	0x52;}
}
unless(defined(&C_CM_IRQ_DSBL)) {
    sub C_CM_IRQ_DSBL () {	0x53;}
}
unless(defined(&C_CM_ACK_ENBL)) {
    sub C_CM_ACK_ENBL () {	0x54;}
}
unless(defined(&C_CM_ACK_DSBL)) {
    sub C_CM_ACK_DSBL () {	0x55;}
}
unless(defined(&C_CM_FLUSH_RX)) {
    sub C_CM_FLUSH_RX () {	0x56;}
}
unless(defined(&C_CM_FLUSH_TX)) {
    sub C_CM_FLUSH_TX () {	0x57;}
}
unless(defined(&C_CM_Q_ENABLE)) {
    sub C_CM_Q_ENABLE () {	0x58;}
}
unless(defined(&C_CM_Q_DISABLE)) {
    sub C_CM_Q_DISABLE () {	0x59;}
}
unless(defined(&C_CM_TXBEMPTY)) {
    sub C_CM_TXBEMPTY () {	0x60;}
}
unless(defined(&C_CM_TXLOWWM)) {
    sub C_CM_TXLOWWM () {	0x61;}
}
unless(defined(&C_CM_RXHIWM)) {
    sub C_CM_RXHIWM () {	0x62;}
}
unless(defined(&C_CM_RXNNDT)) {
    sub C_CM_RXNNDT () {	0x63;}
}
unless(defined(&C_CM_TXFEMPTY)) {
    sub C_CM_TXFEMPTY () {	0x64;}
}
unless(defined(&C_CM_ICHAR)) {
    sub C_CM_ICHAR () {	0x65;}
}
unless(defined(&C_CM_MDCD)) {
    sub C_CM_MDCD () {	0x70;}
}
unless(defined(&C_CM_MDSR)) {
    sub C_CM_MDSR () {	0x71;}
}
unless(defined(&C_CM_MRI)) {
    sub C_CM_MRI () {	0x72;}
}
unless(defined(&C_CM_MCTS)) {
    sub C_CM_MCTS () {	0x73;}
}
unless(defined(&C_CM_MRTS)) {
    sub C_CM_MRTS () {	0x74;}
}
unless(defined(&C_CM_RXBRK)) {
    sub C_CM_RXBRK () {	0x84;}
}
unless(defined(&C_CM_PR_ERROR)) {
    sub C_CM_PR_ERROR () {	0x85;}
}
unless(defined(&C_CM_FR_ERROR)) {
    sub C_CM_FR_ERROR () {	0x86;}
}
unless(defined(&C_CM_OVR_ERROR)) {
    sub C_CM_OVR_ERROR () {	0x87;}
}
unless(defined(&C_CM_RXOFL)) {
    sub C_CM_RXOFL () {	0x88;}
}
unless(defined(&C_CM_CMDERROR)) {
    sub C_CM_CMDERROR () {	0x90;}
}
unless(defined(&C_CM_FATAL)) {
    sub C_CM_FATAL () {	0x91;}
}
unless(defined(&C_CM_HW_RESET)) {
    sub C_CM_HW_RESET () {	0x92;}
}
1;
