require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&UATH_CONFIG_NO)) {
    sub UATH_CONFIG_NO () {	1;}
}
unless(defined(&UATH_IFACE_INDEX)) {
    sub UATH_IFACE_INDEX () {	0;}
}
unless(defined(&UATH_WRITE_BLOCK)) {
    sub UATH_WRITE_BLOCK () {	(1<< 4);}
}
unless(defined(&UATH_MAX_FWBLOCK_SIZE)) {
    sub UATH_MAX_FWBLOCK_SIZE () {	2048;}
}
unless(defined(&UATH_MAX_RXCMDSZ)) {
    sub UATH_MAX_RXCMDSZ () {	512;}
}
unless(defined(&UATH_MAX_TXCMDSZ)) {
    sub UATH_MAX_TXCMDSZ () {	512;}
}
unless(defined(&UATH_CMD_SETUP)) {
    sub UATH_CMD_SETUP () {	0x1;}
}
unless(defined(&UATH_CMD_02)) {
    sub UATH_CMD_02 () {	0x2;}
}
unless(defined(&UATH_CMD_READ_MAC)) {
    sub UATH_CMD_READ_MAC () {	0x3;}
}
unless(defined(&UATH_CMD_WRITE_MAC)) {
    sub UATH_CMD_WRITE_MAC () {	0x4;}
}
unless(defined(&UATH_CMD_READ_EEPROM)) {
    sub UATH_CMD_READ_EEPROM () {	0x5;}
}
unless(defined(&UATH_CMD_STATS)) {
    sub UATH_CMD_STATS () {	0x6;}
}
unless(defined(&UATH_CMD_07)) {
    sub UATH_CMD_07 () {	0x7;}
}
unless(defined(&UATH_CMD_SHUTDOWN)) {
    sub UATH_CMD_SHUTDOWN () {	0x8;}
}
unless(defined(&UATH_CMD_0B)) {
    sub UATH_CMD_0B () {	0xb;}
}
unless(defined(&UATH_CMD_0C)) {
    sub UATH_CMD_0C () {	0xc;}
}
unless(defined(&UATH_CMD_0F)) {
    sub UATH_CMD_0F () {	0xf;}
}
unless(defined(&UATH_NOTIF_STATS)) {
    sub UATH_NOTIF_STATS () {	0x10;}
}
unless(defined(&UATH_NOTIF_READY)) {
    sub UATH_NOTIF_READY () {	0x12;}
}
unless(defined(&UATH_NOTIF_TX)) {
    sub UATH_NOTIF_TX () {	0x13;}
}
unless(defined(&UATH_CMD_15)) {
    sub UATH_CMD_15 () {	0x15;}
}
unless(defined(&UATH_CMD_SET_LED)) {
    sub UATH_CMD_SET_LED () {	0x17;}
}
unless(defined(&UATH_CMD_SET_XLED)) {
    sub UATH_CMD_SET_XLED () {	0x18;}
}
unless(defined(&UATH_CMD_1B)) {
    sub UATH_CMD_1B () {	0x1b;}
}
unless(defined(&UATH_CMD_1E)) {
    sub UATH_CMD_1E () {	0x1e;}
}
unless(defined(&UATH_CMD_CRYPTO)) {
    sub UATH_CMD_CRYPTO () {	0x1d;}
}
unless(defined(&UATH_CMD_SET_STATE)) {
    sub UATH_CMD_SET_STATE () {	0x20;}
}
unless(defined(&UATH_CMD_SET_BSSID)) {
    sub UATH_CMD_SET_BSSID () {	0x21;}
}
unless(defined(&UATH_CMD_24)) {
    sub UATH_CMD_24 () {	0x24;}
}
unless(defined(&UATH_CMD_SET_RATES)) {
    sub UATH_CMD_SET_RATES () {	0x26;}
}
unless(defined(&UATH_CMD_27)) {
    sub UATH_CMD_27 () {	0x27;}
}
unless(defined(&UATH_CMD_2E)) {
    sub UATH_CMD_2E () {	0x2e;}
}
unless(defined(&UATH_CMD_31)) {
    sub UATH_CMD_31 () {	0x31;}
}
unless(defined(&UATH_CMD_SET_FILTER)) {
    sub UATH_CMD_SET_FILTER () {	0x32;}
}
unless(defined(&UATH_CMD_SET_CHAN)) {
    sub UATH_CMD_SET_CHAN () {	0x34;}
}
unless(defined(&UATH_CMD_RESET)) {
    sub UATH_CMD_RESET () {	0x35;}
}
unless(defined(&UATH_CMD_SET_QUEUE)) {
    sub UATH_CMD_SET_QUEUE () {	0x3a;}
}
unless(defined(&UATH_CMD_RESET_QUEUE)) {
    sub UATH_CMD_RESET_QUEUE () {	0x3b;}
}
unless(defined(&UATH_MAKECTL)) {
    sub UATH_MAKECTL {
	my($qid, $len) = @_;
	eval q( &htobe32(($qid) << 16| ($len)));
    }
}
unless(defined(&UATH_TX_DATA)) {
    sub UATH_TX_DATA () {	0xe;}
}
unless(defined(&UATH_TX_NULL)) {
    sub UATH_TX_NULL () {	0xf;}
}
unless(defined(&UATH_ID_BSS)) {
    sub UATH_ID_BSS () {	2;}
}
unless(defined(&UATH_ID_BROADCAST)) {
    sub UATH_ID_BROADCAST () {	0xffffffff;}
}
unless(defined(&UATH_TX_NOTIFY)) {
    sub UATH_TX_NOTIFY () {	(1<< 24);}
}
unless(defined(&UATH_LED_LINK)) {
    sub UATH_LED_LINK () {	0;}
}
unless(defined(&UATH_LED_ACTIVITY)) {
    sub UATH_LED_ACTIVITY () {	1;}
}
unless(defined(&UATH_LED_OFF)) {
    sub UATH_LED_OFF () {	0;}
}
unless(defined(&UATH_LED_ON)) {
    sub UATH_LED_ON () {	1;}
}
unless(defined(&UATH_DEFAULT_KEY)) {
    sub UATH_DEFAULT_KEY () {	6;}
}
unless(defined(&UATH_MAX_NRATES)) {
    sub UATH_MAX_NRATES () {	30;}
}
unless(defined(&UATH_AC_TO_QID)) {
    sub UATH_AC_TO_QID {
	my($ac) = @_;
	eval q(($ac));
    }
}
unless(defined(&UATH_EEPROM_MACADDR)) {
    sub UATH_EEPROM_MACADDR () {	0xb;}
}
unless(defined(&UATH_EEPROM_RXBUFSZ)) {
    sub UATH_EEPROM_RXBUFSZ () {	0xf;}
}
unless(defined(&UATH_MAX_TXBUFSZ)) {
    sub UATH_MAX_TXBUFSZ () {	($sizeof{ &uint32_t} + $sizeof{'struct uath_tx_desc'} +  &IEEE80211_MAX_LEN);}
}
unless(defined(&UATH_MIN_RXBUFSZ)) {
    sub UATH_MIN_RXBUFSZ () {	((($sizeof{ &uint32_t} + $sizeof{'struct ieee80211_frame_min'} + $sizeof{'struct uath_rx_desc'}) + 3) & ~3);}
}
1;
