require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&IWI_CMD_RING_COUNT)) {
    sub IWI_CMD_RING_COUNT () {	16;}
}
unless(defined(&IWI_TX_RING_COUNT)) {
    sub IWI_TX_RING_COUNT () {	64;}
}
unless(defined(&IWI_RX_RING_COUNT)) {
    sub IWI_RX_RING_COUNT () {	32;}
}
unless(defined(&IWI_CSR_INTR)) {
    sub IWI_CSR_INTR () {	0x8;}
}
unless(defined(&IWI_CSR_INTR_MASK)) {
    sub IWI_CSR_INTR_MASK () {	0xc;}
}
unless(defined(&IWI_CSR_INDIRECT_ADDR)) {
    sub IWI_CSR_INDIRECT_ADDR () {	0x10;}
}
unless(defined(&IWI_CSR_INDIRECT_DATA)) {
    sub IWI_CSR_INDIRECT_DATA () {	0x14;}
}
unless(defined(&IWI_CSR_AUTOINC_ADDR)) {
    sub IWI_CSR_AUTOINC_ADDR () {	0x18;}
}
unless(defined(&IWI_CSR_AUTOINC_DATA)) {
    sub IWI_CSR_AUTOINC_DATA () {	0x1c;}
}
unless(defined(&IWI_CSR_RST)) {
    sub IWI_CSR_RST () {	0x20;}
}
unless(defined(&IWI_CSR_CTL)) {
    sub IWI_CSR_CTL () {	0x24;}
}
unless(defined(&IWI_CSR_IO)) {
    sub IWI_CSR_IO () {	0x30;}
}
unless(defined(&IWI_CSR_CMD_BASE)) {
    sub IWI_CSR_CMD_BASE () {	0x200;}
}
unless(defined(&IWI_CSR_CMD_SIZE)) {
    sub IWI_CSR_CMD_SIZE () {	0x204;}
}
unless(defined(&IWI_CSR_TX_BASE)) {
    sub IWI_CSR_TX_BASE {
	my($ac) = @_;
	eval q((0x208 + ($ac) * 8));
    }
}
unless(defined(&IWI_CSR_TX_SIZE)) {
    sub IWI_CSR_TX_SIZE {
	my($ac) = @_;
	eval q((0x20c + ($ac) * 8));
    }
}
unless(defined(&IWI_CSR_CMD_RIDX)) {
    sub IWI_CSR_CMD_RIDX () {	0x280;}
}
unless(defined(&IWI_CSR_TX_RIDX)) {
    sub IWI_CSR_TX_RIDX {
	my($ac) = @_;
	eval q((0x284 + ($ac) * 4));
    }
}
unless(defined(&IWI_CSR_RX_RIDX)) {
    sub IWI_CSR_RX_RIDX () {	0x2a0;}
}
unless(defined(&IWI_CSR_RX_BASE)) {
    sub IWI_CSR_RX_BASE () {	0x500;}
}
unless(defined(&IWI_CSR_TABLE0_SIZE)) {
    sub IWI_CSR_TABLE0_SIZE () {	0x700;}
}
unless(defined(&IWI_CSR_TABLE0_BASE)) {
    sub IWI_CSR_TABLE0_BASE () {	0x704;}
}
unless(defined(&IWI_CSR_NODE_BASE)) {
    sub IWI_CSR_NODE_BASE () {	0xc0c;}
}
unless(defined(&IWI_CSR_CMD_WIDX)) {
    sub IWI_CSR_CMD_WIDX () {	0xf80;}
}
unless(defined(&IWI_CSR_TX_WIDX)) {
    sub IWI_CSR_TX_WIDX {
	my($ac) = @_;
	eval q((0xf84 + ($ac) * 4));
    }
}
unless(defined(&IWI_CSR_RX_WIDX)) {
    sub IWI_CSR_RX_WIDX () {	0xfa0;}
}
unless(defined(&IWI_CSR_READ_INT)) {
    sub IWI_CSR_READ_INT () {	0xff4;}
}
unless(defined(&IWI_CSR_CURRENT_TX_RATE)) {
    sub IWI_CSR_CURRENT_TX_RATE () {	 &IWI_CSR_TABLE0_BASE;}
}
unless(defined(&IWI_INTR_RX_DONE)) {
    sub IWI_INTR_RX_DONE () {	0x2;}
}
unless(defined(&IWI_INTR_CMD_DONE)) {
    sub IWI_INTR_CMD_DONE () {	0x800;}
}
unless(defined(&IWI_INTR_TX1_DONE)) {
    sub IWI_INTR_TX1_DONE () {	0x1000;}
}
unless(defined(&IWI_INTR_TX2_DONE)) {
    sub IWI_INTR_TX2_DONE () {	0x2000;}
}
unless(defined(&IWI_INTR_TX3_DONE)) {
    sub IWI_INTR_TX3_DONE () {	0x4000;}
}
unless(defined(&IWI_INTR_TX4_DONE)) {
    sub IWI_INTR_TX4_DONE () {	0x8000;}
}
unless(defined(&IWI_INTR_FW_INITED)) {
    sub IWI_INTR_FW_INITED () {	0x1000000;}
}
unless(defined(&IWI_INTR_RADIO_OFF)) {
    sub IWI_INTR_RADIO_OFF () {	0x4000000;}
}
unless(defined(&IWI_INTR_FATAL_ERROR)) {
    sub IWI_INTR_FATAL_ERROR () {	0x40000000;}
}
unless(defined(&IWI_INTR_PARITY_ERROR)) {
    sub IWI_INTR_PARITY_ERROR () {	0x80000000;}
}
unless(defined(&IWI_INTR_MASK)) {
    sub IWI_INTR_MASK () {	( &IWI_INTR_RX_DONE |  &IWI_INTR_CMD_DONE |  &IWI_INTR_TX1_DONE |  &IWI_INTR_TX2_DONE |  &IWI_INTR_TX3_DONE |  &IWI_INTR_TX4_DONE |  &IWI_INTR_FW_INITED |  &IWI_INTR_RADIO_OFF |  &IWI_INTR_FATAL_ERROR |  &IWI_INTR_PARITY_ERROR);}
}
unless(defined(&IWI_RST_PRINCETON_RESET)) {
    sub IWI_RST_PRINCETON_RESET () {	0x1;}
}
unless(defined(&IWI_RST_SW_RESET)) {
    sub IWI_RST_SW_RESET () {	0x80;}
}
unless(defined(&IWI_RST_MASTER_DISABLED)) {
    sub IWI_RST_MASTER_DISABLED () {	0x100;}
}
unless(defined(&IWI_RST_STOP_MASTER)) {
    sub IWI_RST_STOP_MASTER () {	0x200;}
}
unless(defined(&IWI_CTL_CLOCK_READY)) {
    sub IWI_CTL_CLOCK_READY () {	0x1;}
}
unless(defined(&IWI_CTL_ALLOW_STANDBY)) {
    sub IWI_CTL_ALLOW_STANDBY () {	0x2;}
}
unless(defined(&IWI_CTL_INIT)) {
    sub IWI_CTL_INIT () {	0x4;}
}
unless(defined(&IWI_IO_RADIO_ENABLED)) {
    sub IWI_IO_RADIO_ENABLED () {	0x10000;}
}
unless(defined(&IWI_READ_INT_INIT_HOST)) {
    sub IWI_READ_INT_INIT_HOST () {	0x20000000;}
}
unless(defined(&IWI_CB_DEFAULT_CTL)) {
    sub IWI_CB_DEFAULT_CTL () {	0x8cea0000;}
}
unless(defined(&IWI_CB_MAXDATALEN)) {
    sub IWI_CB_MAXDATALEN () {	8191;}
}
unless(defined(&IWI_HDR_TYPE_DATA)) {
    sub IWI_HDR_TYPE_DATA () {	0;}
}
unless(defined(&IWI_HDR_TYPE_COMMAND)) {
    sub IWI_HDR_TYPE_COMMAND () {	1;}
}
unless(defined(&IWI_HDR_TYPE_NOTIF)) {
    sub IWI_HDR_TYPE_NOTIF () {	3;}
}
unless(defined(&IWI_HDR_TYPE_FRAME)) {
    sub IWI_HDR_TYPE_FRAME () {	9;}
}
unless(defined(&IWI_HDR_FLAG_IRQ)) {
    sub IWI_HDR_FLAG_IRQ () {	0x4;}
}
unless(defined(&IWI_NOTIF_TYPE_ASSOCIATION)) {
    sub IWI_NOTIF_TYPE_ASSOCIATION () {	10;}
}
unless(defined(&IWI_NOTIF_TYPE_AUTHENTICATION)) {
    sub IWI_NOTIF_TYPE_AUTHENTICATION () {	11;}
}
unless(defined(&IWI_NOTIF_TYPE_SCAN_CHANNEL)) {
    sub IWI_NOTIF_TYPE_SCAN_CHANNEL () {	12;}
}
unless(defined(&IWI_NOTIF_TYPE_SCAN_COMPLETE)) {
    sub IWI_NOTIF_TYPE_SCAN_COMPLETE () {	13;}
}
unless(defined(&IWI_NOTIF_TYPE_BAD_LINK)) {
    sub IWI_NOTIF_TYPE_BAD_LINK () {	15;}
}
unless(defined(&IWI_NOTIF_TYPE_BEACON)) {
    sub IWI_NOTIF_TYPE_BEACON () {	17;}
}
unless(defined(&IWI_NOTIF_TYPE_PAIRWISE_KEY)) {
    sub IWI_NOTIF_TYPE_PAIRWISE_KEY () {	18;}
}
unless(defined(&IWI_NOTIF_TYPE_CALIBRATION)) {
    sub IWI_NOTIF_TYPE_CALIBRATION () {	20;}
}
unless(defined(&IWI_NOTIF_TYPE_NOISE)) {
    sub IWI_NOTIF_TYPE_NOISE () {	25;}
}
unless(defined(&IWI_DEAUTHENTICATED)) {
    sub IWI_DEAUTHENTICATED () {	0;}
}
unless(defined(&IWI_AUTHENTICATED)) {
    sub IWI_AUTHENTICATED () {	9;}
}
unless(defined(&IWI_DEASSOCIATED)) {
    sub IWI_DEASSOCIATED () {	0;}
}
unless(defined(&IWI_ASSOCIATED)) {
    sub IWI_ASSOCIATED () {	12;}
}
unless(defined(&IWI_BEACON_MISSED)) {
    sub IWI_BEACON_MISSED () {	1;}
}
unless(defined(&IWI_DATA_CMD_TX)) {
    sub IWI_DATA_CMD_TX () {	0xb;}
}
unless(defined(&IWI_DATA_FLAG_SHPREAMBLE)) {
    sub IWI_DATA_FLAG_SHPREAMBLE () {	(1<< 2);}
}
unless(defined(&IWI_DATA_FLAG_NO_WEP)) {
    sub IWI_DATA_FLAG_NO_WEP () {	(1<< 5);}
}
unless(defined(&IWI_DATA_FLAG_NEED_ACK)) {
    sub IWI_DATA_FLAG_NEED_ACK () {	(1<< 7);}
}
unless(defined(&IWI_DATA_XFLAG_CCK)) {
    sub IWI_DATA_XFLAG_CCK () {	(1<< 0);}
}
unless(defined(&IWI_DATA_XFLAG_QOS)) {
    sub IWI_DATA_XFLAG_QOS () {	(1<< 4);}
}
unless(defined(&IWI_DATA_KEY_USE_PAIRWISE)) {
    sub IWI_DATA_KEY_USE_PAIRWISE () {	(1<< 5);}
}
unless(defined(&IWI_DATA_KEY_WEP40)) {
    sub IWI_DATA_KEY_WEP40 () {	(1<< 6);}
}
unless(defined(&IWI_DATA_KEY_WEP104)) {
    sub IWI_DATA_KEY_WEP104 () {	(1<< 7);}
}
unless(defined(&IWI_MAX_NSEG)) {
    sub IWI_MAX_NSEG () {	6;}
}
unless(defined(&IWI_MAX_SCATTER)) {
    sub IWI_MAX_SCATTER () {	( &IWI_MAX_NSEG - 2);}
}
unless(defined(&IWI_CMD_ENABLE)) {
    sub IWI_CMD_ENABLE () {	2;}
}
unless(defined(&IWI_CMD_SET_CONFIG)) {
    sub IWI_CMD_SET_CONFIG () {	6;}
}
unless(defined(&IWI_CMD_SET_ESSID)) {
    sub IWI_CMD_SET_ESSID () {	8;}
}
unless(defined(&IWI_CMD_SET_MAC_ADDRESS)) {
    sub IWI_CMD_SET_MAC_ADDRESS () {	11;}
}
unless(defined(&IWI_CMD_SET_RTS_THRESHOLD)) {
    sub IWI_CMD_SET_RTS_THRESHOLD () {	15;}
}
unless(defined(&IWI_CMD_SET_FRAG_THRESHOLD)) {
    sub IWI_CMD_SET_FRAG_THRESHOLD () {	16;}
}
unless(defined(&IWI_CMD_SET_POWER_MODE)) {
    sub IWI_CMD_SET_POWER_MODE () {	17;}
}
unless(defined(&IWI_CMD_SET_GROUP_KEY)) {
    sub IWI_CMD_SET_GROUP_KEY () {	18;}
}
unless(defined(&IWI_CMD_SET_PAIRWISE_KEY)) {
    sub IWI_CMD_SET_PAIRWISE_KEY () {	19;}
}
unless(defined(&IWI_CMD_ASSOCIATE)) {
    sub IWI_CMD_ASSOCIATE () {	21;}
}
unless(defined(&IWI_CMD_SET_RATES)) {
    sub IWI_CMD_SET_RATES () {	22;}
}
unless(defined(&IWI_CMD_SET_QOS_PARAMS)) {
    sub IWI_CMD_SET_QOS_PARAMS () {	25;}
}
unless(defined(&IWI_CMD_SCAN)) {
    sub IWI_CMD_SCAN () {	26;}
}
unless(defined(&IWI_CMD_SET_OPTIE)) {
    sub IWI_CMD_SET_OPTIE () {	31;}
}
unless(defined(&IWI_CMD_DISABLE)) {
    sub IWI_CMD_DISABLE () {	33;}
}
unless(defined(&IWI_CMD_SET_RANDOM_SEED)) {
    sub IWI_CMD_SET_RANDOM_SEED () {	34;}
}
unless(defined(&IWI_CMD_SET_TX_POWER)) {
    sub IWI_CMD_SET_TX_POWER () {	35;}
}
unless(defined(&IWI_CMD_SET_SENSITIVITY)) {
    sub IWI_CMD_SET_SENSITIVITY () {	42;}
}
unless(defined(&IWI_CMD_SET_QOS_CAP)) {
    sub IWI_CMD_SET_QOS_CAP () {	84;}
}
unless(defined(&IWI_MODE_11A)) {
    sub IWI_MODE_11A () {	0;}
}
unless(defined(&IWI_MODE_11B)) {
    sub IWI_MODE_11B () {	1;}
}
unless(defined(&IWI_MODE_11G)) {
    sub IWI_MODE_11G () {	2;}
}
unless(defined(&IWI_POWER_MODE_CAM)) {
    sub IWI_POWER_MODE_CAM () {	0;}
}
unless(defined(&IWI_RATESET_TYPE_NEGOTIATED)) {
    sub IWI_RATESET_TYPE_NEGOTIATED () {	0;}
}
unless(defined(&IWI_RATESET_TYPE_SUPPORTED)) {
    sub IWI_RATESET_TYPE_SUPPORTED () {	1;}
}
unless(defined(&IWI_TXPOWER_MAX)) {
    sub IWI_TXPOWER_MAX () {	20;}
}
unless(defined(&IWI_TXPOWER_RATIO)) {
    sub IWI_TXPOWER_RATIO () {	( &IEEE80211_TXPOWER_MAX /  &IWI_TXPOWER_MAX);}
}
unless(defined(&IWI_AUTH_OPEN)) {
    sub IWI_AUTH_OPEN () {	0;}
}
unless(defined(&IWI_AUTH_SHARED)) {
    sub IWI_AUTH_SHARED () {	1;}
}
unless(defined(&IWI_AUTH_NONE)) {
    sub IWI_AUTH_NONE () {	3;}
}
unless(defined(&IWI_ASSOC_ASSOCIATE)) {
    sub IWI_ASSOC_ASSOCIATE () {	0;}
}
unless(defined(&IWI_ASSOC_REASSOCIATE)) {
    sub IWI_ASSOC_REASSOCIATE () {	1;}
}
unless(defined(&IWI_ASSOC_DISASSOCIATE)) {
    sub IWI_ASSOC_DISASSOCIATE () {	2;}
}
unless(defined(&IWI_ASSOC_SIBSS)) {
    sub IWI_ASSOC_SIBSS () {	3;}
}
unless(defined(&IWI_ASSOC_POLICY_QOS)) {
    sub IWI_ASSOC_POLICY_QOS () {	(1<< 0);}
}
unless(defined(&IWI_ASSOC_POLICY_RSN)) {
    sub IWI_ASSOC_POLICY_RSN () {	(1<< 1);}
}
unless(defined(&IWI_ASSOC_SHPREAMBLE)) {
    sub IWI_ASSOC_SHPREAMBLE () {	(1<< 2);}
}
unless(defined(&IWI_CHAN_5GHZ)) {
    sub IWI_CHAN_5GHZ () {	(0<< 6);}
}
unless(defined(&IWI_CHAN_2GHZ)) {
    sub IWI_CHAN_2GHZ () {	(1<< 6);}
}
unless(defined(&IWI_SCAN_TYPE_PASSIVE)) {
    sub IWI_SCAN_TYPE_PASSIVE () {	0x11;}
}
unless(defined(&IWI_SCAN_TYPE_DIRECTED)) {
    sub IWI_SCAN_TYPE_DIRECTED () {	0x22;}
}
unless(defined(&IWI_SCAN_TYPE_BROADCAST)) {
    sub IWI_SCAN_TYPE_BROADCAST () {	0x33;}
}
unless(defined(&IWI_SCAN_TYPE_BDIRECTED)) {
    sub IWI_SCAN_TYPE_BDIRECTED () {	0x44;}
}
unless(defined(&IWI_GROUP_KEY_CMD_SETKEY)) {
    sub IWI_GROUP_KEY_CMD_SETKEY () {	0x8;}
}
unless(defined(&IWI_CIPHER_WEP)) {
    sub IWI_CIPHER_WEP () {	0;}
}
unless(defined(&IWI_CIPHER_CCMP)) {
    sub IWI_CIPHER_CCMP () {	2;}
}
unless(defined(&IWI_CIPHER_TKIP)) {
    sub IWI_CIPHER_TKIP () {	3;}
}
unless(defined(&IWI_MEM_EEPROM_CTL)) {
    sub IWI_MEM_EEPROM_CTL () {	0x300040;}
}
unless(defined(&IWI_MEM_EVENT_CTL)) {
    sub IWI_MEM_EVENT_CTL () {	0x300004;}
}
unless(defined(&IWI_LED_ASSOC)) {
    sub IWI_LED_ASSOC () {	(1<< 5);}
}
unless(defined(&IWI_LED_MASK)) {
    sub IWI_LED_MASK () {	0xd9fffffb;}
}
unless(defined(&IWI_EEPROM_MAC)) {
    sub IWI_EEPROM_MAC () {	0x21;}
}
unless(defined(&IWI_EEPROM_DELAY)) {
    sub IWI_EEPROM_DELAY () {	1;}
}
unless(defined(&IWI_EEPROM_C)) {
    sub IWI_EEPROM_C () {	(1<< 0);}
}
unless(defined(&IWI_EEPROM_S)) {
    sub IWI_EEPROM_S () {	(1<< 1);}
}
unless(defined(&IWI_EEPROM_D)) {
    sub IWI_EEPROM_D () {	(1<< 2);}
}
unless(defined(&IWI_EEPROM_Q)) {
    sub IWI_EEPROM_Q () {	(1<< 4);}
}
unless(defined(&IWI_EEPROM_SHIFT_D)) {
    sub IWI_EEPROM_SHIFT_D () {	2;}
}
unless(defined(&IWI_EEPROM_SHIFT_Q)) {
    sub IWI_EEPROM_SHIFT_Q () {	4;}
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_2(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_READ_REGION_4)) {
    sub CSR_READ_REGION_4 {
	my($sc, $offset, $datap, $count) = @_;
	eval q( &bus_space_read_region_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($offset), ($datap), ($count)));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_REGION_1)) {
    sub CSR_WRITE_REGION_1 {
	my($sc, $offset, $datap, $count) = @_;
	eval q( &bus_space_write_region_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($offset), ($datap), ($count)));
    }
}
unless(defined(&MEM_WRITE_1)) {
    sub MEM_WRITE_1 {
	my($sc, $addr, $val) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IWI_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_1(($sc),  &IWI_CSR_INDIRECT_DATA, ($val)); }  &while ( 0));
    }
}
unless(defined(&MEM_WRITE_2)) {
    sub MEM_WRITE_2 {
	my($sc, $addr, $val) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IWI_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_2(($sc),  &IWI_CSR_INDIRECT_DATA, ($val)); }  &while ( 0));
    }
}
unless(defined(&MEM_WRITE_4)) {
    sub MEM_WRITE_4 {
	my($sc, $addr, $val) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IWI_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_4(($sc),  &IWI_CSR_INDIRECT_DATA, ($val)); }  &while ( 0));
    }
}
unless(defined(&MEM_WRITE_MULTI_1)) {
    sub MEM_WRITE_MULTI_1 {
	my($sc, $addr, $buf, $len) = @_;
	eval q( &do {  &CSR_WRITE_4(($sc),  &IWI_CSR_INDIRECT_ADDR, ($addr));  &CSR_WRITE_MULTI_1(($sc),  &IWI_CSR_INDIRECT_DATA, ($buf), ($len)); }  &while ( 0));
    }
}
unless(defined(&IWI_EEPROM_CTL)) {
    sub IWI_EEPROM_CTL {
	my($sc, $val) = @_;
	eval q( &do {  &MEM_WRITE_4(($sc),  &IWI_MEM_EEPROM_CTL, ($val));  &DELAY( &IWI_EEPROM_DELAY); }  &while ( 0));
    }
}
1;
