smooth.construct.ps.smooth.spec     package:mgcv     R Documentation

_P-_s_p_l_i_n_e_s _i_n _G_A_M_s

_D_e_s_c_r_i_p_t_i_o_n:

     'gam' can use univariate P-splines as proposed by Eilers and Marx
     (1996),  specified via terms like 's(x,bs="ps")'. These terms use
     B-spline bases  penalized by discrete penalties applied directly
     to  the basis coefficients. Cyclic P-splines are specified by
     model terms like 's(x,bs="cp",...)'.  These bases can be used in
     tensor product smooths (see 'te').

     The advantage of P-splines is the flexible way that penalty and
     basis order can be mixed. This often provides a useful way of
     `taming' an otherwise poorly behave smooth. However, in regular
     use, splines with derivative based penalties (e.g. '"tp"' or
     '"cr"' bases) tend to result in slightly better MSE performance,
     presumably because the good approximation theoretic properties of
     splines are rather closely connected to the use of derivative
     penalties.

_U_s_a_g_e:

     ## S3 method for class 'ps.smooth.spec':
     smooth.construct(object, data, knots)
     ## S3 method for class 'cp.smooth.spec':
     smooth.construct(object, data, knots)

_A_r_g_u_m_e_n_t_s:

  object: a smooth specification object, usually generated by a term
          's(x,bs="ps",...)' or  's(x,bs="cp",...)'

    data: a list containing just the data (including any 'by' variable)
          required by this term,  with names corresponding to
          'object$term' (and 'object$by'). The 'by' variable  is the
          last element.

   knots: a list containing any knots supplied for basis setup - in
          same order and with same names as 'data'.  Can be 'NULL'

_D_e_t_a_i_l_s:

     A  smooth term of the form 's(x,bs="ps",m=c(2,3))' specifies a 2nd
     order P-spline basis (cubic spline),  with a third order
     difference penalty (0th order is a ridge penalty) on the
     coefficients. If 'm' is a single number then it is taken as the
     basis order and penalty order. The default is the `cubic spline
     like' 'm=c(2,2)'.

     The default basis dimension, 'k', is the larger of 10 and 'm[1]+1'
     for a '"ps"' terms and the larger of 10 and 'm[1]' for a '"cp"'
     term. 'm[1]+1' and 'm[1]' are the lower limits on basis dimension
     for the two types. 

     If knots are supplied, then the number of knots should be one more
     than the basis dimension (i.e. 'k+1') for a '"cp"'smooth. For the
     '"ps"' basis the number of supplied knots should be 'k + m[1] +
     2', and the range of the middle  'k-m[1]' knots should include all
     the covariate values. See example. P-splines don't make much sense
     with uneven knot spacing.

_V_a_l_u_e:

     An object of class '"ps.smooth"' or '"cp.smooth"'. See
     'smooth.construct',  for the elements that this object will
     contain.

_A_u_t_h_o_r(_s):

     Simon N. Wood simon.wood@r-project.org

_R_e_f_e_r_e_n_c_e_s:

     Eilers, P.H.C. and B.D. Marx (1996) Flexible Smoothing with
     B-splines and Penalties.  Statistical Science, 11(2):89-121

_S_e_e _A_l_s_o:

     'cSplineDes'

_E_x_a_m_p_l_e_s:

     ## see ?gam
     ## cyclic example ...
       set.seed(6)
       x <- sort(runif(200)*10)
       z <- runif(200)
       f <- sin(x*2*pi/10)+.5
       y <- rpois(exp(f),exp(f)) 

     ## finished simulating data, now fit model...
       b <- gam(y ~ s(x,bs="cp") + s(z,bs="ps"),family=poisson)

     ## example with supplied knots...
       bk <- gam(y ~ s(x,bs="cp",k=12) + s(z,bs="ps",k=13),family=poisson,
                           knots=list(x=seq(0,10,length=13),z=(-3):13))

     ## plot results...
       par(mfrow=c(2,2))
       plot(b,select=1,shade=TRUE);lines(x,f-mean(f),col=2)
       plot(b,select=2,shade=TRUE);lines(z,0*z,col=2)
       plot(bk,select=1,shade=TRUE);lines(x,f-mean(f),col=2)
       plot(bk,select=2,shade=TRUE);lines(z,0*z,col=2)
       

