<?php
/**
 * A library for reading/writing the Kolab format.
 *
 * $Horde: framework/Kolab_Format/lib/Horde/Kolab/Format.php,v 1.4.2.3 2008/08/01 07:13:20 wrobel Exp $
 *
 * @package Kolab_Format
 */

/** We need PEAR */
require_once 'PEAR.php';

/**
 * The Horde_Kolab_Format:: class provides the means to read/write the
 * Kolab format.
 *
 * $Horde: framework/Kolab_Format/lib/Horde/Kolab/Format.php,v 1.4.2.3 2008/08/01 07:13:20 wrobel Exp $
 *
 * Copyright 2007-2008 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @since   Horde 3.2
 * @author  Gunnar Wrobel <wrobel@pardus.de>
 * @package Kolab_Format
 */
class Horde_Kolab_Format
{

    /**
     * Attempts to return a concrete Horde_Kolab_Format instance based on $format_type.
     *
     * @param string    $format_type    The format type that should be handled.
     * @param string    $object_type    The object type that should be handled.
     * @param array     $params         An array of  additional parameters.
     *
     *                                  Supported parameters:
     *
     *                                    'version' - The format version.
     *
     * @return mixed    The newly created concrete Horde_Kolab_Format_XML instance, or
     *                  a PEAR error.
     */
    function &factory($format_type = '', $object_type = '', $params = null)
    {
        @include_once dirname(__FILE__) . '/Format/' . $format_type . '.php';
        $class = 'Horde_Kolab_Format_' . $format_type;
        if (class_exists($class)) {
            $driver = call_user_func(array($class, 'factory'), $object_type, $params);
        } else {
            return PEAR::raiseError(sprintf(_("Failed to load Kolab Format driver %s"), $format_type));
        }

        return $driver;
    }

}
