<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2041 $
 * $Id: HolidayPolicyList.php 2041 2008-08-13 22:15:53Z ipso $
 * $Date: 2008-08-13 15:15:53 -0700 (Wed, 13 Aug 2008) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('holiday_policy','enabled')
		OR !( $permission->Check('holiday_policy','view') OR $permission->Check('holiday_policy','view_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Holiday Policy List')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'page',
												'sort_column',
												'sort_order',
												'ids',
												) ) );

URLBuilder::setURL($_SERVER['SCRIPT_NAME'],
											array(
													'sort_column' => $sort_column,
													'sort_order' => $sort_order,
													'page' => $page
												) );

$sort_array = NULL;
if ( $sort_column != '' ) {
	$sort_array = array($sort_column => $sort_order);
}

Debug::Arr($ids,'Selected Objects', __FILE__, __LINE__, __METHOD__,10);

$action = Misc::findSubmitButton();
switch ($action) {
	case 'add':

		Redirect::Page( URLBuilder::getURL( NULL, 'EditHolidayPolicy.php', FALSE) );

		break;
	case 'delete' OR 'undelete':
		if ( strtolower($action) == 'delete' ) {
			$delete = TRUE;
		} else {
			$delete = FALSE;
		}

		$hplf = new HolidayPolicyListFactory();

		foreach ($ids as $id) {
			$hplf->getByIdAndCompanyId($id, $current_company->getId() );
			foreach ($hplf as $hp_obj) {
				$hp_obj->setDeleted($delete);
				if ( $hp_obj->isValid() ) {
					$hp_obj->Save();
				}
			}
		}

		Redirect::Page( URLBuilder::getURL( NULL, 'HolidayPolicyList.php') );

		break;

	default:
		BreadCrumb::setCrumb($title);

		$hplf = new HolidayPolicyListFactory();
		$hplf->getByCompanyId( $current_company->getId() );

		$pager = new Pager($hplf);

		$type_options = $hplf->getOptions('type');

		$show_no_policy_group_notice = FALSE;
		foreach ($hplf as $hp_obj) {
			if ( (int)$hp_obj->getColumn('assigned_policy_groups') == 0 ) {
				$show_no_policy_group_notice = TRUE;
			}

			$policies[] = array(
								'id' => $hp_obj->getId(),
								'name' => $hp_obj->getName(),
								'type_id' => $hp_obj->getType(),
								'type' => $type_options[$hp_obj->getType()],
								'assigned_policy_groups' => (int)$hp_obj->getColumn('assigned_policy_groups'),
								'deleted' => $hp_obj->getDeleted()
							);

		}
		$smarty->assign_by_ref('policies', $policies);

		$smarty->assign_by_ref('show_no_policy_group_notice', $show_no_policy_group_notice );

		$smarty->assign_by_ref('sort_column', $sort_column );
		$smarty->assign_by_ref('sort_order', $sort_order );

		$smarty->assign_by_ref('paging_data', $pager->getPageVariables() );

		break;
}
$smarty->display('policy/HolidayPolicyList.tpl');
?>