
# Generated from the Telepathy spec
""" Copyright (C) 2005, 2006, 2008 Collabora Limited 
 Copyright (C) 2005, 2006, 2008 Nokia Corporation 
 Copyright (C) 2006 INdT 

    This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
  
"""

import dbus.service


class ConnectionInterfaceContactCapabilities(dbus.service.Interface):
    """\
      Contact capabilities describe the channel classes which may be
        created with a given contact in advance of attempting to create a
        channel. Each capability represents a commitment by the
        connection manager that it will ordinarily be able to create a channel
        with a contact when given a request with the properties defined by the
        channel class.

      Capabilities pertain to particular contact handles, and represent
        activities such as having a text chat, a voice call with the user or a
        stream tube of a defined type.

      This interface also enables user interfaces to notify the connection
        manager what capabilities to advertise for the user to other contacts.
        This is done by using the
        SetSelfCapabilities method, and deals
        with channel property values pertaining to them which are implemented
        by available client processes.

    """

    def __init__(self):
        self._interfaces.add('org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities.DRAFT')

    @dbus.service.method('org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities.DRAFT', in_signature='aa{sv}', out_signature='')
    def SetSelfCapabilities(self, caps):
        """
        Used by user interfaces to indicate which channel classes they are
        able to handle on this connection. It replaces the previous advertised
        channel classes by the set given as parameter.

        If a channel class is unknown by the connection manager, it is just
        ignored. No error are returned in this case, and other known channel
        class are added.

        Upon a successful invocation of this method, the
        ContactCapabilitiesChanged signal
        will only be emitted for the user's own
        handle (as returned by GetSelfHandle) by the connection manager if, in
        the given protocol, the given capabilities are distinct from the
        previous state.

        
          The connection manager will essentially intersect the provided
            capabilities and the channel classes it implements. Therefore,
            certain properties which are never fixed for a channel class
            (such as the target handle, or the Parameters property of a tube
            channel) will almost certainly not be advertised.
        

      
        """
        raise NotImplementedError
  
    @dbus.service.method('org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities.DRAFT', in_signature='au', out_signature='a{ua(a{sv}as)}')
    def GetContactCapabilities(self, handles):
        """
        Returns an array of enhanced capabilities for the given contact handles.
      
        """
        raise NotImplementedError
  
    @dbus.service.signal('org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities.DRAFT', signature='a{ua(a{sv}as)}')
    def ContactCapabilitiesChanged(self, caps):
        """
        Announce that there has been a change of capabilities on the
          given handles. A single signal can be emitted for several
        contacts.

        
          The underlying protocol can get several contacts' capabilities at
            the same time.
        
        
      
        """
        pass
  