/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import writer2latex.latex.Context;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.ListStyleConverter;
import writer2latex.latex.style.StyleConverter;
import writer2latex.office.ParStyle;
import writer2latex.office.PropertySet;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class NoteConfigurationConverter
extends StyleConverter {
    public NoteConfigurationConverter(WriterStyleCollection writerStyleCollection, Config config, ConverterPalette converterPalette) {
        super(writerStyleCollection, config, converterPalette);
    }

    public void convertFootnotesConfiguration(LaTeXDocumentPortion laTeXDocumentPortion) {
        this.convertFootEndnotesConfiguration(this.wsc.getFootnotesConfiguration(), "foot", laTeXDocumentPortion);
    }

    public void convertEndnotesConfiguration(LaTeXDocumentPortion laTeXDocumentPortion) {
        this.convertFootEndnotesConfiguration(this.wsc.getEndnotesConfiguration(), "end", laTeXDocumentPortion);
    }

    private void convertFootEndnotesConfiguration(PropertySet propertySet, String string, LaTeXDocumentPortion laTeXDocumentPortion) {
        int n;
        String string2;
        if (this.config.formatting() < 2) {
            return;
        }
        String string3 = string2 = string.equals("foot") ? "fn" : "en";
        if (propertySet == null) {
            return;
        }
        laTeXDocumentPortion.append("% ").append(string).append("notes configuration").nl().append("\\makeatletter").nl();
        String string4 = propertySet.getProperty("style:num-format");
        if (string4 != null) {
            laTeXDocumentPortion.append("\\renewcommand\\the").append(string).append("note{").append(ListStyleConverter.numFormat(string4)).append("{").append(string).append("note}}").nl();
        }
        if ("chapter".equals(propertySet.getProperty("text:start-numbering-at"))) {
            laTeXDocumentPortion.append("\\@addtoreset{").append(string).append("note}{section}").nl();
        }
        if ((n = Misc.getPosInteger(propertySet.getProperty("text:start-value"), 0)) != 0) {
            laTeXDocumentPortion.append("\\setcounter{").append(string).append("note}{" + n + "}").nl();
        }
        if (this.config.formatting() >= 3) {
            Object object;
            String string5 = propertySet.getProperty("text:citation-body-style-name");
            if (string5 != null && this.wsc.getTextStyle(string5) != null) {
                object = new BeforeAfter();
                this.palette.getCharSc().applyTextStyle(string5, (BeforeAfter)object, new Context());
                laTeXDocumentPortion.append("\\renewcommand\\@make").append(string2).append("mark{\\mbox{").append(((BeforeAfter)object).getBefore()).append("\\@the").append(string2).append("mark").append(((BeforeAfter)object).getAfter()).append("}}").nl();
            }
            object = propertySet.getProperty("text:citation-style-name");
            String string6 = propertySet.getProperty("text:default-style-name");
            if (string6 != null) {
                BeforeAfter beforeAfter = new BeforeAfter();
                this.palette.getCharSc().applyTextStyle((String)object, beforeAfter, new Context());
                ParStyle parStyle = this.wsc.getParStyle(string6);
                if (parStyle != null) {
                    BeforeAfter beforeAfter2 = new BeforeAfter();
                    this.palette.getCharSc().applyHardCharFormatting(parStyle, beforeAfter2);
                    laTeXDocumentPortion.append("\\renewcommand\\@make").append(string2).append("text[1]{\\noindent").append(beforeAfter.getBefore()).append("\\@the").append(string2).append("mark\\ ").append(beforeAfter.getAfter()).append(beforeAfter2.getBefore()).append("#1").append(beforeAfter2.getAfter());
                    laTeXDocumentPortion.append("}").nl();
                }
            }
        }
        laTeXDocumentPortion.append("\\makeatother").nl();
    }
}

