/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.classfile.JavaVariable;

final class OptLocalVariable
implements JavaVariable {
    private String itsName;
    private boolean itsIsParameter;
    private int itsIndex = -1;
    private short itsJRegister = (short)-1;
    private boolean itsLiveAcrossCall;
    private boolean itsIsNumber;
    private int itsTypeUnion;
    private int initPC;

    public OptLocalVariable(String string, boolean bl) {
        this.itsName = string;
        this.itsIsParameter = bl;
        this.itsTypeUnion = bl ? 3 : 0;
    }

    public String toString() {
        return "LocalVariable : '" + this.getName() + "', index = " + this.getIndex() + ", LiveAcrossCall = " + this.itsLiveAcrossCall + ", isNumber = " + this.itsIsNumber + ", isParameter = " + this.isParameter() + ", JRegister = " + this.itsJRegister;
    }

    public String getName() {
        return this.itsName;
    }

    public String getTypeDescriptor() {
        return this.isNumber() ? "D" : "Ljava/lang/Object;";
    }

    public short getJRegister() {
        return this.itsJRegister;
    }

    void assignJRegister(short s) {
        this.itsJRegister = s;
    }

    public int getStartPC() {
        return this.initPC;
    }

    int getIndex() {
        return this.itsIndex;
    }

    void setIndex(int n) {
        this.itsIndex = n;
    }

    void setStartPC(int n) {
        this.initPC = n;
    }

    void setIsNumber() {
        this.itsIsNumber = true;
    }

    boolean isNumber() {
        return this.itsIsNumber;
    }

    boolean isParameter() {
        return this.itsIsParameter;
    }

    void markLiveAcrossCall() {
        this.itsLiveAcrossCall = true;
    }

    void clearLiveAcrossCall() {
        this.itsLiveAcrossCall = false;
    }

    boolean isLiveAcrossCall() {
        return this.itsLiveAcrossCall;
    }

    boolean assignType(int n) {
        this.itsTypeUnion |= n;
        return this.itsTypeUnion != n;
    }

    int getTypeUnion() {
        return this.itsTypeUnion;
    }
}

