/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.debug.DebuggableScript;

final class InterpreterData
implements Serializable,
DebuggableScript {
    static final long serialVersionUID = 4815333329084415557L;
    static final int INITIAL_MAX_ICODE_LENGTH = 1024;
    static final int INITIAL_STRINGTABLE_SIZE = 64;
    static final int INITIAL_NUMBERTABLE_SIZE = 64;
    SecurityController securityController;
    Object securityDomain;
    String itsName;
    String itsSourceFile;
    boolean itsNeedsActivation;
    boolean itsFromEvalCode;
    boolean itsCheckThis;
    int itsFunctionType;
    String[] itsStringTable;
    double[] itsDoubleTable;
    InterpreterData[] itsNestedFunctions;
    Object[] itsRegExpLiterals;
    byte[] itsICode;
    int itsICodeTop;
    int[] itsExceptionTable;
    int itsMaxVars;
    int itsMaxLocals;
    int itsMaxStack;
    int itsMaxFrameArray;
    String[] argNames;
    int argCount;
    int itsMaxCalleeArgs;
    String encodedSource;
    int encodedSourceStart;
    int encodedSourceEnd;
    int languageVersion;
    boolean useDynamicScope;
    boolean topLevel;
    InterpreterData parentData;

    InterpreterData(SecurityController securityController, Object object, int n, String string, String string2) {
        this.securityController = securityController;
        this.securityDomain = object;
        this.languageVersion = n;
        this.itsSourceFile = string;
        this.encodedSource = string2;
        this.init();
    }

    InterpreterData(InterpreterData interpreterData) {
        this.parentData = interpreterData;
        this.securityController = interpreterData.securityController;
        this.securityDomain = interpreterData.securityDomain;
        this.languageVersion = interpreterData.languageVersion;
        this.itsSourceFile = interpreterData.itsSourceFile;
        this.encodedSource = interpreterData.encodedSource;
        this.init();
    }

    private void init() {
        this.itsICodeTop = 1024;
        this.itsICode = new byte[this.itsICodeTop];
        this.itsStringTable = new String[64];
    }

    public boolean isTopLevel() {
        return this.topLevel;
    }

    public boolean isFunction() {
        return this.itsFunctionType != 0;
    }

    public String getFunctionName() {
        return this.itsName;
    }

    public String getSourceName() {
        return this.itsSourceFile;
    }

    public boolean isGeneratedScript() {
        return ScriptRuntime.isGeneratedScript(this.itsSourceFile);
    }

    public int[] getLineNumbers() {
        return Interpreter.getLineNumbers(this);
    }

    public int getFunctionCount() {
        return this.itsNestedFunctions == null ? 0 : this.itsNestedFunctions.length;
    }

    public DebuggableScript getFunction(int n) {
        return this.itsNestedFunctions[n];
    }

    public DebuggableScript getParent() {
        return this.parentData;
    }
}

