/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import com.sun.star.script.framework.container.ScriptEntry;
import com.sun.star.script.framework.container.XMLParserFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ParcelDescriptor {
    public static final String PARCEL_DESCRIPTOR_NAME = "parcel-descriptor.xml";
    private static final Map PARCEL_DESCRIPTOR_MAP = new HashMap(5);
    private static final byte[] EMPTY_DOCUMENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<parcel xmlns:parcel=\"scripting.dtd\" language=\"Java\">\n</parcel>".getBytes();
    private File file = null;
    private Document document = null;
    private String language = null;
    private Map languagedepprops = new Hashtable(3);

    public static synchronized void removeParcelDescriptor(File file) {
        File file2 = new File(file, PARCEL_DESCRIPTOR_NAME);
        PARCEL_DESCRIPTOR_MAP.remove(file2);
    }

    public static synchronized void renameParcelDescriptor(File file, File file2) {
        File file3 = new File(file, PARCEL_DESCRIPTOR_NAME);
        ParcelDescriptor parcelDescriptor = (ParcelDescriptor)PARCEL_DESCRIPTOR_MAP.get(file3);
        if (parcelDescriptor != null) {
            File file4;
            PARCEL_DESCRIPTOR_MAP.remove(file3);
            parcelDescriptor.file = file4 = new File(file2, PARCEL_DESCRIPTOR_NAME);
            PARCEL_DESCRIPTOR_MAP.put(file4, parcelDescriptor);
        }
    }

    public static synchronized ParcelDescriptor getParcelDescriptor(File file) {
        File file2 = new File(file, PARCEL_DESCRIPTOR_NAME);
        ParcelDescriptor parcelDescriptor = (ParcelDescriptor)PARCEL_DESCRIPTOR_MAP.get(file2);
        if (parcelDescriptor == null && file2.exists()) {
            try {
                parcelDescriptor = new ParcelDescriptor(file2);
            }
            catch (IOException iOException) {
                return null;
            }
            PARCEL_DESCRIPTOR_MAP.put(file2, parcelDescriptor);
        }
        return parcelDescriptor;
    }

    public static synchronized ParcelDescriptor createParcelDescriptor(File file) throws IOException {
        ParcelDescriptor parcelDescriptor = ParcelDescriptor.getParcelDescriptor(file);
        if (parcelDescriptor == null) {
            if (file == null || !file.exists() || !file.isDirectory()) {
                throw new IOException("Cannot create Parcel Descriptor");
            }
            File file2 = new File(file, PARCEL_DESCRIPTOR_NAME);
            parcelDescriptor = new ParcelDescriptor(file2);
            PARCEL_DESCRIPTOR_MAP.put(file2, parcelDescriptor);
        }
        return parcelDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelDescriptor() throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(EMPTY_DOCUMENT);
            this.document = XMLParserFactory.getParser().parse(byteArrayInputStream);
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
        }
    }

    public ParcelDescriptor(Document document) {
        this.document = document;
        this.initLanguageProperties();
    }

    public ParcelDescriptor(InputStream inputStream) throws IOException {
        this(XMLParserFactory.getParser().parse(inputStream));
    }

    public ParcelDescriptor(File file) throws IOException {
        this(file, "Java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelDescriptor(File file, String string) throws IOException {
        this.file = file;
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                this.document = XMLParserFactory.getParser().parse(fileInputStream);
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(EMPTY_DOCUMENT);
            this.document = XMLParserFactory.getParser().parse(byteArrayInputStream);
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
        }
        this.setLanguage(string);
        this.initLanguageProperties();
    }

    public void write(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        XMLParserFactory.getParser().write(this.document, fileOutputStream);
        fileOutputStream.close();
    }

    public void write() throws IOException {
        if (this.file == null) {
            throw new FileNotFoundException("No file specified");
        }
        this.write(this.file);
    }

    public void write(OutputStream outputStream) throws IOException {
        XMLParserFactory.getParser().write(this.document, outputStream);
    }

    public Document getDocument() {
        return this.document;
    }

    public String getLanguage() {
        if (this.language == null && this.document != null) {
            Element element = this.document.getDocumentElement();
            this.language = element.getAttribute("language");
        }
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
        if (this.document != null) {
            try {
                Element element = this.document.getDocumentElement();
                element.setAttribute("language", string);
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
    }

    public ScriptEntry[] getScriptEntries() {
        int n;
        NodeList nodeList;
        ArrayList<ScriptEntry> arrayList = new ArrayList<ScriptEntry>();
        if (this.document == null || (nodeList = this.document.getElementsByTagName("script")) == null || (n = nodeList.getLength()) == 0) {
            return new ScriptEntry[0];
        }
        for (int i = 0; i < n; ++i) {
            NodeList nodeList2;
            String string;
            Element element;
            String string2;
            String string3 = "";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Element element2 = (Element)nodeList.item(i);
            String string4 = element2.getAttribute("language");
            NodeList nodeList3 = element2.getElementsByTagName("logicalname");
            if (nodeList3 == null) {
                string2 = "";
            } else {
                element = (Element)nodeList3.item(0);
                string2 = element.getAttribute("value");
            }
            nodeList3 = element2.getElementsByTagName("locale");
            if (nodeList3 != null && (nodeList3 = nodeList3.item(0).getChildNodes()) != null) {
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    if (!nodeList3.item(j).getNodeName().equals("description")) continue;
                    CharacterData characterData = (CharacterData)nodeList3.item(j).getFirstChild();
                    string3 = characterData.getData().trim();
                }
            }
            if ((nodeList3 = element2.getElementsByTagName("functionname")) == null) {
                string = "";
            } else {
                element = (Element)nodeList3.item(0);
                string = element.getAttribute("value");
            }
            nodeList3 = element2.getElementsByTagName("languagedepprops");
            if (nodeList3 != null && nodeList3.getLength() > 0 && (nodeList2 = ((Element)nodeList3.item(0)).getElementsByTagName("prop")) != null) {
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    element = (Element)nodeList2.item(j);
                    String string5 = element.getAttribute("name");
                    String string6 = element.getAttribute("value");
                    hashMap.put(string5, string6);
                }
            }
            ScriptEntry scriptEntry = new ScriptEntry(string4, string, string2, "", hashMap, string3);
            arrayList.add(scriptEntry);
        }
        return arrayList.toArray(new ScriptEntry[0]);
    }

    public void setScriptEntries(ScriptEntry[] scriptEntryArray) {
        this.clearEntries();
        for (int i = 0; i < scriptEntryArray.length; ++i) {
            this.addScriptEntry(scriptEntryArray[i]);
        }
    }

    public void setScriptEntries(Enumeration enumeration) {
        this.clearEntries();
        while (enumeration.hasMoreElements()) {
            this.addScriptEntry((ScriptEntry)enumeration.nextElement());
        }
    }

    public String getLanguageProperty(String string) {
        return (String)this.languagedepprops.get(string);
    }

    public void setLanguageProperty(String string, String string2) {
        this.languagedepprops.put(string, string2);
        this.setScriptEntries(this.getScriptEntries());
    }

    private void initLanguageProperties() {
        int n;
        NodeList nodeList = this.document.getElementsByTagName("languagedepprops");
        if (nodeList != null && (n = nodeList.getLength()) != 0) {
            for (int i = 0; i < n; ++i) {
                int n2;
                Element element = (Element)nodeList.item(i);
                NodeList nodeList2 = element.getElementsByTagName("prop");
                if (nodeList2 == null || (n2 = nodeList2.getLength()) == 0) continue;
                for (int j = 0; j < n2; ++j) {
                    Element element2 = (Element)nodeList2.item(j);
                    String string = element2.getAttribute("name");
                    String string2 = element2.getAttribute("value");
                    if (this.getLanguageProperty(string) != null) continue;
                    this.languagedepprops.put(string, string2);
                }
            }
        }
    }

    private void clearEntries() {
        int n;
        Element element = this.document.getDocumentElement();
        NodeList nodeList = this.document.getElementsByTagName("script");
        if (nodeList != null && (n = nodeList.getLength()) != 0) {
            for (int i = n - 1; i >= 0; --i) {
                try {
                    element.removeChild(nodeList.item(i));
                    continue;
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
            }
        }
    }

    public void removeScriptEntry(ScriptEntry scriptEntry) {
        int n;
        Element element = this.document.getDocumentElement();
        NodeList nodeList = this.document.getElementsByTagName("script");
        if (nodeList != null && (n = nodeList.getLength()) != 0) {
            for (int i = n - 1; i >= 0; --i) {
                try {
                    Element element2;
                    Element element3 = (Element)nodeList.item(i);
                    String string = "";
                    NodeList nodeList2 = element3.getElementsByTagName("functionname");
                    if (nodeList2 == null || !(string = (element2 = (Element)nodeList2.item(0)).getAttribute("value")).equals(scriptEntry.getLanguageName())) continue;
                    element.removeChild(element3);
                    continue;
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
            }
        }
    }

    public void addScriptEntry(ScriptEntry scriptEntry) {
        Element element = this.document.getDocumentElement();
        Element element2 = this.document.createElement("script");
        element2.setAttribute("language", scriptEntry.getLanguage());
        Element element3 = this.document.createElement("locale");
        element3.setAttribute("lang", "en");
        Element element4 = this.document.createElement("displayname");
        element4.setAttribute("value", scriptEntry.getLogicalName());
        element3.appendChild(element4);
        element4 = this.document.createElement("description");
        String string = scriptEntry.getDescription();
        if (string == null || string.equals("")) {
            string = scriptEntry.getLogicalName();
        }
        element4.appendChild(this.document.createTextNode(string));
        element3.appendChild(element4);
        element2.appendChild(element3);
        element3 = this.document.createElement("logicalname");
        element3.setAttribute("value", scriptEntry.getLogicalName());
        element2.appendChild(element3);
        element3 = this.document.createElement("functionname");
        element3.setAttribute("value", scriptEntry.getLanguageName());
        element2.appendChild(element3);
        if (this.languagedepprops != null && this.languagedepprops.size() != 0) {
            element3 = this.document.createElement("languagedepprops");
            Iterator iterator = this.languagedepprops.keySet().iterator();
            while (iterator.hasNext()) {
                element4 = this.document.createElement("prop");
                String string2 = (String)iterator.next();
                element4.setAttribute("name", string2);
                element4.setAttribute("value", (String)this.languagedepprops.get(string2));
                element3.appendChild(element4);
            }
            element2.appendChild(element3);
        }
        element.appendChild(element2);
    }
}

